/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigIncludeContext;
import com.typesafe.config.ConfigIncluder;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigSyntax;
import com.typesafe.config.ConfigValueType;
import com.typesafe.config.impl.AbstractConfigObject;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.ConfigImplUtil;
import com.typesafe.config.impl.ConfigSubstitution;
import com.typesafe.config.impl.Path;
import com.typesafe.config.impl.PathBuilder;
import com.typesafe.config.impl.SimpleConfigList;
import com.typesafe.config.impl.SimpleConfigObject;
import com.typesafe.config.impl.SimpleConfigOrigin;
import com.typesafe.config.impl.SubstitutionExpression;
import com.typesafe.config.impl.Token;
import com.typesafe.config.impl.Tokenizer;
import com.typesafe.config.impl.Tokens;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;

final class Parser {
    static ConfigOrigin apiOrigin = SimpleConfigOrigin.newSimple("path parameter");

    Parser() {
    }

    static AbstractConfigValue parse(Iterator<Token> iterator2, ConfigOrigin configOrigin, ConfigParseOptions configParseOptions, ConfigIncludeContext configIncludeContext) {
        ParseContext parseContext = new ParseContext(configParseOptions.getSyntax(), configOrigin, iterator2, configParseOptions.getIncluder(), configIncludeContext);
        return parseContext.parse();
    }

    private static void addPathText(List<Element> list2, boolean bl, String string2) {
        int n = bl ? -1 : string2.indexOf(46);
        Element element = list2.get(list2.size() - 1);
        if (n < 0) {
            element.sb.append(string2);
            if (bl && element.sb.length() == 0) {
                element.canBeEmpty = true;
            }
        } else {
            element.sb.append(string2.substring(0, n));
            list2.add(new Element("", false));
            Parser.addPathText(list2, false, string2.substring(n + 1));
        }
    }

    private static Path parsePathExpression(Iterator<Token> iterator2, ConfigOrigin configOrigin) {
        return Parser.parsePathExpression(iterator2, configOrigin, null);
    }

    private static Path parsePathExpression(Iterator<Token> iterator2, ConfigOrigin configOrigin, String string2) {
        Object object;
        ArrayList<Element> arrayList = new ArrayList<Element>();
        arrayList.add(new Element("", false));
        if (!iterator2.hasNext()) {
            throw new ConfigException.BadPath(configOrigin, string2, "Expecting a field name or path here, but got nothing");
        }
        while (iterator2.hasNext()) {
            Object object3;
            object = iterator2.next();
            if (Tokens.isValueWithType((Token)object, ConfigValueType.STRING)) {
                object3 = Tokens.getValue((Token)object);
                String string3 = ((AbstractConfigValue)object3).transformToString();
                Parser.addPathText(arrayList, true, string3);
                continue;
            }
            if (object == Tokens.END) continue;
            if (Tokens.isValue((Token)object)) {
                AbstractConfigValue abstractConfigValue = Tokens.getValue((Token)object);
                object3 = abstractConfigValue.transformToString();
            } else if (Tokens.isUnquotedText((Token)object)) {
                object3 = Tokens.getUnquotedText((Token)object);
            } else {
                throw new ConfigException.BadPath(configOrigin, string2, "Token not allowed in path expression: " + object + " (you can double-quote this token if you really want it here)");
            }
            Parser.addPathText(arrayList, false, (String)object3);
        }
        object = new PathBuilder();
        for (Element element : arrayList) {
            if (element.sb.length() == 0 && !element.canBeEmpty) {
                throw new ConfigException.BadPath(configOrigin, string2, "path has a leading, trailing, or two adjacent period '.' (use quoted \"\" empty string if you want an empty element)");
            }
            ((PathBuilder)object).appendKey(element.sb.toString());
        }
        return ((PathBuilder)object).result();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Path parsePath(String string2) {
        Path path = Parser.speculativeFastParsePath(string2);
        if (path != null) {
            return path;
        }
        StringReader stringReader = new StringReader(string2);
        try {
            Iterator<Token> iterator2 = Tokenizer.tokenize(apiOrigin, stringReader, ConfigSyntax.CONF);
            iterator2.next();
            Path path2 = Parser.parsePathExpression(iterator2, apiOrigin, string2);
            return path2;
        }
        finally {
            stringReader.close();
        }
    }

    private static boolean hasUnsafeChars(String string2) {
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (Character.isLetter(c) || c == '.') continue;
            return true;
        }
        return false;
    }

    private static void appendPathString(PathBuilder pathBuilder, String string2) {
        int n = string2.indexOf(46);
        if (n < 0) {
            pathBuilder.appendKey(string2);
        } else {
            pathBuilder.appendKey(string2.substring(0, n));
            Parser.appendPathString(pathBuilder, string2.substring(n + 1));
        }
    }

    private static Path speculativeFastParsePath(String string2) {
        String string3 = ConfigImplUtil.unicodeTrim(string2);
        if (string3.isEmpty()) {
            return null;
        }
        if (Parser.hasUnsafeChars(string3)) {
            return null;
        }
        if (string3.startsWith(".") || string3.endsWith(".") || string3.contains("..")) {
            return null;
        }
        PathBuilder pathBuilder = new PathBuilder();
        Parser.appendPathString(pathBuilder, string3);
        return pathBuilder.result();
    }

    static class Element {
        StringBuilder sb;
        boolean canBeEmpty;

        Element(String string2, boolean bl) {
            this.canBeEmpty = bl;
            this.sb = new StringBuilder(string2);
        }

        public String toString() {
            return "Element(" + this.sb.toString() + "," + this.canBeEmpty + ")";
        }
    }

    private static final class ParseContext {
        private int lineNumber = 1;
        private final Stack<TokenWithComments> buffer = new Stack();
        private final Iterator<Token> tokens;
        private final ConfigIncluder includer;
        private final ConfigIncludeContext includeContext;
        private final ConfigSyntax flavor;
        private final ConfigOrigin baseOrigin;
        private final LinkedList<Path> pathStack;
        int equalsCount;

        ParseContext(ConfigSyntax configSyntax, ConfigOrigin configOrigin, Iterator<Token> iterator2, ConfigIncluder configIncluder, ConfigIncludeContext configIncludeContext) {
            this.tokens = iterator2;
            this.flavor = configSyntax;
            this.baseOrigin = configOrigin;
            this.includer = configIncluder;
            this.includeContext = configIncludeContext;
            this.pathStack = new LinkedList();
            this.equalsCount = 0;
        }

        private void consolidateCommentBlock(Token token2) {
            ArrayList<Token> arrayList = new ArrayList<Token>();
            ArrayList<Token> arrayList2 = new ArrayList<Token>();
            Token token3 = null;
            Token token4 = token2;
            while (true) {
                if (Tokens.isNewline(token4)) {
                    if (token3 != null && Tokens.isNewline(token3)) {
                        arrayList2.clear();
                    }
                    arrayList.add(token4);
                } else {
                    if (!Tokens.isComment(token4)) break;
                    arrayList2.add(token4);
                }
                token3 = token4;
                token4 = this.tokens.next();
            }
            this.buffer.push(new TokenWithComments(token4, arrayList2));
            ListIterator listIterator = arrayList.listIterator(arrayList.size());
            while (listIterator.hasPrevious()) {
                this.buffer.push(new TokenWithComments((Token)listIterator.previous()));
            }
        }

        private TokenWithComments popToken() {
            if (this.buffer.isEmpty()) {
                Token token2 = this.tokens.next();
                if (Tokens.isComment(token2)) {
                    this.consolidateCommentBlock(token2);
                    return this.buffer.pop();
                }
                return new TokenWithComments(token2);
            }
            return this.buffer.pop();
        }

        private TokenWithComments nextToken() {
            TokenWithComments tokenWithComments = null;
            tokenWithComments = this.popToken();
            Token token2 = tokenWithComments.token;
            if (Tokens.isProblem(token2)) {
                ConfigOrigin configOrigin = token2.origin();
                String string2 = Tokens.getProblemMessage(token2);
                Throwable throwable = Tokens.getProblemCause(token2);
                boolean bl = Tokens.getProblemSuggestQuotes(token2);
                string2 = bl ? this.addQuoteSuggestion(token2.toString(), string2) : this.addKeyName(string2);
                throw new ConfigException.Parse(configOrigin, string2, throwable);
            }
            if (this.flavor == ConfigSyntax.JSON) {
                if (Tokens.isUnquotedText(token2)) {
                    throw this.parseError(this.addKeyName("Token not allowed in valid JSON: '" + Tokens.getUnquotedText(token2) + "'"));
                }
                if (Tokens.isSubstitution(token2)) {
                    throw this.parseError(this.addKeyName("Substitutions (${} syntax) not allowed in JSON"));
                }
            }
            return tokenWithComments;
        }

        private void putBack(TokenWithComments tokenWithComments) {
            this.buffer.push(tokenWithComments);
        }

        private TokenWithComments nextTokenIgnoringNewline() {
            TokenWithComments tokenWithComments = this.nextToken();
            while (Tokens.isNewline(tokenWithComments.token)) {
                this.lineNumber = tokenWithComments.token.lineNumber() + 1;
                tokenWithComments = this.nextToken();
            }
            return tokenWithComments;
        }

        private boolean checkElementSeparator() {
            if (this.flavor == ConfigSyntax.JSON) {
                TokenWithComments tokenWithComments = this.nextTokenIgnoringNewline();
                if (tokenWithComments.token == Tokens.COMMA) {
                    return true;
                }
                this.putBack(tokenWithComments);
                return false;
            }
            boolean bl = false;
            TokenWithComments tokenWithComments = this.nextToken();
            while (true) {
                if (!Tokens.isNewline(tokenWithComments.token)) {
                    if (tokenWithComments.token == Tokens.COMMA) {
                        return true;
                    }
                    this.putBack(tokenWithComments);
                    return bl;
                }
                this.lineNumber = tokenWithComments.token.lineNumber() + 1;
                bl = true;
                tokenWithComments = this.nextToken();
            }
        }

        private void consolidateValueTokens() {
            if (this.flavor == ConfigSyntax.JSON) {
                return;
            }
            ArrayList<Token> arrayList = null;
            TokenWithComments tokenWithComments = null;
            TokenWithComments tokenWithComments2 = this.nextTokenIgnoringNewline();
            while (Tokens.isValue(tokenWithComments2.token) || Tokens.isUnquotedText(tokenWithComments2.token) || Tokens.isSubstitution(tokenWithComments2.token)) {
                if (arrayList == null) {
                    arrayList = new ArrayList<Token>();
                    tokenWithComments = tokenWithComments2;
                }
                arrayList.add(tokenWithComments2.token);
                tokenWithComments2 = this.nextToken();
            }
            this.putBack(tokenWithComments2);
            if (arrayList == null) {
                return;
            }
            if (arrayList.size() == 1 && Tokens.isValue(tokenWithComments.token)) {
                this.putBack(tokenWithComments);
                return;
            }
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            StringBuilder stringBuilder = new StringBuilder();
            ConfigOrigin configOrigin = null;
            for (Token token2 : arrayList) {
                List<Token> list2;
                if (Tokens.isValue(token2)) {
                    list2 = Tokens.getValue(token2);
                    stringBuilder.append(((AbstractConfigValue)((Object)list2)).transformToString());
                    if (configOrigin != null) continue;
                    configOrigin = ((AbstractConfigValue)((Object)list2)).origin();
                    continue;
                }
                if (Tokens.isUnquotedText(token2)) {
                    list2 = Tokens.getUnquotedText(token2);
                    if (configOrigin == null) {
                        configOrigin = token2.origin();
                    }
                    stringBuilder.append((String)((Object)list2));
                    continue;
                }
                if (Tokens.isSubstitution(token2)) {
                    if (configOrigin == null) {
                        configOrigin = token2.origin();
                    }
                    if (stringBuilder.length() > 0) {
                        arrayList2.add(stringBuilder.toString());
                        stringBuilder.setLength(0);
                    }
                    list2 = Tokens.getSubstitutionPathExpression(token2);
                    Path path = Parser.parsePathExpression(list2.iterator(), token2.origin());
                    boolean bl = Tokens.getSubstitutionOptional(token2);
                    arrayList2.add(new SubstitutionExpression(path, bl));
                    continue;
                }
                throw new ConfigException.BugOrBroken("should not be trying to consolidate token: " + token2);
            }
            if (stringBuilder.length() > 0) {
                arrayList2.add(stringBuilder.toString());
            }
            if (arrayList2.isEmpty()) {
                throw new ConfigException.BugOrBroken("trying to consolidate values to nothing");
            }
            Object object = null;
            object = arrayList2.size() == 1 && arrayList2.get(0) instanceof String ? Tokens.newString(configOrigin, (String)arrayList2.get(0)) : Tokens.newValue(new ConfigSubstitution(configOrigin, arrayList2));
            this.putBack(new TokenWithComments((Token)object, tokenWithComments.comments));
        }

        private ConfigOrigin lineOrigin() {
            return ((SimpleConfigOrigin)this.baseOrigin).setLineNumber(this.lineNumber);
        }

        private ConfigException parseError(String string2) {
            return this.parseError(string2, null);
        }

        private ConfigException parseError(String string2, Throwable throwable) {
            return new ConfigException.Parse(this.lineOrigin(), string2, throwable);
        }

        private String previousFieldName(Path path) {
            if (path != null) {
                return path.render();
            }
            if (this.pathStack.isEmpty()) {
                return null;
            }
            return this.pathStack.peek().render();
        }

        private String previousFieldName() {
            return this.previousFieldName(null);
        }

        private String addKeyName(String string2) {
            String string3 = this.previousFieldName();
            if (string3 != null) {
                return "in value for key '" + string3 + "': " + string2;
            }
            return string2;
        }

        private String addQuoteSuggestion(String string2, String string3) {
            return this.addQuoteSuggestion(null, this.equalsCount > 0, string2, string3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private String addQuoteSuggestion(Path path, boolean bl, String string2, String string3) {
            String string4;
            String string5 = this.previousFieldName(path);
            if (string2.equals(Tokens.END.toString())) {
                if (string5 == null) return string3;
                string4 = string3 + " (if you intended '" + string5 + "' to be part of a value, instead of a key, " + "try adding double quotes around the whole value";
            } else {
                string4 = string5 != null ? string3 + " (if you intended " + string2 + " to be part of the value for '" + string5 + "', " + "try enclosing the value in double quotes" : string3 + " (if you intended " + string2 + " to be part of a key or string value, " + "try enclosing the key or value in double quotes";
            }
            if (!bl) return string4 + ")";
            return string4 + ", or you may be able to rename the file .properties rather than .conf)";
        }

        private AbstractConfigValue parseValue(TokenWithComments tokenWithComments) {
            AbstractConfigValue abstractConfigValue;
            if (Tokens.isValue(tokenWithComments.token)) {
                abstractConfigValue = Tokens.getValue(tokenWithComments.token);
            } else if (tokenWithComments.token == Tokens.OPEN_CURLY) {
                abstractConfigValue = this.parseObject(true);
            } else if (tokenWithComments.token == Tokens.OPEN_SQUARE) {
                abstractConfigValue = this.parseArray();
            } else {
                throw this.parseError(this.addQuoteSuggestion(tokenWithComments.token.toString(), "Expecting a value but got wrong token: " + tokenWithComments.token));
            }
            abstractConfigValue = abstractConfigValue.withOrigin(tokenWithComments.setComments(abstractConfigValue.origin()));
            return abstractConfigValue;
        }

        private static AbstractConfigObject createValueUnderPath(Path path, AbstractConfigValue abstractConfigValue) {
            ArrayList<String> arrayList = new ArrayList<String>();
            String string2 = path.first();
            Path path2 = path.remainder();
            while (string2 != null) {
                arrayList.add(string2);
                if (path2 == null) break;
                string2 = path2.first();
                path2 = path2.remainder();
            }
            ListIterator listIterator = arrayList.listIterator(arrayList.size());
            String string3 = (String)listIterator.previous();
            SimpleConfigObject simpleConfigObject = new SimpleConfigObject(abstractConfigValue.origin().setComments(null), Collections.singletonMap(string3, abstractConfigValue));
            while (listIterator.hasPrevious()) {
                Map<String, AbstractConfigValue> map2 = Collections.singletonMap(listIterator.previous(), simpleConfigObject);
                simpleConfigObject = new SimpleConfigObject(abstractConfigValue.origin().setComments(null), map2);
            }
            return simpleConfigObject;
        }

        private Path parseKey(TokenWithComments tokenWithComments) {
            if (this.flavor == ConfigSyntax.JSON) {
                if (Tokens.isValueWithType(tokenWithComments.token, ConfigValueType.STRING)) {
                    String string2 = (String)Tokens.getValue(tokenWithComments.token).unwrapped();
                    return Path.newKey(string2);
                }
                throw this.parseError(this.addKeyName("Expecting close brace } or a field name here, got " + tokenWithComments));
            }
            ArrayList<Token> arrayList = new ArrayList<Token>();
            TokenWithComments tokenWithComments2 = tokenWithComments;
            while (Tokens.isValue(tokenWithComments2.token) || Tokens.isUnquotedText(tokenWithComments2.token)) {
                arrayList.add(tokenWithComments2.token);
                tokenWithComments2 = this.nextToken();
            }
            if (arrayList.isEmpty()) {
                throw this.parseError(this.addKeyName("expecting a close brace or a field name here, got " + tokenWithComments2));
            }
            this.putBack(tokenWithComments2);
            return Parser.parsePathExpression(arrayList.iterator(), this.lineOrigin());
        }

        private static boolean isIncludeKeyword(Token token2) {
            return Tokens.isUnquotedText(token2) && Tokens.getUnquotedText(token2).equals("include");
        }

        private static boolean isUnquotedWhitespace(Token token2) {
            if (!Tokens.isUnquotedText(token2)) {
                return false;
            }
            String string2 = Tokens.getUnquotedText(token2);
            for (int i = 0; i < string2.length(); ++i) {
                char c = string2.charAt(i);
                if (ConfigImplUtil.isWhitespace(c)) continue;
                return false;
            }
            return true;
        }

        private void parseInclude(Map<String, AbstractConfigValue> map2) {
            TokenWithComments tokenWithComments = this.nextTokenIgnoringNewline();
            while (ParseContext.isUnquotedWhitespace(tokenWithComments.token)) {
                tokenWithComments = this.nextTokenIgnoringNewline();
            }
            if (Tokens.isValueWithType(tokenWithComments.token, ConfigValueType.STRING)) {
                String string2 = (String)Tokens.getValue(tokenWithComments.token).unwrapped();
                AbstractConfigObject abstractConfigObject = (AbstractConfigObject)this.includer.include(this.includeContext, string2);
                if (!this.pathStack.isEmpty()) {
                    Path path = new Path(this.pathStack);
                    abstractConfigObject = abstractConfigObject.relativized(path);
                }
                for (String string3 : abstractConfigObject.keySet()) {
                    AbstractConfigValue abstractConfigValue = abstractConfigObject.get(string3);
                    AbstractConfigValue abstractConfigValue2 = map2.get(string3);
                    if (abstractConfigValue2 != null) {
                        map2.put(string3, abstractConfigValue.withFallback(abstractConfigValue2));
                        continue;
                    }
                    map2.put(string3, abstractConfigValue);
                }
            } else {
                throw this.parseError("include keyword is not followed by a quoted string, but by: " + tokenWithComments);
            }
        }

        private boolean isKeyValueSeparatorToken(Token token2) {
            if (this.flavor == ConfigSyntax.JSON) {
                return token2 == Tokens.COLON;
            }
            return token2 == Tokens.COLON || token2 == Tokens.EQUALS;
        }

        private AbstractConfigObject parseObject(boolean bl) {
            ConfigOrigin configOrigin;
            HashMap<String, AbstractConfigValue> hashMap;
            block24: {
                TokenWithComments tokenWithComments;
                hashMap = new HashMap<String, AbstractConfigValue>();
                configOrigin = this.lineOrigin();
                boolean bl2 = false;
                Path path = null;
                boolean bl3 = false;
                while (true) {
                    tokenWithComments = this.nextTokenIgnoringNewline();
                    if (tokenWithComments.token == Tokens.CLOSE_CURLY) {
                        if (this.flavor == ConfigSyntax.JSON && bl2) {
                            throw this.parseError(this.addQuoteSuggestion(tokenWithComments.toString(), "expecting a field name after a comma, got a close brace } instead"));
                        }
                        if (!bl) {
                            throw this.parseError(this.addQuoteSuggestion(tokenWithComments.toString(), "unbalanced close brace '}' with no open brace"));
                        }
                        break block24;
                    }
                    if (tokenWithComments.token == Tokens.END && !bl) {
                        this.putBack(tokenWithComments);
                        break block24;
                    }
                    if (this.flavor != ConfigSyntax.JSON && ParseContext.isIncludeKeyword(tokenWithComments.token)) {
                        this.parseInclude(hashMap);
                        bl2 = false;
                    } else {
                        AbstractConfigValue abstractConfigValue;
                        TokenWithComments tokenWithComments2;
                        TokenWithComments tokenWithComments3 = tokenWithComments;
                        Path path2 = this.parseKey(tokenWithComments3);
                        TokenWithComments tokenWithComments4 = this.nextTokenIgnoringNewline();
                        boolean bl4 = false;
                        this.pathStack.push(path2);
                        if (this.flavor == ConfigSyntax.CONF && tokenWithComments4.token == Tokens.OPEN_CURLY) {
                            tokenWithComments2 = tokenWithComments4;
                        } else {
                            if (!this.isKeyValueSeparatorToken(tokenWithComments4.token)) {
                                throw this.parseError(this.addQuoteSuggestion(tokenWithComments4.toString(), "Key '" + path2.render() + "' may not be followed by token: " + tokenWithComments4));
                            }
                            if (tokenWithComments4.token == Tokens.EQUALS) {
                                bl4 = true;
                                ++this.equalsCount;
                            }
                            this.consolidateValueTokens();
                            tokenWithComments2 = this.nextTokenIgnoringNewline();
                        }
                        AbstractConfigValue abstractConfigValue2 = this.parseValue(tokenWithComments2.prepend(tokenWithComments3.comments));
                        path = this.pathStack.pop();
                        if (bl4) {
                            --this.equalsCount;
                        }
                        bl3 = bl4;
                        String string2 = path2.first();
                        Path path3 = path2.remainder();
                        if (path3 == null) {
                            abstractConfigValue = (AbstractConfigValue)hashMap.get(string2);
                            if (abstractConfigValue != null) {
                                if (this.flavor == ConfigSyntax.JSON) {
                                    throw this.parseError("JSON does not allow duplicate fields: '" + string2 + "' was already seen at " + abstractConfigValue.origin().description());
                                }
                                abstractConfigValue2 = abstractConfigValue2.withFallback(abstractConfigValue);
                            }
                            hashMap.put(string2, abstractConfigValue2);
                        } else {
                            if (this.flavor == ConfigSyntax.JSON) {
                                throw new ConfigException.BugOrBroken("somehow got multi-element path in JSON mode");
                            }
                            abstractConfigValue = ParseContext.createValueUnderPath(path3, abstractConfigValue2);
                            AbstractConfigValue abstractConfigValue3 = (AbstractConfigValue)hashMap.get(string2);
                            if (abstractConfigValue3 != null) {
                                abstractConfigValue = ((AbstractConfigObject)abstractConfigValue).withFallback(abstractConfigValue3);
                            }
                            hashMap.put(string2, abstractConfigValue);
                        }
                        bl2 = false;
                    }
                    if (!this.checkElementSeparator()) break;
                    bl2 = true;
                }
                tokenWithComments = this.nextTokenIgnoringNewline();
                if (tokenWithComments.token == Tokens.CLOSE_CURLY) {
                    if (!bl) {
                        throw this.parseError(this.addQuoteSuggestion(path, bl3, tokenWithComments.toString(), "unbalanced close brace '}' with no open brace"));
                    }
                } else {
                    if (bl) {
                        throw this.parseError(this.addQuoteSuggestion(path, bl3, tokenWithComments.toString(), "Expecting close brace } or a comma, got " + tokenWithComments));
                    }
                    if (tokenWithComments.token == Tokens.END) {
                        this.putBack(tokenWithComments);
                    } else {
                        throw this.parseError(this.addQuoteSuggestion(path, bl3, tokenWithComments.toString(), "Expecting end of input or a comma, got " + tokenWithComments));
                    }
                }
            }
            return new SimpleConfigObject(configOrigin, hashMap);
        }

        private SimpleConfigList parseArray() {
            ConfigOrigin configOrigin = this.lineOrigin();
            ArrayList<AbstractConfigValue> arrayList = new ArrayList<AbstractConfigValue>();
            this.consolidateValueTokens();
            TokenWithComments tokenWithComments = this.nextTokenIgnoringNewline();
            if (tokenWithComments.token == Tokens.CLOSE_SQUARE) {
                return new SimpleConfigList(configOrigin, Collections.<AbstractConfigValue>emptyList());
            }
            if (!Tokens.isValue(tokenWithComments.token) && tokenWithComments.token != Tokens.OPEN_CURLY && tokenWithComments.token != Tokens.OPEN_SQUARE) {
                throw this.parseError(this.addKeyName("List should have ] or a first element after the open [, instead had token: " + tokenWithComments + " (if you want " + tokenWithComments + " to be part of a string value, then double-quote it)"));
            }
            arrayList.add(this.parseValue(tokenWithComments));
            while (true) {
                if (!this.checkElementSeparator()) {
                    tokenWithComments = this.nextTokenIgnoringNewline();
                    if (tokenWithComments.token == Tokens.CLOSE_SQUARE) {
                        return new SimpleConfigList(configOrigin, arrayList);
                    }
                    throw this.parseError(this.addKeyName("List should have ended with ] or had a comma, instead had token: " + tokenWithComments + " (if you want " + tokenWithComments + " to be part of a string value, then double-quote it)"));
                }
                this.consolidateValueTokens();
                tokenWithComments = this.nextTokenIgnoringNewline();
                if (Tokens.isValue(tokenWithComments.token) || tokenWithComments.token == Tokens.OPEN_CURLY || tokenWithComments.token == Tokens.OPEN_SQUARE) {
                    arrayList.add(this.parseValue(tokenWithComments));
                    continue;
                }
                if (this.flavor == ConfigSyntax.JSON || tokenWithComments.token != Tokens.CLOSE_SQUARE) break;
                this.putBack(tokenWithComments);
            }
            throw this.parseError(this.addKeyName("List should have had new element after a comma, instead had token: " + tokenWithComments + " (if you want the comma or " + tokenWithComments + " to be part of a string value, then double-quote it)"));
        }

        AbstractConfigValue parse() {
            TokenWithComments tokenWithComments = this.nextTokenIgnoringNewline();
            if (tokenWithComments.token != Tokens.START) {
                throw new ConfigException.BugOrBroken("token stream did not begin with START, had " + tokenWithComments);
            }
            tokenWithComments = this.nextTokenIgnoringNewline();
            AbstractConfigValue abstractConfigValue = null;
            if (tokenWithComments.token == Tokens.OPEN_CURLY || tokenWithComments.token == Tokens.OPEN_SQUARE) {
                abstractConfigValue = this.parseValue(tokenWithComments);
            } else {
                if (this.flavor == ConfigSyntax.JSON) {
                    if (tokenWithComments.token == Tokens.END) {
                        throw this.parseError("Empty document");
                    }
                    throw this.parseError("Document must have an object or array at root, unexpected token: " + tokenWithComments);
                }
                this.putBack(tokenWithComments);
                abstractConfigValue = this.parseObject(false);
            }
            tokenWithComments = this.nextTokenIgnoringNewline();
            if (tokenWithComments.token == Tokens.END) {
                return abstractConfigValue;
            }
            throw this.parseError("Document has trailing tokens after first object or array: " + tokenWithComments);
        }
    }

    private static final class TokenWithComments {
        final Token token;
        final List<Token> comments;

        TokenWithComments(Token token2, List<Token> list2) {
            this.token = token2;
            this.comments = list2;
        }

        TokenWithComments(Token token2) {
            this(token2, Collections.emptyList());
        }

        TokenWithComments prepend(List<Token> list2) {
            if (this.comments.isEmpty()) {
                return new TokenWithComments(this.token, list2);
            }
            ArrayList<Token> arrayList = new ArrayList<Token>();
            arrayList.addAll(list2);
            arrayList.addAll(this.comments);
            return new TokenWithComments(this.token, arrayList);
        }

        SimpleConfigOrigin setComments(SimpleConfigOrigin simpleConfigOrigin) {
            if (this.comments.isEmpty()) {
                return simpleConfigOrigin;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Token token2 : this.comments) {
                arrayList.add(Tokens.getCommentText(token2));
            }
            return simpleConfigOrigin.setComments(arrayList);
        }

        public String toString() {
            return this.token.toString();
        }
    }
}

