/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.snpeff.fileIterator.BedFileIterator;
import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.interval.Genome;
import org.snpeff.interval.Markers;
import org.snpeff.interval.tree.IntervalForest;
import org.snpeff.util.Timer;
import org.snpeff.vcf.VcfEntry;
import org.snpsift.SnpSift;

public class SnpSiftCmdIntervals
extends SnpSift {
    String vcfFileName;
    LinkedList<String> bedFiles;
    IntervalForest intervalForest;
    Genome genome;
    boolean exclude;

    public SnpSiftCmdIntervals() {
    }

    public SnpSiftCmdIntervals(String[] args) {
        super(args);
    }

    @Override
    public void init() {
        super.init();
        this.verbose = false;
        this.genome = new Genome("genome");
        this.exclude = false;
        this.vcfFileName = "-";
    }

    void loadIntervals() {
        LinkedList seqChangesAll = new LinkedList();
        for (String bedFileName : this.bedFiles) {
            if (this.verbose) {
                Timer.showStdErr("Reading filter interval file '" + bedFileName + "'");
            }
            BedFileIterator bedFile = new BedFileIterator(bedFileName, this.genome);
            bedFile.setCreateChromos(true);
            List seqChanges = bedFile.load();
            seqChangesAll.addAll(seqChanges);
        }
        if (this.verbose) {
            Timer.showStdErr("Total " + seqChangesAll.size() + " intervals added.");
        }
        if (this.verbose) {
            Timer.showStdErr("Building interval forest.");
        }
        this.intervalForest = new IntervalForest();
        this.intervalForest.add(seqChangesAll);
        this.intervalForest.build();
        if (this.verbose) {
            Timer.showStdErr("Done.");
        }
    }

    @Override
    public void parseArgs(String[] args) {
        if (args.length <= 0) {
            this.usage(null);
        }
        this.bedFiles = new LinkedList();
        for (int i = 0; i < args.length; ++i) {
            if (this.isOpt(args[i])) {
                if (args[i].equals("-h") || args[i].equalsIgnoreCase("-help")) {
                    this.usage(null);
                    continue;
                }
                if (args[i].equals("-x")) {
                    this.exclude = true;
                    continue;
                }
                if (!args[i].equals("-i")) continue;
                this.vcfFileName = args[++i];
                continue;
            }
            this.bedFiles.add(args[i]);
        }
    }

    @Override
    public boolean run() {
        this.run(false);
        return true;
    }

    public List<VcfEntry> run(boolean createList) {
        this.loadIntervals();
        if (this.verbose) {
            Timer.showStdErr("FileName: '" + this.vcfFileName + "'\n\t\t\tIntervals: " + this.bedFiles + "\n\t\t\tExclude : " + this.exclude);
        }
        ArrayList<VcfEntry> results = new ArrayList<VcfEntry>();
        VcfFileIterator vcfFile = new VcfFileIterator(this.vcfFileName);
        vcfFile.setDebug(this.debug);
        boolean showHeader = true;
        for (VcfEntry vcfEntry : vcfFile) {
            Markers queryResult;
            if (showHeader) {
                this.addHeaders(vcfFile);
                String headerStr = vcfFile.getVcfHeader().toString();
                if (!headerStr.isEmpty()) {
                    this.print(headerStr);
                }
                showHeader = false;
            }
            if ((queryResult = this.intervalForest.query(vcfEntry)).isEmpty()) {
                if (!this.exclude) continue;
                results.add(vcfEntry);
                this.print(vcfEntry);
                continue;
            }
            if (this.exclude) continue;
            results.add(vcfEntry);
            this.print(vcfEntry);
        }
        return results;
    }

    @Override
    public void usage(String msg) {
        if (msg != null) {
            System.err.println("Error: " + msg);
            this.showCmd();
        }
        this.showVersion();
        System.err.println("Usage: java -jar " + SnpSift.class.getSimpleName() + ".jar intervals [-x] file_1.bed file_2.bed ... file_N.bed");
        System.err.println("Options:");
        System.err.println("\t\t-i <file> :\tVCF file. Default STDIN");
        System.err.println("\t\t-x        :\tExclude VCF entries in intervals");
        System.exit(1);
    }
}

