/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift;

import org.snpeff.fileIterator.MatrixEntry;
import org.snpeff.fileIterator.MatrixEntryFileIterator;
import org.snpeff.util.Gpr;
import org.snpeff.util.Timer;
import org.snpsift.SnpSift;

public class SnpSiftCmdCovarianceMatrix
extends SnpSift {
    public static int SHOW_EVERY = 10000;
    String matrixFile;
    double[] mean;
    double[][] matrix;

    public SnpSiftCmdCovarianceMatrix() {
    }

    public SnpSiftCmdCovarianceMatrix(String[] args) {
        super(args);
    }

    public void covariance() {
        int i;
        int len = this.mean.length;
        this.matrix = new double[len][len];
        for (int i2 = 0; i2 < len; ++i2) {
            for (int j = 0; j < len; ++j) {
                this.matrix[i2][j] = 0.0;
            }
        }
        int count2 = 0;
        int lineNum = 1;
        MatrixEntryFileIterator mfile = new MatrixEntryFileIterator(this.matrixFile);
        for (MatrixEntry m : mfile) {
            int[] scores = m.getValues();
            for (int i3 = 0; i3 < len; ++i3) {
                for (int j = i3; j < len; ++j) {
                    double[] dArray = this.matrix[i3];
                    int n = j;
                    dArray[n] = dArray[n] + ((double)scores[i3] - this.mean[i3]) * ((double)scores[j] - this.mean[j]);
                }
            }
            Gpr.showMark(lineNum++, SHOW_EVERY);
            ++count2;
        }
        for (i = 0; i < len; ++i) {
            for (int j = i + 1; j < len; ++j) {
                this.matrix[j][i] = this.matrix[i][j];
            }
        }
        if (count2 > 0) {
            for (i = 0; i < len; ++i) {
                for (int j = 0; j < len; ++j) {
                    double[] dArray = this.matrix[j];
                    int n = i;
                    dArray[n] = dArray[n] / (double)count2;
                }
            }
        }
        for (i = 0; i < len; ++i) {
            double p = this.mean[i] / 2.0;
            double sigma = Math.sqrt(p * (1.0 - p));
            if (sigma == 0.0) {
                throw new RuntimeException("Sigma is zero for column " + i + " (mean = " + this.mean[i] + "). This should never happen!");
            }
            for (int j = 0; j < len; ++j) {
                double[] dArray = this.matrix[j];
                int n = i;
                dArray[n] = dArray[n] / sigma;
            }
        }
    }

    public void mean() {
        long[] sum2 = null;
        int count2 = 0;
        int lineNum = 1;
        MatrixEntryFileIterator mfile = new MatrixEntryFileIterator(this.matrixFile);
        for (MatrixEntry m : mfile) {
            int[] scores = m.getValues();
            if (sum2 == null) {
                sum2 = new long[scores.length];
            }
            for (int i = 0; i < scores.length; ++i) {
                int n = i;
                sum2[n] = sum2[n] + (long)scores[i];
            }
            Gpr.showMark(lineNum++, SHOW_EVERY);
            ++count2;
        }
        this.mean = new double[sum2.length];
        if (count2 > 0) {
            for (int i = 0; i < this.mean.length; ++i) {
                this.mean[i] = (double)sum2[i] / (double)count2;
            }
        }
    }

    @Override
    public void parseArgs(String[] args) {
        if (args.length != 1) {
            this.usage(null);
        }
        this.matrixFile = args[0];
    }

    @Override
    public boolean run() {
        Timer.showStdErr("Pass1: Processing file '" + this.matrixFile + "'");
        this.mean();
        Timer.showStdErr("Pass2: Processing file '" + this.matrixFile + "'");
        this.covariance();
        System.out.println(this);
        Timer.showStdErr("Done");
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.matrix.length; ++i) {
            String sep = "";
            for (int j = 0; j < this.matrix[i].length; ++j) {
                sb.append(sep + this.matrix[i][j]);
                sep = "\t";
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    @Override
    public void usage(String msg) {
        if (msg != null) {
            System.err.println("Error: " + msg);
            this.showCmd();
        }
        this.showVersion();
        System.err.println("Usage: java -jar " + SnpSift.class.getSimpleName() + ".jar covMat allele.matrix.txt > cov.matrix.txt");
        System.exit(1);
    }
}

