/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.vcf;

import java.util.Collection;
import java.util.LinkedList;
import org.snpeff.interval.Variant;
import org.snpeff.vcf.VcfEntry;

public class VariantVcfEntry
extends Variant {
    private static final long serialVersionUID = 2589022632388179932L;
    protected VcfEntry vcfEntry;

    public static Collection<VariantVcfEntry> factory(VcfEntry vcfEntry) {
        LinkedList<VariantVcfEntry> list2 = new LinkedList<VariantVcfEntry>();
        for (Variant var : vcfEntry.variants()) {
            list2.add(new VariantVcfEntry(var, vcfEntry));
        }
        return list2;
    }

    public VariantVcfEntry(Variant variant, VcfEntry vcfEntry) {
        super(variant.getParent(), variant.getStart(), variant.getEnd(), variant.getId());
        this.chromosomeNameOri = variant.getChromosomeNameOri();
        this.type = variant.getType();
        this.variantType = variant.getVariantType();
        this.ref = variant.getReference();
        this.alt = variant.getAlt();
        this.genotype = variant.getGenotype();
        this.imprecise = variant.isImprecise();
        this.vcfEntry = vcfEntry;
    }

    public VcfEntry getVcfEntry() {
        return this.vcfEntry;
    }

    @Override
    public String toString() {
        return "Variant: " + super.toString() + "\tVcfEntry: " + this.vcfEntry;
    }
}

