/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.unity;

import junit.framework.Assert;
import org.junit.Test;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Variant;
import org.snpeff.snpEffect.HgvsDna;
import org.snpeff.snpEffect.HgvsProtein;
import org.snpeff.snpEffect.VariantEffect;
import org.snpeff.snpEffect.VariantEffects;
import org.snpeff.snpEffect.testCases.unity.TestCasesBase;
import org.snpeff.util.Gpr;

public class TestCasesHgvsProtDup
extends TestCasesBase {
    @Test
    public void test_01() {
        Gpr.debug("Test");
        this.prependSequenceToFirstExon("atgaaaatgggccatcagcagcagtgctgc");
        if (this.verbose) {
            Gpr.debug(this.transcript);
        }
        Variant variant = new Variant((Marker)this.chromosome, 898, "", "ggccatcag", "");
        if (this.verbose) {
            Gpr.debug("Variant: " + variant);
        }
        VariantEffects effs = this.snpEffectPredictor.variantEffect(variant);
        VariantEffect eff = effs.get();
        HgvsDna hgvsc = new HgvsDna(eff);
        String hgvsDna = hgvsc.toString();
        HgvsProtein hgvsp = new HgvsProtein(eff);
        String hgvsProt = hgvsp.toString();
        if (this.verbose) {
            Gpr.debug("Eff        : " + eff);
            Gpr.debug("HGVS (DNA) : '" + hgvsDna + "'");
            Gpr.debug("HGVS (Prot): '" + hgvsProt + "'");
        }
        Assert.assertEquals("c.10_18dupGGCCATCAG", hgvsDna);
        Assert.assertEquals("p.Gly4_Gln6dup", hgvsProt);
    }

    @Test
    public void test_02() {
        Gpr.debug("Test");
        this.prependSequenceToFirstExon("atgaaaatgggccatcagcatcagcagcagtgctgc");
        if (this.verbose) {
            Gpr.debug(this.transcript);
        }
        Variant variant = new Variant((Marker)this.chromosome, 904, "", "catcag", "");
        if (this.verbose) {
            Gpr.debug("Variant: " + variant);
        }
        VariantEffects effs = this.snpEffectPredictor.variantEffect(variant);
        VariantEffect eff = effs.get();
        HgvsDna hgvsc = new HgvsDna(eff);
        String hgvsDna = hgvsc.toString();
        HgvsProtein hgvsp = new HgvsProtein(eff);
        String hgvsProt = hgvsp.toString();
        if (this.verbose) {
            Gpr.debug("Eff        : " + eff);
            Gpr.debug("HGVS (DNA) : '" + hgvsDna + "'");
            Gpr.debug("HGVS (Prot): '" + hgvsProt + "'");
        }
        Assert.assertEquals("c.19_24dupCATCAG", hgvsDna);
        Assert.assertEquals("p.His7_Gln8dup", hgvsProt);
    }
}

