/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.integration;

import java.util.HashSet;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;
import org.snpeff.SnpEff;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Variant;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.snpEffect.VariantEffect;
import org.snpeff.snpEffect.VariantEffects;
import org.snpeff.snpEffect.commandLine.SnpEffCmdEff;
import org.snpeff.snpEffect.testCases.unity.TestCasesBase;
import org.snpeff.util.Gpr;
import org.snpeff.vcf.VcfEffect;
import org.snpeff.vcf.VcfEntry;

public class TestCasesAnn
extends TestCasesBase {
    List<VcfEntry> annotate(String vcfFile) {
        String genome = "test_ENSG00000158062";
        String[] args = new String[]{"-noLog", "-noStats", genome, vcfFile};
        SnpEff snpEff = new SnpEff(args);
        snpEff.setVerbose(this.verbose);
        snpEff.setSupressOutput(!this.verbose);
        snpEff.setDebug(this.debug);
        SnpEffCmdEff seff = (SnpEffCmdEff)snpEff.cmd();
        List<VcfEntry> vcfEntries = seff.run(true);
        Assert.assertTrue("Empty annotataions list!", !vcfEntries.isEmpty());
        return vcfEntries;
    }

    VcfEntry annotateFirst(String vcfFile) {
        List<VcfEntry> vcfEntries = this.annotate(vcfFile);
        return vcfEntries.get(0);
    }

    VcfEffect annotateFirst(String vcfFile, String trId) {
        List<VcfEntry> vcfEntries = this.annotate(vcfFile);
        VcfEntry ve = vcfEntries.get(0);
        for (VcfEffect veff : ve.getVcfEffects()) {
            if (this.verbose) {
                System.out.println("\t" + veff + "\n\t\tveff.getEffectString() : " + veff.getVcfFieldString() + "\n\t\tveff.getEffectsStr()   : " + veff.getEffectsStr() + "\n\t\tveff.getEffectsStrSo() : " + veff.getEffectsStrSo() + "\n\t\tveff.getEffectType()   : " + (Object)((Object)veff.getEffectType()) + "\n\t\tveff.getEffectTypes()  : " + veff.getEffectTypes());
            }
            if (trId != null && !veff.getTranscriptId().equals(trId)) continue;
            return veff;
        }
        throw new RuntimeException("Transcript '" + trId + "' not found");
    }

    @Test
    public void test_01_Annotation_Stop() {
        Gpr.debug("Test");
        String vcfFile = "tests/test_ann_01.vcf";
        VcfEffect veff = this.annotateFirst(vcfFile, "ENST00000472155");
        if (this.verbose) {
            Gpr.debug(veff);
        }
        Assert.assertEquals("A", veff.getAllele());
        Assert.assertEquals("stop_gained", veff.getEffectsStrSo());
        Assert.assertEquals("STOP_GAINED", veff.getEffectsStr());
        Assert.assertEquals("HIGH", veff.getImpact().toString());
        Assert.assertEquals("UBXN11", veff.getGeneName());
        Assert.assertEquals("ENSG00000158062", veff.getGeneId());
        Assert.assertEquals("transcript", veff.getFeatureType());
        Assert.assertEquals("ENST00000472155", veff.getFeatureId());
        Assert.assertEquals("ENST00000472155", veff.getTranscriptId());
        Assert.assertEquals("protein_coding", veff.getBioType().toString());
        Assert.assertEquals("10", "" + veff.getRank());
        Assert.assertEquals("14", "" + veff.getRankMax());
        Assert.assertEquals("c.1915C>T", veff.getHgvsDna());
        Assert.assertEquals("p.Gln639*", veff.getHgvsProt());
        Assert.assertEquals("1915", "" + veff.getcDnaPos());
        Assert.assertEquals("2646", "" + veff.getcDnaLen());
        Assert.assertEquals("1915", "" + veff.getCdsPos());
        Assert.assertEquals("2646", "" + veff.getCdsLen());
        Assert.assertEquals("639", "" + veff.getAaPos());
        Assert.assertEquals("881", "" + veff.getAaLen());
        Assert.assertEquals("WARNING_TRANSCRIPT_MULTIPLE_STOP_CODONS", veff.getErrorsWarning());
    }

    @Test
    public void test_01_VcfRawAlt() {
        Gpr.debug("Test");
        String[] args = new String[]{"testHg3775Chr1", "tests/test_ann_integration_01.vcf"};
        SnpEff cmd = new SnpEff(args);
        SnpEffCmdEff cmdEff = (SnpEffCmdEff)cmd.cmd();
        cmdEff.setVerbose(this.verbose);
        cmdEff.setSupressOutput(!this.verbose);
        List<VcfEntry> list2 = cmdEff.run(true);
        Assert.assertTrue("Errors while executing SnpEff", cmdEff.getTotalErrs() <= 0);
        HashSet<String> allelesExpected = new HashSet<String>();
        allelesExpected.add("AACACACACACACACACACACACACACACACACACACAC");
        allelesExpected.add("AACACACACACACACACACACACACACACACACACACACAC");
        allelesExpected.add("AACACACACACACACACACACACACACAC");
        allelesExpected.add("AACACACACACACACACACACACACACACACACACACACACAC");
        allelesExpected.add("AACACACACACACACACACACACACACACACACACAC");
        HashSet<String> allelesReal = new HashSet<String>();
        for (VcfEntry vcfEntry : list2) {
            if (this.debug) {
                System.err.println(vcfEntry);
            }
            for (VcfEffect eff : vcfEntry.getVcfEffects()) {
                String allele = eff.getAllele();
                if (this.verbose) {
                    System.err.println("\t" + eff + "\n\t\tAllele: " + allele);
                }
                Assert.assertTrue("Unexpected allele '" + allele + "'", allelesExpected.contains(allele));
                allelesReal.add(allele);
            }
        }
        Assert.assertEquals(allelesExpected, allelesReal);
    }

    @Test
    public void test_02_Annotation_SpliceRegion() {
        Gpr.debug("Test");
        String vcfFile = "tests/test_ann_02.vcf";
        VcfEffect veff = this.annotateFirst(vcfFile, "ENST00000374221");
        if (this.verbose) {
            Gpr.debug(veff);
        }
        Assert.assertEquals("A", veff.getAllele());
        Assert.assertEquals("splice_region_variant&intron_variant", veff.getEffectsStrSo());
        Assert.assertEquals("SPLICE_SITE_REGION&INTRON", veff.getEffectsStr());
        Assert.assertEquals("LOW", veff.getImpact().toString());
        Assert.assertEquals("UBXN11", veff.getGeneName());
        Assert.assertEquals("ENSG00000158062", veff.getGeneId());
        Assert.assertEquals("transcript", veff.getFeatureType());
        Assert.assertEquals("ENST00000374221", veff.getFeatureId());
        Assert.assertEquals("ENST00000374221", veff.getTranscriptId());
        Assert.assertEquals("protein_coding", veff.getBioType().toString());
        Assert.assertEquals("11", "" + veff.getRank());
        Assert.assertEquals("15", "" + veff.getRankMax());
        Assert.assertEquals("c.853-3C>T", veff.getHgvsDna());
        Assert.assertEquals("", veff.getHgvsProt());
        Assert.assertEquals("-1", "" + veff.getcDnaPos());
        Assert.assertEquals("-1", "" + veff.getcDnaLen());
        Assert.assertEquals("-1", "" + veff.getCdsPos());
        Assert.assertEquals("-1", "" + veff.getCdsLen());
        Assert.assertEquals("-1", "" + veff.getAaPos());
        Assert.assertEquals("-1", "" + veff.getAaLen());
        Assert.assertEquals("", veff.getErrorsWarning());
    }

    @Test
    public void test_03_Annotation_NonSyn() {
        Gpr.debug("Test");
        String vcfFile = "tests/test_ann_03.vcf";
        VcfEffect veff = this.annotateFirst(vcfFile, "ENST00000374221");
        if (this.verbose) {
            Gpr.debug(veff);
        }
        Assert.assertEquals("A", veff.getAllele());
        Assert.assertEquals("missense_variant&splice_region_variant", veff.getEffectsStrSo());
        Assert.assertEquals("NON_SYNONYMOUS_CODING&SPLICE_SITE_REGION", veff.getEffectsStr());
        Assert.assertEquals("MODERATE", veff.getImpact().toString());
        Assert.assertEquals("UBXN11", veff.getGeneName());
        Assert.assertEquals("ENSG00000158062", veff.getGeneId());
        Assert.assertEquals("transcript", veff.getFeatureType());
        Assert.assertEquals("ENST00000374221", veff.getFeatureId());
        Assert.assertEquals("ENST00000374221", veff.getTranscriptId());
        Assert.assertEquals("protein_coding", veff.getBioType().toString());
        Assert.assertEquals("12", "" + veff.getRank());
        Assert.assertEquals("16", "" + veff.getRankMax());
        Assert.assertEquals("c.853C>T", veff.getHgvsDna());
        Assert.assertEquals("p.Val285Leu", veff.getHgvsProt());
        Assert.assertEquals("1067", "" + veff.getcDnaPos());
        Assert.assertEquals("1792", "" + veff.getcDnaLen());
        Assert.assertEquals("853", "" + veff.getCdsPos());
        Assert.assertEquals("1563", "" + veff.getCdsLen());
        Assert.assertEquals("285", "" + veff.getAaPos());
        Assert.assertEquals("520", "" + veff.getAaLen());
        Assert.assertEquals("WARNING_REF_DOES_NOT_MATCH_GENOME", veff.getErrorsWarning());
    }

    @Test
    public void test_04_Annotation_Intergenic() {
        Gpr.debug("Test");
        String vcfFile = "tests/test_ann_04.vcf";
        VcfEffect veff = this.annotateFirst(vcfFile, null);
        if (this.verbose) {
            Gpr.debug(veff);
        }
        Assert.assertEquals("A", veff.getAllele());
        Assert.assertEquals("intergenic_region", veff.getEffectsStrSo());
        Assert.assertEquals("INTERGENIC", veff.getEffectsStr());
        Assert.assertEquals("MODIFIER", veff.getImpact().toString());
        Assert.assertEquals("CHR_START-UBXN11", veff.getGeneName());
        Assert.assertEquals("CHR_START-ENSG00000158062", veff.getGeneId());
        Assert.assertEquals("intergenic_region", veff.getFeatureType());
        Assert.assertEquals("CHR_START-ENSG00000158062", veff.getFeatureId());
        Assert.assertEquals("", veff.getTranscriptId());
        Assert.assertTrue(veff.getBioType() == null);
        Assert.assertEquals("-1", "" + veff.getRank());
        Assert.assertEquals("-1", "" + veff.getRankMax());
        Assert.assertEquals("n.26600818G>A", veff.getHgvsDna());
        Assert.assertEquals("", veff.getHgvsProt());
        Assert.assertEquals("-1", "" + veff.getcDnaPos());
        Assert.assertEquals("-1", "" + veff.getcDnaLen());
        Assert.assertEquals("-1", "" + veff.getCdsPos());
        Assert.assertEquals("-1", "" + veff.getCdsLen());
        Assert.assertEquals("-1", "" + veff.getAaPos());
        Assert.assertEquals("-1", "" + veff.getAaLen());
        Assert.assertEquals("", veff.getErrorsWarning());
    }

    @Test
    public void test_05_Annotation_EndOfChromosome() {
        Gpr.debug("Test");
        Variant variant = new Variant((Marker)this.genome.getChromosome("1"), 2001, "", "TTT", "");
        VariantEffects veffs = this.snpEffectPredictor.variantEffect(variant);
        if (this.verbose) {
            System.out.println("Number of effects: " + veffs.size());
        }
        Assert.assertEquals(1, veffs.size());
        VariantEffect veff = veffs.get(0);
        if (this.verbose) {
            System.out.println("Effect type : " + (Object)((Object)veff.getEffectType()));
        }
        Assert.assertEquals((Object)EffectType.CHROMOSOME_ELONGATION, (Object)veff.getEffectType());
    }
}

