/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.commandLine;

import java.util.HashSet;
import org.snpeff.SnpEff;
import org.snpeff.interval.Cds;
import org.snpeff.interval.Exon;
import org.snpeff.interval.Gene;
import org.snpeff.interval.Genome;
import org.snpeff.interval.Transcript;
import org.snpeff.util.Gpr;
import org.snpeff.util.Timer;

public class SnpEffCmdGenes2Bed
extends SnpEff {
    HashSet<String> geneIds = new HashSet();
    String fileName = null;
    boolean onlyProteinCoding;
    boolean showCds;
    boolean showExons;
    boolean showTranscripts;
    int expandUpstreamDownstream = 0;

    public static void main(String[] args) {
        SnpEffCmdGenes2Bed conf2down = new SnpEffCmdGenes2Bed();
        conf2down.parseArgs(args);
        conf2down.run();
    }

    void loadGenes() {
        if (this.fileName != null) {
            String[] lines2;
            if (this.verbose) {
                Timer.showStdErr("Loading genes list from file '" + this.fileName + "'");
            }
            if ((lines2 = Gpr.readFile(this.fileName).split("\n")).length <= 0) {
                throw new RuntimeException("Cannot read file '" + this.fileName + "'");
            }
            for (String line : lines2) {
                String id = line.trim();
                if (id.isEmpty()) continue;
                this.geneIds.add(id);
            }
        }
    }

    @Override
    public void parseArgs(String[] args) {
        if (args.length < 1) {
            this.usage(null);
        }
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (this.isOpt(arg)) {
                switch (arg.toLowerCase()) {
                    case "-e": {
                        this.showExons = true;
                        break;
                    }
                    case "-cds": {
                        this.showCds = true;
                        break;
                    }
                    case "-f": {
                        if (i + 1 < args.length) {
                            this.fileName = args[++i];
                            break;
                        }
                        this.usage("Option '-f' without file argument");
                        break;
                    }
                    case "-pc": {
                        this.onlyProteinCoding = true;
                        break;
                    }
                    case "-tr": {
                        this.showTranscripts = true;
                        break;
                    }
                    case "-ud": {
                        if (i + 1 < args.length) {
                            this.expandUpstreamDownstream = Gpr.parseIntSafe(args[++i]);
                            break;
                        }
                        this.usage("Option '-ud' without file argument");
                        break;
                    }
                    default: {
                        this.usage("Unknown commnand line option '" + arg + "'");
                        break;
                    }
                }
                continue;
            }
            if (this.genomeVer == null || this.genomeVer.isEmpty()) {
                this.genomeVer = args[i];
                continue;
            }
            this.geneIds.add(args[i]);
        }
        int countMutex = 0;
        if (this.showCds) {
            ++countMutex;
        }
        if (this.showExons) {
            ++countMutex;
        }
        if (this.showTranscripts) {
            ++countMutex;
        }
        if (countMutex > 1) {
            this.usage("Options '-e', '-cds' and '-tr' are mutually exclusive");
        }
    }

    @Override
    public boolean run() {
        this.loadGenes();
        if (this.verbose) {
            Timer.showStdErr("Number of gene IDs to look up: " + this.geneIds.size());
            if (this.geneIds.isEmpty()) {
                Timer.showStdErr("Empty list of IDs. Using all genes.");
            }
        }
        this.loadConfig();
        this.loadDb();
        this.showGenes();
        return true;
    }

    void show(Gene g) {
        if (this.showCds) {
            this.showCds(g);
        } else if (this.showExons) {
            this.showExons(g);
        } else if (this.showTranscripts) {
            this.showTr(g);
        } else {
            this.showGene(g);
        }
    }

    void showCds(Gene g) {
        for (Transcript tr : g) {
            for (Exon ex : tr) {
                Cds cds = tr.findCds(ex);
                if (cds == null) continue;
                int start = cds.getStart() - this.expandUpstreamDownstream;
                int end = cds.getEnd() + 1 + this.expandUpstreamDownstream;
                System.out.println(cds.getChromosomeName() + "\t" + start + "\t" + end + "\t" + g.getGeneName() + ";" + g.getId() + ";" + tr.getId() + ";" + ex.getRank() + ";" + (ex.isStrandPlus() ? "+" : "-"));
            }
        }
    }

    void showExons(Gene g) {
        for (Transcript tr : g) {
            for (Exon ex : tr) {
                int start = ex.getStart() - this.expandUpstreamDownstream;
                int end = ex.getEnd() + 1 + this.expandUpstreamDownstream;
                System.out.println(ex.getChromosomeName() + "\t" + start + "\t" + end + "\t" + g.getGeneName() + ";" + g.getId() + ";" + tr.getId() + ";" + ex.getRank() + ";" + (ex.isStrandPlus() ? "+" : "-"));
            }
        }
    }

    void showGene(Gene g) {
        int start = g.getStart() - this.expandUpstreamDownstream;
        int end = g.getEnd() + 1 + this.expandUpstreamDownstream;
        System.out.println(g.getChromosomeName() + "\t" + start + "\t" + end + "\t" + g.getGeneName() + ";" + g.getId() + ";" + (g.isStrandPlus() ? "+" : "-"));
    }

    public void showGenes() {
        if (this.showCds) {
            System.out.println("#chr\tstart\tend\tgeneName;geneId;transcriptId;exonRank;strand");
        } else if (this.showExons) {
            System.out.println("#chr\tstart\tend\tgeneName;geneId;transcriptId;exonRank;stramd");
        } else if (this.showTranscripts) {
            System.out.println("#chr\tstart\tend\tgeneName;geneId;transcriptId;strand");
        } else {
            System.out.println("#chr\tstart\tend\tgeneName;geneId;strand");
        }
        Genome genome = this.config.getGenome();
        if (this.verbose) {
            Timer.showStdErr("Finding genes.");
        }
        int found = 0;
        int filtered = 0;
        for (Gene g : genome.getGenesSortedPos()) {
            if (!this.geneIds.isEmpty() && !this.geneIds.contains(g.getId()) && !this.geneIds.contains(g.getGeneName())) continue;
            ++found;
            if (!this.onlyProteinCoding || g.isProteinCoding()) {
                this.show(g);
                continue;
            }
            ++filtered;
        }
        if (this.verbose) {
            Timer.showStdErr("Done\n\tFound      : " + found + " / " + this.geneIds.size() + (filtered > 0 ? "\n\tFiltered out : " + filtered + " / " + found : ""));
        }
    }

    void showTr(Gene g) {
        for (Transcript tr : g) {
            int start = tr.getStart() - this.expandUpstreamDownstream;
            int end = tr.getEnd() + 1 + this.expandUpstreamDownstream;
            System.out.println(tr.getChromosomeName() + "\t" + start + "\t" + end + "\t" + g.getGeneName() + ";" + g.getId() + ";" + tr.getId() + ";" + (tr.isStrandPlus() ? "+" : "-"));
        }
    }

    @Override
    public void usage(String message) {
        if (message != null) {
            System.err.println("Error: " + message + "\n");
        }
        System.err.println("Usage: " + SnpEffCmdGenes2Bed.class.getSimpleName() + " genomeVer [-f genes.txt | geneList]}");
        System.err.println("Options: ");
        System.err.println("\t-cds           : Show coding exons (no UTRs).");
        System.err.println("\t-e             : Show exons.");
        System.err.println("\t-f <file.txt>  : A TXT file having one gene ID (or name) per line.");
        System.err.println("\t-pc            : Use only protein coding genes.");
        System.err.println("\t-tr            : Show transcript coordinates.");
        System.err.println("\t-ud <num>      : Expand gene interval upstream and downstream by 'num' bases.");
        System.err.println("\tgeneList       : A list of gene IDs or names. One per command line argument: geneId_1 geneId_2 geneId_3 ... geneId_N");
        System.exit(-1);
    }
}

