/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.binseq.indexer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import org.snpeff.binseq.BinarySequence;
import org.snpeff.binseq.comparator.SequenceReference;
import org.snpeff.binseq.comparator.SubsequenceComparator;

public class SequenceIndexer<T extends BinarySequence>
implements Comparator<Long>,
Iterable<T> {
    ArrayList<T> sequences = new ArrayList();
    SubsequenceComparator<T> subsequenceComparator;

    public SequenceIndexer(SubsequenceComparator<T> subsequenceComparator) {
        this.subsequenceComparator = subsequenceComparator;
    }

    public void add(Collection<T> sequences) {
        this.sequences.addAll(sequences);
    }

    public int add(T sequence2) {
        this.sequences.add(sequence2);
        return this.sequences.size() - 1;
    }

    @Override
    public int compare(Long reference1, Long reference2) {
        int seqIdx1 = SequenceReference.getSeqIdx(reference1);
        BinarySequence seq1 = (BinarySequence)this.sequences.get(seqIdx1);
        int start1 = SequenceReference.getStart(reference1);
        int seqIdx2 = SequenceReference.getSeqIdx(reference2);
        BinarySequence seq2 = (BinarySequence)this.sequences.get(seqIdx2);
        int start2 = SequenceReference.getStart(reference2);
        int comp = this.subsequenceComparator.compare(seq1, start1, seq2, start2);
        return comp;
    }

    public T get(int idx) {
        return (T)((BinarySequence)this.sequences.get(idx));
    }

    @Override
    public Iterator<T> iterator() {
        return this.sequences.iterator();
    }

    public int size() {
        return this.sequences.size();
    }
}

