/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.align;

public class NeedlemanWunsch {
    String alignment;
    char[] a;
    char[] b;
    char[] alignmentA;
    char[] alignmentB;
    int[][] score;
    int match = 1;
    int missMatch = -1;
    int deletion = -2;
    int offset = 0;
    int bestScore = 0;
    boolean useSpace;

    public NeedlemanWunsch(String a, String b) {
        this.a = a.toCharArray();
        this.b = b.toCharArray();
        this.useSpace = true;
    }

    public String align() {
        try {
            this.scoreMatrix();
            this.calcAlignment();
        }
        catch (Throwable t2) {
            throw new RuntimeException("Error aligning sequences:\n\tSequence 1: " + new String(this.a) + "\n\tSequence 2: " + new String(this.b), t2);
        }
        return this.alignment;
    }

    void calcAlignment() {
        int h;
        int i;
        int maxLen = Math.max(this.a.length, this.b.length);
        this.alignmentA = new char[maxLen];
        this.alignmentB = new char[maxLen];
        for (i = 0; i < maxLen; ++i) {
            this.alignmentB[i] = 32;
            this.alignmentA[i] = 32;
        }
        i = this.a.length;
        int j = this.b.length;
        for (h = maxLen - 1; i > 0 && j > 0 && h >= 0; --h) {
            int s = this.getScore(i, j);
            int scorediag = this.getScore(i - 1, j - 1);
            int scoreup = this.getScore(i, j - 1);
            int scoreleft = this.getScore(i - 1, j);
            if (s == scoreup + this.deletion) {
                this.alignmentA[h] = 45;
                this.alignmentB[h] = this.b[j - 1];
                --j;
                continue;
            }
            if (s == scoreleft + this.deletion) {
                this.alignmentA[h] = this.a[i - 1];
                this.alignmentB[h] = 45;
                --i;
                continue;
            }
            if (s == scorediag + this.simmilarity(i, j)) {
                if (this.useSpace) {
                    this.alignmentA[h] = 32;
                    this.alignmentB[h] = 32;
                } else {
                    this.alignmentA[h] = this.a[i - 1];
                    this.alignmentB[h] = this.b[j - 1];
                }
                --i;
                --j;
                continue;
            }
            throw new RuntimeException("This should never happen!\n");
        }
        while (i > 0 && h >= 0) {
            this.alignmentA[h] = this.a[i - 1];
            this.alignmentB[h] = 45;
            --i;
            --h;
        }
        while (j > 0 && h >= 0) {
            this.alignmentA[h] = 45;
            this.alignmentB[h] = this.b[j - 1];
            --j;
            --h;
        }
        this.offset = 0;
        while (this.offset < maxLen && this.alignmentA[this.offset] == ' ') {
            ++this.offset;
        }
        StringBuffer alsb = new StringBuffer();
        int prev = 32;
        for (i = 0; i < maxLen; ++i) {
            if (this.alignmentA[i] == '-') {
                if (prev != 45) {
                    alsb.append('-');
                }
                alsb.append(this.alignmentB[i]);
                prev = 45;
                continue;
            }
            if (this.alignmentB[i] != '-') continue;
            if (prev != 43) {
                alsb.append('+');
            }
            alsb.append(this.alignmentA[i]);
            prev = 43;
        }
        this.alignment = alsb.toString();
    }

    public String getAlignment() {
        return this.alignment;
    }

    public int getAlignmentScore() {
        return this.bestScore;
    }

    public int getOffset() {
        return this.offset;
    }

    int getScore(int i, int j) {
        return this.score[i][j];
    }

    void scoreMatrix() {
        int i;
        this.score = new int[this.a.length + 1][this.b.length + 1];
        for (i = 0; i <= this.a.length; ++i) {
            this.setScore(i, 0, this.deletion * i);
        }
        for (int j = 0; j <= this.b.length; ++j) {
            this.setScore(0, j, this.deletion * j);
        }
        this.bestScore = Integer.MIN_VALUE;
        for (i = 1; i <= this.a.length; ++i) {
            for (int j = 1; j <= this.b.length; ++j) {
                int match = this.getScore(i - 1, j - 1) + this.simmilarity(i, j);
                int del = this.getScore(i - 1, j) + this.deletion;
                int ins = this.getScore(i, j - 1) + this.deletion;
                int s = Math.max(match, Math.max(del, ins));
                this.setScore(i, j, s);
                this.bestScore = Math.max(this.bestScore, s);
            }
        }
    }

    public void setDeletion(int deletion) {
        this.deletion = deletion;
    }

    public void setMatch(int match) {
        this.match = match;
    }

    public void setMissMatch(int missMatch) {
        this.missMatch = missMatch;
    }

    void setScore(int i, int j, int val) {
        this.score[i][j] = val;
    }

    public void setUseSpace(boolean useSpace) {
        this.useSpace = useSpace;
    }

    int simmilarity(int i, int j) {
        if (this.a[i - 1] != this.b[j - 1]) {
            return this.missMatch;
        }
        return this.match;
    }

    public String toString() {
        if (this.score == null) {
            return "";
        }
        char[] matching = new char[this.alignmentA.length];
        for (int i = 0; i < this.alignmentA.length; ++i) {
            matching[i] = this.alignmentA[i] == ' ' || this.alignmentB[i] == ' ' || this.alignmentA[i] == '-' || this.alignmentB[i] == '-' ? 32 : (this.alignmentA[i] == this.alignmentB[i] ? 124 : 42);
        }
        return "\t" + new String(this.alignmentA) + "\n\t" + new String(matching) + "\n\t" + new String(this.alignmentB);
    }
}

