/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.sequence.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedHashMap;
import org.biojava3.core.sequence.ProteinSequence;
import org.biojava3.core.sequence.compound.AminoAcidCompoundSet;
import org.biojava3.core.sequence.io.BufferedReaderBytesRead;
import org.biojava3.core.sequence.io.FastaSequenceParser;
import org.biojava3.core.sequence.io.FileProxyProteinSequenceCreator;
import org.biojava3.core.sequence.io.GenericFastaHeaderParser;
import org.biojava3.core.sequence.io.ProteinSequenceCreator;
import org.biojava3.core.sequence.io.template.SequenceCreatorInterface;
import org.biojava3.core.sequence.io.template.SequenceHeaderParserInterface;
import org.biojava3.core.sequence.template.AbstractSequence;
import org.biojava3.core.sequence.template.Compound;
import org.biojava3.core.sequence.template.Sequence;

public class FastaReader<S extends Sequence<?>, C extends Compound> {
    SequenceCreatorInterface<C> sequenceCreator;
    SequenceHeaderParserInterface<S, C> headerParser;
    BufferedReaderBytesRead br;
    InputStreamReader isr;
    FileInputStream fi = null;
    long fileIndex = 0L;
    long sequenceIndex = 0L;
    String line = "";
    String header = "";

    public FastaReader(InputStream is, SequenceHeaderParserInterface<S, C> headerParser, SequenceCreatorInterface<C> sequenceCreator) {
        this.headerParser = headerParser;
        this.isr = new InputStreamReader(is);
        this.br = new BufferedReaderBytesRead(this.isr);
        this.sequenceCreator = sequenceCreator;
    }

    public FastaReader(File file, SequenceHeaderParserInterface<S, C> headerParser, SequenceCreatorInterface<C> sequenceCreator) throws FileNotFoundException {
        this.headerParser = headerParser;
        this.fi = new FileInputStream(file);
        this.isr = new InputStreamReader(this.fi);
        this.br = new BufferedReaderBytesRead(this.isr);
        this.sequenceCreator = sequenceCreator;
    }

    public LinkedHashMap<String, S> process() throws IOException {
        LinkedHashMap<String, S> sequences = this.process(-1);
        this.close();
        return sequences;
    }

    public LinkedHashMap<String, S> process(int max2) throws IOException {
        LinkedHashMap<String, AbstractSequence<C>> sequences = new LinkedHashMap<String, AbstractSequence<C>>();
        String line = "";
        if (this.line != null && this.line.length() > 0) {
            line = this.line;
        }
        String header = "";
        if (this.header != null && this.header.length() > 0) {
            header = this.header;
        }
        StringBuilder sb = new StringBuilder();
        int processedSequences = 0;
        boolean keepGoing = true;
        do {
            AbstractSequence<C> sequence2;
            if ((line = line.trim()).length() != 0) {
                if (line.startsWith(">")) {
                    if (sb.length() > 0) {
                        sequence2 = this.sequenceCreator.getSequence(sb.toString(), this.sequenceIndex);
                        this.headerParser.parseHeader(header, sequence2);
                        sequences.put(sequence2.getAccession().getID(), sequence2);
                        ++processedSequences;
                        sb.setLength(0);
                    }
                    header = line.substring(1);
                } else if (!line.startsWith(";")) {
                    if (sb.length() == 0) {
                        this.sequenceIndex = this.fileIndex;
                    }
                    sb.append(line);
                }
            }
            this.fileIndex = this.br.getBytesRead();
            line = this.br.readLine();
            if (line == null) {
                sequence2 = this.sequenceCreator.getSequence(sb.toString(), this.sequenceIndex);
                this.headerParser.parseHeader(header, sequence2);
                sequences.put(sequence2.getAccession().getID(), sequence2);
                ++processedSequences;
                keepGoing = false;
            }
            if (max2 <= -1 || processedSequences < max2) continue;
            keepGoing = false;
        } while (keepGoing);
        this.line = line;
        this.header = header;
        return sequences;
    }

    public void close() throws IOException {
        this.br.close();
        this.isr.close();
        if (this.fi != null) {
            this.fi.close();
        }
        this.header = null;
        this.line = null;
    }

    public static void main(String[] args) {
        try {
            String inputFile = "src/test/resources/PF00104_small.fasta";
            FileInputStream is = new FileInputStream(inputFile);
            FastaReader fastaReader = new FastaReader(is, new GenericFastaHeaderParser(), new ProteinSequenceCreator(AminoAcidCompoundSet.getAminoAcidCompoundSet()));
            LinkedHashMap proteinSequences = fastaReader.process();
            is.close();
            System.out.println(proteinSequences);
            File file = new File(inputFile);
            FastaReader fastaProxyReader = new FastaReader(file, new GenericFastaHeaderParser(), new FileProxyProteinSequenceCreator(file, AminoAcidCompoundSet.getAminoAcidCompoundSet(), new FastaSequenceParser()));
            LinkedHashMap proteinProxySequences = fastaProxyReader.process();
            for (String key : proteinProxySequences.keySet()) {
                ProteinSequence proteinSequence = (ProteinSequence)proteinProxySequences.get(key);
                System.out.println(key);
                System.out.println(proteinSequence.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

