/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.domain;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.biojava.bio.structure.align.util.HTTPConnectionTools;
import org.biojava.bio.structure.domain.DomainProvider;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PDBDomainProvider
implements DomainProvider {
    public static final String DEFAULT_PDB_HOST = "http://www.rcsb.org";
    public static final String DEFAULT_PDB_API_URL = "http://www.rcsb.org/pdb/rest/";
    private String base;
    private int cutoff;

    public PDBDomainProvider() {
        this(DEFAULT_PDB_API_URL, 40);
    }

    public PDBDomainProvider(String base, int cutoff) {
        this.base = base;
        this.cutoff = cutoff;
    }

    @Override
    public SortedSet<String> getDomainNames(String name) {
        if (name.length() < 4) {
            throw new IllegalArgumentException("Can't interpret IDs that are shorter than 4 residues!");
        }
        String url = String.format("%srepresentativeDomains?cluster=%s&structureId=%s", this.base, this.cutoff, name);
        return this.requestRepresentativeDomains(url);
    }

    @Override
    public SortedSet<String> getRepresentativeDomains() {
        String url = this.base + "representativeDomains?cluster=" + this.cutoff;
        return this.requestRepresentativeDomains(url);
    }

    private SortedSet<String> requestRepresentativeDomains(String url) {
        try {
            final TreeSet<String> results = new TreeSet<String>();
            DefaultHandler handler = new DefaultHandler(){

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if (qName.equalsIgnoreCase("representative")) {
                        String name = attributes.getValue("name");
                        results.add(name);
                    }
                }
            };
            PDBDomainProvider.handleRestRequest(url, handler);
            return results;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static void handleRestRequest(String url, DefaultHandler handler) throws SAXException, IOException, ParserConfigurationException {
        URL u = new URL(url);
        InputStream response = HTTPConnectionTools.getInputStream(u);
        InputSource xml = new InputSource(response);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        saxParser.parse(xml, handler);
    }

    public static void main(String[] args) {
        PDBDomainProvider dom = new PDBDomainProvider();
        String name = "2CDG";
        SortedSet<String> domains = dom.getDomainNames(name);
        System.out.println("Domains for " + name + ":");
        for (String s : domains) {
            System.out.println(s);
        }
        SortedSet<String> reprs = dom.getRepresentativeDomains();
        System.out.format("%nFound %d clusters.%n", reprs.size());
        try {
            File outfile = new File("/Users/blivens/Downloads/representativeDomainsJava.xml");
            BufferedWriter out = new BufferedWriter(new FileWriter(outfile));
            for (String repr : reprs) {
                out.write(String.format("  <representative name=\"%s\"/>%n", repr));
            }
            ((Writer)out).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

