/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Util;

public class Options
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map shortOpts = new HashMap();
    private Map longOpts = new HashMap();
    private List requiredOpts = new ArrayList();
    private Map optionGroups = new HashMap();

    public Options addOptionGroup(OptionGroup group) {
        Iterator options = group.getOptions().iterator();
        if (group.isRequired()) {
            this.requiredOpts.add(group);
        }
        while (options.hasNext()) {
            Option option = (Option)options.next();
            option.setRequired(false);
            this.addOption(option);
            this.optionGroups.put(option.getKey(), group);
        }
        return this;
    }

    Collection getOptionGroups() {
        return new HashSet(this.optionGroups.values());
    }

    public Options addOption(String opt2, boolean hasArg, String description) {
        this.addOption(opt2, null, hasArg, description);
        return this;
    }

    public Options addOption(String opt2, String longOpt, boolean hasArg, String description) {
        this.addOption(new Option(opt2, longOpt, hasArg, description));
        return this;
    }

    public Options addOption(Option opt2) {
        String key = opt2.getKey();
        if (opt2.hasLongOpt()) {
            this.longOpts.put(opt2.getLongOpt(), opt2);
        }
        if (opt2.isRequired()) {
            if (this.requiredOpts.contains(key)) {
                this.requiredOpts.remove(this.requiredOpts.indexOf(key));
            }
            this.requiredOpts.add(key);
        }
        this.shortOpts.put(key, opt2);
        return this;
    }

    public Collection getOptions() {
        return Collections.unmodifiableCollection(this.helpOptions());
    }

    List helpOptions() {
        return new ArrayList(this.shortOpts.values());
    }

    public List getRequiredOptions() {
        return this.requiredOpts;
    }

    public Option getOption(String opt2) {
        if (this.shortOpts.containsKey(opt2 = Util.stripLeadingHyphens(opt2))) {
            return (Option)this.shortOpts.get(opt2);
        }
        return (Option)this.longOpts.get(opt2);
    }

    public boolean hasOption(String opt2) {
        return this.shortOpts.containsKey(opt2 = Util.stripLeadingHyphens(opt2)) || this.longOpts.containsKey(opt2);
    }

    public OptionGroup getOptionGroup(Option opt2) {
        return (OptionGroup)this.optionGroups.get(opt2.getKey());
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[ Options: [ short ");
        buf.append(this.shortOpts.toString());
        buf.append(" ] [ long ");
        buf.append(this.longOpts);
        buf.append(" ]");
        return buf.toString();
    }
}

