/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Configurable;
import freemarker.core.Environment;
import freemarker.template.Template;

public class CustomAttribute {
    public static final int SCOPE_ENVIRONMENT = 0;
    public static final int SCOPE_TEMPLATE = 1;
    public static final int SCOPE_CONFIGURATION = 2;
    private final Object key = new Object();
    private final int scope;

    public CustomAttribute(int scope) {
        if (scope != 0 && scope != 1 && scope != 2) {
            throw new IllegalArgumentException();
        }
        this.scope = scope;
    }

    protected Object create() {
        return null;
    }

    public final Object get() {
        return this.getScopeConfigurable().getCustomAttribute(this.key, this);
    }

    public final Object get(Template t2) {
        if (this.scope != 1) {
            throw new UnsupportedOperationException("This is not a template-scope attribute");
        }
        return t2.getCustomAttribute(this.key, this);
    }

    public final void set(Object value2) {
        this.getScopeConfigurable().setCustomAttribute(this.key, value2);
    }

    public final void set(Object value2, Template t2) {
        if (this.scope != 1) {
            throw new UnsupportedOperationException("This is not a template-scope attribute");
        }
        t2.setCustomAttribute(this.key, value2);
    }

    private Configurable getScopeConfigurable() {
        Environment c = Environment.getCurrentEnvironment();
        if (c == null) {
            throw new IllegalStateException("No current environment");
        }
        switch (this.scope) {
            case 0: {
                return c;
            }
            case 1: {
                return c.getParent();
            }
            case 2: {
                return c.getParent().getParent();
            }
        }
        throw new Error();
    }
}

