/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URI;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;

final class InfoDialog {
    private static final String version = "2.1.0";
    private static final String decription = "Calcoo - scientific calculator. Version 2.1.0.";
    private static final String copyright = "Copyright (C) 2001-2013 Alexei Kaminski.";
    private static final String webpage = "http://calcoo.sourceforge.net/";
    private static final String feedback = "calcoo.calculator@gmail.com";
    private static final String gplText = "Calcoo - scientific calculator. Version 2.1.0.\r\nCopyright (C) 2001-2013 Alexei Kaminski.\r\n\r\nThis program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.\r\n\r\nThis program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.\r\n\r\nYou should have received a copy of the GNU General Public License along with this program. If not, see http://www.gnu.org/licenses/.";
    private static final String helpText = "Even though it must be clear in general how to use calcoo, some subtleties may need clarification.\r\n\r\nIn the RPN mode, the stack either has four registers, X, Y, Z, T, like in most real RPN calculators, or is unlimited, depending on the corresponding option. In the algebraic mode, the number of registers is unlimited, but only the lowest four have their contents displayed.\r\n\r\nSeveral adjacent opening parens are possible. However, calcoo will show only one paren in the corresponding display, due to display limitations. Calcoo does keep track of all of them, even though it is unable to show them.\r\n\r\nThe closing paren button acts as \"=\" button if there are no matching opening parens.\r\n\r\nIf an expression begins with an opening paren, the paren will not be displayed (actually the paren will be ignored). Nevertheless, you should go ahead and type the whole expression, since an unmatched closing paren acts as \"=\", the whole expression will be evaluated properly, as though the (ignored) opening paren and the closing paren (interpreted as \"=\") were interpreted as parens.\r\n\r\nUndo remembers only the last 200 elementary actions.\r\n\r\nSwitching between RPN and algebraic modes resets undo.\r\n\r\nLocale-based parsing of pasted numbers uses Java's native pasting algorithm, based on your current locale. It is quite robust and should be chosen unless sometimes you happen to paste numbers formatted in different locales. In this case, the heuristic parser may be a better choice. While more picky, it tries to figure out which locale conventions to use based on the appearance of the pasted number.";
    private static final String[][] shortcutsText = new String[][]{{"Esc", "clear all registers"}, {"Delete", "clear register X"}, {"0 1 2 3 4 5 6 7 8 9", "corresponding digits"}, {". ,", "."}, {"+ - * / ^", "corresponding binary operations"}, {"s c t", "sin cos tan"}, {"n g", "ln log"}, {"x d", "e^x 10^x"}, {"q w r", "x^2 sqrt y^x"}, {"i p f", "1/x pi x!"}, {"a h", "arc hyp"}, {"( [  ] )", "( )"}, {"Enter, =", "evaluate (algebraic mode)"}, {"Enter", "enter (RPN mode)"}, {"BackSpace Ctrl-z LeftArrow", "undo"}, {"Ctrl-y RightArrow", "redo"}, {"Ctrl-c Ctrl-v", "copy paste"}, {"Ctrl--", "change mantissa sign"}, {"Ctrl-e", "change exp sign"}, {"m", "change the current sign"}, {"UpArrow/DownArrow", "scroll stack up/down (RPN mode)"}, {"y", "swap registers X and Y"}, {"e", "E"}, {"?", "info/help"}, {"!", "settings"}, {"Ctrl-q", "exit"}};

    InfoDialog() {
    }

    void run(JFrame jFrame) {
        Container container;
        JComponent jComponent;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 2));
        for (String[] object2 : shortcutsText) {
            jPanel.add(new JLabel(object2[0] + "  -", 4));
            jPanel.add(new JLabel("-  " + object2[1], 2));
        }
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JLabel jLabel = new JLabel(" ", 2);
        JTextArea jTextArea = new JTextArea(helpText, shortcutsText.length, 50);
        jTextArea.setFont(jLabel.getFont());
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setEditable(false);
        jTextArea.setBackground(null);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JTextArea jTextArea2 = new JTextArea(gplText, shortcutsText.length, 50);
        jTextArea2.setFont(jLabel.getFont());
        jTextArea2.setLineWrap(true);
        jTextArea2.setWrapStyleWord(true);
        jTextArea2.setEditable(false);
        jTextArea2.setBackground(null);
        JScrollPane jScrollPane2 = new JScrollPane(jTextArea2);
        jScrollPane2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipady = 20;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 21;
        jPanel2.add((Component)new JLabel(decription), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipady = 20;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 21;
        jPanel2.add((Component)new JLabel(copyright), gridBagConstraints);
        gridBagConstraints.ipady = 20;
        gridBagConstraints = new GridBagConstraints();
        jPanel2.add((Component)new JLabel("Webpage: "), gridBagConstraints);
        gridBagConstraints.ipady = 20;
        gridBagConstraints.gridy = 3;
        jPanel2.add((Component)new JLabel("Feedback: "), gridBagConstraints);
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.ipady = 20;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.anchor = 17;
            jComponent = new JLabel("<html><a href=\" http://calcoo.sourceforge.net/\">http://calcoo.sourceforge.net/</a></html>");
            jComponent.addMouseListener(new MouseProcessor((JLabel)jComponent, webpage));
            jPanel2.add((Component)jComponent, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.anchor = 17;
            container = new JLabel("<html><a href=\" calcoo.calculator@gmail.com\">calcoo.calculator@gmail.com</a></html>");
            container.addMouseListener(new MouseProcessor((JLabel)container, "mailto:calcoo.calculator@gmail.com"));
            jPanel2.add((Component)container, gridBagConstraints);
        } else {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.anchor = 17;
            jComponent = new JTextPane();
            ((JEditorPane)jComponent).setText(webpage);
            ((JTextComponent)jComponent).setEditable(false);
            jComponent.setBackground(null);
            jComponent.setBorder(null);
            jPanel2.add((Component)jComponent, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            container = new JTextPane();
            ((JEditorPane)container).setText(feedback);
            ((JTextComponent)container).setEditable(false);
            ((JComponent)container).setBackground(null);
            ((JComponent)container).setBorder(null);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.anchor = 17;
            jPanel2.add((Component)container, gridBagConstraints);
        }
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jComponent = new JTabbedPane();
        ((JTabbedPane)jComponent).addTab("Shortcuts", null, jPanel, null);
        ((JTabbedPane)jComponent).setMnemonicAt(0, 83);
        ((JTabbedPane)jComponent).addTab("Help", null, jScrollPane, null);
        ((JTabbedPane)jComponent).setMnemonicAt(1, 72);
        ((JTabbedPane)jComponent).addTab("License", null, jScrollPane2, null);
        ((JTabbedPane)jComponent).setMnemonicAt(2, 76);
        ((JTabbedPane)jComponent).addTab("About", null, jPanel2, null);
        ((JTabbedPane)jComponent).setMnemonicAt(3, 65);
        container = new JDialog(jFrame, "Calcoo Settings", true);
        JButton jButton = new JButton("OK");
        abstract class ButtonListener
        implements ActionListener {
            ButtonListener() {
            }
        }
        jButton.addActionListener(new ButtonListener((JDialog)container){
            final /* synthetic */ JDialog val$dialog;
            {
                this.val$dialog = jDialog;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.val$dialog.dispose();
            }
        });
        ((JDialog)container).setLayout(new BorderLayout());
        container.add((Component)jComponent, "North");
        container.add((Component)jButton, "Last");
        JRootPane jRootPane = ((JDialog)container).getRootPane();
        InputMap inputMap = jRootPane.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), "OK");
        jRootPane.getActionMap().put("OK", new AbstractAction((JDialog)container){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ JDialog val$dialog;
            {
                this.val$dialog = jDialog;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.val$dialog.dispose();
            }
        });
        ((Window)container).pack();
        ((Window)container).setLocationRelativeTo(jFrame);
        ((Dialog)container).setResizable(false);
        ((Dialog)container).setVisible(true);
    }

    private class MouseProcessor
    implements MouseListener {
        private final String link;
        private final JLabel label;

        public MouseProcessor(JLabel jLabel, String string) {
            this.label = jLabel;
            this.link = string;
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.label.setCursor(new Cursor(12));
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.label.setCursor(Cursor.getDefaultCursor());
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            try {
                URI uRI = new URI(this.link);
                Desktop.getDesktop().browse(uRI);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
    }
}

