#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <gtk/gtk.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>
#include "main.h"

#include "help.h"
#include "license.h"
#include "readme.h"

static char aboutmsg[] = 
		"Arka is a graphical user interface for the\n"
		"GP sequence manipulation package. More on\n"
		"http://www.bioinformatics.org/genpak/\n"
		"In case of any problems or suggestions, mail\n"
		AUTHOR_EMAIL 
		"\n" ;

void about_destroy_dialog(GtkWidget *okno, gpointer dane) ;
void about_close_dialog(GtkWidget *kontrolka, gpointer dane) ;


void help_short_info(char *progname) {

	fprintf(stderr, 
		"%s - graphical user interface for command line programs\n"
		"  Usage:\n"
		"     %s [options] [ input file ] [ output file ]\n"
		"\n"
		"  Options:\n"
		"     -d       : turn debugging on\n"
		"     -v       : print version information & exit\n"
		"     -h       : display this short help message\n\n"
		" Note that %s needs a graphical display\n\n", 
		PROGRAM, progname, PROGRAM);
	return ;
}


/* displays the manual page for a specific page */
int help_display_man_lowlevel(char *name) {
	char *command ;

	say(0, "displaying man page for %s", name) ;
	command = malloc(strlen(name) + 50) ;
	sprintf(command, "xterm -e man %s &", name) ;
	system(command) ;
	free(command) ;
	return EXIT_SUCCESS ;
}


/* called from a button */
void help_display_man(GtkWidget *kontr, gpointer dane) {
	char *name ;

	name = (char*) dane ;
	help_display_man_lowlevel(name) ;
}


/* display a help text */
void help_text_lowlevel(char *textstring) {
	GtkWidget *okno, *tekst, *twin, *przycisk ;
	int i = 0 ;

	okno = gtk_dialog_new() ;
	gtk_widget_set_usize(okno, 500, 400) ;
	gtk_container_border_width(GTK_CONTAINER(okno), 5) ;
	gtk_signal_connect(GTK_OBJECT(okno), 
		"destroy", GTK_SIGNAL_FUNC(about_destroy_dialog), okno) ;

	tekst = gtk_text_new(NULL, NULL) ;
	gtk_text_set_word_wrap(GTK_TEXT(tekst), FALSE) ;
	gtk_text_set_line_wrap(GTK_TEXT(tekst), FALSE) ;
	gtk_text_set_editable( GTK_TEXT(tekst), FALSE) ;
	gtk_editable_insert_text(GTK_EDITABLE(tekst), textstring, strlen(textstring), &i) ;

	twin = gtk_scrolled_window_new(NULL, NULL) ;
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(twin),
		GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC) ;

	gtk_container_add(GTK_CONTAINER(twin), tekst) ;
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(okno)->vbox), twin, TRUE, TRUE, 0) ;

	przycisk = gtk_button_new_with_label("    OK    ") ;
	gtk_signal_connect(GTK_OBJECT(przycisk), "clicked", 
		GTK_SIGNAL_FUNC(about_close_dialog), okno) ;

	GTK_WIDGET_SET_FLAGS(przycisk, GTK_CAN_DEFAULT) ;
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(okno)->action_area), 
		przycisk, FALSE, FALSE, 0) ;
	gtk_widget_grab_default(przycisk) ;
	gtk_widget_set_usize(przycisk, 50, -1) ;

	gtk_widget_show_all(okno) ;
	gtk_window_set_focus(GTK_WINDOW(okno), tekst) ;

}

/* display a help text */
void help_text(gpointer dane, guint signal, GtkWidget *kontrolka) {
	char *textstring ;

	switch(signal){
		case 1: textstring = license ;
			break ;
		case 0: textstring = readme ;
		default:
			break ;
	}

	help_text_lowlevel(textstring) ;

}

/* -------------------- The 'about' window -------------------------- */

void about_destroy_dialog(GtkWidget *okno, gpointer dane) {
	gtk_grab_remove(GTK_WIDGET(dane)) ;
}


void about_close_dialog(GtkWidget *kontrolka, gpointer dane) {
	gtk_widget_destroy(GTK_WIDGET(dane)) ;
}


void help_about_configure(GtkWidget *picture, GdkEventExpose *event, gpointer dane) {
	GdkDrawable *pix ;
	GtkWidget *pic ;
	data_s *d ;

	d = (data_s *) dane ;
	pic = (GtkWidget *) d->data2 ;
	pix = (GdkDrawable *) d->data3 ;

  gdk_draw_pixmap(pic->window,
   	pic->style->fg_gc[GTK_WIDGET_STATE(pic)], pix, 0, 0, 0, 0, -1, -1) ;
}

/* The "about" message from the "Help" menu */
void help_about(gpointer dane, guint signal, GtkWidget *kontrolka) {
	GtkWidget *etykieta, *okno, *przycisk, *east, *hpole, *drawable ;
	GdkDrawable *pixmap ;
	data_s *d ;
	int *i ;

	/* don't worry about those */
	i = malloc(sizeof(*i)) ;
	d = malloc(sizeof(*d)) ;
	d->data1 = i ;
	*i = 0 ;

	/* main window */
	okno = gtk_dialog_new() ;
	gtk_container_border_width(GTK_CONTAINER(okno), 5) ;
	gtk_signal_connect(GTK_OBJECT(okno), 
		"destroy", GTK_SIGNAL_FUNC(about_destroy_dialog), okno) ;

	hpole = gtk_hbox_new(FALSE, 5) ;
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(okno)->vbox), hpole, TRUE, TRUE, 0) ;

	etykieta = gtk_label_new(aboutmsg) ;
	gtk_misc_set_padding(GTK_MISC(etykieta), 10, 10) ;
	gtk_box_pack_start(GTK_BOX(hpole), etykieta, TRUE, TRUE, 0) ;
	gtk_label_set_justify(GTK_LABEL(etykieta), GTK_JUSTIFY_RIGHT) ;

	/* drawable for the logo */
	east = gtk_event_box_new() ;
	gtk_widget_set_usize(east, 100, 100) ;
	gtk_box_pack_start(GTK_BOX(hpole), east, TRUE, TRUE, 5) ;

	drawable = gtk_drawing_area_new() ;
	gtk_container_add(GTK_CONTAINER(east), drawable) ;
	d->data2 = drawable ;

	/* he he he again */
	gtk_widget_set_events(okno, GDK_KEY_RELEASE_MASK) ;
	gtk_signal_connect(GTK_OBJECT(east), "button-press-event", 
		GTK_SIGNAL_FUNC(help_about_easter_butt), d) ;
	gtk_signal_connect(GTK_OBJECT(okno), "key-press-event", 
		GTK_SIGNAL_FUNC(help_about_easter_key), d) ;

	/* ok button */
	przycisk = gtk_button_new_with_label("    OK    ") ;
	gtk_signal_connect(GTK_OBJECT(przycisk), "clicked", 
		GTK_SIGNAL_FUNC(about_close_dialog), okno) ;

	GTK_WIDGET_SET_FLAGS(przycisk, GTK_CAN_DEFAULT) ;
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(okno)->action_area), 
		przycisk, FALSE, FALSE, 0) ;
	gtk_widget_grab_default(przycisk) ;
	gtk_widget_set_usize(przycisk, 50, -1) ;

	gtk_window_set_position(GTK_WINDOW(okno), GTK_WIN_POS_CENTER) ;
	gtk_widget_show_all(okno) ;

	/* logo */
	pixmap = gdk_pixmap_create_from_xpm_d(drawable->window,
		NULL, NULL, arka) ;
	d->data3 = pixmap ;
	d->data4 = etykieta ;

  gdk_draw_pixmap(drawable->window,
    drawable->style->fg_gc[GTK_WIDGET_STATE(drawable)], pixmap, 0, 0, 0, 0, -1, -1) ;

	gtk_signal_connect(GTK_OBJECT(drawable), "configure_event", 
		GTK_SIGNAL_FUNC(help_about_configure), d) ;
	gtk_signal_connect(GTK_OBJECT(drawable), "expose_event", 
		GTK_SIGNAL_FUNC(help_about_configure), d) ;

	gtk_grab_add(okno) ;

}


/* ----------------------- popup window displayed at start ----------------------- */

void popup_destroy(gpointer data) {
	int *i ;
	data_s *d ;

	d = (data_s *) data ;
	i = (int*) d->data1 ;
	gtk_widget_destroy(d->window1) ;
	gtk_timeout_remove(*i) ;
	free(i) ;
	free(d) ;

}


/* the little popup window displayed at the start of the program */
GtkWidget * popup_at_start(opt_s *o) {

	GtkWidget *okno, *hpole, *label, *drawable ;
	GdkDrawable *pixmap ;
	data_s *d ;
	int *i ;

	okno = gtk_window_new(GTK_WINDOW_POPUP) ;
	hpole = gtk_hbox_new(FALSE, 5) ;
	gtk_container_add(GTK_CONTAINER(okno), hpole) ;

	label = gtk_label_new(PROGRAM "\n" " version " VERSION) ;
	gtk_box_pack_start(GTK_BOX(hpole), label, TRUE, TRUE, 5) ;

	drawable = gtk_drawing_area_new() ;
	gtk_widget_set_usize(drawable, 100, 100) ;
	gtk_box_pack_start(GTK_BOX(hpole), drawable, TRUE, TRUE, 5) ;

	gtk_window_set_position(GTK_WINDOW(okno), GTK_WIN_POS_CENTER) ;
	gtk_widget_show_all(okno) ;
	
	pixmap = gdk_pixmap_create_from_xpm_d(drawable->window, NULL, NULL, arka) ;
  gdk_draw_pixmap(drawable->window,
    drawable->style->fg_gc[GTK_WIDGET_STATE(drawable)], pixmap, 0, 0, 0, 0, -1, -1) ;

	d = malloc(sizeof(*d)) ;
	i = malloc(sizeof(*i)) ;
	d->data1 = i ;
	d->window1 = okno ;

	/* autodestroy in two seconds */
	*i = gtk_timeout_add(3000, (GtkFunction) popup_destroy, d) ;

	return okno ;

}
