/*
 * Decompiled with CFR 0.152.
 */
package org.forester.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Accession;
import org.forester.phylogeny.data.Sequence;
import org.forester.util.ForesterUtil;

public final class SequenceAccessionTools {
    public static final Pattern GENBANK_NUC_PATTERN_1 = Pattern.compile("(?:\\A|.*[^a-zA-Z0-9])([A-Z]\\d{5}(?:\\.\\d+)?)(?:[^a-zA-Z0-9]|\\Z)");
    public static final Pattern GENBANK_NUC_PATTERN_2 = Pattern.compile("(?:\\A|.*[^a-zA-Z0-9])([A-Z]{2}\\d{6}(?:\\.\\d+)?)(?:[^a-zA-Z0-9]|\\Z)");
    public static final Pattern GENBANK_PROT_PATTERN = Pattern.compile("(?:\\A|.*[^a-zA-Z0-9])([A-Z]{3}\\d{5}(?:\\.\\d+)?)(?:[^a-zA-Z0-9]|\\Z)");
    public static final Pattern GI_PATTERN = Pattern.compile("(?:\\b|_)(?:GI|gi)[|_=:](\\d+)(?:\\b|_)");
    public static final String UNIPROT_KB_BASE_PATTERN_STR = "((?:[OPQ][0-9][A-Z0-9]{3}[0-9])|(?:[A-NR-Z][0-9]([A-Z][A-Z0-9]{2}[0-9]){1,2}))";
    public static final Pattern UNIPROT_KB_PATTERN_0 = Pattern.compile("(?:\\b|_)((?:[OPQ][0-9][A-Z0-9]{3}[0-9])|(?:[A-NR-Z][0-9]([A-Z][A-Z0-9]{2}[0-9]){1,2}))(?:\\b|_)");
    public static final Pattern UNIPROT_KB_PATTERN_1 = Pattern.compile("(?:\\b|_)(?:sp|tr)[\\.|\\-_=/\\\\]((?:[OPQ][0-9][A-Z0-9]{3}[0-9])|(?:[A-NR-Z][0-9]([A-Z][A-Z0-9]{2}[0-9]){1,2}))(?:\\b|_)");
    public static final Pattern UNIPROT_KB_PATTERN_2 = Pattern.compile("(?:\\b|_)(?:[A-Z0-9]{2,5}|((?:[OPQ][0-9][A-Z0-9]{3}[0-9])|(?:[A-NR-Z][0-9]([A-Z][A-Z0-9]{2}[0-9]){1,2})))_(([A-Z9][A-Z]{2}[A-Z0-9]{2})|RAT|PIG|PEA)(?:\\b|_)");
    public static final Pattern ENSEMBL_PATTERN = Pattern.compile("(?:\\b|_)(ENS[A-Z]*[0-9]+)(?:\\b|_)");
    private static final Pattern REFSEQ_PATTERN = Pattern.compile("(?:\\A|.*[^a-zA-Z0-9])([A-Z]{2}_\\d{6,}(\\.\\d)?)(?:[^a-zA-Z0-9]|\\Z)");
    private static final Pattern VIPR_PATTERN = Pattern.compile("\\|(VIPR_.+?)\\|");
    public static final String VIPR_SOURCE = "ViPR";

    private SequenceAccessionTools() {
    }

    public static final boolean isProteinDbQuery(String string) {
        String string2 = SequenceAccessionTools.parseRefSeqAccessorFromString(string);
        if (!ForesterUtil.isEmpty(string2) && string2.charAt(1) == 'P') {
            return true;
        }
        String string3 = SequenceAccessionTools.parseUniProtAccessorFromString(string);
        if (!ForesterUtil.isEmpty(string3)) {
            return true;
        }
        return GENBANK_PROT_PATTERN.matcher(string).lookingAt();
    }

    public static final Accession obtainAccessorFromDataFields(PhylogenyNode phylogenyNode) {
        String string = SequenceAccessionTools.obtainUniProtAccessorFromDataFields(phylogenyNode);
        if (!ForesterUtil.isEmpty(string)) {
            return new Accession(string, Accession.Source.UNIPROT);
        }
        string = SequenceAccessionTools.obtainGenbankAccessorFromDataFields(phylogenyNode);
        if (!ForesterUtil.isEmpty(string)) {
            return new Accession(string, Accession.Source.NCBI);
        }
        string = SequenceAccessionTools.obtainRefSeqAccessorFromDataFields(phylogenyNode);
        if (!ForesterUtil.isEmpty(string)) {
            return new Accession(string, Accession.Source.REFSEQ);
        }
        string = SequenceAccessionTools.obtainGiNumberFromDataFields(phylogenyNode);
        if (!ForesterUtil.isEmpty(string)) {
            return new Accession(string, Accession.Source.GI);
        }
        return null;
    }

    public static final Accession obtainFromSeqAccession(PhylogenyNode phylogenyNode) {
        if (phylogenyNode.getNodeData().isHasSequence() && phylogenyNode.getNodeData().getSequence().getAccession() != null && !ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getAccession().getSource()) && !ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getAccession().getValue())) {
            String string = phylogenyNode.getNodeData().getSequence().getAccession().getSource().toLowerCase();
            String string2 = phylogenyNode.getNodeData().getSequence().getAccession().getValue();
            if (string.startsWith("uniprot") || string.equals("swissprot") || string.equals("trembl") || string.equals("sp")) {
                return new Accession(string2, Accession.Source.UNIPROT);
            }
            if (string.equals("embl") || string.equals("ebi")) {
                return new Accession(string2, Accession.Source.EMBL);
            }
            if (string.equals("ncbi") || string.equals("genbank")) {
                return new Accession(string2, Accession.Source.NCBI);
            }
            if (string.equals("refseq")) {
                return new Accession(string2, Accession.Source.REFSEQ);
            }
            if (string.equals("gi")) {
                return new Accession(string2, Accession.Source.GI);
            }
        }
        return null;
    }

    public static final String obtainGenbankAccessorFromDataFields(PhylogenyNode phylogenyNode) {
        String string = null;
        if (phylogenyNode.getNodeData().isHasSequence()) {
            Sequence sequence = phylogenyNode.getNodeData().getSequence();
            if (!ForesterUtil.isEmpty(sequence.getSymbol())) {
                string = SequenceAccessionTools.parseGenbankAccessorFromString(sequence.getSymbol());
            }
            if (!ForesterUtil.isEmpty(sequence.getGeneName())) {
                string = SequenceAccessionTools.parseGenbankAccessorFromString(sequence.getGeneName());
            }
            if (ForesterUtil.isEmpty(string) && !ForesterUtil.isEmpty(sequence.getName())) {
                string = SequenceAccessionTools.parseGenbankAccessorFromString(sequence.getName());
            }
            if (ForesterUtil.isEmpty(string) && phylogenyNode.getNodeData().getSequence().getAccession() != null && !ForesterUtil.isEmpty(sequence.getAccession().getValue())) {
                string = SequenceAccessionTools.parseGenbankAccessorFromString(sequence.getAccession().getValue());
            }
        }
        if (ForesterUtil.isEmpty(string) && !ForesterUtil.isEmpty(phylogenyNode.getName())) {
            string = SequenceAccessionTools.parseGenbankAccessorFromString(phylogenyNode.getName());
        }
        return string;
    }

    public static final String obtainGiNumberFromDataFields(PhylogenyNode phylogenyNode) {
        String string = null;
        if (phylogenyNode.getNodeData().isHasSequence()) {
            Sequence sequence = phylogenyNode.getNodeData().getSequence();
            if (ForesterUtil.isEmpty(string) && !ForesterUtil.isEmpty(sequence.getName())) {
                string = SequenceAccessionTools.parseGInumberFromString(sequence.getName());
            }
            if (ForesterUtil.isEmpty(string) && !ForesterUtil.isEmpty(sequence.getGeneName())) {
                string = SequenceAccessionTools.parseGInumberFromString(sequence.getGeneName());
            }
            if (ForesterUtil.isEmpty(string) && phylogenyNode.getNodeData().getSequence().getAccession() != null && !ForesterUtil.isEmpty(sequence.getAccession().getValue())) {
                string = SequenceAccessionTools.parseGInumberFromString(sequence.getAccession().getValue());
            }
        }
        if (ForesterUtil.isEmpty(string) && !ForesterUtil.isEmpty(phylogenyNode.getName())) {
            string = SequenceAccessionTools.parseGInumberFromString(phylogenyNode.getName());
        }
        return string;
    }

    public static final String obtainRefSeqAccessorFromDataFields(PhylogenyNode phylogenyNode) {
        String string = null;
        if (phylogenyNode.getNodeData().isHasSequence()) {
            Sequence sequence = phylogenyNode.getNodeData().getSequence();
            if (!ForesterUtil.isEmpty(sequence.getSymbol())) {
                string = SequenceAccessionTools.parseRefSeqAccessorFromString(sequence.getSymbol());
            }
            if (!ForesterUtil.isEmpty(sequence.getGeneName())) {
                string = SequenceAccessionTools.parseRefSeqAccessorFromString(sequence.getGeneName());
            }
            if (ForesterUtil.isEmpty(string) && !ForesterUtil.isEmpty(sequence.getName())) {
                string = SequenceAccessionTools.parseRefSeqAccessorFromString(sequence.getName());
            }
            if (ForesterUtil.isEmpty(string) && phylogenyNode.getNodeData().getSequence().getAccession() != null && !ForesterUtil.isEmpty(sequence.getAccession().getValue())) {
                string = SequenceAccessionTools.parseRefSeqAccessorFromString(sequence.getAccession().getValue());
            }
        }
        if (ForesterUtil.isEmpty(string) && !ForesterUtil.isEmpty(phylogenyNode.getName())) {
            string = SequenceAccessionTools.parseRefSeqAccessorFromString(phylogenyNode.getName());
        }
        return string;
    }

    public static final String obtainUniProtAccessorFromDataFields(PhylogenyNode phylogenyNode) {
        String string = null;
        if (phylogenyNode.getNodeData().isHasSequence()) {
            Sequence sequence = phylogenyNode.getNodeData().getSequence();
            if (!ForesterUtil.isEmpty(sequence.getSymbol())) {
                string = SequenceAccessionTools.parseUniProtAccessorFromString(sequence.getSymbol());
            }
            if (ForesterUtil.isEmpty(string) && !ForesterUtil.isEmpty(sequence.getName())) {
                string = SequenceAccessionTools.parseUniProtAccessorFromString(sequence.getName());
            }
            if (ForesterUtil.isEmpty(string) && !ForesterUtil.isEmpty(sequence.getGeneName())) {
                string = SequenceAccessionTools.parseUniProtAccessorFromString(sequence.getGeneName());
            }
            if (ForesterUtil.isEmpty(string) && phylogenyNode.getNodeData().getSequence().getAccession() != null && !ForesterUtil.isEmpty(sequence.getAccession().getValue())) {
                string = SequenceAccessionTools.parseUniProtAccessorFromString(sequence.getAccession().getValue());
            }
        }
        if (ForesterUtil.isEmpty(string) && !ForesterUtil.isEmpty(phylogenyNode.getName())) {
            string = SequenceAccessionTools.parseUniProtAccessorFromString(phylogenyNode.getName());
        }
        return string;
    }

    public static final Accession parseAccessorFromString(String string) {
        if (!ForesterUtil.isEmpty(string)) {
            String string2 = SequenceAccessionTools.parseGenbankAccessorFromString(string);
            if (!ForesterUtil.isEmpty(string2)) {
                return new Accession(string2, Accession.Source.NCBI);
            }
            string2 = SequenceAccessionTools.parseRefSeqAccessorFromString(string);
            if (!ForesterUtil.isEmpty(string2)) {
                return new Accession(string2, Accession.Source.REFSEQ);
            }
            string2 = SequenceAccessionTools.parseGInumberFromString(string);
            if (!ForesterUtil.isEmpty(string2)) {
                return new Accession(string2, Accession.Source.GI);
            }
            string2 = SequenceAccessionTools.parseEnsemlAccessorFromString(string);
            if (!ForesterUtil.isEmpty(string2)) {
                return new Accession(string2, Accession.Source.ENSEMBL);
            }
            string2 = SequenceAccessionTools.parseUniProtAccessorFromString(string);
            if (!ForesterUtil.isEmpty(string2)) {
                return new Accession(string2, Accession.Source.UNIPROT);
            }
            string2 = SequenceAccessionTools.parseViprFromString(string);
            if (!ForesterUtil.isEmpty(string2)) {
                return new Accession(string2, VIPR_SOURCE);
            }
        }
        return null;
    }

    public static final String parseGenbankAccessorFromString(String string) {
        Matcher matcher = GENBANK_NUC_PATTERN_1.matcher(string);
        if (matcher.lookingAt()) {
            return matcher.group(1);
        }
        matcher = GENBANK_NUC_PATTERN_2.matcher(string);
        if (matcher.lookingAt()) {
            return matcher.group(1);
        }
        matcher = GENBANK_PROT_PATTERN.matcher(string);
        if (matcher.lookingAt()) {
            return matcher.group(1);
        }
        return null;
    }

    public static final String parseGenbankProteinAccessorFromString(String string) {
        Matcher matcher = GENBANK_PROT_PATTERN.matcher(string);
        if (matcher.lookingAt()) {
            return matcher.group(1);
        }
        return null;
    }

    public static final String parseGInumberFromString(String string) {
        Matcher matcher = GI_PATTERN.matcher(string);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static final String parseEnsemlAccessorFromString(String string) {
        Matcher matcher = ENSEMBL_PATTERN.matcher(string);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static final String parseRefSeqAccessorFromString(String string) {
        Matcher matcher = REFSEQ_PATTERN.matcher(string);
        if (matcher.lookingAt()) {
            return matcher.group(1);
        }
        return null;
    }

    public static final String parseViprFromString(String string) {
        Matcher matcher = VIPR_PATTERN.matcher(string);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static final String parseUniProtAccessorFromString(String string) {
        Matcher matcher = UNIPROT_KB_PATTERN_1.matcher(string);
        if (matcher.find()) {
            return matcher.group(1);
        }
        matcher = UNIPROT_KB_PATTERN_2.matcher(string);
        if (matcher.find()) {
            return matcher.group();
        }
        matcher = UNIPROT_KB_PATTERN_0.matcher(string);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }
}

