/*
 * Decompiled with CFR 0.152.
 */
package org.forester.util;

import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.forester.util.ForesterUtil;

public class GeneralTable<IDENTIFIER_TYPE, VALUE_TYPE> {
    private Map<IDENTIFIER_TYPE, Map<IDENTIFIER_TYPE, VALUE_TYPE>> _rows;
    private SortedSet<IDENTIFIER_TYPE> _row_identifiers;
    private SortedSet<IDENTIFIER_TYPE> _column_identifiers;

    public GeneralTable() {
        this.init();
    }

    public SortedSet<IDENTIFIER_TYPE> getColumnIdentifiers() {
        return this._column_identifiers;
    }

    private Map<IDENTIFIER_TYPE, VALUE_TYPE> getRow(IDENTIFIER_TYPE IDENTIFIER_TYPE) {
        return this.getRows().get(IDENTIFIER_TYPE);
    }

    public SortedSet<IDENTIFIER_TYPE> getRowIdentifiers() {
        return this._row_identifiers;
    }

    private Map<IDENTIFIER_TYPE, Map<IDENTIFIER_TYPE, VALUE_TYPE>> getRows() {
        return this._rows;
    }

    public VALUE_TYPE getValue(IDENTIFIER_TYPE IDENTIFIER_TYPE, IDENTIFIER_TYPE IDENTIFIER_TYPE2) throws IllegalArgumentException {
        Map<IDENTIFIER_TYPE, VALUE_TYPE> map = this.getRow(IDENTIFIER_TYPE2);
        if (map == null || map.size() < 1) {
            return null;
        }
        return map.get(IDENTIFIER_TYPE);
    }

    public String getValueAsString(IDENTIFIER_TYPE IDENTIFIER_TYPE, IDENTIFIER_TYPE IDENTIFIER_TYPE2) throws IllegalArgumentException {
        VALUE_TYPE VALUE_TYPE = this.getValue(IDENTIFIER_TYPE, IDENTIFIER_TYPE2);
        return VALUE_TYPE == null ? "" : this.getValue(IDENTIFIER_TYPE, IDENTIFIER_TYPE2).toString();
    }

    private void init() {
        this._rows = new HashMap<IDENTIFIER_TYPE, Map<IDENTIFIER_TYPE, VALUE_TYPE>>();
        this._row_identifiers = new TreeSet<IDENTIFIER_TYPE>();
        this._column_identifiers = new TreeSet<IDENTIFIER_TYPE>();
    }

    public void setValue(IDENTIFIER_TYPE IDENTIFIER_TYPE, IDENTIFIER_TYPE IDENTIFIER_TYPE2, VALUE_TYPE VALUE_TYPE) {
        this.getColumnIdentifiers().add(IDENTIFIER_TYPE);
        this.getRowIdentifiers().add(IDENTIFIER_TYPE2);
        Map<Object, Object> map = null;
        if (this.getRows().containsKey(IDENTIFIER_TYPE2)) {
            map = this.getRows().get(IDENTIFIER_TYPE2);
        } else {
            map = new HashMap();
            this.getRows().put(IDENTIFIER_TYPE2, map);
        }
        map.put(IDENTIFIER_TYPE, VALUE_TYPE);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\t");
        for (Object e : this.getColumnIdentifiers()) {
            stringBuilder.append(e.toString());
            stringBuilder.append("\t");
        }
        stringBuilder.append(ForesterUtil.LINE_SEPARATOR);
        for (Object e : this.getRowIdentifiers()) {
            stringBuilder.append(e.toString());
            stringBuilder.append("\t");
            for (Object e2 : this.getColumnIdentifiers()) {
                stringBuilder.append(this.getValueAsString(e2, e));
                stringBuilder.append("\t");
            }
            stringBuilder.append(ForesterUtil.LINE_SEPARATOR);
        }
        return stringBuilder.toString();
    }

    public String toString(NumberFormat numberFormat) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\t");
        for (Object e : this.getColumnIdentifiers()) {
            stringBuilder.append(e.toString());
            stringBuilder.append("\t");
        }
        stringBuilder.append(ForesterUtil.LINE_SEPARATOR);
        for (Object e : this.getRowIdentifiers()) {
            stringBuilder.append(e.toString());
            stringBuilder.append("\t");
            for (Object e2 : this.getColumnIdentifiers()) {
                try {
                    stringBuilder.append(numberFormat.format(this.getValue(e2, e)));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    stringBuilder.append(this.getValueAsString(e2, e));
                }
                stringBuilder.append("\t");
            }
            stringBuilder.append(ForesterUtil.LINE_SEPARATOR);
        }
        return stringBuilder.toString();
    }
}

