/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.forester.species.Species;
import org.forester.surfacing.CombinableDomains;
import org.forester.surfacing.CombinationsBasedPairwiseDomainSimilarity;
import org.forester.surfacing.CombinationsBasedPairwiseDomainSimilarityCalculator;
import org.forester.surfacing.DomainSimilarity;
import org.forester.surfacing.DomainSimilarityCalculator;
import org.forester.surfacing.GenomeWideCombinableDomains;
import org.forester.surfacing.PairwiseDomainSimilarity;
import org.forester.surfacing.PairwiseDomainSimilarityCalculator;
import org.forester.surfacing.PrintableSpeciesSpecificDcData;
import org.forester.util.BasicDescriptiveStatistics;
import org.forester.util.ForesterUtil;

public class BasicDomainSimilarityCalculator
implements DomainSimilarityCalculator {
    final DomainSimilarity.DomainSimilaritySortField _sort;
    private final boolean _calc_similarity_score;
    private final boolean _sort_by_species_count_first;
    private final boolean _treat_as_binary_comparison;
    private final boolean _verbose;

    public BasicDomainSimilarityCalculator(DomainSimilarity.DomainSimilaritySortField domainSimilaritySortField, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this._sort = domainSimilaritySortField;
        this._sort_by_species_count_first = bl;
        this._treat_as_binary_comparison = bl2;
        this._calc_similarity_score = bl3;
        this._verbose = bl4;
    }

    public BasicDomainSimilarityCalculator(DomainSimilarity.DomainSimilaritySortField domainSimilaritySortField, boolean bl, boolean bl2, boolean bl3) {
        this._sort = domainSimilaritySortField;
        this._sort_by_species_count_first = bl;
        this._treat_as_binary_comparison = bl2;
        this._calc_similarity_score = bl3;
        this._verbose = false;
    }

    @Override
    public SortedSet<DomainSimilarity> calculateSimilarities(PairwiseDomainSimilarityCalculator pairwiseDomainSimilarityCalculator, List<GenomeWideCombinableDomains> list, boolean bl, boolean bl2) {
        if (list.size() < 2) {
            throw new IllegalArgumentException("attempt to calculate multiple combinable domains similarity for less than two combinale domains collections");
        }
        TreeSet<DomainSimilarity> treeSet = new TreeSet<DomainSimilarity>();
        TreeSet<String> treeSet2 = new TreeSet<String>();
        for (GenomeWideCombinableDomains genomeWideCombinableDomains : list) {
            treeSet2.addAll(genomeWideCombinableDomains.getAllCombinableDomainsIds().keySet());
        }
        DecimalFormat decimalFormat = new DecimalFormat("000000");
        int n = 1;
        if (this._verbose) {
            System.out.println(treeSet2.size());
        }
        for (String string : treeSet2) {
            if (this._verbose) {
                ForesterUtil.updateProgress(n, decimalFormat);
            }
            ++n;
            ArrayList<CombinableDomains> arrayList = new ArrayList<CombinableDomains>(list.size());
            ArrayList<Species> arrayList2 = new ArrayList<Species>();
            for (GenomeWideCombinableDomains genomeWideCombinableDomains : list) {
                if (!genomeWideCombinableDomains.contains(string)) continue;
                arrayList.add(genomeWideCombinableDomains.get(string));
                arrayList2.add(genomeWideCombinableDomains.getSpecies());
            }
            if (bl) {
                boolean bl3 = true;
                for (CombinableDomains combinableDomains : arrayList) {
                    if (combinableDomains.getNumberOfCombinableDomains() <= 0) continue;
                    bl3 = false;
                    break;
                }
                if (bl3) continue;
            }
            if (arrayList.size() > 0) {
                if (bl2 && arrayList.size() <= 1) continue;
                DomainSimilarity domainSimilarity = this.calculateSimilarity(pairwiseDomainSimilarityCalculator, arrayList);
                if (domainSimilarity != null) {
                    treeSet.add(domainSimilarity);
                    continue;
                }
                throw new RuntimeException("similarity is null: this should not have happened");
            }
            throw new RuntimeException("this should not have happened");
        }
        if (this._verbose) {
            System.out.println();
        }
        return treeSet;
    }

    public boolean isCalcSimilarityScore() {
        return this._calc_similarity_score;
    }

    private DomainSimilarity calculateSimilarity(PairwiseDomainSimilarityCalculator pairwiseDomainSimilarityCalculator, List<CombinableDomains> list) {
        if (list.size() == 1) {
            TreeMap<Species, PrintableSpeciesSpecificDcData> treeMap = new TreeMap<Species, PrintableSpeciesSpecificDcData>();
            treeMap.put(list.get(0).getSpecies(), BasicDomainSimilarityCalculator.createSpeciesSpecificDomainSimilariyData(list.get(0)));
            if (!this.isCalcSimilarityScore()) {
                return new DomainSimilarity(list.get(0), 0, 0, treeMap, this.isSortBySpeciesCountFirst(), this.isTreatAsBinaryComparison());
            }
            return new DomainSimilarity(list.get(0), 1.0, 1.0, 1.0, 1.0, 0.0, 0, 0, 0, treeMap, this.isSortBySpeciesCountFirst(), this.isTreatAsBinaryComparison());
        }
        BasicDescriptiveStatistics basicDescriptiveStatistics = null;
        if (this.isCalcSimilarityScore()) {
            basicDescriptiveStatistics = new BasicDescriptiveStatistics();
        }
        TreeMap<Species, PrintableSpeciesSpecificDcData> treeMap = new TreeMap<Species, PrintableSpeciesSpecificDcData>();
        treeMap.put(list.get(0).getSpecies(), BasicDomainSimilarityCalculator.createSpeciesSpecificDomainSimilariyData(list.get(0)));
        int n = 0;
        int n2 = 0;
        boolean bl = pairwiseDomainSimilarityCalculator instanceof CombinationsBasedPairwiseDomainSimilarityCalculator;
        for (int i = 1; i < list.size(); ++i) {
            treeMap.put(list.get(i).getSpecies(), BasicDomainSimilarityCalculator.createSpeciesSpecificDomainSimilariyData(list.get(i)));
            CombinableDomains combinableDomains = list.get(i);
            for (int j = 0; j < i; ++j) {
                PairwiseDomainSimilarity pairwiseDomainSimilarity = pairwiseDomainSimilarityCalculator.calculateSimilarity(combinableDomains, list.get(j));
                int n3 = pairwiseDomainSimilarity.getDifferenceInCounts();
                int n4 = 0;
                n4 = bl ? ((CombinationsBasedPairwiseDomainSimilarity)pairwiseDomainSimilarity).getNumberOfDifferentDomains() : n3;
                if (Math.abs(n3) > Math.abs(n)) {
                    n = n3;
                }
                if (Math.abs(n4) > Math.abs(n2)) {
                    n2 = n4;
                }
                if (!this.isCalcSimilarityScore()) continue;
                basicDescriptiveStatistics.addValue(pairwiseDomainSimilarity.getSimilarityScore());
            }
        }
        if (this.isCalcSimilarityScore()) {
            if (basicDescriptiveStatistics.getN() < 1) {
                throw new RuntimeException("empty descriptive statistics: this should not have happened");
            }
            if (basicDescriptiveStatistics.getN() != 1 && this.isTreatAsBinaryComparison()) {
                throw new IllegalArgumentException("attmpt to treat similarity with N not equal to one as binary comparison");
            }
        }
        if (!this.isTreatAsBinaryComparison() && n < 0) {
            n = Math.abs(n);
            if (!bl) {
                n2 = Math.abs(n2);
            }
        }
        DomainSimilarity domainSimilarity = null;
        domainSimilarity = !this.isCalcSimilarityScore() ? new DomainSimilarity(list.get(0), n, n2, treeMap, this.isSortBySpeciesCountFirst(), this.isTreatAsBinaryComparison()) : (basicDescriptiveStatistics.getN() == 1 ? new DomainSimilarity(list.get(0), basicDescriptiveStatistics.getMin(), basicDescriptiveStatistics.getMax(), basicDescriptiveStatistics.arithmeticMean(), basicDescriptiveStatistics.median(), 0.0, basicDescriptiveStatistics.getN(), n, n2, treeMap, this.isSortBySpeciesCountFirst(), this.isTreatAsBinaryComparison()) : new DomainSimilarity(list.get(0), basicDescriptiveStatistics.getMin(), basicDescriptiveStatistics.getMax(), basicDescriptiveStatistics.arithmeticMean(), basicDescriptiveStatistics.median(), basicDescriptiveStatistics.sampleStandardDeviation(), basicDescriptiveStatistics.getN(), n, n2, treeMap, this.isSortBySpeciesCountFirst(), this.isTreatAsBinaryComparison()));
        return domainSimilarity;
    }

    private boolean isSortBySpeciesCountFirst() {
        return this._sort_by_species_count_first;
    }

    private boolean isTreatAsBinaryComparison() {
        return this._treat_as_binary_comparison;
    }

    private static PrintableSpeciesSpecificDcData createSpeciesSpecificDomainSimilariyData(CombinableDomains combinableDomains) {
        PrintableSpeciesSpecificDcData printableSpeciesSpecificDcData = new PrintableSpeciesSpecificDcData(combinableDomains.getKeyDomainCount(), combinableDomains.getNumberOfCombinableDomains());
        for (String string : combinableDomains.getKeyDomainProteins()) {
            printableSpeciesSpecificDcData.addKeyDomainProtein(string);
        }
        for (String string : combinableDomains.getCombinableDomains()) {
            printableSpeciesSpecificDcData.addProteinsExhibitingCombinationCount(string, combinableDomains.getNumberOfProteinsExhibitingCombination(string));
        }
        return printableSpeciesSpecificDcData;
    }
}

