/*
 * Decompiled with CFR 0.152.
 */
package org.forester.sdi;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyBranch;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.sdi.GSDI;
import org.forester.sdi.GSDII;
import org.forester.sdi.GSDIsummaryResult;
import org.forester.sdi.NodesLinkingResult;
import org.forester.sdi.SDIException;
import org.forester.sdi.SDIutil;
import org.forester.util.BasicDescriptiveStatistics;

public class GSDIR
implements GSDII {
    private final int _min_duplications_sum;
    private final int _speciations_sum;
    private final BasicDescriptiveStatistics _duplications_sum_stats;
    private Phylogeny _min_duplications_sum_gene_tree;
    private final List<PhylogenyNode> _stripped_gene_tree_nodes;
    private final List<PhylogenyNode> _stripped_species_tree_nodes;
    private final Set<PhylogenyNode> _mapped_species_tree_nodes;
    private final SDIutil.TaxonomyComparisonBase _tax_comp_base;
    private final SortedSet<String> _scientific_names_mapped_to_reduced_specificity;

    public GSDIR(Phylogeny phylogeny, Phylogeny phylogeny2, boolean bl, boolean bl2, boolean bl3) throws SDIException {
        NodesLinkingResult nodesLinkingResult = GSDI.linkNodesOfG(phylogeny, phylogeny2, bl, bl2);
        this._stripped_gene_tree_nodes = nodesLinkingResult.getStrippedGeneTreeNodes();
        this._stripped_species_tree_nodes = nodesLinkingResult.getStrippedSpeciesTreeNodes();
        this._mapped_species_tree_nodes = nodesLinkingResult.getMappedSpeciesTreeNodes();
        this._scientific_names_mapped_to_reduced_specificity = nodesLinkingResult.getScientificNamesMappedToReducedSpecificity();
        this._tax_comp_base = nodesLinkingResult.getTaxCompBase();
        ArrayList<PhylogenyBranch> arrayList = new ArrayList<PhylogenyBranch>();
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.isRoot() || phylogenyNode.getParent().isRoot() && phylogeny.getRoot().getNumberOfDescendants() == 2) continue;
            arrayList.add(new PhylogenyBranch(phylogenyNode, phylogenyNode.getParent()));
        }
        if (phylogeny.getRoot().getNumberOfDescendants() == 2) {
            arrayList.add(new PhylogenyBranch(phylogeny.getRoot().getChildNode1(), phylogeny.getRoot().getChildNode2()));
        }
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        this._duplications_sum_stats = new BasicDescriptiveStatistics();
        for (PhylogenyBranch phylogenyBranch : arrayList) {
            GSDIR.reRoot(phylogenyBranch, phylogeny);
            PhylogenyMethods.preOrderReId(phylogeny2);
            GSDIsummaryResult gSDIsummaryResult = GSDI.geneTreePostOrderTraversal(phylogeny, true, n);
            if (gSDIsummaryResult == null) continue;
            if (gSDIsummaryResult.getDuplicationsSum() < n) {
                n = gSDIsummaryResult.getDuplicationsSum();
                n2 = gSDIsummaryResult.getSpeciationsSum();
                this._min_duplications_sum_gene_tree = phylogeny.copy();
                if (bl3) {
                    GSDIR.transferTaxonomy(this._min_duplications_sum_gene_tree);
                }
            } else if (gSDIsummaryResult.getDuplicationsSum() == n) {
                ArrayList<Phylogeny> arrayList2 = new ArrayList<Phylogeny>();
                arrayList2.add(this._min_duplications_sum_gene_tree);
                arrayList2.add(phylogeny);
                int n3 = GSDIR.getIndexesOfShortestTree(arrayList2).get(0);
                if (n3 == 1) {
                    this._min_duplications_sum_gene_tree = phylogeny.copy();
                    if (bl3) {
                        GSDIR.transferTaxonomy(this._min_duplications_sum_gene_tree);
                    }
                }
            }
            this._duplications_sum_stats.addValue(gSDIsummaryResult.getDuplicationsSum());
        }
        this._min_duplications_sum = n;
        this._speciations_sum = n2;
    }

    public BasicDescriptiveStatistics getDuplicationsSumStats() {
        return this._duplications_sum_stats;
    }

    @Override
    public Set<PhylogenyNode> getMappedExternalSpeciesTreeNodes() {
        return this._mapped_species_tree_nodes;
    }

    public int getMinDuplicationsSum() {
        return this._min_duplications_sum;
    }

    public Phylogeny getMinDuplicationsSumGeneTree() {
        return this._min_duplications_sum_gene_tree;
    }

    @Override
    public final SortedSet<String> getReMappedScientificNamesFromGeneTree() {
        return this._scientific_names_mapped_to_reduced_specificity;
    }

    @Override
    public int getSpeciationsSum() {
        return this._speciations_sum;
    }

    @Override
    public List<PhylogenyNode> getStrippedExternalGeneTreeNodes() {
        return this._stripped_gene_tree_nodes;
    }

    @Override
    public List<PhylogenyNode> getStrippedSpeciesTreeNodes() {
        return this._stripped_species_tree_nodes;
    }

    @Override
    public SDIutil.TaxonomyComparisonBase getTaxCompBase() {
        return this._tax_comp_base;
    }

    public static final List<Integer> getIndexesOfShortestTree(List<Phylogeny> list) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        boolean bl = true;
        double d = Double.MAX_VALUE;
        for (int i = 0; i < list.size(); ++i) {
            double d2;
            Phylogeny phylogeny = list.get(i);
            if (i == 0 && PhylogenyMethods.calculateMaxDistanceToRoot(phylogeny) > 0.0) {
                bl = false;
            }
            if ((d2 = bl ? (double)PhylogenyMethods.calculateMaxDepth(phylogeny) : PhylogenyMethods.calculateMaxDistanceToRoot(phylogeny)) < d) {
                d = d2;
                arrayList.clear();
                arrayList.add(i);
                continue;
            }
            if (d2 != d) continue;
            arrayList.add(i);
        }
        return arrayList;
    }

    static final void reRoot(PhylogenyBranch phylogenyBranch, Phylogeny phylogeny) {
        PhylogenyNode phylogenyNode = phylogenyBranch.getFirstNode();
        PhylogenyNode phylogenyNode2 = phylogenyBranch.getSecondNode();
        if (phylogenyNode.isExternal()) {
            phylogeny.reRoot(phylogenyNode);
        } else if (phylogenyNode2.isExternal()) {
            phylogeny.reRoot(phylogenyNode2);
        } else if (phylogenyNode2 == phylogenyNode.getChildNode1() || phylogenyNode2 == phylogenyNode.getChildNode2()) {
            phylogeny.reRoot(phylogenyNode2);
        } else if (phylogenyNode == phylogenyNode2.getChildNode1() || phylogenyNode == phylogenyNode2.getChildNode2()) {
            phylogeny.reRoot(phylogenyNode);
        } else {
            throw new IllegalArgumentException("reRoot( Branch b ): b is not a branch.");
        }
    }

    private static final void transferTaxonomy(Phylogeny phylogeny) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            GSDI.transferTaxonomy(phylogenyNodeIterator.next());
        }
    }
}

