/*
 * Decompiled with CFR 0.152.
 */
package org.forester.sdi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Event;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.sdi.GSDII;
import org.forester.sdi.GSDIsummaryResult;
import org.forester.sdi.NodesLinkingResult;
import org.forester.sdi.SDIException;
import org.forester.sdi.SDIutil;
import org.forester.util.ForesterUtil;

public final class GSDI
implements GSDII {
    private final boolean _most_parsimonious_duplication_model;
    private final int _speciation_or_duplication_events_sum;
    private final int _speciations_sum;
    private final int _duplications_sum;
    private final List<PhylogenyNode> _stripped_gene_tree_nodes;
    private final List<PhylogenyNode> _stripped_species_tree_nodes;
    private final Set<PhylogenyNode> _mapped_species_tree_nodes;
    private final SDIutil.TaxonomyComparisonBase _tax_comp_base;
    private final SortedSet<String> _scientific_names_mapped_to_reduced_specificity;

    public GSDI(Phylogeny phylogeny, Phylogeny phylogeny2, boolean bl, boolean bl2, boolean bl3) throws SDIException {
        this(phylogeny, phylogeny2, bl, bl2, bl3, true);
    }

    public GSDI(Phylogeny phylogeny, Phylogeny phylogeny2, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws SDIException {
        this._most_parsimonious_duplication_model = bl;
        if (phylogeny.getRoot().getNumberOfDescendants() == 3) {
            phylogeny.reRoot(phylogeny.getRoot().getChildNode(2));
        }
        NodesLinkingResult nodesLinkingResult = GSDI.linkNodesOfG(phylogeny, phylogeny2, bl2, bl3);
        this._stripped_gene_tree_nodes = nodesLinkingResult.getStrippedGeneTreeNodes();
        this._stripped_species_tree_nodes = nodesLinkingResult.getStrippedSpeciesTreeNodes();
        this._mapped_species_tree_nodes = nodesLinkingResult.getMappedSpeciesTreeNodes();
        this._scientific_names_mapped_to_reduced_specificity = nodesLinkingResult.getScientificNamesMappedToReducedSpecificity();
        this._tax_comp_base = nodesLinkingResult.getTaxCompBase();
        PhylogenyMethods.preOrderReId(phylogeny2);
        GSDIsummaryResult gSDIsummaryResult = GSDI.geneTreePostOrderTraversal(phylogeny, this._most_parsimonious_duplication_model, bl4);
        this._speciation_or_duplication_events_sum = gSDIsummaryResult.getSpeciationOrDuplicationEventsSum();
        this._speciations_sum = gSDIsummaryResult.getSpeciationsSum();
        this._duplications_sum = gSDIsummaryResult.getDuplicationsSum();
    }

    public int getDuplicationsSum() {
        return this._duplications_sum;
    }

    @Override
    public Set<PhylogenyNode> getMappedExternalSpeciesTreeNodes() {
        return this._mapped_species_tree_nodes;
    }

    @Override
    public final SortedSet<String> getReMappedScientificNamesFromGeneTree() {
        return this._scientific_names_mapped_to_reduced_specificity;
    }

    public final int getSpeciationOrDuplicationEventsSum() {
        return this._speciation_or_duplication_events_sum;
    }

    @Override
    public final int getSpeciationsSum() {
        return this._speciations_sum;
    }

    @Override
    public List<PhylogenyNode> getStrippedExternalGeneTreeNodes() {
        return this._stripped_gene_tree_nodes;
    }

    @Override
    public List<PhylogenyNode> getStrippedSpeciesTreeNodes() {
        return this._stripped_species_tree_nodes;
    }

    @Override
    public SDIutil.TaxonomyComparisonBase getTaxCompBase() {
        return this._tax_comp_base;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Most parsimonious duplication model: " + this._most_parsimonious_duplication_model);
        stringBuffer.append(ForesterUtil.getLineSeparator());
        stringBuffer.append("Speciations sum                    : " + this.getSpeciationsSum());
        stringBuffer.append(ForesterUtil.getLineSeparator());
        stringBuffer.append("Duplications sum                   : " + this.getDuplicationsSum());
        stringBuffer.append(ForesterUtil.getLineSeparator());
        if (!this._most_parsimonious_duplication_model) {
            stringBuffer.append("Speciation or duplications sum     : " + this.getSpeciationOrDuplicationEventsSum());
            stringBuffer.append(ForesterUtil.getLineSeparator());
        }
        return stringBuffer.toString();
    }

    static final GSDIsummaryResult geneTreePostOrderTraversal(Phylogeny phylogeny, boolean bl, boolean bl2) throws SDIException {
        GSDIsummaryResult gSDIsummaryResult = new GSDIsummaryResult();
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.isInternal()) {
                if (phylogenyNode.getNumberOfDescendants() != 2) {
                    throw new SDIException("gene tree contains internal node with " + phylogenyNode.getNumberOfDescendants() + " descendents");
                }
                PhylogenyNode phylogenyNode2 = phylogenyNode.getChildNode1().getLink();
                PhylogenyNode phylogenyNode3 = phylogenyNode.getChildNode2().getLink();
                while (phylogenyNode2 != phylogenyNode3) {
                    if (phylogenyNode2.getId() > phylogenyNode3.getId()) {
                        phylogenyNode2 = phylogenyNode2.getParent();
                        continue;
                    }
                    phylogenyNode3 = phylogenyNode3.getParent();
                }
                phylogenyNode.setLink(phylogenyNode2);
                GSDI.determineEvent(phylogenyNode2, phylogenyNode, bl, gSDIsummaryResult);
            }
            if (!bl2) continue;
            GSDI.transferTaxonomy(phylogenyNode);
        }
        return gSDIsummaryResult;
    }

    static final GSDIsummaryResult geneTreePostOrderTraversal(Phylogeny phylogeny, boolean bl, int n) throws SDIException {
        GSDIsummaryResult gSDIsummaryResult = new GSDIsummaryResult();
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (!phylogenyNode.isInternal()) continue;
            if (phylogenyNode.getNumberOfDescendants() != 2) {
                throw new SDIException("gene tree contains internal node with " + phylogenyNode.getNumberOfDescendants() + " descendents");
            }
            PhylogenyNode phylogenyNode2 = phylogenyNode.getChildNode1().getLink();
            PhylogenyNode phylogenyNode3 = phylogenyNode.getChildNode2().getLink();
            while (phylogenyNode2 != phylogenyNode3) {
                if (phylogenyNode2.getId() > phylogenyNode3.getId()) {
                    phylogenyNode2 = phylogenyNode2.getParent();
                    continue;
                }
                phylogenyNode3 = phylogenyNode3.getParent();
            }
            phylogenyNode.setLink(phylogenyNode2);
            GSDI.determineEvent(phylogenyNode2, phylogenyNode, bl, gSDIsummaryResult);
            if (gSDIsummaryResult.getDuplicationsSum() <= n) continue;
            return null;
        }
        return gSDIsummaryResult;
    }

    static final NodesLinkingResult linkNodesOfG(Phylogeny phylogeny, Phylogeny phylogeny2, boolean bl, boolean bl2) throws SDIException {
        SDIutil.TaxonomyComparisonBase taxonomyComparisonBase = SDIutil.determineTaxonomyComparisonBase(phylogeny);
        if (taxonomyComparisonBase == null) {
            throw new RuntimeException("failed to establish taxonomy linking base (taxonomy linking base is null)");
        }
        return GSDI.linkNodesOfG(phylogeny, phylogeny2, taxonomyComparisonBase, bl, bl2);
    }

    static final NodesLinkingResult linkNodesOfG(Phylogeny phylogeny, Phylogeny phylogeny2, SDIutil.TaxonomyComparisonBase taxonomyComparisonBase, boolean bl, boolean bl2) throws SDIException {
        String string;
        PhylogenyNode phylogenyNode;
        if (taxonomyComparisonBase == null) {
            throw new IllegalArgumentException("taxonomy linking base is null");
        }
        HashMap<String, PhylogenyNode> hashMap = new HashMap<String, PhylogenyNode>();
        ArrayList<PhylogenyNode> arrayList = new ArrayList<PhylogenyNode>();
        NodesLinkingResult nodesLinkingResult = new NodesLinkingResult();
        nodesLinkingResult.setTaxCompBase(taxonomyComparisonBase);
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny2.iteratorExternalForward();
        while (phylogenyNodeIterator.hasNext()) {
            phylogenyNode = phylogenyNodeIterator.next();
            arrayList.add(phylogenyNode);
            if (!phylogenyNode.getNodeData().isHasTaxonomy() || ForesterUtil.isEmpty(string = SDIutil.taxonomyToString(phylogenyNode, nodesLinkingResult.getTaxCompBase()))) continue;
            if (hashMap.containsKey(string)) {
                throw new SDIException("taxonomy \"" + string + "\" is not unique in species tree (using " + (Object)((Object)nodesLinkingResult.getTaxCompBase()) + " for linking to gene tree)");
            }
            hashMap.put(string, phylogenyNode);
        }
        phylogenyNodeIterator = phylogeny.iteratorExternalForward();
        while (phylogenyNodeIterator.hasNext()) {
            phylogenyNode = phylogenyNodeIterator.next();
            if (!phylogenyNode.getNodeData().isHasTaxonomy()) {
                if (bl) {
                    nodesLinkingResult.getStrippedGeneTreeNodes().add(phylogenyNode);
                    continue;
                }
                throw new SDIException("gene tree node \"" + phylogenyNode + "\" has no taxonomic data");
            }
            string = SDIutil.taxonomyToString(phylogenyNode, nodesLinkingResult.getTaxCompBase());
            if (ForesterUtil.isEmpty(string)) {
                if (bl) {
                    nodesLinkingResult.getStrippedGeneTreeNodes().add(phylogenyNode);
                    continue;
                }
                throw new SDIException("gene tree node \"" + phylogenyNode + "\" has no appropriate taxonomic data");
            }
            PhylogenyNode phylogenyNode2 = (PhylogenyNode)hashMap.get(string);
            if (nodesLinkingResult.getTaxCompBase() == SDIutil.TaxonomyComparisonBase.SCIENTIFIC_NAME && phylogenyNode2 == null && ForesterUtil.countChars(string, ' ') > 1) {
                phylogenyNode2 = GSDI.tryMapByRemovingOverlySpecificData(hashMap, string, nodesLinkingResult.getScientificNamesMappedToReducedSpecificity());
            }
            if (phylogenyNode2 == null) {
                if (bl) {
                    nodesLinkingResult.getStrippedGeneTreeNodes().add(phylogenyNode);
                    continue;
                }
                throw new SDIException("taxonomy \"" + phylogenyNode.getNodeData().getTaxonomy() + "\" not present in species tree");
            }
            phylogenyNode.setLink(phylogenyNode2);
            nodesLinkingResult.getMappedSpeciesTreeNodes().add(phylogenyNode2);
        }
        if (bl) {
            GSDI.stripTree(phylogeny, nodesLinkingResult.getStrippedGeneTreeNodes());
            if (phylogeny.isEmpty() || phylogeny.getNumberOfExternalNodes() < 2) {
                throw new SDIException("species could not be mapped between gene tree and species tree (based on " + (Object)((Object)nodesLinkingResult.getTaxCompBase()) + ")");
            }
        }
        if (bl2) {
            GSDI.stripSpeciesTree(phylogeny2, arrayList, nodesLinkingResult);
        }
        return nodesLinkingResult;
    }

    static final void transferTaxonomy(PhylogenyNode phylogenyNode) {
        if (phylogenyNode == null) {
            throw new IllegalArgumentException("gene tree node is null");
        }
        PhylogenyNode phylogenyNode2 = phylogenyNode.getLink();
        if (phylogenyNode2 == null) {
            throw new IllegalArgumentException("mapped species tree node is null");
        }
        if (phylogenyNode2.getNodeData().isHasTaxonomy()) {
            phylogenyNode.getNodeData().setTaxonomy(phylogenyNode2.getNodeData().getTaxonomy());
            if (phylogenyNode.isInternal()) {
                if (phylogenyNode.getChildNode1().isInternal() && phylogenyNode.getChildNode1().getNodeData().isHasTaxonomy() && phylogenyNode.getChildNode1().getNodeData().getTaxonomy() == phylogenyNode2.getNodeData().getTaxonomy()) {
                    phylogenyNode.getChildNode1().getNodeData().setTaxonomy(null);
                }
                if (phylogenyNode.getChildNode2().isInternal() && phylogenyNode.getChildNode2().getNodeData().isHasTaxonomy() && phylogenyNode.getChildNode2().getNodeData().getTaxonomy() == phylogenyNode2.getNodeData().getTaxonomy()) {
                    phylogenyNode.getChildNode2().getNodeData().setTaxonomy(null);
                }
            }
        }
    }

    private static final void addScientificNamesMappedToReducedSpecificity(String string, String string2, SortedSet<String> sortedSet) {
        sortedSet.add(string + " -> " + string2);
    }

    /*
     * WARNING - void declaration
     */
    private static final void determineEvent(PhylogenyNode phylogenyNode, PhylogenyNode phylogenyNode2, boolean bl, GSDIsummaryResult gSDIsummaryResult) {
        boolean bl2 = false;
        if (phylogenyNode2.getChildNode1().getLink() == phylogenyNode || phylogenyNode2.getChildNode2().getLink() == phylogenyNode) {
            bl2 = true;
        }
        if (phylogenyNode2.getLink().getNumberOfDescendants() == 2) {
            if (bl2) {
                phylogenyNode2.getNodeData().setEvent(Event.createSingleDuplicationEvent());
                gSDIsummaryResult.increaseDuplicationsSum();
            } else {
                phylogenyNode2.getNodeData().setEvent(Event.createSingleSpeciationEvent());
                gSDIsummaryResult.increaseSpeciationsSum();
            }
        } else if (bl2) {
            HashSet<void> hashSet = new HashSet<void>();
            for (PhylogenyNode phylogenyNode3 : phylogenyNode2.getChildNode1().getAllExternalDescendants()) {
                PhylogenyNode phylogenyNode4;
                void object;
                PhylogenyNode phylogenyNode5 = phylogenyNode3.getLink();
                while (object.getParent() != phylogenyNode && object.getParent() != null && !(phylogenyNode4 = object.getParent()).isRoot()) {
                }
                hashSet.add(object);
            }
            boolean bl3 = false;
            for (PhylogenyNode phylogenyNode6 : phylogenyNode2.getChildNode2().getAllExternalDescendants()) {
                phylogenyNode6 = phylogenyNode6.getLink();
                while (phylogenyNode6.getParent() != phylogenyNode && phylogenyNode6.getParent() != null && !(phylogenyNode6 = phylogenyNode6.getParent()).isRoot()) {
                }
                if (!hashSet.contains(phylogenyNode6)) continue;
                bl3 = true;
                break;
            }
            if (bl3) {
                phylogenyNode2.getNodeData().setEvent(Event.createSingleDuplicationEvent());
                gSDIsummaryResult.increaseDuplicationsSum();
            } else if (bl) {
                phylogenyNode2.getNodeData().setEvent(Event.createSingleSpeciationEvent());
                gSDIsummaryResult.increaseSpeciationsSum();
            } else {
                phylogenyNode2.getNodeData().setEvent(Event.createSingleSpeciationOrDuplicationEvent());
                gSDIsummaryResult.increaseSpeciationOrDuplicationEventsSum();
            }
        } else {
            phylogenyNode2.getNodeData().setEvent(Event.createSingleSpeciationEvent());
            gSDIsummaryResult.increaseSpeciationsSum();
        }
    }

    private static final void stripSpeciesTree(Phylogeny phylogeny, List<PhylogenyNode> list, NodesLinkingResult nodesLinkingResult) {
        for (PhylogenyNode phylogenyNode : list) {
            if (nodesLinkingResult.getMappedSpeciesTreeNodes().contains(phylogenyNode)) continue;
            phylogeny.deleteSubtree(phylogenyNode, true);
            nodesLinkingResult.getStrippedSpeciesTreeNodes().add(phylogenyNode);
        }
        phylogeny.clearHashIdToNodeMap();
        phylogeny.externalNodesHaveChanged();
    }

    private static final void stripTree(Phylogeny phylogeny, List<PhylogenyNode> list) {
        for (PhylogenyNode phylogenyNode : list) {
            phylogeny.deleteSubtree(phylogenyNode, true);
        }
        phylogeny.clearHashIdToNodeMap();
        phylogeny.externalNodesHaveChanged();
    }

    private static final PhylogenyNode tryMapByRemovingOverlySpecificData(Map<String, PhylogenyNode> map, String string, SortedSet<String> sortedSet) {
        String[] stringArray;
        PhylogenyNode phylogenyNode = GSDI.tryMapByRemovingOverlySpecificData(map, string, " (", sortedSet);
        if (phylogenyNode == null && ForesterUtil.countChars(string, ' ') == 2 && (phylogenyNode = map.get(stringArray = string.substring(0, string.lastIndexOf(32)).trim())) != null) {
            GSDI.addScientificNamesMappedToReducedSpecificity(string, (String)stringArray, sortedSet);
        }
        if (phylogenyNode == null) {
            String string2;
            stringArray = new String[]{" subspecies ", " strain ", " variety ", " varietas ", " subvariety ", " form ", " subform ", " cultivar ", " section ", " subsection "};
            int n = stringArray.length;
            for (int i = 0; i < n && (phylogenyNode = GSDI.tryMapByRemovingOverlySpecificData(map, string, string2 = stringArray[i], sortedSet)) == null; ++i) {
            }
        }
        return phylogenyNode;
    }

    private static final PhylogenyNode tryMapByRemovingOverlySpecificData(Map<String, PhylogenyNode> map, String string, String string2, SortedSet<String> sortedSet) {
        int n = string.indexOf(string2);
        if (n > 4) {
            String string3 = string.substring(0, n).trim();
            PhylogenyNode phylogenyNode = map.get(string3);
            if (phylogenyNode != null) {
                GSDI.addScientificNamesMappedToReducedSpecificity(string, string3, sortedSet);
            }
            return phylogenyNode;
        }
        return null;
    }
}

