/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.parsers.phyloxml.PhyloXmlUtil;
import org.forester.phylogeny.data.Accession;
import org.forester.phylogeny.data.Annotation;
import org.forester.phylogeny.data.DomainArchitecture;
import org.forester.phylogeny.data.MultipleUris;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PhylogenyDataUtil;
import org.forester.phylogeny.data.SequenceRelation;
import org.forester.phylogeny.data.Uri;
import org.forester.sequence.MolecularSequence;
import org.forester.util.ForesterUtil;

public class Sequence
implements PhylogenyData,
MultipleUris,
Comparable<Sequence> {
    private Accession _accession;
    private SortedSet<Annotation> _annotations;
    private DomainArchitecture _da;
    private String _gene_name;
    private String _location;
    private String _mol_sequence;
    private boolean _mol_sequence_is_aligned;
    private String _name;
    private List<SequenceRelation> _seq_relations;
    private String _source_id;
    private String _symbol;
    private String _type;
    private List<Uri> _uris;
    private SortedSet<Accession> _xrefs;

    public Sequence() {
        this.init();
    }

    public Sequence(MolecularSequence molecularSequence) {
        String string;
        this.init();
        this.setMolecularSequence(molecularSequence.getMolecularSequenceAsString());
        this.setName(molecularSequence.getIdentifier());
        if (molecularSequence.getType() == MolecularSequence.TYPE.AA) {
            string = "protein";
        } else if (molecularSequence.getType() == MolecularSequence.TYPE.DNA) {
            string = "dna";
        } else if (molecularSequence.getType() == MolecularSequence.TYPE.RNA) {
            string = "rna";
        } else {
            throw new IllegalArgumentException("unknown sequence type " + (Object)((Object)molecularSequence.getType()));
        }
        try {
            this.setType(string);
        }
        catch (PhyloXmlDataFormatException phyloXmlDataFormatException) {
            throw new IllegalArgumentException("don't know how to handle type " + (Object)((Object)molecularSequence.getType()));
        }
    }

    public void addAnnotation(Annotation annotation) {
        this.getAnnotations().add(annotation);
    }

    public void addCrossReference(Accession accession) {
        if (this.getCrossReferences() == null) {
            this.setCrossReferences(new TreeSet<Accession>());
        }
        this.getCrossReferences().add(accession);
    }

    public void addSequenceRelation(SequenceRelation sequenceRelation) {
        this.getSequenceRelations().add(sequenceRelation);
    }

    @Override
    public void addUri(Uri uri) {
        if (this.getUris() == null) {
            this.setUris(new ArrayList<Uri>());
        }
        this.getUris().add(uri);
    }

    @Override
    public StringBuffer asSimpleText() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getAccession() != null) {
            stringBuffer.append("[");
            stringBuffer.append(this.getAccession());
            stringBuffer.append("] ");
        }
        if (!ForesterUtil.isEmpty(this.getName())) {
            stringBuffer.append(this.getName());
            stringBuffer.append(" ");
        }
        if (!ForesterUtil.isEmpty(this.getLocation())) {
            stringBuffer.append(this.getLocation());
        }
        return stringBuffer;
    }

    @Override
    public StringBuffer asText() {
        return this.asSimpleText();
    }

    @Override
    public int compareTo(Sequence sequence) {
        if (!ForesterUtil.isEmpty(this.getName()) && !ForesterUtil.isEmpty(sequence.getName())) {
            return this.getName().compareTo(sequence.getName());
        }
        if (!ForesterUtil.isEmpty(this.getSymbol()) && !ForesterUtil.isEmpty(sequence.getSymbol())) {
            return this.getSymbol().compareTo(sequence.getSymbol());
        }
        if (!ForesterUtil.isEmpty(this.getGeneName()) && !ForesterUtil.isEmpty(sequence.getGeneName())) {
            return this.getGeneName().compareTo(sequence.getGeneName());
        }
        if (this.getAccession() != null && sequence.getAccession() != null && !ForesterUtil.isEmpty(this.getAccession().getValue()) && !ForesterUtil.isEmpty(sequence.getAccession().getValue())) {
            return this.getAccession().getValue().compareTo(sequence.getAccession().getValue());
        }
        if (!ForesterUtil.isEmpty(this.getMolecularSequence()) && !ForesterUtil.isEmpty(sequence.getMolecularSequence())) {
            return this.getMolecularSequence().compareTo(sequence.getMolecularSequence());
        }
        return 0;
    }

    @Override
    public PhylogenyData copy() {
        Sequence sequence = new Sequence();
        sequence.setAnnotations(this.getAnnotations());
        sequence.setName(this.getName());
        sequence.setGeneName(this.getGeneName());
        try {
            sequence.setSymbol(this.getSymbol());
        }
        catch (PhyloXmlDataFormatException phyloXmlDataFormatException) {
            phyloXmlDataFormatException.printStackTrace();
        }
        sequence.setMolecularSequence(this.getMolecularSequence());
        sequence.setMolecularSequenceAligned(this.isMolecularSequenceAligned());
        sequence.setLocation(this.getLocation());
        if (this.getAccession() != null) {
            sequence.setAccession((Accession)this.getAccession().copy());
        } else {
            sequence.setAccession(null);
        }
        try {
            sequence.setType(this.getType());
        }
        catch (PhyloXmlDataFormatException phyloXmlDataFormatException) {
            phyloXmlDataFormatException.printStackTrace();
        }
        if (this.getUris() != null) {
            sequence.setUris(new ArrayList<Uri>());
            for (Uri phylogenyData : this.getUris()) {
                if (phylogenyData == null) continue;
                sequence.getUris().add(phylogenyData);
            }
        }
        if (this.getDomainArchitecture() != null) {
            sequence.setDomainArchitecture((DomainArchitecture)this.getDomainArchitecture().copy());
        } else {
            sequence.setDomainArchitecture(null);
        }
        if (this.getCrossReferences() != null) {
            sequence.setCrossReferences(new TreeSet<Accession>());
            for (Accession accession : this.getCrossReferences()) {
                if (accession == null) continue;
                sequence.getCrossReferences().add(accession);
            }
        }
        return sequence;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to check [" + this.getClass() + "] equality to " + object + " [" + object.getClass() + "]");
        }
        return this.isEqual((Sequence)object);
    }

    public Accession getAccession() {
        return this._accession;
    }

    public Annotation getAnnotation(int n) {
        return (Annotation)this.getAnnotations().toArray()[n];
    }

    public SortedSet<Annotation> getAnnotations() {
        if (this._annotations == null) {
            this._annotations = new TreeSet<Annotation>();
        }
        return this._annotations;
    }

    public SortedSet<Accession> getCrossReferences() {
        return this._xrefs;
    }

    public DomainArchitecture getDomainArchitecture() {
        return this._da;
    }

    public String getGeneName() {
        return this._gene_name;
    }

    public String getLocation() {
        return this._location;
    }

    public String getMolecularSequence() {
        return this._mol_sequence;
    }

    public String getName() {
        return this._name;
    }

    public List<SequenceRelation> getSequenceRelations() {
        if (this._seq_relations == null) {
            this._seq_relations = new ArrayList<SequenceRelation>();
        }
        return this._seq_relations;
    }

    public String getSourceId() {
        return this._source_id;
    }

    public String getSymbol() {
        return this._symbol;
    }

    public String getType() {
        return this._type;
    }

    @Override
    public Uri getUri(int n) {
        return this.getUris().get(n);
    }

    @Override
    public List<Uri> getUris() {
        return this._uris;
    }

    public int hashCode() {
        if (this.getAccession() != null) {
            return this.getAccession().hashCode();
        }
        int n = this.getName().hashCode();
        if (this.getSymbol().length() > 0) {
            n ^= this.getName().hashCode();
        }
        if (this.getGeneName().length() > 0) {
            n ^= this.getGeneName().hashCode();
        }
        if (this.getMolecularSequence().length() > 0) {
            n ^= this.getMolecularSequence().hashCode();
        }
        return n;
    }

    public boolean isHasSequenceRelations() {
        return this._seq_relations != null && this._seq_relations.size() > 0;
    }

    public void init() {
        this.setName("");
        this.setGeneName("");
        this.setMolecularSequence("");
        this.setMolecularSequenceAligned(false);
        this.setLocation("");
        this.setAccession(null);
        try {
            this.setSymbol("");
        }
        catch (PhyloXmlDataFormatException phyloXmlDataFormatException) {
            phyloXmlDataFormatException.printStackTrace();
        }
        try {
            this.setType("");
        }
        catch (PhyloXmlDataFormatException phyloXmlDataFormatException) {
            phyloXmlDataFormatException.printStackTrace();
        }
        this.setDomainArchitecture(null);
        this.setUris(null);
        this.setSequenceRelations(null);
        this.setSourceId(null);
        this.setCrossReferences(null);
        this.setAnnotations(null);
    }

    public boolean isEmpty() {
        return this.getAccession() == null && ForesterUtil.isEmpty(this.getName()) && ForesterUtil.isEmpty(this.getSymbol()) && ForesterUtil.isEmpty(this.getGeneName()) && ForesterUtil.isEmpty(this.getType()) && ForesterUtil.isEmpty(this.getLocation()) && ForesterUtil.isEmpty(this.getSourceId()) && ForesterUtil.isEmpty(this.getMolecularSequence()) && this.getDomainArchitecture() == null && ForesterUtil.isEmpty(this._annotations) && ForesterUtil.isEmpty(this._uris) && ForesterUtil.isEmpty(this._seq_relations) && (this.getCrossReferences() == null || this.getCrossReferences().isEmpty());
    }

    @Override
    public boolean isEqual(PhylogenyData phylogenyData) {
        if (this == phylogenyData) {
            return true;
        }
        Sequence sequence = (Sequence)phylogenyData;
        if (this.getAccession() != null && sequence.getAccession() != null) {
            return this.getAccession().isEqual(sequence.getAccession());
        }
        return sequence.getMolecularSequence().equals(this.getMolecularSequence()) && sequence.getName().equals(this.getName()) && sequence.getSymbol().equals(this.getSymbol()) && sequence.getGeneName().equals(this.getGeneName());
    }

    public boolean isMolecularSequenceAligned() {
        return this._mol_sequence_is_aligned;
    }

    public void setAccession(Accession accession) {
        this._accession = accession;
    }

    public void setDomainArchitecture(DomainArchitecture domainArchitecture) {
        this._da = domainArchitecture;
    }

    public void setGeneName(String string) {
        this._gene_name = string;
    }

    public void setLocation(String string) {
        this._location = string;
    }

    public void setMolecularSequence(String string) {
        this._mol_sequence = string;
    }

    public void setMolecularSequenceAligned(boolean bl) {
        this._mol_sequence_is_aligned = bl;
    }

    public void setName(String string) {
        this._name = string;
    }

    public void setSourceId(String string) {
        this._source_id = string;
    }

    public void setSymbol(String string) throws PhyloXmlDataFormatException {
        if (!ForesterUtil.isEmpty(string) && !PhyloXmlUtil.SEQUENCE_SYMBOL_PATTERN.matcher(string).matches()) {
            throw new PhyloXmlDataFormatException("illegal sequence symbol: [" + string + "]");
        }
        this._symbol = string;
    }

    public void setType(String string) throws PhyloXmlDataFormatException {
        if (!ForesterUtil.isEmpty(string) && !PhyloXmlUtil.SEQUENCE_TYPES.contains(string)) {
            throw new PhyloXmlDataFormatException("illegal sequence type: [" + string + "]");
        }
        this._type = string;
    }

    @Override
    public void setUris(List<Uri> list) {
        this._uris = list;
    }

    @Override
    public StringBuffer toNHX() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getName().length() > 0) {
            stringBuffer.append(":");
            stringBuffer.append("GN=");
            stringBuffer.append(ForesterUtil.replaceIllegalNhxCharacters(this.getName()));
        }
        if (this.getAccession() != null) {
            this.getAccession().toNHX();
        }
        return stringBuffer;
    }

    @Override
    public void toPhyloXML(Writer writer, int n, String string) throws IOException {
        if (this.isEmpty()) {
            return;
        }
        String string2 = string + "  ";
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(string);
        PhylogenyDataUtil.appendOpen(writer, "sequence", "type", this.getType());
        if (!ForesterUtil.isEmpty(this.getSymbol())) {
            PhylogenyDataUtil.appendElement(writer, "symbol", this.getSymbol(), string);
        }
        if (this.getAccession() != null && !ForesterUtil.isEmpty(this.getAccession().getValue())) {
            this.getAccession().toPhyloXML(writer, n, string);
        }
        if (!ForesterUtil.isEmpty(this.getName())) {
            PhylogenyDataUtil.appendElement(writer, "name", this.getName(), string);
        }
        if (!ForesterUtil.isEmpty(this.getGeneName())) {
            PhylogenyDataUtil.appendElement(writer, "gene_name", this.getGeneName(), string);
        }
        if (!ForesterUtil.isEmpty(this.getLocation())) {
            PhylogenyDataUtil.appendElement(writer, "location", this.getLocation(), string);
        }
        if (!ForesterUtil.isEmpty(this.getMolecularSequence())) {
            PhylogenyDataUtil.appendElement(writer, "mol_seq", this.getMolecularSequence(), "is_aligned", String.valueOf(this.isMolecularSequenceAligned()), string);
        }
        if (this.getUris() != null && !this.getUris().isEmpty()) {
            for (Uri phylogenyData : this.getUris()) {
                if (phylogenyData == null) continue;
                phylogenyData.toPhyloXML(writer, n, string);
            }
        }
        if (this.getAnnotations() != null && !this.getAnnotations().isEmpty()) {
            for (PhylogenyData phylogenyData : this.getAnnotations()) {
                phylogenyData.toPhyloXML(writer, n, string2);
            }
        }
        if (this.getCrossReferences() != null && !this.getCrossReferences().isEmpty()) {
            writer.write(ForesterUtil.LINE_SEPARATOR);
            writer.write(string2);
            PhylogenyDataUtil.appendOpen(writer, "cross_references");
            for (PhylogenyData phylogenyData : this.getCrossReferences()) {
                phylogenyData.toPhyloXML(writer, n, string2);
            }
            writer.write(ForesterUtil.LINE_SEPARATOR);
            writer.write(string2);
            PhylogenyDataUtil.appendClose(writer, "cross_references");
        }
        if (this.getDomainArchitecture() != null) {
            this.getDomainArchitecture().toPhyloXML(writer, n, string2);
        }
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(string);
        PhylogenyDataUtil.appendClose(writer, "sequence");
    }

    public String toString() {
        return this.asText().toString();
    }

    private void setAnnotations(SortedSet<Annotation> sortedSet) {
        this._annotations = sortedSet;
    }

    private void setCrossReferences(TreeSet<Accession> treeSet) {
        this._xrefs = treeSet;
    }

    private void setSequenceRelations(List<SequenceRelation> list) {
        this._seq_relations = list;
    }
}

