/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.Property;
import org.forester.util.ForesterUtil;

public final class NodeVisualData
implements PhylogenyData {
    public static final String APTX_VISUALIZATION_REF = "style:";
    public static final int DEFAULT_SIZE = -1;
    public static final String FONT_COLOR_REF = "style:font_color";
    public static final String FONT_COLOR_TYPE = "xsd:token";
    public static final String FONT_REF = "style:font";
    public static final String FONT_SIZE_REF = "style:font_size";
    public static final String FONT_SIZE_TYPE = "xsd:unsignedByte";
    public static final String FONT_STYLE_BOLD = "bold";
    public static final String FONT_STYLE_BOLD_ITALIC = "bold_italic";
    public static final String FONT_STYLE_ITALIC = "italic";
    public static final String FONT_STYLE_PLAIN = "plain";
    public static final String FONT_STYLE_REF = "style:font_style";
    public static final String FONT_STYLE_TYPE = "xsd:token";
    public static final String FONT_TYPE = "xsd:token";
    public static final String NODE_COLOR_REF = "style:node_color";
    public static final String NODE_COLOR_TYPE = "xsd:token";
    public static final String NODE_FILL_GRADIENT = "gradient";
    public static final String NODE_FILL_NONE = "none";
    public static final String NODE_FILL_SOLID = "solid";
    public static final String NODE_FILL_TYPE_REF = "style:node_fill_type";
    public static final String NODE_FILL_TYPE_TYPE = "xsd:token";
    public static final String NODE_SHAPE_CIRCLE = "circle";
    public static final String NODE_SHAPE_RECTANGLE = "rectangle";
    public static final String NODE_SHAPE_REF = "style:node_shape";
    public static final String NODE_SHAPE_TYPE = "xsd:token";
    public static final String NODE_SIZE_REF = "style:node_size";
    public static final String NODE_SIZE_TYPE = "xsd:float";
    public static final String NODE_TRANSPARENCY_REF = "style:node_transparency";
    public static final String NODE_TRANSPARENCY_TYPE = "xsd:float";
    private static final byte DEFAULT_FONT_SIZE = -1;
    private static final int DEFAULT_TRANSPARENCY = -1;
    private NodeFill _fill_type;
    private Font _font;
    private Color _font_color;
    private String _font_name;
    private byte _font_size;
    private FontType _font_style;
    private Color _node_color;
    private NodeShape _shape;
    private float _size;
    private float _transparency;

    public NodeVisualData() {
        this.init();
    }

    public NodeVisualData(String string, FontType fontType, byte by, Color color, NodeShape nodeShape, NodeFill nodeFill, Color color2, float f, float f2) {
        this.setFontName(string);
        this.setFontStyle(fontType);
        this.setFontSize(by);
        this.setFontColor(color);
        this.setShape(nodeShape);
        this.setFillType(nodeFill);
        this.setNodeColor(color2);
        this.setSize(f);
        this.setTransparency(f2);
    }

    @Override
    public final StringBuffer asSimpleText() {
        return this.asText();
    }

    @Override
    public final StringBuffer asText() {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer;
    }

    @Override
    public final PhylogenyData copy() {
        return new NodeVisualData(!ForesterUtil.isEmpty(this.getFontName()) ? new String(this.getFontName()) : null, this.getFontStyle(), this.getFontSize(), this.getFontColor() != null ? new Color(this.getFontColor().getRed(), this.getFontColor().getGreen(), this.getFontColor().getBlue()) : null, this.getShape(), this.getFillType(), this.getNodeColor() != null ? new Color(this.getNodeColor().getRed(), this.getNodeColor().getGreen(), this.getNodeColor().getBlue()) : null, this.getSize(), this.getTransparency());
    }

    public final NodeFill getFillType() {
        return this._fill_type;
    }

    public final Font getFont() {
        if (this._font != null) {
            return this._font;
        }
        if (!ForesterUtil.isEmpty(this.getFontName())) {
            this._font = new Font(this.getFontName(), this.getFontStyleInt(), this.getFontSize());
            return this._font;
        }
        return null;
    }

    public final Color getFontColor() {
        return this._font_color;
    }

    public final String getFontName() {
        return this._font_name;
    }

    public final byte getFontSize() {
        return this._font_size;
    }

    public final FontType getFontStyle() {
        return this._font_style;
    }

    public final int getFontStyleInt() {
        if (this.getFontStyle() == FontType.BOLD) {
            return 1;
        }
        if (this.getFontStyle() == FontType.ITALIC) {
            return 2;
        }
        if (this.getFontStyle() == FontType.BOLD_ITALIC) {
            return 3;
        }
        return 0;
    }

    public final Color getNodeColor() {
        return this._node_color;
    }

    public final NodeShape getShape() {
        return this._shape;
    }

    public final float getSize() {
        return this._size;
    }

    public final float getTransparency() {
        return this._transparency;
    }

    public final boolean isEmpty() {
        return ForesterUtil.isEmpty(this.getFontName()) && this.getFontStyle() == FontType.PLAIN && this.getFontSize() == -1 && this.getFontColor() == null && this.getShape() == NodeShape.DEFAULT && this.getFillType() == NodeFill.DEFAULT && this.getNodeColor() == null && this.getSize() == -1.0f && this.getTransparency() == -1.0f;
    }

    @Override
    public final boolean isEqual(PhylogenyData phylogenyData) {
        throw new UnsupportedOperationException();
    }

    public void parseProperty(Property property) {
        if (property.getRef().equals(FONT_REF)) {
            this.setFontName(property.getValue().trim());
        } else if (property.getRef().equals(FONT_SIZE_REF)) {
            int n = -1;
            try {
                n = Integer.parseInt(property.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            if (n >= 0 && n < 127) {
                this.setFontSize(n);
            }
        } else if (property.getRef().equals(FONT_STYLE_REF)) {
            this.setFontStyle(property.getValue());
        } else {
            if (property.getRef().equals(FONT_COLOR_REF)) {
                try {
                    this.setFontColor(Color.decode(property.getValue()));
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
            }
            if (property.getRef().equals(NODE_SIZE_REF)) {
                float f = -1.0f;
                try {
                    f = Float.parseFloat(property.getValue());
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
                if (f >= 0.0f) {
                    this.setSize(f);
                }
            } else if (property.getRef().equals(NODE_COLOR_REF)) {
                try {
                    this.setNodeColor(Color.decode(property.getValue()));
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
            } else if (property.getRef().equals(NODE_SHAPE_REF)) {
                this.setShape(property.getValue());
            } else if (property.getRef().equals(NODE_FILL_TYPE_REF)) {
                this.setFillType(property.getValue());
            }
        }
    }

    public final void setFillType(NodeFill nodeFill) {
        this._fill_type = nodeFill;
    }

    public final void setFillType(String string) {
        if (string.equalsIgnoreCase(NODE_FILL_NONE)) {
            this.setFillType(NodeFill.NONE);
        } else if (string.equalsIgnoreCase(NODE_FILL_SOLID)) {
            this.setFillType(NodeFill.SOLID);
        } else if (string.equalsIgnoreCase(NODE_FILL_GRADIENT)) {
            this.setFillType(NodeFill.GRADIENT);
        } else {
            this.setFillType(NodeFill.DEFAULT);
        }
    }

    public final void setFontColor(Color color) {
        this._font_color = color;
    }

    public final void setFontName(String string) {
        this._font_name = !ForesterUtil.isEmpty(string) ? string : null;
        this._font = null;
    }

    public final void setFontSize(int n) {
        if (n != -1 && n < 0) {
            throw new IllegalArgumentException("negative font size: " + n);
        }
        if (n > 127) {
            throw new IllegalArgumentException("font size is too large: " + n);
        }
        this._font_size = (byte)n;
        this._font = null;
    }

    public final void setFontStyle(FontType fontType) {
        this._font_style = fontType;
        this._font = null;
    }

    public final void setFontStyle(int n) {
        if (n == 3) {
            this.setFontStyle(FontType.BOLD_ITALIC);
        } else if (n == 2) {
            this.setFontStyle(FontType.ITALIC);
        } else if (n == 1) {
            this.setFontStyle(FontType.BOLD);
        } else {
            this.setFontStyle(FontType.PLAIN);
        }
    }

    public final void setFontStyle(String string) {
        if (string.equalsIgnoreCase(FONT_STYLE_BOLD)) {
            this.setFontStyle(FontType.BOLD);
        } else if (string.equalsIgnoreCase(FONT_STYLE_ITALIC)) {
            this.setFontStyle(FontType.ITALIC);
        } else if (string.equalsIgnoreCase(FONT_STYLE_BOLD_ITALIC)) {
            this.setFontStyle(FontType.BOLD_ITALIC);
        } else {
            this.setFontStyle(FontType.PLAIN);
        }
    }

    public final void setNodeColor(Color color) {
        this._node_color = color;
    }

    public final void setShape(NodeShape nodeShape) {
        this._shape = nodeShape;
    }

    public final void setShape(String string) {
        if (string.equalsIgnoreCase(NODE_SHAPE_CIRCLE)) {
            this.setShape(NodeShape.CIRCLE);
        } else if (string.equalsIgnoreCase(NODE_SHAPE_RECTANGLE)) {
            this.setShape(NodeShape.RECTANGLE);
        } else {
            this.setShape(NodeShape.DEFAULT);
        }
    }

    public final void setSize(float f) {
        if (f != -1.0f && f < 0.0f) {
            throw new IllegalArgumentException("negative size: " + f);
        }
        this._size = f;
    }

    public final void setTransparency(float f) {
        this._transparency = f;
    }

    @Override
    public final StringBuffer toNHX() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void toPhyloXML(Writer writer, int n, String string) throws IOException {
        for (Property property : this.toProperties()) {
            property.toPhyloXML(writer, n, string);
        }
    }

    public final String toString() {
        return this.asText().toString();
    }

    private String colorToHex(Color color) {
        return String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
    }

    private final void init() {
        this.setFontName(null);
        this.setFontStyle(FontType.PLAIN);
        this.setFontSize(-1);
        this.setFontColor(null);
        this.setShape(NodeShape.DEFAULT);
        this.setFillType(NodeFill.DEFAULT);
        this.setNodeColor(null);
        this.setSize(-1.0f);
        this.setTransparency(-1.0f);
        this._font = null;
    }

    private final List<Property> toProperties() {
        String string;
        ArrayList<Property> arrayList = new ArrayList<Property>();
        if (!ForesterUtil.isEmpty(this.getFontName())) {
            arrayList.add(new Property(FONT_REF, this.getFontName(), "", "xsd:token", Property.AppliesTo.NODE));
        }
        if (this.getFontSize() != -1) {
            arrayList.add(new Property(FONT_SIZE_REF, String.valueOf(this.getFontSize()), "", FONT_SIZE_TYPE, Property.AppliesTo.NODE));
        }
        if (this.getFontStyle() != FontType.PLAIN) {
            string = "";
            if (this.getFontStyle() == FontType.ITALIC) {
                string = FONT_STYLE_ITALIC;
            } else if (this.getFontStyle() == FontType.BOLD) {
                string = FONT_STYLE_BOLD;
            } else if (this.getFontStyle() == FontType.BOLD_ITALIC) {
                string = FONT_STYLE_BOLD_ITALIC;
            } else {
                throw new RuntimeException("unknown font style" + (Object)((Object)this.getShape()));
            }
            arrayList.add(new Property(FONT_STYLE_REF, string, "", "xsd:token", Property.AppliesTo.NODE));
        }
        if (this.getFontColor() != null) {
            arrayList.add(new Property(FONT_COLOR_REF, this.colorToHex(this.getFontColor()), "", "xsd:token", Property.AppliesTo.NODE));
        }
        if (this.getShape() != NodeShape.DEFAULT) {
            string = null;
            if (this.getShape() == NodeShape.RECTANGLE) {
                string = NODE_SHAPE_RECTANGLE;
            } else if (this.getShape() == NodeShape.CIRCLE) {
                string = NODE_SHAPE_CIRCLE;
            } else {
                throw new RuntimeException("unknown node shape" + (Object)((Object)this.getShape()));
            }
            arrayList.add(new Property(NODE_SHAPE_REF, string, "", "xsd:token", Property.AppliesTo.NODE));
        }
        if (this.getSize() != -1.0f) {
            arrayList.add(new Property(NODE_SIZE_REF, String.valueOf(this.getSize()), "", "xsd:float", Property.AppliesTo.NODE));
        }
        if (this.getNodeColor() != null) {
            arrayList.add(new Property(NODE_COLOR_REF, this.colorToHex(this.getNodeColor()), "", "xsd:token", Property.AppliesTo.NODE));
        }
        if (this.getFillType() != NodeFill.DEFAULT) {
            string = null;
            if (this.getFillType() == NodeFill.GRADIENT) {
                string = NODE_FILL_GRADIENT;
            } else if (this.getFillType() == NodeFill.NONE) {
                string = NODE_FILL_NONE;
            } else if (this.getFillType() == NodeFill.SOLID) {
                string = NODE_FILL_SOLID;
            } else {
                throw new RuntimeException("unknown fill type " + (Object)((Object)this.getFillType()));
            }
            arrayList.add(new Property(NODE_FILL_TYPE_REF, string, "", "xsd:token", Property.AppliesTo.NODE));
        }
        if (this.getTransparency() != -1.0f) {
            arrayList.add(new Property(NODE_TRANSPARENCY_REF, String.valueOf(this.getTransparency()), "", "xsd:float", Property.AppliesTo.NODE));
        }
        return arrayList;
    }

    public static enum NodeShape {
        CIRCLE,
        DEFAULT,
        RECTANGLE;

    }

    public static enum NodeFill {
        DEFAULT,
        GRADIENT,
        NONE,
        SOLID;

    }

    public static enum FontType {
        BOLD,
        BOLD_ITALIC,
        ITALIC,
        PLAIN;

    }
}

