/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import java.util.StringTokenizer;
import org.forester.io.parsers.nhx.NHXFormatException;
import org.forester.phylogeny.data.Confidence;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PhylogenyDataUtil;
import org.forester.util.ForesterUtil;

public class Event
implements PhylogenyData {
    public static final int DEFAULT_VALUE = -1;
    private static final String NHX_SEPARATOR = ">";
    private int _duplications;
    private int _speciations;
    private int _gene_losses;
    private EventType _event_type;
    private Confidence _confidence;

    public Event() {
        this._duplications = -1;
        this._speciations = -1;
        this._gene_losses = -1;
        this._event_type = EventType.unassigned;
    }

    public Event(EventType eventType) {
        this._duplications = -1;
        this._speciations = -1;
        this._gene_losses = -1;
        this._event_type = eventType;
    }

    public Event(int n, int n2, int n3) {
        this._duplications = n;
        this._speciations = n2;
        this._gene_losses = n3;
        this._event_type = EventType.mixed;
    }

    public Event(int n, int n2, int n3, String string) {
        this._duplications = n;
        this._speciations = n2;
        this._gene_losses = n3;
        this._event_type = EventType.valueOf(string);
    }

    public Event(String string) throws NHXFormatException {
        if (ForesterUtil.isEmpty(string)) {
            this._duplications = -1;
            this._speciations = -1;
            this._gene_losses = -1;
            this._event_type = EventType.unassigned;
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, NHX_SEPARATOR);
            if (stringTokenizer.countTokens() != 4) {
                throw new NHXFormatException("malformed NHX format for event [" + string + "]");
            }
            String string2 = (String)stringTokenizer.nextElement();
            String string3 = (String)stringTokenizer.nextElement();
            String string4 = (String)stringTokenizer.nextElement();
            String string5 = (String)stringTokenizer.nextElement();
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            try {
                n = Integer.parseInt(string2);
                n2 = Integer.parseInt(string3);
                n3 = Integer.parseInt(string4);
                this._duplications = n;
                this._speciations = n2;
                this._gene_losses = n3;
                this._event_type = EventType.valueOf(string5);
            }
            catch (Exception exception) {
                throw new NHXFormatException("malformed NHX format for event [" + string + "]:" + exception.getMessage());
            }
        }
    }

    @Override
    public StringBuffer asSimpleText() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.isUnassigned()) {
            if (this.isSpeciationOrDuplication()) {
                stringBuffer.append("?");
            } else if (this.isOther() || this.isRoot() || this.isTransfer() || this.isFusion()) {
                stringBuffer.append(this.getEventType().toString());
            } else {
                if (this.getNumberOfDuplications() > 0) {
                    if (this.getNumberOfDuplications() > 1) {
                        stringBuffer.append(this.getNumberOfDuplications());
                    }
                    stringBuffer.append("D");
                }
                if (this.getNumberOfSpeciations() > 0) {
                    if (this.getNumberOfSpeciations() > 1) {
                        stringBuffer.append(this.getNumberOfSpeciations());
                    }
                    stringBuffer.append("S");
                }
                if (this.getNumberOfGeneLosses() > 0) {
                    if (this.getNumberOfGeneLosses() > 1) {
                        stringBuffer.append(this.getNumberOfGeneLosses());
                    }
                    stringBuffer.append("L");
                }
            }
        }
        return stringBuffer;
    }

    @Override
    public StringBuffer asText() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isUnassigned() || this.isSpeciationOrDuplication() || this.isOther() || this.isRoot() || this.isTransfer() || this.isFusion()) {
            stringBuffer.append(this.getEventType().toString());
        } else if (this.isDuplication()) {
            if (this.getNumberOfDuplications() == 1) {
                stringBuffer.append("duplication");
            } else {
                stringBuffer.append("duplications [" + this.getNumberOfDuplications() + "]");
            }
        } else if (this.isSpeciation()) {
            if (this.getNumberOfSpeciations() == 1) {
                stringBuffer.append("speciation");
            } else {
                stringBuffer.append("speciations [" + this.getNumberOfSpeciations() + "]");
            }
        } else if (this.isGeneLoss()) {
            if (this.getNumberOfGeneLosses() == 1) {
                stringBuffer.append("gene-loss");
            } else {
                stringBuffer.append("gene-losses [" + this.getNumberOfGeneLosses() + "]");
            }
        } else {
            stringBuffer.append("duplications [" + this.getNumberOfDuplications() + "] ");
            stringBuffer.append("speciations [" + this.getNumberOfSpeciations() + "] ");
            stringBuffer.append("gene-losses [" + this.getNumberOfGeneLosses() + "]");
        }
        return stringBuffer;
    }

    @Override
    public PhylogenyData copy() {
        if (this.isUnassigned()) {
            return new Event();
        }
        if (this._event_type != EventType.mixed) {
            return new Event(this._event_type);
        }
        return new Event(this._duplications, this._speciations, this._gene_losses);
    }

    public Confidence getConfidence() {
        return this._confidence;
    }

    public EventType getEventType() {
        return this._event_type;
    }

    public int getNumberOfDuplications() {
        return this._duplications;
    }

    public int getNumberOfGeneLosses() {
        return this._gene_losses;
    }

    public int getNumberOfSpeciations() {
        return this._speciations;
    }

    public boolean isDuplication() {
        return this._duplications > 0 && this._gene_losses < 1 && this._speciations < 1;
    }

    @Override
    public boolean isEqual(PhylogenyData phylogenyData) {
        if (phylogenyData == null || !(phylogenyData instanceof Event)) {
            return false;
        }
        Event event = (Event)phylogenyData;
        if (this.getEventType().compareTo(event.getEventType()) != 0) {
            return false;
        }
        if (this.getNumberOfDuplications() != event.getNumberOfDuplications()) {
            return false;
        }
        if (this.getNumberOfSpeciations() != event.getNumberOfSpeciations()) {
            return false;
        }
        return this.getNumberOfGeneLosses() == event.getNumberOfGeneLosses();
    }

    public boolean isFusion() {
        return this._event_type == EventType.fusion;
    }

    public boolean isGeneLoss() {
        return this._duplications < 1 && this._gene_losses > 0 && this._speciations < 1;
    }

    public boolean isOther() {
        return this._event_type == EventType.other;
    }

    public boolean isRoot() {
        return this._event_type == EventType.root;
    }

    public boolean isSpeciation() {
        return this._duplications < 1 && this._gene_losses < 1 && this._speciations > 0;
    }

    public boolean isSpeciationOrDuplication() {
        return this._event_type == EventType.speciation_or_duplication;
    }

    public boolean isTransfer() {
        return this._event_type == EventType.transfer;
    }

    public boolean isUnassigned() {
        return this._duplications == -1 && this._event_type == EventType.unassigned;
    }

    public void setConfidence(Confidence confidence) {
        this._confidence = confidence;
    }

    public void setDuplications(int n) {
        this._duplications = n;
        this._event_type = EventType.mixed;
    }

    public void setGeneLosses(int n) {
        this._gene_losses = n;
        this._event_type = EventType.mixed;
    }

    public void setSpeciations(int n) {
        this._speciations = n;
        this._event_type = EventType.mixed;
    }

    @Override
    public StringBuffer toNHX() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.isUnassigned() && (this.isSpeciationOrDuplication() || this.isDuplication() || this.isSpeciation())) {
            stringBuffer.append(":");
            stringBuffer.append("D=");
            if (this.isSpeciationOrDuplication()) {
                stringBuffer.append("?");
            } else if (this.isDuplication()) {
                stringBuffer.append("Y");
            } else if (this.isSpeciation()) {
                stringBuffer.append("N");
            }
        }
        return stringBuffer;
    }

    @Override
    public void toPhyloXML(Writer writer, int n, String string) throws IOException {
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(string);
        PhylogenyDataUtil.appendOpen(writer, "events");
        if (this.getEventType() != EventType.unassigned && this.getEventType() != EventType.mixed) {
            PhylogenyDataUtil.appendElement(writer, "type", this.getEventType().toString(), string);
        }
        if (this.getNumberOfDuplications() > 0) {
            PhylogenyDataUtil.appendElement(writer, "duplications", this.getNumberOfDuplications() + "", string);
        }
        if (this.getNumberOfSpeciations() > 0) {
            PhylogenyDataUtil.appendElement(writer, "speciations", this.getNumberOfSpeciations() + "", string);
        }
        if (this.getNumberOfGeneLosses() > 0) {
            PhylogenyDataUtil.appendElement(writer, "losses", this.getNumberOfGeneLosses() + "", string);
        }
        if (this.getConfidence() != null) {
            this.getConfidence().toPhyloXML(writer, n, string + "  ");
        }
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(string);
        PhylogenyDataUtil.appendClose(writer, "events");
    }

    public String toString() {
        return this.asText().toString();
    }

    public static Event createSingleDuplicationEvent() {
        return new Event(1, 0, 0);
    }

    public static Event createSingleSpeciationEvent() {
        return new Event(0, 1, 0);
    }

    public static Event createSingleSpeciationOrDuplicationEvent() {
        return new Event(EventType.speciation_or_duplication);
    }

    public static enum EventType {
        transfer,
        fusion,
        root,
        speciation_or_duplication,
        other,
        mixed,
        unassigned;

    }
}

