/*
 * Decompiled with CFR 0.152.
 */
package org.forester.pccx;

import org.forester.pccx.BranchCountingBasedScoringMethod;
import org.forester.pccx.ModelingUtils;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;

public class LogBranchLengthBasedScoringMethod
extends BranchCountingBasedScoringMethod {
    public static final double MIN_ALLOWED_BL_VALUE = 1.0E-4;
    public static final double MAX_ALLOWED_BL_VALUE = 1.0;

    @Override
    double calculateScoreContributionPerExternalNode(PhylogenyNode phylogenyNode, PhylogenyNode phylogenyNode2) {
        double d = 0.0;
        d = phylogenyNode2 == phylogenyNode ? phylogenyNode.getDistanceToParent() : ModelingUtils.calculateBranchLengthSum(phylogenyNode, phylogenyNode2);
        if (d > 1.0) {
            d = 1.0;
        } else if (d < 1.0E-4) {
            d = 1.0E-4;
        }
        return -Math.log(d);
    }

    @Override
    public String getDesciption() {
        return "sum of -ln(branch-length-sum) [for self: -ln(branch-length)] [min branch length: 1.0E-4, max branch length: 1.0]";
    }

    @Override
    public double getNormalizationFactor(Phylogeny phylogeny) {
        double d = 0.0;
        double d2 = 0.0;
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorExternalForward();
        while (phylogenyNodeIterator.hasNext()) {
            d2 = phylogenyNodeIterator.next().getDistanceToParent();
            if (d2 > 1.0) {
                d2 = 1.0;
            } else if (d2 < 1.0E-4) {
                d2 = 1.0E-4;
            }
            d += -Math.log(d2);
        }
        return 1.0 / d;
    }
}

