/*
 * Decompiled with CFR 0.152.
 */
package org.forester.msa_compactor;

import com.approximatrix.charting.coordsystem.BoxCoordSystem;
import com.approximatrix.charting.coordsystem.CoordSystem;
import com.approximatrix.charting.model.MultiScatterDataModel;
import com.approximatrix.charting.render.AbstractChartRenderer;
import com.approximatrix.charting.render.MultiScatterChartRenderer;
import com.approximatrix.charting.swing.ChartPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.forester.msa_compactor.MsaProperties;
import org.forester.util.ForesterUtil;

public final class Chart
extends JDialog
implements ActionListener {
    private static final NumberFormat NF_1 = new DecimalFormat("0.##");
    private static final long serialVersionUID = -5292420246132943515L;
    private ChartPanel _chart_panel = null;
    private final int _initial_number_of_seqs;
    private final JMenuItem _m_exit = new JMenuItem();
    private final List<MsaProperties> _msa_props;
    private final boolean _show_msa_qual;
    private final String _title;

    private Chart(List<MsaProperties> list, int n, boolean bl, String string) {
        this._msa_props = list;
        this._title = string;
        this._initial_number_of_seqs = n;
        this._show_msa_qual = bl;
        this.setTitle("msa compactor");
        this.setSize(600, 500);
        this.setResizable(true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.setContentPane(jPanel);
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu();
        jMenu.setText("File");
        this._m_exit.setText("Exit");
        jMenu.add(this._m_exit);
        jMenuBar.add(jMenu);
        this.setJMenuBar(jMenuBar);
        this.setDefaultCloseOperation(2);
        this._m_exit.addActionListener(this);
        jPanel.add((Component)this.obtainChartPanel(), "Center");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._m_exit) {
            this.dispose();
        }
    }

    private ChartPanel obtainChartPanel() {
        if (this._chart_panel == null) {
            Object object;
            MultiScatterDataModel multiScatterDataModel = new MultiScatterDataModel();
            double[][] dArray = new double[this._msa_props.size()][2];
            int n = -1;
            int n2 = Integer.MAX_VALUE;
            double d = -1.0;
            double d2 = Double.MAX_VALUE;
            double d3 = -1.0;
            double d4 = Double.MAX_VALUE;
            for (int i = 0; i < this._msa_props.size(); ++i) {
                double d5;
                double d6;
                dArray[i][0] = this._initial_number_of_seqs - this._msa_props.get(i).getNumberOfSequences();
                int n3 = this._msa_props.get(i).getLength();
                dArray[i][1] = n3;
                if (n3 > n) {
                    n = n3;
                }
                if (n3 < n2) {
                    n2 = n3;
                }
                if ((d6 = this._msa_props.get(i).getGapRatio()) > d) {
                    d = d6;
                }
                if (d6 < d2) {
                    d2 = d6;
                }
                if ((d5 = this._msa_props.get(i).getAvgNumberOfGaps()) > d3) {
                    d3 = d5;
                }
                if (!(d5 < d4)) continue;
                d4 = d5;
            }
            multiScatterDataModel.addData(dArray, "Length (" + Chart.minMaxToString(n2, n) + ")");
            multiScatterDataModel.setSeriesLine("Series Length", true);
            multiScatterDataModel.setSeriesMarker("Series Length", false);
            double[][] dArray2 = new double[this._msa_props.size()][2];
            double d7 = -1.0;
            double d8 = -1.0;
            double d9 = Double.MAX_VALUE;
            double d10 = Double.MAX_VALUE;
            if (this._show_msa_qual) {
                for (int i = 0; i < this._msa_props.size(); ++i) {
                    double d11;
                    double d12 = this._msa_props.get(i).getEntropy7();
                    if (d12 > d7) {
                        d7 = d12;
                    }
                    if (d12 < d7) {
                        d9 = d12;
                    }
                    if ((d11 = this._msa_props.get(i).getEntropy21()) > d10) {
                        d8 = d11;
                    }
                    if (!(d11 < d10)) continue;
                    d10 = d11;
                }
            }
            double d13 = (double)n / 2.0 / d;
            double d14 = (double)n / 2.0 / d3;
            double d15 = (double)n / 2.0 / d7;
            double d16 = (double)n / 2.0 / d8;
            for (int i = 0; i < this._msa_props.size(); ++i) {
                dArray2[i][0] = this._initial_number_of_seqs - this._msa_props.get(i).getNumberOfSequences();
                dArray2[i][1] = ForesterUtil.roundToInt(this._msa_props.get(i).getGapRatio() * d13);
            }
            multiScatterDataModel.addData(dArray2, "Gap Ratio (" + Chart.minMaxToString(d2, d) + ")");
            multiScatterDataModel.setSeriesLine("Series Gap Ratio", true);
            multiScatterDataModel.setSeriesMarker("Series Gap Ratio", false);
            double[][] dArray3 = new double[this._msa_props.size()][2];
            for (int i = 0; i < this._msa_props.size(); ++i) {
                dArray3[i][0] = this._initial_number_of_seqs - this._msa_props.get(i).getNumberOfSequences();
                dArray3[i][1] = ForesterUtil.roundToInt(this._msa_props.get(i).getAvgNumberOfGaps() * d14);
            }
            multiScatterDataModel.addData(dArray3, "Mean Gap Count (" + Chart.minMaxToString(d4, d3) + ")");
            multiScatterDataModel.setSeriesLine("Series Mean Gap Count", true);
            multiScatterDataModel.setSeriesMarker("Series Mean Gap Count", false);
            if (this._show_msa_qual) {
                double[][] dArray4 = new double[this._msa_props.size()][2];
                for (int i = 0; i < this._msa_props.size(); ++i) {
                    dArray4[i][0] = this._initial_number_of_seqs - this._msa_props.get(i).getNumberOfSequences();
                    dArray4[i][1] = ForesterUtil.roundToInt(this._msa_props.get(i).getEntropy7() * d15);
                }
                multiScatterDataModel.addData(dArray4, "Entropy norm 7 (" + Chart.minMaxToString(d9, d7) + ")");
                multiScatterDataModel.setSeriesLine("Series Entropy norm 7", true);
                multiScatterDataModel.setSeriesMarker("Series Entropy norm 7", false);
                object = new double[this._msa_props.size()][2];
                for (int i = 0; i < this._msa_props.size(); ++i) {
                    object[i][0] = (double)(this._initial_number_of_seqs - this._msa_props.get(i).getNumberOfSequences());
                    object[i][1] = (double)ForesterUtil.roundToInt(this._msa_props.get(i).getEntropy21() * d16);
                }
                multiScatterDataModel.addData((double[][])object, "Entropy norm 21 (" + Chart.minMaxToString(d10, d8) + ")");
                multiScatterDataModel.setSeriesLine("Series Entropy norm 21", true);
                multiScatterDataModel.setSeriesMarker("Series Entropy norm 21", false);
            }
            BoxCoordSystem boxCoordSystem = new BoxCoordSystem(multiScatterDataModel);
            boxCoordSystem.setUnitFont(boxCoordSystem.getUnitFont().deriveFont(16.0f));
            boxCoordSystem.setXAxisUnit("Number of Removed Sequences");
            boxCoordSystem.setPaintGrid(true);
            boxCoordSystem.setYAxisUnit("MSA Length");
            this._chart_panel = new ChartPanel(multiScatterDataModel, this._title);
            this._chart_panel.setCoordSystem(boxCoordSystem);
            object = new MultiScatterChartRenderer((CoordSystem)boxCoordSystem, multiScatterDataModel);
            ((MultiScatterChartRenderer)object).setAllowBuffer(false);
            this._chart_panel.addChartRenderer((AbstractChartRenderer)object, 0);
        }
        return this._chart_panel;
    }

    private static final String minMaxToString(double d, double d2) {
        return NF_1.format(d) + "-" + NF_1.format(d2);
    }

    public static void display(List<MsaProperties> list, int n, boolean bl, String string) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Chart chart = new Chart(list, n, bl, string);
        chart.setVisible(true);
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Chart chart = new Chart(null, 0, true, "title");
        chart.setVisible(true);
    }
}

