/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.tol;

import java.util.ArrayList;
import java.util.List;
import org.forester.io.parsers.phyloxml.XmlElement;
import org.forester.io.parsers.util.PhylogenyParserException;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Identifier;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.util.FailedConditionCheckException;
import org.forester.util.ForesterUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class TolXmlHandler
extends DefaultHandler {
    private String _current_element_name;
    private Phylogeny _current_phylogeny;
    private List<Phylogeny> _phylogenies;
    private XmlElement _current_xml_element;
    private PhylogenyNode _current_node;
    private static final StringBuffer _buffer = new StringBuffer();

    TolXmlHandler() {
    }

    private void addNode() {
        PhylogenyNode phylogenyNode = new PhylogenyNode();
        this.getCurrentNode().addAsChild(phylogenyNode);
        this.setCurrentNode(phylogenyNode);
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        if (this.getCurrentXmlElement() != null && this.getCurrentElementName() != null && !this.getCurrentElementName().equals("NODE") && !this.getCurrentElementName().equals("TREE")) {
            this.getCurrentXmlElement().setValue(new String(cArray, n, n2).trim());
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (ForesterUtil.isEmpty(string) || string.startsWith("http://www.phyloxml.org")) {
            if (string2.equals("NODE")) {
                try {
                    TolXmlHandler.mapElementToPhylogenyNode(this.getCurrentXmlElement(), this.getCurrentNode());
                    if (!this.getCurrentNode().isRoot()) {
                        this.setCurrentNode(this.getCurrentNode().getParent());
                    }
                    this.setCurrentXmlElement(this.getCurrentXmlElement().getParent());
                }
                catch (PhylogenyParserException phylogenyParserException) {
                    throw new SAXException(phylogenyParserException.getMessage());
                }
            }
            if (string2.equals("TREE")) {
                try {
                    TolXmlHandler.mapElementToPhylogeny(this.getCurrentXmlElement(), this.getCurrentPhylogeny());
                }
                catch (PhylogenyParserException phylogenyParserException) {
                    throw new SAXException(phylogenyParserException.getMessage());
                }
                this.finishPhylogeny();
                this.reset();
            } else if (this.getCurrentPhylogeny() != null && this.getCurrentXmlElement().getParent() != null) {
                this.setCurrentXmlElement(this.getCurrentXmlElement().getParent());
            }
            this.setCurrentElementName(null);
        }
    }

    private void finishPhylogeny() throws SAXException {
        this.getCurrentPhylogeny().setRooted(true);
        this.getCurrentPhylogeny().recalculateNumberOfExternalDescendants(false);
        this.getPhylogenies().add(this.getCurrentPhylogeny());
    }

    private String getCurrentElementName() {
        return this._current_element_name;
    }

    private PhylogenyNode getCurrentNode() {
        return this._current_node;
    }

    private Phylogeny getCurrentPhylogeny() {
        return this._current_phylogeny;
    }

    private XmlElement getCurrentXmlElement() {
        return this._current_xml_element;
    }

    List<Phylogeny> getPhylogenies() {
        return this._phylogenies;
    }

    private void init() {
        this.reset();
        this.setPhylogenies(new ArrayList<Phylogeny>());
    }

    private void initCurrentNode() {
        if (this.getCurrentNode() != null) {
            throw new FailedConditionCheckException("attempt to create new current node when current node already exists");
        }
        if (this.getCurrentPhylogeny() == null) {
            throw new FailedConditionCheckException("attempt to create new current node for non-existing phylogeny");
        }
        PhylogenyNode phylogenyNode = new PhylogenyNode();
        this.getCurrentPhylogeny().setRoot(phylogenyNode);
        this.setCurrentNode(this.getCurrentPhylogeny().getRoot());
    }

    private void newClade() {
        if (this.getCurrentNode() == null) {
            this.initCurrentNode();
        } else {
            this.addNode();
        }
    }

    private void newPhylogeny() {
        this.setCurrentPhylogeny(new Phylogeny());
    }

    private void reset() {
        this.setCurrentPhylogeny(null);
        this.setCurrentNode(null);
        this.setCurrentElementName(null);
        this.setCurrentXmlElement(null);
    }

    private void setCurrentElementName(String string) {
        this._current_element_name = string;
    }

    private void setCurrentNode(PhylogenyNode phylogenyNode) {
        this._current_node = phylogenyNode;
    }

    private void setCurrentPhylogeny(Phylogeny phylogeny) {
        this._current_phylogeny = phylogeny;
    }

    private void setCurrentXmlElement(XmlElement xmlElement) {
        this._current_xml_element = xmlElement;
    }

    private void setPhylogenies(List<Phylogeny> list) {
        this._phylogenies = list;
    }

    @Override
    public void startDocument() throws SAXException {
        this.init();
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.setCurrentElementName(string2);
        if (string2.equals("NODE")) {
            XmlElement xmlElement = new XmlElement(string, string2, string2, attributes);
            this.getCurrentXmlElement().addChildElement(xmlElement);
            this.setCurrentXmlElement(xmlElement);
            this.newClade();
        } else if (string2.equals("TREE")) {
            this.setCurrentXmlElement(new XmlElement("", "", "", null));
            this.newPhylogeny();
        } else if (this.getCurrentPhylogeny() != null) {
            XmlElement xmlElement = new XmlElement(string, string2, string2, attributes);
            this.getCurrentXmlElement().addChildElement(xmlElement);
            this.setCurrentXmlElement(xmlElement);
        }
    }

    public static boolean attributeEqualsValue(XmlElement xmlElement, String string, String string2) {
        String string3 = xmlElement.getAttribute(string);
        return string3 != null && string3.equals(string2);
    }

    public static String getAtttributeValue(XmlElement xmlElement, String string) {
        String string2 = xmlElement.getAttribute(string);
        if (string2 != null) {
            return string2;
        }
        return "";
    }

    private static void mapElementToPhylogeny(XmlElement xmlElement, Phylogeny phylogeny) throws PhylogenyParserException {
    }

    private static void mapElementToPhylogenyNode(XmlElement xmlElement, PhylogenyNode phylogenyNode) throws PhylogenyParserException {
        String string;
        if (xmlElement.isHasAttribute("ID") && !ForesterUtil.isEmpty(string = xmlElement.getAttribute("ID"))) {
            if (!phylogenyNode.getNodeData().isHasTaxonomy()) {
                phylogenyNode.getNodeData().setTaxonomy(new Taxonomy());
            }
            phylogenyNode.getNodeData().getTaxonomy().setIdentifier(new Identifier(string, "tol"));
        }
        for (int i = 0; i < xmlElement.getNumberOfChildElements(); ++i) {
            XmlElement xmlElement2 = xmlElement.getChildElement(i);
            String string2 = xmlElement2.getQualifiedName();
            if (string2.equals("NAME")) {
                String string3 = xmlElement2.getValueAsString();
                if (ForesterUtil.isEmpty(string3)) continue;
                if (!phylogenyNode.getNodeData().isHasTaxonomy()) {
                    phylogenyNode.getNodeData().setTaxonomy(new Taxonomy());
                }
                phylogenyNode.getNodeData().getTaxonomy().setScientificName(string3);
                continue;
            }
            if (string2.equals("AUTHORITY")) {
                String string4 = xmlElement2.getValueAsString();
                if (ForesterUtil.isEmpty(string4) || string4.equalsIgnoreCase("null")) continue;
                if (!phylogenyNode.getNodeData().isHasTaxonomy()) {
                    phylogenyNode.getNodeData().setTaxonomy(new Taxonomy());
                }
                string4 = string4.replaceAll("&amp;", "&");
                phylogenyNode.getNodeData().getTaxonomy().setAuthority(string4);
                continue;
            }
            if (string2.equals("AUTHDATE")) {
                String string5 = xmlElement2.getValueAsString();
                if (ForesterUtil.isEmpty(string5) || string5.equalsIgnoreCase("null") || !phylogenyNode.getNodeData().isHasTaxonomy() || ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getAuthority())) continue;
                _buffer.setLength(0);
                _buffer.append(phylogenyNode.getNodeData().getTaxonomy().getAuthority());
                _buffer.append(" ");
                _buffer.append(string5);
                phylogenyNode.getNodeData().getTaxonomy().setAuthority(_buffer.toString());
                continue;
            }
            if (!string2.equals("OTHERNAMES")) continue;
            for (int j = 0; j < xmlElement2.getNumberOfChildElements(); ++j) {
                XmlElement xmlElement3 = xmlElement2.getChildElement(j);
                if (!xmlElement3.getQualifiedName().equals("OTHERNAME")) continue;
                for (int k = 0; k < xmlElement3.getNumberOfChildElements(); ++k) {
                    String string6;
                    XmlElement xmlElement4 = xmlElement3.getChildElement(k);
                    if (!xmlElement4.getQualifiedName().equals("NAME") || ForesterUtil.isEmpty(string6 = xmlElement4.getValueAsString()) || string6.equalsIgnoreCase("null")) continue;
                    if (!phylogenyNode.getNodeData().isHasTaxonomy()) {
                        phylogenyNode.getNodeData().setTaxonomy(new Taxonomy());
                    }
                    phylogenyNode.getNodeData().getTaxonomy().getSynonyms().add(string6);
                }
            }
        }
    }
}

