/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forester.msa.BasicMsa;
import org.forester.msa.Msa;
import org.forester.msa.MsaFormatException;
import org.forester.sequence.BasicSequence;
import org.forester.sequence.MolecularSequence;

public class FastaParser {
    private static final Pattern NAME_REGEX = Pattern.compile("^\\s*>\\s*(.+)");
    private static final Pattern SEQ_REGEX = Pattern.compile("^\\s*(.+)");
    private static final Pattern ANYTHING_REGEX = Pattern.compile("[\\d\\s]+");
    public static final Pattern FASTA_DESC_LINE = Pattern.compile(">?\\s*([^|]+)\\|([^|]+)\\S*\\s+(.+)\\s+\\[(.+)\\]");

    public static void main(String[] stringArray) {
        Matcher matcher = FASTA_DESC_LINE.matcher(">gi|71834668|ref|NP_001025424.1| Bcl2 [Danio rerio]");
        if (matcher.lookingAt()) {
            System.out.println();
            System.out.println(matcher.group(1));
            System.out.println(matcher.group(2));
            System.out.println(matcher.group(3));
            System.out.println(matcher.group(4));
        } else {
            System.out.println("Does not match.");
        }
    }

    public static boolean isLikelyFasta(File file) throws IOException {
        return FastaParser.isLikelyFasta(new FileInputStream(file));
    }

    public static boolean isLikelyFasta(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            boolean bl = NAME_REGEX.matcher(string).lookingAt();
            if (FastaParser.canIgnore(string, true, false)) continue;
            if (bl) {
                bufferedReader.close();
                return true;
            }
            if (!SEQ_REGEX.matcher(string).lookingAt()) continue;
            bufferedReader.close();
            return false;
        }
        bufferedReader.close();
        return false;
    }

    public static Msa parseMsa(File file) throws IOException {
        return FastaParser.parseMsa(new FileInputStream(file));
    }

    public static Msa parseMsa(InputStream inputStream) throws IOException {
        return BasicMsa.createInstance(FastaParser.parse(inputStream));
    }

    public static Msa parseMsa(String string) throws IOException {
        return FastaParser.parseMsa(string.getBytes());
    }

    public static Msa parseMsa(byte[] byArray) throws IOException {
        return FastaParser.parseMsa(new ByteArrayInputStream(byArray));
    }

    public static List<MolecularSequence> parse(File file) throws IOException {
        return FastaParser.parse(new FileInputStream(file));
    }

    /*
     * WARNING - void declaration
     */
    public static List<MolecularSequence> parse(InputStream inputStream) throws IOException {
        void var9_11;
        Object object;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        String string = null;
        int n2 = 0;
        boolean bl = false;
        StringBuilder stringBuilder = null;
        StringBuilder stringBuilder2 = null;
        ArrayList<StringBuilder[]> arrayList = new ArrayList<StringBuilder[]>();
        while ((string = bufferedReader.readLine()) != null) {
            ++n2;
            object = NAME_REGEX.matcher(string);
            boolean n = ((Matcher)object).lookingAt();
            if (FastaParser.canIgnore(string, bl, n)) continue;
            Matcher matcher = SEQ_REGEX.matcher(string);
            if (n) {
                bl = true;
                FastaParser.addSeq(stringBuilder2, stringBuilder, arrayList);
                stringBuilder2 = new StringBuilder(((Matcher)object).group(1).trim());
                stringBuilder = new StringBuilder();
                continue;
            }
            if (matcher.lookingAt()) {
                if (stringBuilder2.length() < 1) {
                    bufferedReader.close();
                    throw new MsaFormatException("illegally formatted fasta msa (line: " + n2 + "):\n\"" + FastaParser.trim(string) + "\"");
                }
                stringBuilder.append(matcher.group(1).replaceAll("\\s+", ""));
                continue;
            }
            bufferedReader.close();
            throw new MsaFormatException("illegally formatted fasta msa (line: " + n2 + "):\n\"" + FastaParser.trim(string) + "\"");
        }
        FastaParser.addSeq(stringBuilder2, stringBuilder, arrayList);
        bufferedReader.close();
        object = new ArrayList();
        boolean bl2 = false;
        while (var9_11 < arrayList.size()) {
            object.add(BasicSequence.createAaSequence(((StringBuilder[])arrayList.get((int)var9_11))[0].toString(), ((StringBuilder[])arrayList.get((int)var9_11))[1].toString()));
            ++var9_11;
        }
        return object;
    }

    private static boolean canIgnore(String string, boolean bl, boolean bl2) {
        if (string.length() < 1 || ANYTHING_REGEX.matcher(string).matches()) {
            return true;
        }
        return !bl && !bl2;
    }

    private static void addSeq(StringBuilder stringBuilder, StringBuilder stringBuilder2, List<StringBuilder[]> list) {
        if (stringBuilder != null && stringBuilder2 != null && stringBuilder.length() > 0 && stringBuilder2.length() > 0) {
            StringBuilder[] stringBuilderArray = new StringBuilder[]{stringBuilder, stringBuilder2};
            list.add(stringBuilderArray);
        } else if (stringBuilder == null || stringBuilder.length() < 1) {
            System.out.println("WARNING: sequence with empty name -- ignored");
        } else if (stringBuilder2 == null || stringBuilder2.length() < 1) {
            System.out.println("WARNING: empty sequence -- ignored");
        }
    }

    private static String trim(String string) {
        if (string.length() > 100) {
            return string.substring(0, 100) + " ...";
        }
        return string;
    }
}

