/*
 * Decompiled with CFR 0.152.
 */
package org.forester.development;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JComponent;
import org.forester.development.AbstractRenderer;
import org.forester.development.ResidueRenderer;
import org.forester.msa.Msa;

public class MsaRenderer
extends JComponent {
    private static final long serialVersionUID = -68078011081748093L;
    private final int _rows;
    private final int _columns;
    private int _wellSize;
    private AbstractRenderer[][] _wells;
    private double _min;
    private double _max;
    private double _mean;
    private Color _minColor;
    private Color _maxColor;
    private Color _meanColor;
    private boolean _useMean;
    private final Msa _msa;
    private final JComponent _parent;

    public static boolean isMouseEventAltered(MouseEvent mouseEvent) {
        return mouseEvent.isShiftDown() || mouseEvent.isAltDown() || mouseEvent.isControlDown() || mouseEvent.isAltGraphDown() || mouseEvent.isMetaDown();
    }

    public MsaRenderer(Msa msa, int n, JComponent jComponent) {
        this._parent = jComponent;
        this._msa = msa;
        this._rows = this._msa.getNumberOfSequences();
        this._columns = this._msa.getLength();
        this.setWellSize(n);
        this.addMouseListeners();
        this.initializeWells();
    }

    private void addMouseListeners() {
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
    }

    public AbstractRenderer getAbstractRenderer(int n, int n2) {
        return this._wells[n][n2];
    }

    public int getColumns() {
        return this._columns;
    }

    private double getMax() {
        return this._max;
    }

    private Color getMaxColor() {
        return this._maxColor;
    }

    private double getMean() {
        return this._mean;
    }

    private Color getMeanColor() {
        return this._meanColor;
    }

    private double getMin() {
        return this._min;
    }

    private Color getMinColor() {
        return this._minColor;
    }

    @Override
    public Dimension getPreferredSize() {
        int n = (this.getWellSize() + 1) * (this.getColumns() + 1);
        int n2 = (this.getWellSize() + 1) * (this.getRows() + 1) + 30;
        return new Dimension(n, n2);
    }

    public int getRows() {
        return this._rows;
    }

    private int getWellSize() {
        return this._wellSize;
    }

    private void initializeWells() {
        int n;
        this._wells = new AbstractRenderer[this.getRows() + 1][this.getColumns() + 1];
        for (n = 0; n < this.getRows(); ++n) {
            for (int i = 0; i < this.getColumns() + 1; ++i) {
                if (i == this.getColumns()) continue;
                ResidueRenderer residueRenderer = new ResidueRenderer(this.getMsa().getResidueAt(n, i), this);
            }
        }
        for (n = 0; n < this.getColumns() + 1; ++n) {
            if (n != this.getColumns()) continue;
        }
    }

    private Msa getMsa() {
        return this._msa;
    }

    public void inverseMarkedOfWell(int n, int n2) {
        ResidueRenderer residueRenderer = (ResidueRenderer)this.getAbstractRenderer(n, n2);
        if (residueRenderer.isMarked()) {
            residueRenderer.setIsMarked(false);
        } else {
            residueRenderer.setIsMarked(true);
        }
    }

    private boolean isUseMean() {
        return this._useMean;
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setColor(Color.white);
        for (int i = 0; i < this.getRows() + 1; ++i) {
            for (int j = 0; j < this.getColumns() + 1; ++j) {
                this.getAbstractRenderer(i, j).paint(graphics);
            }
        }
    }

    public void resetWellColors() {
        for (int i = 0; i < this.getRows(); ++i) {
            for (int j = 0; j < this.getColumns(); ++j) {
                ResidueRenderer residueRenderer = (ResidueRenderer)this.getAbstractRenderer(i, j);
                if (this.isUseMean()) {
                    residueRenderer.resetWellColor(this.getMin(), this.getMax(), this.getMean(), this.getMinColor(), this.getMaxColor(), this.getMeanColor());
                    continue;
                }
                residueRenderer.resetWellColor(this.getMin(), this.getMax(), this.getMinColor(), this.getMaxColor());
            }
        }
    }

    public void resetWellSize(int n) {
        this.setWellSize(n);
        int n2 = n + 0;
        for (int i = 0; i < this.getRows() + 1; ++i) {
            for (int j = 0; j < this.getColumns() + 1; ++j) {
                AbstractRenderer abstractRenderer = this.getAbstractRenderer(i, j);
                abstractRenderer.setX(10 + n2 * j);
                abstractRenderer.setY(n2 * i + 30);
                abstractRenderer.setWellSize(n);
            }
        }
    }

    private void setAbstractRenderer(AbstractRenderer abstractRenderer, int n, int n2) {
        this._wells[n][n2] = abstractRenderer;
    }

    public void setFlaggedStatusOfOutlierWells(boolean bl) {
        for (int i = 0; i < this.getRows(); ++i) {
            for (int j = 0; j < this.getColumns(); ++j) {
                ResidueRenderer residueRenderer = (ResidueRenderer)this.getAbstractRenderer(i, j);
            }
        }
    }

    public void setFlaggedStatusOfSelectedWells(boolean bl) {
        for (int i = 0; i < this.getRows(); ++i) {
            for (int j = 0; j < this.getColumns(); ++j) {
                ResidueRenderer residueRenderer = (ResidueRenderer)this.getAbstractRenderer(i, j);
                if (!residueRenderer.isSelected()) continue;
                residueRenderer.setIsSelected(false);
            }
        }
    }

    public void setIsFlaggingStatusChangedToFalse() {
        for (int i = 0; i < this.getRows(); ++i) {
            for (int j = 0; j < this.getColumns(); ++j) {
                ResidueRenderer residueRenderer = (ResidueRenderer)this.getAbstractRenderer(i, j);
            }
        }
    }

    private void setIsSelectedOfAll(boolean bl) {
        for (int i = 0; i < this.getColumns() + 1; ++i) {
            this.setIsSelectedOfColumn(i, bl);
        }
    }

    private void setIsSelectedOfColumn(int n, boolean bl) {
        for (int i = 0; i < this.getRows() + 1; ++i) {
            this.getAbstractRenderer(i, n).setIsSelected(bl);
        }
    }

    private void setIsSelectedOfRow(int n, boolean bl) {
        for (int i = 0; i < this.getColumns() + 1; ++i) {
            this.getAbstractRenderer(n, i).setIsSelected(bl);
        }
    }

    private void setIsSelectedOfRowAlternating(int n, boolean bl) {
        boolean bl2 = bl;
        for (int i = 0; i < this.getColumns(); ++i) {
            this.getAbstractRenderer(n, i).setIsSelected(bl2);
            bl2 = !bl2;
        }
    }

    private void setIsSelectedToQuarter(int n) {
        boolean bl = false;
        boolean bl2 = false;
        if (n <= 1) {
            bl = true;
            bl2 = true;
        } else if (n == 2) {
            bl2 = true;
        } else if (n == 3) {
            bl = true;
        }
        for (int i = 0; i < this.getRows(); ++i) {
            if (bl2) {
                this.setIsSelectedOfRowAlternating(i, bl);
            } else {
                this.setIsSelectedOfRow(i, false);
            }
            bl2 = !bl2;
        }
    }

    public void setMarkedOfAllWellsToFalse() {
        for (int i = 0; i < this.getRows(); ++i) {
            for (int j = 0; j < this.getColumns(); ++j) {
                ResidueRenderer residueRenderer = (ResidueRenderer)this.getAbstractRenderer(i, j);
            }
        }
    }

    public void setMax(double d) {
        this._max = d;
    }

    void setMaxColor(Color color) {
        this._maxColor = color;
    }

    void setMean(double d) {
        this._mean = d;
    }

    public void setMeanColor(Color color) {
        this._meanColor = color;
    }

    public void setMin(double d) {
        this._min = d;
    }

    void setMinColor(Color color) {
        this._minColor = color;
    }

    public void setUseMean(boolean bl) {
        this._useMean = bl;
    }

    private void setWellSize(int n) {
        this._wellSize = n;
    }

    public void unSelectUnMarkAll() {
        for (int i = 0; i < this.getRows(); ++i) {
            for (int j = 0; j < this.getColumns(); ++j) {
                ResidueRenderer residueRenderer = (ResidueRenderer)this.getAbstractRenderer(i, j);
                residueRenderer.setIsSelected(false);
                residueRenderer.setIsMarked(false);
            }
        }
    }
}

