/*
 * Decompiled with CFR 0.152.
 */
package org.forester.datastructures;

import java.util.List;
import org.forester.util.ForesterUtil;

public final class IntMatrix {
    private final int[][] _data;
    private final String[] _labels;

    public IntMatrix(int n) {
        this._data = new int[n][n];
        this._labels = new String[n];
    }

    public IntMatrix(List<String> list) {
        int n = list.size();
        this._data = new int[n][n];
        this._labels = new String[n];
        for (int i = 0; i < n; ++i) {
            this.setLabel(i, list.get(i));
        }
    }

    public final int get(int n, int n2) {
        return this._data[n][n2];
    }

    public final String getLabel(int n) {
        return this._labels[n];
    }

    public final String getRowAsString(int n, char c) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getLabel(n));
        for (int i = 0; i < this.size(); ++i) {
            stringBuilder.append(c);
            stringBuilder.append(this.get(n, i));
        }
        return stringBuilder.toString();
    }

    public final void inreaseByOne(int n, int n2) {
        int[] nArray = this._data[n];
        int n3 = n2;
        nArray[n3] = nArray[n3] + 1;
    }

    public final void set(int n, int n2, int n3) {
        this._data[n][n2] = n3;
    }

    public final void setLabel(int n, String string) {
        if (string == null) {
            throw new IllegalArgumentException("matrix label must not be null");
        }
        this._labels[n] = string;
    }

    public final int size() {
        return this._labels.length;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            if (this.getLabel(i) != null) {
                stringBuilder.append(this.getLabel(i));
                stringBuilder.append("\t");
            }
            for (int j = 0; j < this.size(); ++j) {
                stringBuilder.append(this.get(i, j));
                stringBuilder.append("\t");
            }
            stringBuilder.append(ForesterUtil.LINE_SEPARATOR);
        }
        return stringBuilder.toString();
    }
}

