/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx.tools;

import java.awt.color.CMMException;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import org.forester.archaeopteryx.AptxUtil;
import org.forester.archaeopteryx.TreePanel;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.data.Uri;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;

public class ImageLoader
implements Runnable {
    private final TreePanel _tp;
    private static final BufferedImage PLACEHOLDER = new BufferedImage(1, 1, 1);
    private static final boolean DEBUG = false;

    public ImageLoader(TreePanel treePanel) {
        this._tp = treePanel;
    }

    @Override
    public void run() {
        this.load();
    }

    private void load() {
        Hashtable<String, BufferedImage> hashtable = null;
        if (this._tp.getImageMap() != null) {
            hashtable = this._tp.getImageMap();
        } else {
            hashtable = new Hashtable();
            this._tp.setImageMap(hashtable);
        }
        PhylogenyNodeIterator phylogenyNodeIterator = this._tp.getPhylogeny().iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (!phylogenyNode.getNodeData().isHasTaxonomy() || phylogenyNode.getNodeData().getTaxonomy().getUris() == null || phylogenyNode.getNodeData().getTaxonomy().getUris().isEmpty()) continue;
            ArrayList<Uri> arrayList = new ArrayList<Uri>();
            for (Taxonomy taxonomy : phylogenyNode.getNodeData().getTaxonomies()) {
                if (taxonomy.getUris() == null) continue;
                for (Uri uri : taxonomy.getUris()) {
                    arrayList.add(uri);
                }
            }
            for (Uri uri : arrayList) {
                if (uri == null) continue;
                String string = uri.getType().toLowerCase();
                String string2 = uri.getValue().toString().toLowerCase();
                if (hashtable.containsKey(string2) || !string.equals("image") && !string.equals("img") && !string.equals("photo") && !string.equals("picture") && !string2.endsWith(".jpg") && !string2.endsWith(".jpeg") && !string2.endsWith(".png") && !string2.endsWith(".gif") && !string2.endsWith(".bmp")) continue;
                hashtable.put(string2, PLACEHOLDER);
                BufferedImage bufferedImage = null;
                try {
                    bufferedImage = ImageIO.read(uri.getValue().toURL());
                }
                catch (MalformedURLException malformedURLException) {
                    AptxUtil.printWarningMessage("Archaeopteryx", "could not load image from \"" + uri.getValue() + "\": Malformed URL Exception: " + malformedURLException.getLocalizedMessage());
                }
                catch (IOException iOException) {
                    AptxUtil.printWarningMessage("Archaeopteryx", "could not load image from \"" + uri.getValue() + "\": IO Exception: " + iOException.getLocalizedMessage());
                }
                catch (CMMException cMMException) {
                    AptxUtil.printWarningMessage("Archaeopteryx", "could not load image from \"" + uri.getValue() + "\": CMMException: " + cMMException.getLocalizedMessage());
                }
                if (bufferedImage != null) {
                    hashtable.put(string2, bufferedImage);
                    this._tp.repaint();
                    continue;
                }
                hashtable.remove(string2);
            }
        }
    }
}

