/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.forester.io.parsers.FastaParser;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.data.Identifier;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.sequence.MolecularSequence;
import org.forester.tools.PhylogenyDecorator;
import org.forester.util.BasicTable;
import org.forester.util.BasicTableParser;
import org.forester.util.CommandLineArguments;
import org.forester.util.ForesterUtil;

public final class decorator {
    private static final String SEQUENCE_NAME_FIELD = "s";
    private static final String MOL_SEQ = "m";
    private static final String TAXONOMY_CODE_FIELD = "c";
    private static final String TAXONOMY_SCIENTIFIC_NAME_FIELD = "sn";
    private static final String DS_FILED = "d";
    private static final String SEQUENCE_ANNOTATION_DESC = "a";
    private static final String NODE_NAME_FIELD = "n";
    private static final String PICKY_OPTION = "p";
    private static final String FIELD_OPTION = "f";
    private static final String TRIM_AFTER_TILDE_OPTION = "t";
    private static final String VERBOSE_OPTION = "ve";
    private static final String TREE_NAME_OPTION = "pn";
    private static final String TREE_ID_OPTION = "pi";
    private static final String TREE_DESC_OPTION = "pd";
    private static final String MIDPOINT_ROOT_OPTION = "mp";
    private static final String ORDER_TREE_OPTION = "or";
    private static final String EXTRACT_BRACKETED_SCIENTIC_NAME_OPTION = "sn";
    private static final String EXTRACT_BRACKETED_TAXONOMIC_CODE_OPTION = "tc";
    private static final String CUT_NAME_AFTER_FIRST_SPACE_OPTION = "c";
    private static final String ADVANCED_TABLE_OPTION = "table";
    private static final String KEY_COLUMN = "k";
    private static final String VALUE_COLUMN = "v";
    private static final String MAPPING_FILE_SEPARATOR_OPTION = "s";
    private static final char MAPPING_FILE_SEPARATOR_DEFAULT = '\t';
    private static final String PRG_NAME = "decorator";
    private static final String PRG_VERSION = "1.16";
    private static final String PRG_DATE = "131113";

    /*
     * WARNING - void declaration
     */
    public static void main(String[] stringArray) {
        Object object;
        Phylogeny[] phylogenyArray;
        boolean bl;
        boolean bl2;
        File file;
        block83: {
            SortedMap sortedMap;
            boolean bl3;
            String string;
            ForesterUtil.printProgramInformation(PRG_NAME, PRG_VERSION, PRG_DATE);
            System.out.println();
            if (stringArray.length < 4 || stringArray.length > 13) {
                decorator.argumentsError();
            }
            CommandLineArguments commandLineArguments = null;
            try {
                commandLineArguments = new CommandLineArguments(stringArray);
            }
            catch (Exception exception) {
                ForesterUtil.fatalError(PRG_NAME, exception.getMessage());
            }
            if (commandLineArguments.getNumberOfNames() < 3 || commandLineArguments.getNumberOfNames() > 4) {
                decorator.argumentsError();
            }
            File file2 = commandLineArguments.getFile(0);
            File file3 = commandLineArguments.getFile(1);
            file = commandLineArguments.getFile(2);
            if (file.exists()) {
                ForesterUtil.fatalError(PRG_NAME, "[" + file + "] already exists");
            }
            if (!ForesterUtil.isEmpty(string = ForesterUtil.isReadableFile(file2))) {
                ForesterUtil.fatalError(PRG_NAME, string);
            }
            if (!ForesterUtil.isEmpty(string = ForesterUtil.isReadableFile(file3))) {
                ForesterUtil.fatalError(PRG_NAME, string);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(ADVANCED_TABLE_OPTION);
            arrayList.add(PICKY_OPTION);
            arrayList.add(FIELD_OPTION);
            arrayList.add("c");
            arrayList.add(KEY_COLUMN);
            arrayList.add(VALUE_COLUMN);
            arrayList.add("s");
            arrayList.add("sn");
            arrayList.add(EXTRACT_BRACKETED_TAXONOMIC_CODE_OPTION);
            arrayList.add(TREE_NAME_OPTION);
            arrayList.add(TREE_ID_OPTION);
            arrayList.add(TREE_DESC_OPTION);
            arrayList.add(TRIM_AFTER_TILDE_OPTION);
            arrayList.add(ORDER_TREE_OPTION);
            arrayList.add(MIDPOINT_ROOT_OPTION);
            arrayList.add(VERBOSE_OPTION);
            String string2 = commandLineArguments.validateAllowedOptionsAsString(arrayList);
            if (string2.length() > 0) {
                ForesterUtil.fatalError(PRG_NAME, "unknown option(s): " + string2);
            }
            if (!(bl3 = commandLineArguments.isOptionSet(ADVANCED_TABLE_OPTION))) {
                ArrayList<String> arrayList2 = new ArrayList<String>();
                arrayList2.add(FIELD_OPTION);
                String string3 = commandLineArguments.validateMandatoryOptionsAsString(arrayList2);
                if (string3.length() > 0) {
                    ForesterUtil.fatalError(PRG_NAME, "missing option(s): " + string3);
                }
            }
            boolean bl4 = commandLineArguments.isOptionSet(PICKY_OPTION);
            char c = '\t';
            if (commandLineArguments.isOptionSet("s")) {
                if (bl3) {
                    decorator.argumentsError();
                }
                c = commandLineArguments.getOptionValueAsChar("s");
            }
            int n = 0;
            int n2 = 1;
            String string4 = "";
            PhylogenyDecorator.FIELD fIELD = PhylogenyDecorator.FIELD.NODE_NAME;
            boolean bl5 = false;
            boolean bl6 = false;
            boolean bl7 = false;
            boolean bl8 = false;
            bl2 = false;
            bl = false;
            boolean bl9 = false;
            String string5 = "";
            String string6 = "";
            String string7 = "";
            try {
                if (commandLineArguments.isOptionSet(TREE_NAME_OPTION)) {
                    string5 = commandLineArguments.getOptionValueAsCleanString(TREE_NAME_OPTION);
                }
                if (commandLineArguments.isOptionSet(TREE_ID_OPTION)) {
                    string6 = commandLineArguments.getOptionValueAsCleanString(TREE_ID_OPTION);
                }
                if (commandLineArguments.isOptionSet(TREE_DESC_OPTION)) {
                    string7 = commandLineArguments.getOptionValueAsCleanString(TREE_DESC_OPTION);
                }
                if (commandLineArguments.isOptionSet("sn")) {
                    if (bl3) {
                        decorator.argumentsError();
                    }
                    bl6 = true;
                }
                if (commandLineArguments.isOptionSet(EXTRACT_BRACKETED_TAXONOMIC_CODE_OPTION)) {
                    if (bl3) {
                        decorator.argumentsError();
                    }
                    bl7 = true;
                }
                if (commandLineArguments.isOptionSet(KEY_COLUMN)) {
                    if (bl3) {
                        decorator.argumentsError();
                    }
                    n = commandLineArguments.getOptionValueAsInt(KEY_COLUMN);
                }
                if (commandLineArguments.isOptionSet(VALUE_COLUMN)) {
                    if (bl3) {
                        decorator.argumentsError();
                    }
                    n2 = commandLineArguments.getOptionValueAsInt(VALUE_COLUMN);
                }
                if (commandLineArguments.isOptionSet("c")) {
                    if (bl3) {
                        decorator.argumentsError();
                    }
                    bl5 = true;
                }
                if (commandLineArguments.isOptionSet(TRIM_AFTER_TILDE_OPTION)) {
                    if (bl3) {
                        decorator.argumentsError();
                    }
                    bl8 = true;
                }
                if (commandLineArguments.isOptionSet(MIDPOINT_ROOT_OPTION)) {
                    bl = true;
                }
                if (commandLineArguments.isOptionSet(ORDER_TREE_OPTION)) {
                    bl2 = true;
                }
                if (commandLineArguments.isOptionSet(VERBOSE_OPTION)) {
                    bl9 = true;
                }
                if (commandLineArguments.isOptionSet(FIELD_OPTION)) {
                    string4 = commandLineArguments.getOptionValue(FIELD_OPTION);
                    if (string4.equals(NODE_NAME_FIELD)) {
                        fIELD = PhylogenyDecorator.FIELD.NODE_NAME;
                    } else if (string4.equals(SEQUENCE_ANNOTATION_DESC)) {
                        fIELD = PhylogenyDecorator.FIELD.SEQUENCE_ANNOTATION_DESC;
                    } else if (string4.equals(DS_FILED)) {
                        fIELD = PhylogenyDecorator.FIELD.DOMAIN_STRUCTURE;
                        bl6 = false;
                        bl7 = false;
                    } else if (string4.equals("c")) {
                        fIELD = PhylogenyDecorator.FIELD.TAXONOMY_CODE;
                    } else if (string4.equals("s")) {
                        fIELD = PhylogenyDecorator.FIELD.SEQUENCE_NAME;
                    } else if (string4.equals(MOL_SEQ)) {
                        fIELD = PhylogenyDecorator.FIELD.MOL_SEQ;
                    } else if (string4.equals("sn")) {
                        fIELD = PhylogenyDecorator.FIELD.TAXONOMY_SCIENTIFIC_NAME;
                        bl6 = false;
                        bl7 = false;
                    } else {
                        ForesterUtil.fatalError(PRG_NAME, "unknown value for \"f\" option: \"" + string4 + "\"");
                    }
                }
            }
            catch (Exception exception) {
                ForesterUtil.fatalError(PRG_NAME, "error in command line: " + exception.getMessage());
            }
            if (bl6 && bl7) {
                decorator.argumentsError();
            }
            ForesterUtil.programMessage(PRG_NAME, "input tree(s) : " + file2);
            ForesterUtil.programMessage(PRG_NAME, "map           : " + file3);
            ForesterUtil.programMessage(PRG_NAME, "output tree(s): " + file);
            System.out.println();
            phylogenyArray = null;
            try {
                sortedMap = ParserBasedPhylogenyFactory.getInstance();
                object = ParserUtils.createParserDependingOnFileType(file2, true);
                phylogenyArray = sortedMap.create(file2, object);
            }
            catch (Exception exception) {
                ForesterUtil.fatalError(PRG_NAME, "failed to read phylgenies from [" + file2 + "] [" + exception.getMessage() + "]");
            }
            sortedMap = null;
            if (!bl3) {
                if (fIELD != PhylogenyDecorator.FIELD.MOL_SEQ) {
                    object = null;
                    try {
                        object = BasicTableParser.parse(file3, c, true, false);
                    }
                    catch (Exception exception) {
                        ForesterUtil.fatalError(PRG_NAME, "failed to read [" + file3 + "] [" + exception.getMessage() + "]");
                    }
                    if (n < 0 || n >= ((BasicTable)object).getNumberOfColumns()) {
                        ForesterUtil.fatalError(PRG_NAME, "illegal value for key column");
                    }
                    if (n2 < 0 || n2 >= ((BasicTable)object).getNumberOfColumns()) {
                        ForesterUtil.fatalError(PRG_NAME, "illegal value for value column");
                    }
                    if (((BasicTable)object).isEmpty() || ((BasicTable)object).getNumberOfColumns() < 1) {
                        ForesterUtil.fatalError(PRG_NAME, "mapping table is empty");
                    }
                    if (((BasicTable)object).getNumberOfColumns() == 1) {
                        ForesterUtil.fatalError(PRG_NAME, "mapping table has only one column");
                    }
                    sortedMap = ((BasicTable)object).getColumnsAsMap(n, n2);
                    Iterator iterator = sortedMap.entrySet().iterator();
                    if (bl9) {
                        System.out.println();
                    }
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        if (ForesterUtil.isEmpty((String)entry.getKey())) {
                            ForesterUtil.fatalError(PRG_NAME, "mapping table contains empty key");
                        }
                        if (ForesterUtil.isEmpty((String)entry.getValue())) {
                            ForesterUtil.fatalError(PRG_NAME, "mapping table contains empty value for key \"" + (String)entry.getKey() + "\"");
                        }
                        if (!bl9) continue;
                        System.out.println((String)entry.getKey() + " => " + (String)entry.getValue());
                    }
                    if (bl9) {
                        System.out.println();
                    }
                } else {
                    sortedMap = decorator.readFastaFileIntoMap(file3, bl9);
                }
            }
            if (!(ForesterUtil.isEmpty(string5) && ForesterUtil.isEmpty(string6) && ForesterUtil.isEmpty(string7))) {
                if (!(phylogenyArray.length <= 1 || ForesterUtil.isEmpty(string5) && ForesterUtil.isEmpty(string6))) {
                    ForesterUtil.fatalError(PRG_NAME, "attempt to set same name or id on more than one phylogeny");
                }
                if (!ForesterUtil.isEmpty(string5)) {
                    phylogenyArray[0].setName(string5);
                }
                if (!ForesterUtil.isEmpty(string6)) {
                    object = string6.split(":");
                    phylogenyArray[0].setIdentifier(new Identifier((String)object[1], (String)object[0]));
                }
                if (!ForesterUtil.isEmpty(string7)) {
                    for (Phylogeny object2 : phylogenyArray) {
                        object2.setDescription(string7);
                    }
                }
            }
            try {
                if (bl3) {
                    void phylogeny;
                    object = null;
                    try {
                        object = PhylogenyDecorator.parseMappingTable(file3);
                    }
                    catch (IOException iOException) {
                        ForesterUtil.fatalError(PRG_NAME, "failed to read \"" + file3 + "\" [" + iOException.getMessage() + "]");
                    }
                    Phylogeny[] phylogenyArray2 = phylogenyArray;
                    int n3 = phylogenyArray2.length;
                    boolean bl10 = false;
                    while (phylogeny < n3) {
                        Phylogeny phylogeny2 = phylogenyArray2[phylogeny];
                        PhylogenyDecorator.decorate(phylogeny2, (Map<String, Map<String, String>>)object, bl4);
                        ++phylogeny;
                    }
                    break block83;
                }
                for (Phylogeny phylogeny : phylogenyArray) {
                    String string3 = PhylogenyDecorator.decorate(phylogeny, sortedMap, fIELD, bl6, bl7, bl4, bl5, bl8, bl9);
                    ForesterUtil.programMessage(PRG_NAME, string3);
                }
            }
            catch (NullPointerException nullPointerException) {
                ForesterUtil.unexpectedFatalError(PRG_NAME, nullPointerException);
            }
            catch (Exception exception) {
                ForesterUtil.fatalError(PRG_NAME, exception.getLocalizedMessage());
            }
        }
        if (bl || bl2) {
            for (Phylogeny phylogeny : phylogenyArray) {
                if (bl) {
                    PhylogenyMethods.midpointRoot(phylogeny);
                }
                if (!bl2) continue;
                PhylogenyMethods.orderAppearance(phylogeny.getRoot(), true, true, PhylogenyMethods.DESCENDANT_SORT_PRIORITY.TAXONOMY);
            }
        }
        try {
            object = new PhylogenyWriter();
            ((PhylogenyWriter)object).toPhyloXML(phylogenyArray, 0, file, ForesterUtil.getLineSeparator());
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, "failed to write output [" + iOException.getMessage() + "]");
        }
        System.out.println();
        ForesterUtil.programMessage(PRG_NAME, "wrote: " + file);
        ForesterUtil.programMessage(PRG_NAME, "OK.");
    }

    private static Map<String, String> readFastaFileIntoMap(File file, boolean bl) {
        List<MolecularSequence> list = null;
        try {
            list = FastaParser.parse(new FileInputStream(file));
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, "failed to read fasta-file from [" + file + "] [" + iOException.getMessage() + "]");
        }
        if (ForesterUtil.isEmpty(list)) {
            ForesterUtil.fatalError(PRG_NAME, "fasta-file [" + file + "] is devoid of fasta-formatted sequences");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (MolecularSequence molecularSequence : list) {
            if (ForesterUtil.isEmpty(molecularSequence.getIdentifier())) {
                ForesterUtil.fatalError(PRG_NAME, "fasta-file [" + file + "] contains sequence with empty identifier");
            }
            if (hashMap.containsKey(molecularSequence.getIdentifier())) {
                ForesterUtil.fatalError(PRG_NAME, "sequence identifier [" + molecularSequence.getIdentifier() + "] is not unique");
            }
            if (molecularSequence.getLength() < 1) {
                ForesterUtil.fatalError(PRG_NAME, "sequence [" + molecularSequence.getIdentifier() + "] is empty");
            }
            hashMap.put(molecularSequence.getIdentifier(), molecularSequence.getMolecularSequenceAsString());
            if (!bl) continue;
            System.out.println(molecularSequence.getIdentifier() + " => " + molecularSequence.getMolecularSequenceAsString());
        }
        return hashMap;
    }

    private static void argumentsError() {
        System.out.println();
        System.out.println("decorator -table | -f=<c> <phylogenies infile> <mapping table file|fasta-file> <phylogenies outfile>");
        System.out.println();
        System.out.println("options:");
        System.out.println();
        System.out.println(" -table : table instead of one to one map (-f=<c>)");
        System.out.println(" -p     : picky, fails if node name not found in mapping table");
        System.out.println(" -pn=<s>: name for the phylogeny");
        System.out.println(" -pi=<s>: identifier for the phylogeny (in the form provider:value)");
        System.out.println(" -pd=<s>: description for phylogenies");
        System.out.println();
        System.out.println();
        System.out.println("advanced options, only available if -table is not used:");
        System.out.println();
        System.out.println(" -f=<c> : field to be replaced: n : node name");
        System.out.println("                                a : sequence annotation description");
        System.out.println("                                d : domain structure");
        System.out.println("                                c : taxonomy code");
        System.out.println("                                sn: taxonomy scientific name");
        System.out.println("                                s : sequence name");
        System.out.println("                                m : molecular sequence");
        System.out.println(" -k=<n> : key column in mapping table (0 based),");
        System.out.println("          names of the node to be decorated - default is 0");
        System.out.println(" -v=<n> : value column in mapping table (0 based),");
        System.out.println("          data which with to decorate - default is 1");
        System.out.println(" -sn    : to extract bracketed scientific names, e.g. [Nematostella vectensis]");
        System.out.println(" -tc    : to extract bracketed taxonomic codes, e.g. [NEMVE]");
        System.out.println(" -s=<c> : column separator in mapping file, default is tab");
        System.out.println(" -c     : cut name after first space (only for -f=n)");
        System.out.println(" -t     : trim node name to be replaced after tilde");
        System.out.println(" -mp    : to midpoint-root the tree");
        System.out.println(" -or    : to order tree branches");
        System.out.println(" -ve    : verbose");
        System.out.println();
        System.exit(-1);
    }
}

