/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.render;

import com.approximatrix.charting.coordsystem.CoordSystem;
import com.approximatrix.charting.model.ChartDataModel;
import com.approximatrix.charting.render.AbstractChartRenderer;
import com.approximatrix.charting.render.RowColorModel;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public class LineChartRenderer
extends AbstractChartRenderer {
    public LineChartRenderer(CoordSystem cs, ChartDataModel model) {
        super(cs, model);
    }

    @Override
    public boolean renderChart(Graphics2D g) {
        ChartDataModel m = this.getChartDataModel();
        RowColorModel rcm = this.getRowColorModel();
        AffineTransform yaxis1 = this.getTransform(0);
        int datasetcount = m.getDataSetNumber();
        Point2D paint = null;
        Point2D oldpaint = null;
        boolean numericalcolumns = m.isColumnNumeric();
        float modelVal = 0.0f;
        if (this.getStopFlag()) {
            return false;
        }
        int set = 0;
        while (set < datasetcount && !this.getStopFlag()) {
            int value = 0;
            while (value < m.getDataSetLength(set) && !this.getStopFlag()) {
                modelVal = m.getValueAt(set, value).floatValue();
                if (modelVal != modelVal || modelVal == Float.NEGATIVE_INFINITY || modelVal == Float.POSITIVE_INFINITY) {
                    oldpaint = null;
                } else {
                    Point2D.Float val = numericalcolumns ? new Point2D.Float(((Number)m.getColumnValueAt(set, value)).floatValue(), modelVal) : new Point2D.Float(value, modelVal);
                    oldpaint = paint;
                    if (yaxis1.transform(val, null) != null) {
                        paint = yaxis1.transform(val, null);
                        g.setColor(rcm.getColor(set));
                        if (oldpaint != null) {
                            g.drawLine((int)oldpaint.getX(), (int)oldpaint.getY(), (int)paint.getX(), (int)paint.getY());
                        }
                    }
                }
                ++value;
            }
            oldpaint = null;
            paint = null;
            ++set;
        }
        boolean completed = !this.getStopFlag();
        this.resetStopFlag();
        return completed;
    }
}

