/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.render;

import com.approximatrix.charting.event.RenderChangeEvent;
import com.approximatrix.charting.event.RenderChangeListener;
import com.approximatrix.charting.render.Renderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.event.EventListenerList;

public abstract class AbstractRenderer
implements Renderer {
    private static boolean DirectRender = true;
    protected EventListenerList listener = new EventListenerList();
    Rectangle bounds = new Rectangle(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);

    public static void setDirectRender(boolean value) {
        DirectRender = value;
    }

    public static boolean getDirectRender() {
        return DirectRender;
    }

    @Override
    public void setBounds(Rectangle bounds) {
        if (this.isDifferentBounds(bounds)) {
            this.bounds = bounds;
            this.fireRenderChangeEvent();
        }
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    private void directRender(Graphics2D g) {
        g.translate(this.getBounds().x, this.getBounds().y);
        this.paintDefault(g);
        g.translate(-this.getBounds().x, -this.getBounds().y);
    }

    @Override
    public void render(Graphics2D g) {
        if (DirectRender) {
            this.directRender(g);
        } else {
            Dimension d = this.getPreferredSize();
            if (d.width <= 0 || (double)d.width > 100000.0) {
                d.width = 1;
            }
            if (d.height <= 0 || (double)d.height > 100000.0) {
                d.height = 1;
            }
            BufferedImage im = new BufferedImage(d.width, d.height, 1);
            Graphics2D g2 = im.createGraphics();
            g2.setColor(Color.white);
            g2.fillRect(0, 0, d.width, d.height);
            g2.setColor(Color.black);
            this.paintDefault(g2);
            if ((double)d.width > this.getBounds().getWidth() || (double)d.height > this.getBounds().getHeight()) {
                Image scale = im.getScaledInstance((int)this.getBounds().getWidth(), (int)this.getBounds().getHeight(), 4);
                g.drawImage(scale, (int)this.getBounds().getX(), (int)this.getBounds().getY(), null);
            } else {
                g.drawImage((Image)im, (int)this.getBounds().getX(), (int)this.getBounds().getY(), null);
            }
        }
    }

    public abstract void paintDefault(Graphics2D var1);

    @Override
    public void fireRenderChangeEvent() {
        RenderChangeEvent rce = new RenderChangeEvent(this);
        Object[] ls = this.listener.getListenerList();
        int i = ls.length - 2;
        while (i >= 0) {
            if (ls[i] == RenderChangeListener.class) {
                ((RenderChangeListener)ls[i + 1]).renderUpdateRequested(rce);
            }
            i -= 2;
        }
    }

    @Override
    public void removeRenderChangeListener(RenderChangeListener l) {
        this.listener.remove(RenderChangeListener.class, l);
    }

    @Override
    public void addRenderChangeListener(RenderChangeListener l) {
        Object[] ls = this.listener.getListenerList();
        boolean found = false;
        int i = ls.length - 1;
        while (i >= 1) {
            if (ls[i] == l) {
                found = true;
                break;
            }
            i -= 2;
        }
        if (!found) {
            this.listener.add(RenderChangeListener.class, l);
        }
    }

    @Override
    public void clearRenderChangeListeners() {
        this.listener = new EventListenerList();
    }

    protected boolean isDifferentBounds(Rectangle nb) {
        Rectangle cb = this.getBounds();
        if (cb == nb) {
            return false;
        }
        return !cb.equals(nb);
    }
}

