/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.model.threedimensional;

import com.approximatrix.charting.model.threedimensional.ColorDotPlotDataModel;
import com.approximatrix.charting.render.colorscale.ColorScale;

public class ColorScaleDotPlotDataModel
extends ColorDotPlotDataModel {
    protected double[] z = null;
    protected double maxZ = 1.0;
    protected double minZ = 0.0;

    public ColorScaleDotPlotDataModel(double[] x, double[] y, double[] z, ColorScale scale) {
        super(x, y, scale.getColors(z));
        this.z = z;
        this.scanRanges();
    }

    public ColorScaleDotPlotDataModel(int[] x, int[] y, int[] z, ColorScale scale) {
        super(x, y, scale.getColors(z));
        this.z = this.toDouble(z);
        this.scanRanges();
    }

    public ColorScaleDotPlotDataModel(int[] x, int[] y, double[] z, ColorScale scale) {
        super(x, y, scale.getColors(z));
        this.z = z;
        this.scanRanges();
    }

    public ColorScaleDotPlotDataModel(double[] x, double[] y, int[] z, ColorScale scale) {
        super(x, y, scale.getColors(z));
        this.z = this.toDouble(z);
        this.scanRanges();
    }

    private double[] toDouble(int[] z) {
        if (z == null) {
            return null;
        }
        double[] ret = new double[z.length];
        int i = 0;
        while (i < ret.length) {
            ret[i] = z[i];
            ++i;
        }
        return ret;
    }

    protected void scanRanges() {
        super.scanRanges(this.x, this.y);
        int i = 0;
        while (i < this.z.length) {
            this.maxZ = Math.max(this.maxZ, this.z[i]);
            this.minZ = Math.min(this.minZ, this.z[i]);
            ++i;
        }
    }
}

