/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting;

import com.approximatrix.charting.render.AbstractRenderer;
import com.approximatrix.charting.render.RowColorModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;

public class Legend
extends AbstractRenderer {
    protected int inner_margin = 5;
    protected int color_text_spacing = 10;
    protected Font font = new Font("Helvetica", 0, 14);
    protected Rectangle colorbox = new Rectangle(25, 15);
    protected RowColorModel rcm;

    public Legend() {
    }

    public Legend(RowColorModel rcm) {
        this.setRowColorModel(rcm);
    }

    public void setRowColorModel(RowColorModel rcm) {
        this.rcm = rcm;
        super.fireRenderChangeEvent();
    }

    public RowColorModel getRowColorModel() {
        return this.rcm;
    }

    public void setColorBox(Rectangle r) {
        this.colorbox = r;
        super.fireRenderChangeEvent();
    }

    public Rectangle getColorBox() {
        return this.colorbox;
    }

    public void setFont(Font f) {
        this.font = f;
        super.fireRenderChangeEvent();
    }

    public Font getFont() {
        return this.font;
    }

    @Override
    public Dimension getPreferredSize() {
        RowColorModel rcm = this.getRowColorModel();
        int maxTitleWidth = 0;
        int titleHeight = 0;
        titleHeight = (int)this.getFont().getMaxCharBounds(new FontRenderContext(null, true, false)).getHeight();
        int i = 0;
        while (i < rcm.getRowCount()) {
            TextLayout layout = new TextLayout(rcm.getRow(i), this.getFont(), new FontRenderContext(null, true, false));
            maxTitleWidth = (int)Math.max((double)maxTitleWidth, layout.getBounds().getWidth());
            ++i;
        }
        return new Dimension((int)((double)(2 * this.inner_margin + this.color_text_spacing) + this.getColorBox().getWidth() + (double)maxTitleWidth), Math.max(titleHeight, (int)this.getColorBox().getHeight()) * rcm.getRowCount() + (rcm.getRowCount() + 1) * this.inner_margin);
    }

    @Override
    public void paintDefault(Graphics2D g) {
        RowColorModel rcm = this.getRowColorModel();
        int height = Integer.MIN_VALUE;
        int fontheight = (int)this.getFont().getMaxCharBounds(g.getFontRenderContext()).getHeight();
        height = (int)Math.max((double)fontheight, this.getColorBox().getHeight());
        int startx = this.inner_margin;
        int starty = this.inner_margin;
        Rectangle colorBox = this.getColorBox();
        int i = 0;
        while (i < rcm.getRowCount()) {
            colorBox.setLocation(startx, starty);
            g.setColor(rcm.getColor(i));
            g.fill(colorBox);
            g.setColor(Color.black);
            TextLayout layout = new TextLayout(rcm.getRow(i), this.getFont(), new FontRenderContext(null, true, false));
            layout.draw(g, startx + (int)colorBox.getWidth() + this.color_text_spacing, starty + (int)colorBox.getHeight());
            starty = starty + height + this.inner_margin;
            ++i;
        }
    }
}

