/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting;

import com.approximatrix.charting.AbstractChart;
import com.approximatrix.charting.Legend;
import com.approximatrix.charting.Title;
import com.approximatrix.charting.coordsystem.ClassicCoordSystem;
import com.approximatrix.charting.coordsystem.CoordSystem;
import com.approximatrix.charting.coordsystem.CoordSystemUtilities;
import com.approximatrix.charting.event.ChartDataModelEvent;
import com.approximatrix.charting.event.ChartDataModelListener;
import com.approximatrix.charting.event.RenderChangeEvent;
import com.approximatrix.charting.event.RenderChangeListener;
import com.approximatrix.charting.model.ChartDataModel;
import com.approximatrix.charting.render.AbstractChartRenderer;
import com.approximatrix.charting.render.Renderer;
import com.approximatrix.charting.render.RowColorModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class BufferedChart
extends AbstractChart
implements RenderChangeListener,
ChartDataModelListener {
    public static int LINEAR_X_LINEAR_Y = 0;
    public static int NO_COORDINATE_SYSTEM = 1;
    private static final Class DEFAULT_COORDSYS = ClassicCoordSystem.class;
    private static final boolean DEBUG_CHART = false;
    protected String render_message = "Rendering...";
    protected Font font = new Font("Helvetica", 0, 22);
    private RenderThread rt = null;
    private BufferedImage buffer = null;
    private BufferedImage drawbuffer = null;
    private boolean redraw = true;
    private boolean enableBuffering = true;

    protected BufferedChart() {
    }

    public BufferedChart(ChartDataModel model, String title) {
        this();
        this.setChartDataModel(model);
        this.setRowColorModel(new RowColorModel(model));
        this.setLegend(new Legend(this.getRowColorModel()));
        this.setTitle(new Title(title));
        this.initialize();
    }

    public BufferedChart(ChartDataModel model, String title, int coord) {
        this(model, title);
        if (coord == LINEAR_X_LINEAR_Y) {
            this.setCoordSystem(CoordSystemUtilities.BuildDefaultCoordSystem(model));
        }
        this.initialize();
    }

    public BufferedChart(ChartDataModel model, String title, int coord, String xaxis, String yaxis) {
        this(model, title, coord);
        this.getCoordSystem().setXAxisUnit(xaxis);
        this.getCoordSystem().setYAxisUnit(yaxis);
        this.initialize();
    }

    private void initialize() {
        this.assignListeners();
        this.setBounds(new Rectangle(1, 1));
        this.initBuffer();
    }

    private void assignListeners() {
        ArrayList<Renderer> components = new ArrayList<Renderer>();
        components.add(this.legend);
        components.add(this.coord);
        components.add(this.title);
        Collection<AbstractChartRenderer> chartrenderers = this.getChartRenderer().values();
        components.addAll(chartrenderers);
        for (Renderer comp : components) {
            if (comp == null) continue;
            comp.addRenderChangeListener(this);
        }
        for (AbstractChartRenderer cr : chartrenderers) {
            if (cr == null || cr.getChartDataModel() == null) continue;
            cr.getChartDataModel().addChartDataModelListener(this);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return null;
    }

    private void initBuffer() {
        this.buffer = this.createBuffer();
        this.drawNotification();
    }

    private BufferedImage createBuffer() {
        int w = 1;
        int h = 1;
        if (this.getBounds() != null) {
            w = (int)this.getBounds().getWidth();
            h = (int)this.getBounds().getHeight();
        }
        return new BufferedImage(w, h, 1);
    }

    private boolean invalidBuffer() {
        if (this.buffer == null) {
            return true;
        }
        if (this.getBounds() == null) {
            return true;
        }
        return this.buffer.getWidth() != (int)this.getBounds().getWidth() || this.buffer.getHeight() != (int)this.getBounds().getHeight();
    }

    public void setBuffering(boolean value) {
        this.enableBuffering = value;
    }

    public boolean isBuffering() {
        return this.enableBuffering;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font newfont) {
        this.font = newfont;
    }

    public String getRenderMessage() {
        return this.render_message;
    }

    public void setRenderMessage(String value) {
        if (value != null) {
            this.render_message = value;
        }
    }

    public void notifyDisplayReady(boolean success) {
        if (success) {
            this.buffer = this.drawbuffer;
            this.drawbuffer = null;
        } else {
            this.redraw = true;
        }
        this.fireRenderChangeEvent();
    }

    @Override
    public void render(Graphics2D g) {
        if (this.invalidBuffer()) {
            this.initBuffer();
            this.redraw = true;
        }
        if (this.enableBuffering) {
            if (this.redraw) {
                this.drawbuffer = this.createBuffer();
                if (this.rt != null) {
                    if (this.rt.isAlive()) {
                        this.rt.stopRender();
                        try {
                            this.rt.join();
                        }
                        catch (InterruptedException ie) {
                            System.err.println("Rendering Thread Join Failed!");
                            ie.printStackTrace();
                        }
                    }
                    this.rt = null;
                }
                this.rt = new RenderThread(this.drawbuffer, this);
                this.rt.start();
            }
            this.redraw = false;
            this.drawBufferImage(g);
        } else {
            this.drawChart(g);
        }
    }

    private void drawNotification() {
        Graphics2D g = this.buffer.createGraphics();
        int width = (int)this.getBounds().getWidth();
        int height = (int)this.getBounds().getHeight();
        g.setColor(Color.white);
        g.fillRect(0, 0, width, height);
        g.setColor(Color.gray);
        TextLayout layout = new TextLayout(this.getRenderMessage(), this.getFont(), new FontRenderContext(null, true, false));
        Rectangle2D tb = layout.getBounds();
        layout.draw(g, (float)(((double)width - tb.getWidth()) / 2.0), (float)(((double)height - tb.getHeight()) / 2.0));
    }

    private void drawBufferImage(Graphics2D g) {
        g.drawImage((Image)this.buffer, 0, 0, null);
    }

    public void drawChart(Graphics2D g) {
        int width = (int)this.getBounds().getWidth();
        int height = (int)this.getBounds().getHeight();
        Title t = this.getTitle();
        Legend l = this.getLegend();
        CoordSystem c = this.getCoordSystem();
        Collection<AbstractChartRenderer> renderer = this.getChartRenderer().values();
        for (AbstractChartRenderer cr : renderer) {
            cr.resetStopFlag();
        }
        g.setColor(Color.white);
        g.fillRect(0, 0, width, height);
        g.setColor(Color.black);
        int titleheight = 20;
        int legendwidth = 30;
        if (t != null) {
            Dimension title = t.getPreferredSize();
            t.setBounds(new Rectangle(width / 2 - (int)(title.getWidth() / 2.0), 0, (int)title.getWidth(), (int)title.getHeight()));
            t.render(g);
            titleheight = (int)t.getBounds().getHeight();
        }
        if (l != null) {
            Dimension legend = l.getPreferredSize();
            l.setBounds(new Rectangle((int)((double)width - legend.getWidth()), (int)((double)(height / 2) - legend.getHeight() / 2.0 + (double)titleheight), (int)legend.getWidth(), (int)legend.getHeight()));
            l.render(g);
            legendwidth = (int)l.getBounds().getWidth();
        }
        if (c != null) {
            c.setBounds(new Rectangle(0, titleheight, width - legendwidth, height - titleheight));
        }
        for (AbstractChartRenderer cr : renderer) {
            cr.setBounds(c.getInnerBounds());
            cr.render(g);
        }
        if (c != null) {
            c.render(g);
        }
    }

    @Override
    public void renderUpdateRequested(RenderChangeEvent evt) {
        this.redraw = true;
        this.fireRenderChangeEvent();
    }

    @Override
    public void chartDataChanged(ChartDataModelEvent evt) {
        this.redraw = true;
        this.fireRenderChangeEvent();
    }

    @Override
    public void addChartRenderer(AbstractChartRenderer render, int z) {
        super.addChartRenderer(render, z);
        this.assignListeners();
        this.redraw = true;
        this.fireRenderChangeEvent();
    }

    @Override
    public void setChartRenderer(Map render) {
        super.setChartRenderer(render);
        this.assignListeners();
        this.redraw = true;
        this.fireRenderChangeEvent();
    }

    @Override
    public void setCoordSystem(CoordSystem c) {
        super.setCoordSystem(c);
        this.assignListeners();
        this.redraw = true;
        this.fireRenderChangeEvent();
    }

    @Override
    public void setLegend(Legend l) {
        super.setLegend(l);
        this.assignListeners();
        this.redraw = true;
        this.fireRenderChangeEvent();
    }

    @Override
    public void setTitle(Title t) {
        super.setTitle(t);
        this.assignListeners();
        this.redraw = true;
        this.fireRenderChangeEvent();
    }

    @Override
    public void setRowColorModel(RowColorModel rcm) {
        super.setRowColorModel(rcm);
        this.assignListeners();
        this.redraw = true;
        this.fireRenderChangeEvent();
    }

    @Override
    public void setChartDataModel(ChartDataModel model) {
        super.setChartDataModel(model);
        this.assignListeners();
        this.redraw = true;
        this.fireRenderChangeEvent();
    }

    private class RenderThread
    extends Thread {
        private volatile boolean renderingStoppped = false;
        private BufferedImage bi = null;
        private BufferedChart parent = null;

        public RenderThread(BufferedImage image, BufferedChart notify) {
            this.bi = image;
            this.parent = notify;
        }

        @Override
        public void run() {
            if (this.bi != null) {
                Graphics2D g = this.bi.createGraphics();
                this.parent.drawChart(g);
                if (!this.renderingStoppped) {
                    this.parent.notifyDisplayReady(true);
                }
            } else {
                this.parent.notifyDisplayReady(false);
            }
        }

        public void stopRender() {
            Collection<AbstractChartRenderer> renderer = this.parent.getChartRenderer().values();
            for (AbstractChartRenderer cr : renderer) {
                cr.interruptRendering();
            }
            this.renderingStoppped = true;
        }
    }
}

