/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting;

import com.approximatrix.charting.model.ChartDataModelConstraints;

public class Axis {
    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 2;
    public static final int LOGARITHMIC = 3;
    public static final int LINEAR = 4;
    private int align = 1;
    ChartDataModelConstraints constraints;
    int length = Integer.MAX_VALUE;

    public Axis(int align, ChartDataModelConstraints c) {
        if (align == 1 || align == 2) {
            this.align = align;
        }
        this.constraints = c;
    }

    public int getAlignment() {
        return this.align;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getLength() {
        return this.length;
    }

    public double getPixelForValue(double value) {
        try {
            double ptpr = this.getPointToPixelRatio();
            if (ptpr != 0.0) {
                if (this.getAlignment() == 2) {
                    return (value - this.constraints.getMinimumY().doubleValue()) / ptpr;
                }
                return (value - this.constraints.getMinimumX().doubleValue()) / ptpr;
            }
            return 0.0;
        }
        catch (NullPointerException npe) {
            return 0.0;
        }
    }

    public double getPointToPixelRatio() {
        try {
            if (this.getAlignment() == 2) {
                return (this.constraints.getMaximumY().doubleValue() - this.constraints.getMinimumY().doubleValue()) / (double)this.length;
            }
            return (this.constraints.getMaximumX().doubleValue() - this.constraints.getMinimumX().doubleValue()) / (double)this.length;
        }
        catch (NullPointerException npe) {
            if ((double)this.length != 0.0) {
                return 1.0 / (double)this.length;
            }
            return 0.0;
        }
    }
}

