#!/usr/bin/perl -w
package AlinePlugin;

@magicvars=([1,'$cfg'],
	    [1,'$seq'],
	    [1,'$par'],
	    [1,'$mw'],
	    [1,'$cats'],
	    [1,'$draginfo'],
	    [1,'$cursor'],
            [1,'$canvas'],
	    [1,'$proginfo'],
	    [0,'@bindings'],
	    [0,'$priority'],
);

#--------------------------------------------------------------------------------------

sub import
{   local $_; my $sym; my $c=caller();
    foreach $sym (@magicvars) {
	my $dummy='';
	$_=$sym->[1]; s/^(.)//;
	*{"${c}::$_"}=(($1 eq '$')?\$dummy:(($1 eq '%')?{}:[]));
    }
}

sub new(@) # \%cfg, \@seq, \%par, $mw, \@categories
{   local $_; my ($sym,$q); my $c=shift; my $self={}; bless $self,$c;

    foreach $sym (@magicvars) { if ($sym->[0]) {
	if (!@_) { return 'version mismatch - too few initializers'; }
	# Here we assume that new()-initialized magic vars are all scalar...
	$_=$sym->[1]; s/^.//; ${$c.'::'.$_}=shift @_;
    }}
    if (@_) { return 'invalid parameter count'; }
    return $self;
}

sub terminate
{   main::_UnloadPluginHelper($_[0]); return 0; }

sub id
{   return ref $_[0]; }

sub priority
{   return ${ref($_[0]).'::priority'} || 50; }

sub regbindings($$)
# type:
#    0  keyboard                    [keydesc,coderef]
#    1  'colouring' menu            [menuitem]
#    2  'tools' menu                [menuitem]
#    3  menubar                     [menu]
#    4  'edit' menu                 [menuitem]
#    5  action list                 [action_id,\@desc]
#    6  action hook                 [action_id or _early or _default,hook_code,coderef,late_hook?]
#    7  object type                 [object_id,\@desc,optionally buttonimage]
#    8  import filter               [filtername,\@extensions,coderef]
#    9  export filter               [filtername,\@extensions,coderef]
#   10  config variable             [var,defaultvalue,description]
#   11  private seq hash entry      [loc(0=main,1=t,2=e,3=oe),name]
#   12  scripting command           [coderef,name]
#   13  'file' menu                 [menuitem]
#
{   my ($i,$j); my @rv=(); my $bindings=\@{ref($_[0]).'::bindings'};
    foreach $i (@$bindings) {
	if ($i->[0]==$_[1]) { foreach $j (1..$#$i) { push @rv,$i->[$j]; } }
    }
    return(@rv);
}

1;
