/******************************************************************************/
/*  This plugin implements the 3D 27-point finite-difference stencil with     */
/*  optimized weights for the discretization of the Helmholtz equation from   */
/*                                                                            */
/*  Operto, S., Virieux, J., Amestoy, P., L’Excellent, J. Y., Giraud, L.,     */
/*  & Ali, H. B. H. (2007). 3D finite-difference frequency-domain modeling of */
/*  visco-acoustic wave propagation using a massively parallel direct solver: */
/*  A feasibility study. Geophysics, 72(5), SM195-SM211.                      */
/******************************************************************************/

#include "ff++.hpp"

double wtab[2752] = {
3.00,  0.697262824,  0.007167050,  0.015915025,  0.008594321,  0.307393283,  0.627489984,  0.065116704,
3.05,  0.628711581,  0.019996662,  0.020661540,  0.000421245,  0.196920782,  0.647126138,  0.155953109,
3.10,  0.702129424,  0.007504661,  0.015171047,  0.008848755,  0.301299810,  0.633790970,  0.064909220,
3.15,  0.597348213,  0.041101128,  0.008118212,  0.007328309,  0.093332671,  0.824724078,  0.081943274,
3.20,  0.661647201,  0.027431741,  0.006051943,  0.012642380,  0.182384640,  0.794680238,  0.022935152,
3.25,  0.590004981,  0.035895996,  0.015874669,  0.000515377,  0.099336565,  0.759529948,  0.141133487,
3.30,  0.684338808,  0.015859213,  0.012579773,  0.008693581,  0.233117074,  0.703543723,  0.063339174,
3.35,  0.669184208,  0.011757366,  0.020814210,  0.001312636,  0.247642487,  0.613769174,  0.138588309,
3.40,  0.605685830,  0.037952259,  0.010843948,  0.004559156,  0.106312215,  0.794963479,  0.098724306,
3.45,  0.577374458,  0.051351979,  0.004654191,  0.007332921,  0.049069352,  0.873899043,  0.077031612,
3.50,  0.730903447,  0.008098722,  0.009822279,  0.012829609,  0.288530648,  0.673810482,  0.037658870,
3.55,  0.732483745,  0.009664774,  0.008094728,  0.014048859,  0.271239400,  0.705184042,  0.023576558,
3.60,  0.549728930,  0.054577745,  0.009134758,  0.001648435,  0.037431475,  0.838261247,  0.124307275,
3.65,  0.588351130,  0.043233294,  0.011057518,  0.002444860,  0.092888221,  0.790881932,  0.116229832,
3.70,  0.593093634,  0.045007516,  0.008323755,  0.004622025,  0.089279830,  0.814085007,  0.096635163,
3.75,  0.705916226,  0.023702361,  0.001588978,  0.016600234,  0.207035929,  0.783495188,  0.009468913,
3.80,  0.644065440,  0.033188105,  0.007746205,  0.007981434,  0.152613044,  0.772635043,  0.074751914,
3.85,  0.686284721,  0.022006951,  0.008582693,  0.009835158,  0.199806958,  0.739966452,  0.060226619,
3.90,  0.723992169,  0.011347204,  0.009974223,  0.011029242,  0.241037920,  0.706667662,  0.052294433,
3.95,  0.740161359,  0.010516703,  0.006949648,  0.014167830,  0.250821084,  0.716488242,  0.032690644,
4.00,  0.642623544,  0.039591655,  0.002390578,  0.011392448,  0.130669326,  0.820143163,  0.049187481,
4.05,  0.751542628,  0.013616130,  0.001332268,  0.018846672,  0.239774108,  0.758091807,  0.002134085,
4.10,  0.661690295,  0.024728056,  0.012804141,  0.004536461,  0.177133024,  0.727850020,  0.095016956,
4.15,  0.705562830,  0.019282497,  0.007421181,  0.011211002,  0.205830038,  0.740188360,  0.053981602,
4.20,  0.705840707,  0.019233696,  0.007550273,  0.011019230,  0.204900950,  0.739971042,  0.055127978,
4.25,  0.739306688,  0.015376367,  0.003157761,  0.016317748,  0.224924207,  0.749649525,  0.025426269,
4.30,  0.739022791,  0.014730528,  0.004004352,  0.015567727,  0.226050586,  0.742380440,  0.031568944,
4.35,  0.709601521,  0.021181472,  0.005025975,  0.012874743,  0.197820157,  0.756129682,  0.046050131,
4.40,  0.669521511,  0.030052802,  0.006280851,  0.009348935,  0.167438671,  0.764807403,  0.067753911,
4.45,  0.728317499,  0.012321327,  0.009424124,  0.010583131,  0.221986711,  0.716708302,  0.061304986,
4.50,  0.672598481,  0.025759801,  0.010038640,  0.006547378,  0.177590564,  0.739277303,  0.083132148,
4.55,  0.637889147,  0.032052111,  0.012512553,  0.002455944,  0.157799035,  0.735930085,  0.106270909,
4.60,  0.679027796,  0.019366715,  0.015022421,  0.003062855,  0.189626575,  0.710654736,  0.099718690,
4.65,  0.755430341,  0.002795290,  0.012594124,  0.009583555,  0.242896020,  0.689434111,  0.067669868,
4.70,  0.735527098,  0.009054719,  0.011400590,  0.009167189,  0.223600373,  0.706640780,  0.069758832,
4.75,  0.685611308,  0.024061970,  0.008955622,  0.007818676,  0.184873581,  0.736821055,  0.078305364,
4.80,  0.661247611,  0.027647898,  0.011559054,  0.004269544,  0.168490216,  0.738675535,  0.092834234,
4.85,  0.649699926,  0.038785405,  0.003384510,  0.009621690,  0.145459771,  0.786229610,  0.068310618,
4.90,  0.600613177,  0.043000001,  0.011522740,  0.000389241,  0.128073946,  0.761512101,  0.110413969,
4.95,  0.731156349,  0.010320447,  0.011637069,  0.008409517,  0.216091290,  0.708488405,  0.075420320,
5.00,  0.643246651,  0.035132140,  0.008888522,  0.004912280,  0.153290153,  0.756346762,  0.090363085,
5.05,  0.718462586,  0.023937641,  0.001353388,  0.015208865,  0.189178646,  0.763775110,  0.047046244,
5.10,  0.728470743,  0.006253866,  0.016604763,  0.004343614,  0.218121752,  0.690121174,  0.091757059,
5.15,  0.677486539,  0.027201064,  0.008469470,  0.007209180,  0.175213560,  0.743366539,  0.081419885,
5.20,  0.736674428,  0.007843078,  0.013100819,  0.007382160,  0.216894522,  0.702840269,  0.080265224,
5.25,  0.730766773,  0.001002725,  0.021477260,  0.000686221,  0.225052625,  0.668507040,  0.106440365,
5.30,  0.686039031,  0.024262933,  0.009459300,  0.006858972,  0.181184858,  0.735759377,  0.083055735,
5.35,  0.720685959,  0.006757588,  0.018372390,  0.002287479,  0.213174522,  0.687094331,  0.099731147,
5.40,  0.643997490,  0.035632249,  0.008720243,  0.004695763,  0.155371577,  0.753929377,  0.090699077,
5.45,  0.593268335,  0.055888854,  0.001214772,  0.007102661,  0.115290038,  0.804074764,  0.080635190,
5.50,  0.716838837,  0.005793421,  0.020465158,  0.000352343,  0.212645128,  0.680675685,  0.106679201,
5.55,  0.697915971,  0.022620669,  0.008426502,  0.008155249,  0.181773081,  0.741187036,  0.077039897,
5.60,  0.592262268,  0.050731108,  0.006785112,  0.002741219,  0.126978710,  0.776069999,  0.096951306,
5.65,  0.734041989,  0.003035368,  0.019082792,  0.002344036,  0.215238228,  0.687019885,  0.097741902,
5.70,  0.556647241,  0.063052624,  0.003463144,  0.002934910,  0.107175194,  0.796392262,  0.096432567,
5.75,  0.710051417,  0.016367614,  0.011842607,  0.006203953,  0.193122923,  0.721730053,  0.085147023,
5.80,  0.706029475,  0.012037156,  0.017226923,  0.001878064,  0.196718752,  0.704768419,  0.098512828,
5.85,  0.654612601,  0.036256686,  0.005908306,  0.007118452,  0.158143133,  0.759888172,  0.081968665,
5.90,  0.638387680,  0.045784108,  0.000482990,  0.010138975,  0.145752400,  0.780688822,  0.073558748,
5.95,  0.765625477,  0.009006737,  0.005495900,  0.014297913,  0.209866196,  0.729331076,  0.060802758,
6.00,  0.644492924,  0.038544871,  0.006277613,  0.006113311,  0.156966522,  0.756561697,  0.086471796,
6.05,  0.699514270,  0.014493953,  0.016615160,  0.001767512,  0.191459492,  0.710442722,  0.098097801,
6.10,  0.735310376,  0.000916126,  0.021286702,  0.000469059,  0.213263273,  0.684441924,  0.102294803,
6.15,  0.737085044,  0.019869011,  0.001928771,  0.015069457,  0.193129137,  0.745510876,  0.061360002,
6.20,  0.635766864,  0.033920370,  0.013246342,  0.000219352,  0.160126776,  0.737914145,  0.101959050,
6.25,  0.694312274,  0.017446823,  0.015117271,  0.002449943,  0.185918257,  0.718855798,  0.095225930,
6.30,  0.716026843,  0.015522248,  0.011648934,  0.006381558,  0.190181285,  0.725651085,  0.084167659,
6.35,  0.725953043,  0.008335987,  0.016386669,  0.003423875,  0.200004071,  0.707276762,  0.092719138,
6.40,  0.671939135,  0.030642044,  0.007625898,  0.006587229,  0.170570269,  0.744471550,  0.084958196,
6.45,  0.731507123,  0.006026622,  0.017375994,  0.002977652,  0.205093756,  0.699757218,  0.095149040,
6.50,  0.775374591,  0.009834517,  0.002630318,  0.016756810,  0.205848545,  0.734423161,  0.059728265,
6.55,  0.737466514,  0.001978302,  0.020002356,  0.001329426,  0.208096489,  0.693314075,  0.098589420,
6.60,  0.724905312,  0.007886129,  0.017260177,  0.002581974,  0.201022938,  0.703096569,  0.095880508,
6.65,  0.642845452,  0.031919204,  0.013781587,  0.000032535,  0.163961738,  0.736084521,  0.099953711,
6.70,  0.627521098,  0.039608911,  0.009952100,  0.001925030,  0.155569673,  0.748877347,  0.095552981,
6.75,  0.727513790,  0.021901295,  0.002691241,  0.013597943,  0.186210811,  0.745026588,  0.068762600,
6.80,  0.736520290,  0.021667169,  0.000693249,  0.015644714,  0.189341038,  0.745036721,  0.065622211,
6.85,  0.703413725,  0.026231050,  0.004436190,  0.010745712,  0.180602312,  0.742578208,  0.076819479,
6.90,  0.707485795,  0.029000759,  0.000674026,  0.013802667,  0.176528722,  0.754408419,  0.069062889,
6.95,  0.683170557,  0.019828230,  0.015959816,  0.000792783,  0.180165887,  0.722622693,  0.097211421,
7.00,  0.741733968,  0.000309452,  0.020857314,  0.000765193,  0.205371931,  0.696482182,  0.098145902,
7.05,  0.733277380,  0.018847374,  0.004457326,  0.012518808,  0.189332068,  0.737355947,  0.073311985,
7.10,  0.686947584,  0.020329216,  0.014589685,  0.002000112,  0.181159586,  0.723943591,  0.094896793,
7.15,  0.763238966,  0.008346494,  0.007512387,  0.012066679,  0.201269120,  0.723774552,  0.074956298,
7.20,  0.755818844,  0.016949568,  0.000800188,  0.016610187,  0.190597326,  0.745290041,  0.064112663,
7.25,  0.684460104,  0.033079147,  0.002528107,  0.010840966,  0.172526523,  0.749671519,  0.077801943,
7.30,  0.780553758,  0.005270217,  0.006330614,  0.013982195,  0.201851696,  0.728019595,  0.070128679,
7.35,  0.720273495,  0.017769041,  0.008928446,  0.008246363,  0.190375119,  0.725288272,  0.084336638,
7.40,  0.691181540,  0.033674657,  0.000313735,  0.012875712,  0.170473114,  0.756505847,  0.073021054,
7.45,  0.724639952,  0.017434690,  0.008219006,  0.009015479,  0.185226962,  0.734799385,  0.079973638,
7.50,  0.650077581,  0.035191968,  0.009118620,  0.003668396,  0.170341194,  0.736124039,  0.093534768,
7.55,  0.698249280,  0.018233035,  0.014053045,  0.002964497,  0.182294697,  0.725737393,  0.091967881,
7.60,  0.732726693,  0.003651323,  0.020039063,  0.000612076,  0.198038265,  0.704833031,  0.097128689,
7.65,  0.785859823,  0.010407180,  0.000015683,  0.018938612,  0.203314006,  0.730436444,  0.066249549,
7.70,  0.592862785,  0.049690478,  0.009004613,  0.000117376,  0.144601583,  0.761113882,  0.094284534,
7.75,  0.605973721,  0.051153421,  0.004281623,  0.004465784,  0.155343205,  0.752932906,  0.091723919,
7.80,  0.789317489,  0.002593447,  0.007029239,  0.013846369,  0.205384582,  0.720143259,  0.074472129,
7.85,  0.706174791,  0.016937090,  0.013491407,  0.003788223,  0.182299182,  0.728245080,  0.089455724,
7.90,  0.666150868,  0.038350385,  0.002098883,  0.009820030,  0.162583888,  0.759026945,  0.078389168,
7.95,  0.799540281,  0.003311466,  0.003811127,  0.016857177,  0.200973064,  0.731083333,  0.067943633,
8.00,  0.680162311,  0.022954039,  0.014026556,  0.001724347,  0.172286659,  0.736675143,  0.091038227,
8.05,  0.759831607,  0.004041791,  0.013042748,  0.007425584,  0.194693774,  0.722206652,  0.083099544,
8.10,  0.718426704,  0.026699424,  0.000747219,  0.014051266,  0.178020686,  0.748722494,  0.073256791,
8.15,  0.651540279,  0.037407469,  0.006764994,  0.005354373,  0.165006176,  0.747445941,  0.087547898,
8.20,  0.614697039,  0.043270975,  0.010134578,  0.000507772,  0.162323758,  0.740480542,  0.097195685,
8.25,  0.625735939,  0.049280617,  0.001384329,  0.007746050,  0.159123883,  0.755485237,  0.085390866,
8.30,  0.725445449,  0.019521395,  0.006236922,  0.010322889,  0.184575632,  0.734737873,  0.080686510,
8.35,  0.653648674,  0.039499819,  0.004212866,  0.007349753,  0.161582902,  0.755483210,  0.082933903,
8.40,  0.697551310,  0.032635413,  0.000126698,  0.013139479,  0.174316034,  0.749188185,  0.076495767,
8.45,  0.756601036,  0.007870061,  0.010133540,  0.009322015,  0.195246026,  0.721213520,  0.083540440,
8.50,  0.686896741,  0.019905558,  0.015535688,  0.000905208,  0.182542026,  0.721521914,  0.095936060,
8.55,  0.692634821,  0.028701732,  0.005328579,  0.008901480,  0.168360725,  0.752613902,  0.079025388,
8.60,  0.709603131,  0.025053587,  0.004741546,  0.010397101,  0.176766813,  0.743414402,  0.079818785,
8.65,  0.562588334,  0.062730834,  0.003832389,  0.001879750,  0.144731358,  0.763089716,  0.092178941,
8.70,  0.709370255,  0.015403642,  0.014482113,  0.003052816,  0.176666811,  0.736030579,  0.087302625,
8.75,  0.567155123,  0.058938250,  0.006502643,  0.000147957,  0.153613403,  0.748631060,  0.097755551,
8.80,  0.757969081,  0.005018137,  0.012737557,  0.007383926,  0.196088552,  0.717094302,  0.086817145,
8.85,  0.637681782,  0.041443706,  0.006406926,  0.004596610,  0.167452842,  0.742133498,  0.090413690,
8.90,  0.696166277,  0.022483753,  0.010752261,  0.004988009,  0.171393678,  0.744028687,  0.084577620,
8.95,  0.641492724,  0.038330950,  0.008586541,  0.003185386,  0.164259881,  0.746261537,  0.089478552,
9.00,  0.744261920,  0.014480891,  0.006752837,  0.010977335,  0.185281217,  0.734718859,  0.079999924,
9.05,  0.604861915,  0.054672804,  0.001425516,  0.006249385,  0.154924199,  0.758761585,  0.086314201,
9.10,  0.734394789,  0.011045747,  0.012673132,  0.005906643,  0.182829916,  0.732042849,  0.085127234,
9.15,  0.627262056,  0.046458948,  0.004051410,  0.005670916,  0.164540574,  0.746340811,  0.089118600,
9.20,  0.644625247,  0.042768665,  0.003425462,  0.007207151,  0.162356779,  0.753559232,  0.084083974,
9.25,  0.674772859,  0.029341169,  0.009332273,  0.004649106,  0.165553004,  0.750079751,  0.084367275,
9.30,  0.655452967,  0.033674210,  0.009829640,  0.003068261,  0.180664375,  0.723415256,  0.095920384,
9.35,  0.611765504,  0.053841263,  0.000584934,  0.007270964,  0.162311241,  0.749586463,  0.088102281,
9.40,  0.606882989,  0.054846037,  0.000811920,  0.006787218,  0.162672743,  0.748103857,  0.089223385,
9.45,  0.632426262,  0.038748465,  0.010535475,  0.001082156,  0.171522275,  0.732932031,  0.095545709,
9.50,  0.729691505,  0.020070985,  0.004907718,  0.011373746,  0.187783867,  0.728058815,  0.084157348,
9.55,  0.670830190,  0.033085611,  0.006625537,  0.006393714,  0.175327137,  0.736235499,  0.088437378,
9.60,  0.687369466,  0.034159482,  0.001422087,  0.011326076,  0.172774851,  0.745992362,  0.081232786,
9.65,  0.731532156,  0.006324587,  0.018232957,  0.001465606,  0.182184324,  0.728429914,  0.089385748,
9.70,  0.647118330,  0.033703547,  0.011964437,  0.000885895,  0.167865753,  0.740575910,  0.091558337,
9.75,  0.720653296,  0.013443928,  0.013856275,  0.004050981,  0.176564664,  0.737988055,  0.085447252,
9.80,  0.733275950,  0.005911957,  0.018226840,  0.001566280,  0.203884900,  0.695576549,  0.100538552,
9.85,  0.560077786,  0.063379243,  0.004070256,  0.001350461,  0.144632742,  0.766947985,  0.088419259,
9.90,  0.762389541,  0.009851214,  0.007040165,  0.011752650,  0.180735469,  0.741924822,  0.077339709,
9.95,  0.724952698,  0.014183916,  0.012079667,  0.005623475,  0.172745883,  0.745286882,  0.081967235,
10.00,  0.798044562,  0.007615812,  0.000370339,  0.018977063,  0.180253074,  0.751583099,  0.068163812,
10.05,  0.707427442,  0.020877384,  0.009771857,  0.006255746,  0.173551977,  0.742345214,  0.084102809,
10.10,  0.714741707,  0.015042767,  0.013780370,  0.003704656,  0.178732216,  0.733217955,  0.088049829,
10.15,  0.796544731,  0.007786527,  0.000610150,  0.018676788,  0.189338237,  0.736833274,  0.073828518,
10.20,  0.752726078,  0.003241500,  0.016112743,  0.004309002,  0.186903670,  0.725375235,  0.087721109,
10.25,  0.600836337,  0.050188489,  0.007147860,  0.001532299,  0.166097417,  0.739989996,  0.093912601,
10.30,  0.624425650,  0.045098323,  0.006333862,  0.003622258,  0.155066222,  0.760279775,  0.084653974,
10.35,  0.622179627,  0.051377967,  0.000629879,  0.007749252,  0.176270604,  0.731271684,  0.092457712,
10.40,  0.687915444,  0.032495048,  0.003079327,  0.010020294,  0.189899549,  0.718322694,  0.091777742,
10.45,  0.510093689,  0.079129308,  0.000900544,  0.000540491,  0.157060981,  0.744453490,  0.098485529,
10.50,  0.775071323,  0.006995384,  0.006808441,  0.012656884,  0.198624194,  0.715105593,  0.086270213,
10.55,  0.759528875,  0.014222167,  0.003486849,  0.014161991,  0.191726848,  0.725146830,  0.083126307,
10.60,  0.671943724,  0.027052635,  0.012567002,  0.001867054,  0.156989917,  0.761320829,  0.081689239,
10.65,  0.735664845,  0.016404569,  0.007293276,  0.009798553,  0.177687928,  0.741255939,  0.081056118,
10.70,  0.687610447,  0.031170320,  0.004536416,  0.008866331,  0.163551867,  0.757252872,  0.079195261,
10.75,  0.674482584,  0.034131497,  0.004854865,  0.007808756,  0.160787880,  0.759333372,  0.079878747,
10.80,  0.713703215,  0.019295909,  0.009910833,  0.006448917,  0.187074989,  0.722675264,  0.090249717,
10.85,  0.666478634,  0.039197810,  0.001810361,  0.009576272,  0.193670183,  0.710409224,  0.095920622,
10.90,  0.538286209,  0.070543654,  0.002511822,  0.001038749,  0.170275599,  0.728904247,  0.100820184,
10.95,  0.722132862,  0.019914761,  0.007202789,  0.008993138,  0.179133967,  0.736895561,  0.083970487,
11.00,  0.775188446,  0.002110202,  0.011726528,  0.008928999,  0.179489613,  0.740018725,  0.080491662,
11.05,  0.660312831,  0.034631196,  0.007956591,  0.004552612,  0.164969057,  0.750347555,  0.084683359,
11.10,  0.570146918,  0.064826190,  0.000298418,  0.004664365,  0.154196918,  0.759139419,  0.086663663,
11.15,  0.763172686,  0.010062631,  0.006793454,  0.011866260,  0.185430080,  0.731678963,  0.082890987,
11.20,  0.714733124,  0.023543930,  0.005441414,  0.009838291,  0.169459432,  0.750653207,  0.079887331,
11.25,  0.604502499,  0.054907538,  0.001629133,  0.005812833,  0.176099509,  0.729095876,  0.094804585,
11.30,  0.641456842,  0.041145757,  0.006178096,  0.004691433,  0.161805794,  0.753731728,  0.084462464,
11.35,  0.728042305,  0.011284340,  0.014400549,  0.003930632,  0.206198439,  0.692909837,  0.100891709,
11.40,  0.771990716,  0.006124873,  0.008567598,  0.011056108,  0.211238742,  0.692720175,  0.096041083,
11.45,  0.741813183,  0.018255446,  0.003990404,  0.012596160,  0.170166343,  0.753319442,  0.076514184,
11.50,  0.653191566,  0.034932330,  0.009476501,  0.002937054,  0.183023959,  0.721411407,  0.095564663,
11.55,  0.664150715,  0.037255630,  0.004418969,  0.007410984,  0.183044419,  0.725021720,  0.091933846,
11.60,  0.758137107,  0.010300789,  0.007876605,  0.010692362,  0.161637321,  0.766097665,  0.072265029,
11.65,  0.697066844,  0.027567523,  0.005878599,  0.008373103,  0.193790779,  0.711349308,  0.094859898,
11.70,  0.664852500,  0.035381313,  0.006123699,  0.006171905,  0.167638406,  0.747312129,  0.085049450,
11.75,  0.730120420,  0.022711206,  0.002495445,  0.012958374,  0.180838555,  0.736388803,  0.082772613,
11.80,  0.706266522,  0.013552571,  0.017629609,  0.000107843,  0.182957873,  0.724156797,  0.092885315,
11.85,  0.675682306,  0.029335268,  0.009470142,  0.004333047,  0.186431378,  0.718340933,  0.095227659,
11.90,  0.604786634,  0.053452924,  0.003083225,  0.004687140,  0.164481729,  0.746950388,  0.088567853,
11.95,  0.692369878,  0.020273544,  0.014371768,  0.001690956,  0.161582887,  0.755657673,  0.082759440,
12.00,  0.694708109,  0.024061449,  0.010019578,  0.005086033,  0.196226329,  0.705950379,  0.097823262,
12.05,  0.732194602,  0.018152002,  0.006576806,  0.009996463,  0.162121847,  0.762985051,  0.074893117,
12.10,  0.704596221,  0.024311692,  0.007303685,  0.007736176,  0.176067069,  0.738277316,  0.085655630,
12.15,  0.656632245,  0.032063607,  0.011563718,  0.001527686,  0.182731122,  0.722112954,  0.095155895,
12.20,  0.657639384,  0.030910037,  0.012439933,  0.000952650,  0.170832738,  0.739240587,  0.089926660,
12.25,  0.660332799,  0.042318996,  0.000362214,  0.010175833,  0.201920643,  0.697218537,  0.100860834,
12.30,  0.651309133,  0.035345394,  0.009614673,  0.002655303,  0.154171154,  0.765324533,  0.080504298,
12.35,  0.725657940,  0.007373217,  0.019000620,  0.000261914,  0.150716364,  0.773906052,  0.075377584,
12.40,  0.568968117,  0.064499371,  0.001060508,  0.003913697,  0.176366925,  0.727344036,  0.096289039,
12.45,  0.744530499,  0.012033693,  0.009616859,  0.008483129,  0.191205174,  0.718115389,  0.090679467,
12.50,  0.741482973,  0.020216513,  0.002212025,  0.013834205,  0.212230474,  0.689047694,  0.098721862,
12.55,  0.614267528,  0.046104338,  0.008125730,  0.001449712,  0.135747001,  0.789840996,  0.074411988,
12.60,  0.567347109,  0.064327240,  0.001639552,  0.003376853,  0.132098824,  0.793565631,  0.074335575,
12.65,  0.673445702,  0.031689785,  0.007764861,  0.005404657,  0.184797153,  0.721658289,  0.093544543,
12.70,  0.652556658,  0.039481007,  0.005214557,  0.005997827,  0.140404761,  0.788059235,  0.071536005,
12.75,  0.725125432,  0.019086789,  0.007456597,  0.008859335,  0.192517981,  0.715334713,  0.092147291,
12.80,  0.661961317,  0.036234725,  0.006078526,  0.005961001,  0.193772078,  0.707414925,  0.098812997,
12.85,  0.642713308,  0.040332936,  0.006833710,  0.004160570,  0.175249681,  0.734277964,  0.090472341,
12.90,  0.738380969,  0.022402726,  0.000840865,  0.014639037,  0.181741714,  0.734712362,  0.083545923,
12.95,  0.704517722,  0.029127352,  0.002580315,  0.011219298,  0.192632750,  0.714637876,  0.092729390,
13.00,  0.630471587,  0.042491749,  0.007730529,  0.002726447,  0.201483369,  0.692733884,  0.105782747,
13.05,  0.710673630,  0.013418403,  0.016751640,  0.000974536,  0.182054922,  0.725996017,  0.091949046,
13.10,  0.614334285,  0.047275580,  0.006991714,  0.002263956,  0.135865241,  0.790625811,  0.073508978,
13.15,  0.721841455,  0.013219237,  0.014152825,  0.003626153,  0.209482580,  0.686300099,  0.104217350,
13.20,  0.691670477,  0.027179100,  0.007770687,  0.006500835,  0.196792960,  0.705630720,  0.097576320,
13.25,  0.687379479,  0.026573107,  0.009438056,  0.004990650,  0.184179202,  0.723533928,  0.092286885,
13.30,  0.585538507,  0.055487428,  0.006006163,  0.001182871,  0.170805782,  0.736575484,  0.092618704,
13.35,  0.557284057,  0.065956786,  0.002590083,  0.001986779,  0.115980469,  0.817647934,  0.066371620,
13.40,  0.629613340,  0.046451196,  0.004014723,  0.005437851,  0.216535300,  0.671440601,  0.112024069,
13.45,  0.694086432,  0.025263757,  0.009069107,  0.005687717,  0.177962780,  0.733235180,  0.088802040,
13.50,  0.699766278,  0.031556524,  0.001361847,  0.011819052,  0.183224946,  0.728090286,  0.088684797,
13.55,  0.786130905,  0.005859770,  0.005491737,  0.014101204,  0.181184083,  0.737541556,  0.081274390,
13.60,  0.652902365,  0.033395275,  0.011283882,  0.001414925,  0.180976197,  0.725486219,  0.093537569,
13.65,  0.766006589,  0.004718501,  0.011646405,  0.008240692,  0.178020373,  0.737867415,  0.084112227,
13.70,  0.638251364,  0.038967464,  0.009348910,  0.001969615,  0.176437631,  0.731100321,  0.092462063,
13.75,  0.772822976,  0.012917720,  0.001787543,  0.016027523,  0.160995126,  0.768132389,  0.070872486,
13.80,  0.795924425,  0.000001829,  0.008934669,  0.012106072,  0.190788224,  0.722572505,  0.086639285,
13.85,  0.712637007,  0.016933046,  0.012837119,  0.003964910,  0.147839814,  0.779684186,  0.072476029,
13.90,  0.760183096,  0.012833025,  0.005038776,  0.012794182,  0.207206726,  0.696023166,  0.096770108,
13.95,  0.762026608,  0.006793361,  0.010581672,  0.008779146,  0.176248670,  0.740152180,  0.083599150,
14.00,  0.622943103,  0.049167890,  0.002990570,  0.005770339,  0.192139506,  0.708034217,  0.099826276,
14.05,  0.655722380,  0.034870993,  0.009125449,  0.003193285,  0.160878703,  0.756313086,  0.082808197,
14.10,  0.749844611,  0.001728453,  0.018717691,  0.001896547,  0.207903415,  0.689705551,  0.102391064,
14.15,  0.661753058,  0.037709214,  0.004778191,  0.006831670,  0.127366021,  0.808602035,  0.064031959,
14.20,  0.739294708,  0.011356346,  0.011732958,  0.006471464,  0.234153181,  0.651235938,  0.114610910,
14.25,  0.634925187,  0.040906936,  0.008267399,  0.002553051,  0.216608196,  0.670806050,  0.112585783,
14.30,  0.701252997,  0.030390240,  0.002241876,  0.011187881,  0.131804764,  0.806049347,  0.062145889,
14.35,  0.693837583,  0.027424246,  0.007052854,  0.007122837,  0.187389433,  0.719810724,  0.092799842,
14.40,  0.740905762,  0.012758359,  0.009970337,  0.007862505,  0.139310777,  0.795475006,  0.065214217,
14.45,  0.557903051,  0.064275920,  0.004200913,  0.000753809,  0.118169531,  0.815466285,  0.066364169,
14.50,  0.731989861,  0.023698390,  0.001226645,  0.013887508,  0.204852939,  0.697666109,  0.097480953,
14.55,  0.691941023,  0.021373324,  0.013592146,  0.002089160,  0.192151889,  0.710774899,  0.097073197,
14.60,  0.715600729,  0.018532384,  0.010501079,  0.005899001,  0.238085568,  0.643515944,  0.118398488,
14.65,  0.665756524,  0.037001684,  0.004498050,  0.007282097,  0.221598089,  0.666820526,  0.111581385,
14.70,  0.813443482,  0.002553128,  0.002032824,  0.018355483,  0.107158706,  0.850097120,  0.042744160,
14.75,  0.654727817,  0.036766671,  0.007522210,  0.004300704,  0.131008983,  0.802157104,  0.066833913,
14.80,  0.712311208,  0.019010223,  0.010858625,  0.005415494,  0.237628162,  0.643984616,  0.118387222,
14.85,  0.631842852,  0.044723153,  0.005263939,  0.004581369,  0.176134318,  0.732930183,  0.090935469,
14.90,  0.788987398,  0.005129345,  0.005603261,  0.014124675,  0.113090716,  0.838817120,  0.048092186,
14.95,  0.731478393,  0.011042636,  0.014062844,  0.004188959,  0.204681426,  0.694767416,  0.100551188,
15.00,  0.610909045,  0.052865371,  0.002360716,  0.005446266,  0.269968808,  0.590892971,  0.139138222,
15.05,  0.681244493,  0.034889691,  0.002788819,  0.009493941,  0.122827619,  0.817575455,  0.059596896,
15.10,  0.657367587,  0.035538077,  0.008087836,  0.004043739,  0.211652040,  0.680156767,  0.108191192,
15.15,  0.705144286,  0.024954692,  0.006725430,  0.008052800,  0.230219781,  0.655712485,  0.114067733,
15.20,  0.585954130,  0.059651062,  0.001803875,  0.004311625,  0.230894089,  0.647958457,  0.121147454,
15.25,  0.734103143,  0.010396499,  0.014068563,  0.004336888,  0.096027374,  0.858532667,  0.045439959,
15.30,  0.762889147,  0.012897201,  0.004345894,  0.013447115,  0.238814890,  0.647345304,  0.113839805,
15.35,  0.785427213,  0.001071531,  0.010575417,  0.010154823,  0.105150782,  0.849067211,  0.045782030,
15.40,  0.599935174,  0.054319710,  0.003700614,  0.003717400,  0.192676768,  0.707337499,  0.099985719,
15.45,  0.702837944,  0.022892334,  0.009386800,  0.005895806,  0.138957024,  0.792599559,  0.068443418,
15.50,  0.717270851,  0.019445341,  0.009251539,  0.006879831,  0.105226934,  0.844815135,  0.049957931,
15.55,  0.643918097,  0.034871936,  0.012149259,  0.000132397,  0.169413224,  0.742629766,  0.087957025,
15.60,  0.657019794,  0.030519485,  0.013233595,  0.000132520,  0.206523865,  0.687374592,  0.106101513,
15.65,  0.820778728,  0.002432294,  0.000391729,  0.019990845,  0.214031368,  0.689449608,  0.096519053,
15.70,  0.712360203,  0.014742196,  0.015155707,  0.002164768,  0.086967207,  0.869690895,  0.043341875,
15.75,  0.758473217,  0.014070660,  0.004303962,  0.013181910,  0.117252827,  0.829569757,  0.053177416,
15.80,  0.797629535,  0.003610317,  0.005003586,  0.015083190,  0.085234165,  0.880431414,  0.034334421,
15.85,  0.606994927,  0.049409047,  0.006832600,  0.001819950,  0.259119332,  0.606001198,  0.134879470,
15.90,  0.728422642,  0.021804363,  0.004080050,  0.011473823,  0.167868003,  0.751412511,  0.080719471,
15.95,  0.660934091,  0.029669285,  0.013116829,  0.000456031,  0.101408489,  0.845859706,  0.052731812,
16.00,  0.583330154,  0.059098411,  0.003092103,  0.003121767,  0.065101810,  0.898198545,  0.036699653,
16.05,  0.729344666,  0.009877689,  0.015782207,  0.002750339,  0.097509377,  0.854663551,  0.047827065,
16.10,  0.664115787,  0.036239594,  0.005744293,  0.006189391,  0.253785998,  0.618475318,  0.127738714,
16.15,  0.665620923,  0.040300131,  0.001300715,  0.009621214,  0.122263148,  0.816855431,  0.060881436,
16.20,  0.635851383,  0.039581127,  0.009472668,  0.001623729,  0.186156929,  0.717675388,  0.096167684,
16.25,  0.685067058,  0.028111853,  0.008652397,  0.005304134,  0.254521728,  0.617781579,  0.127696693,
16.30,  0.671372652,  0.030012012,  0.010172911,  0.003310043,  0.114655226,  0.827525616,  0.057819128,
16.35,  0.726615489,  0.015679982,  0.010661013,  0.006421559,  0.284637600,  0.573571861,  0.141790569,
16.40,  0.721436799,  0.013165165,  0.014492884,  0.003207199,  0.074668199,  0.888910353,  0.036421478,
16.45,  0.730993748,  0.008924253,  0.016367376,  0.002381528,  0.100111321,  0.851383686,  0.048505008,
16.50,  0.744230330,  0.009316154,  0.012625471,  0.006045887,  0.228459418,  0.658753753,  0.112786829,
16.55,  0.656634033,  0.033359539,  0.010486320,  0.002171613,  0.192051321,  0.709297061,  0.098651648,
16.60,  0.586481631,  0.059042878,  0.002377570,  0.003841281,  0.132757336,  0.797203362,  0.070039332,
16.65,  0.556891322,  0.064664468,  0.004135080,  0.000687614,  0.133038789,  0.794020951,  0.072940290,
16.70,  0.609965086,  0.047400743,  0.008161463,  0.000961613,  0.113637187,  0.826101661,  0.060261130,
16.75,  0.703126192,  0.027283851,  0.004968520,  0.009193556,  0.314621598,  0.528775275,  0.156603158,
16.80,  0.707181990,  0.020819128,  0.010396242,  0.005393542,  0.158002302,  0.762849987,  0.079147696,
16.85,  0.586543202,  0.060893610,  0.000508472,  0.005249184,  0.242736101,  0.631703854,  0.125560045,
16.90,  0.671847463,  0.029319562,  0.010761410,  0.002887281,  0.266909748,  0.598013699,  0.135076582,
16.95,  0.677711248,  0.027613297,  0.010978378,  0.003108554,  0.200138867,  0.698033094,  0.101828039,
17.00,  0.614473045,  0.047937885,  0.006457590,  0.002551071,  0.224051937,  0.659330189,  0.116617858,
17.05,  0.657729983,  0.040971756,  0.002631158,  0.008108199,  0.178897902,  0.730648160,  0.090453923,
17.10,  0.645247698,  0.036719680,  0.010039009,  0.001745764,  0.128549740,  0.804984808,  0.066465437,
17.15,  0.692725956,  0.027247034,  0.007633924,  0.006523093,  0.073470548,  0.891232729,  0.035296738,
17.20,  0.797381878,  0.005097494,  0.003592685,  0.016115118,  0.094806060,  0.864059865,  0.041134059,
17.25,  0.660030425,  0.041451745,  0.001566984,  0.009056913,  0.159856588,  0.759766281,  0.080377162,
17.30,  0.656274498,  0.031263046,  0.012724653,  0.000431424,  0.148459122,  0.774573863,  0.076967001,
17.35,  0.591632664,  0.054071508,  0.006068319,  0.001389809,  0.287512511,  0.563623309,  0.148864150,
17.40,  0.645229876,  0.035259917,  0.011514872,  0.000629019,  0.124189734,  0.812191665,  0.063618600,
17.45,  0.767431259,  0.004138738,  0.012089640,  0.007832579,  0.207188711,  0.692833364,  0.099977911,
17.50,  0.552409530,  0.066802211,  0.003159411,  0.001108032,  0.103992119,  0.839100063,  0.056907833,
17.55,  0.707447410,  0.013888985,  0.017325327,  0.000164345,  0.027229413,  0.959326029,  0.013444543,
17.60,  0.680527985,  0.031931154,  0.006010443,  0.006969972,  0.270029068,  0.594751656,  0.135219276,
17.65,  0.593147099,  0.059047580,  0.000703789,  0.005515244,  0.249358714,  0.622303665,  0.128337622,
17.70,  0.791372776,  0.001141690,  0.009060048,  0.011632064,  0.309629112,  0.539429247,  0.150941670,
17.75,  0.636191726,  0.039019272,  0.009968549,  0.001258757,  0.284562230,  0.569141746,  0.146296024,
17.80,  0.634177327,  0.047534734,  0.001960412,  0.007136166,  0.189328521,  0.714039862,  0.096631587,
17.85,  0.751469970,  0.009154446,  0.011038139,  0.007643210,  0.026480488,  0.963086367,  0.010433137,
17.90,  0.740025282,  0.010362968,  0.012711003,  0.005658109,  0.316992164,  0.525839865,  0.157167971,
17.95,  0.757209301,  0.013814263,  0.004944399,  0.012571542,  0.330267519,  0.507805765,  0.161926687,
18.00,  0.734100580,  0.022811241,  0.001734763,  0.013526851,  0.121345371,  0.821706414,  0.056948185,
18.05,  0.671925068,  0.030377023,  0.009718709,  0.003648536,  0.308862180,  0.534928679,  0.156209111,
18.10,  0.697446406,  0.028571874,  0.005172521,  0.008631513,  0.261955917,  0.608244121,  0.129799962,
18.15,  0.594167173,  0.051826194,  0.007691681,  0.000321936,  0.266372532,  0.595948577,  0.137678862,
18.20,  0.716311574,  0.018721588,  0.010304630,  0.005962918,  0.055592142,  0.918762624,  0.025645256,
18.25,  0.627494872,  0.044425517,  0.006783403,  0.003068898,  0.021238402,  0.966043234,  0.012718379,
18.30,  0.741219163,  0.014386337,  0.008400612,  0.008956935,  0.316946596,  0.526587188,  0.156466186,
18.35,  0.619465053,  0.044087432,  0.009092562,  0.000862453,  0.297963977,  0.548621953,  0.153414071,
18.40,  0.668275893,  0.029096261,  0.011898503,  0.001795564,  0.152027801,  0.769684196,  0.078288019,
18.45,  0.607787192,  0.052782476,  0.003359668,  0.004400242,  0.324847609,  0.509087801,  0.166064620,
18.50,  0.681842446,  0.025724903,  0.011902027,  0.002622977,  0.146746725,  0.779259026,  0.073994219,
18.55,  0.602584243,  0.054031804,  0.003436208,  0.003998805,  0.227249205,  0.656445622,  0.116305172,
18.60,  0.725293398,  0.012602329,  0.014182538,  0.003612772,  0.243743211,  0.635292530,  0.120964289,
18.65,  0.744948864,  0.005532205,  0.016361281,  0.003190316,  0.185577959,  0.723366737,  0.091055274,
18.70,  0.635090709,  0.040398389,  0.008915991,  0.001940884,  0.363265663,  0.451420426,  0.185313940,
18.75,  0.606926322,  0.055156454,  0.001198828,  0.005968627,  0.228418574,  0.654630065,  0.116951346,
18.80,  0.763809443,  0.014296792,  0.002851591,  0.014523840,  0.280339569,  0.583333433,  0.136326969,
18.85,  0.681040287,  0.030004315,  0.007800214,  0.005666407,  0.395757854,  0.404505789,  0.199736357,
18.90,  0.763031721,  0.014851183,  0.002469085,  0.014779020,  0.108509533,  0.840742886,  0.050747573,
18.95,  0.759478509,  0.001530200,  0.016685277,  0.003889620,  0.100917980,  0.849950433,  0.049131572,
19.00,  0.639116704,  0.044296533,  0.004058942,  0.005799599,  0.130327120,  0.803912163,  0.065760732,
19.05,  0.578526258,  0.059787303,  0.003664106,  0.002347581,  0.376217663,  0.430850267,  0.192932069,
19.10,  0.591366351,  0.056888379,  0.003363959,  0.003366981,  0.066996813,  0.896167576,  0.036835611,
19.15,  0.723976731,  0.022388399,  0.004699200,  0.010662809,  0.322976857,  0.516833544,  0.160189629,
19.20,  0.629271090,  0.049999945,  0.000777811,  0.007674441,  0.212360352,  0.679592371,  0.108047247,
19.25,  0.616772532,  0.052926600,  0.001025140,  0.006670773,  0.305292100,  0.540844560,  0.153863311,
19.30,  0.616772532,  0.052926600,  0.001025140,  0.006670773,  0.305292100,  0.540844560,  0.153863311,
19.35,  0.585252821,  0.056075647,  0.005713806,  0.001215953,  0.122264110,  0.812377095,  0.065358818,
19.40,  0.692379653,  0.024560563,  0.010469109,  0.004328458,  0.101609349,  0.847952902,  0.050437748,
19.45,  0.735629797,  0.011300519,  0.012886256,  0.005241502,  0.371529579,  0.442429751,  0.186040670,
19.50,  0.692917943,  0.024151146,  0.010774881,  0.004109576,  0.123248830,  0.815623760,  0.061127424,
19.55,  0.633065999,  0.049031563,  0.000802159,  0.007889837,  0.149906129,  0.774167955,  0.075925887,
19.60,  0.574742436,  0.063080668,  0.001374975,  0.003784232,  0.148704216,  0.774831355,  0.076464415,
19.65,  0.516435742,  0.078251049,  0.000788152,  0.000575017,  0.325059086,  0.507439494,  0.167501450,
19.70,  0.533551931,  0.074311420,  0.000406727,  0.001962353,  0.342934698,  0.480547130,  0.176518142,
19.75,  0.693292737,  0.022411108,  0.012378633,  0.002962127,  0.155473262,  0.766110063,  0.078416705,
19.80,  0.619924605,  0.052569546,  0.000531286,  0.007285334,  0.148478061,  0.774832845,  0.076689124,
19.85,  0.691357553,  0.021407604,  0.013847128,  0.001753911,  0.179279834,  0.730047703,  0.090672493,
19.90,  0.663915038,  0.038511515,  0.003682941,  0.007602572,  0.239249468,  0.641971469,  0.118779063,
19.95,  0.520983577,  0.076073349,  0.001844108,  0.000055879,  0.317512095,  0.519014537,  0.163473368,
20.00,  0.628557563,  0.045759290,  0.005248681,  0.004237816,  0.184951141,  0.720882893,  0.094165981,
20.05,  0.793222070,  0.003329217,  0.006494150,  0.013609104,  0.359128177,  0.464643240,  0.176228583,
20.10,  0.545972228,  0.068722248,  0.002889521,  0.000877503,  0.009620428,  0.981576681,  0.008802891,
20.15 , 0.623136342 , 0.045090564 , 0.007242844 , 0.002425767 , 0.137593195 , 0.791602910 , 0.070803881
};

double wtab2[3192] = {
   2.49999994E-03 , 0.578033745      , 3.99446450E-02  , 2.38903537E-02 , -1.30482316E-02 , 0.179515034     , 0.731100619     ,  8.93843472E-02,
   3.50000011E-03 , 0.577869534      , 3.99689302E-02  , 2.39049532E-02 , -1.30678229E-02 , 0.179440185     , 0.731137991     ,  8.94218087E-02,
   4.49999981E-03 , 0.577705383      , 3.99932154E-02  , 2.39195526E-02 , -1.30874133E-02 , 0.179365337     , 0.731175423     ,  8.94592628E-02,
   5.49999997E-03 , 0.577541232      , 4.00174968E-02  , 2.39341483E-02 , -1.31069971E-02 , 0.179290488     , 0.731212795     ,  8.94967243E-02,
   6.50000013E-03 , 0.577377021      , 4.00417708E-02  , 2.39487402E-02 , -1.31265689E-02 , 0.179215625     , 0.731250167     ,  8.95342156E-02,
   7.49999983E-03 , 0.577212870      , 4.00660373E-02  , 2.39633210E-02 , -1.31461201E-02 , 0.179140732     , 0.731287539     ,  8.95717517E-02,
   8.50000046E-03 , 0.577048659      , 4.00902927E-02  , 2.39778906E-02 , -1.31656425E-02 , 0.179065749     , 0.731324852     ,  8.96094143E-02,
   9.49999969E-03 , 0.576884508      , 4.01145332E-02  , 2.39924453E-02 , -1.31851304E-02 , 0.178990647     , 0.731362045     ,  8.96473005E-02,
   1.04999999E-02 , 0.576720297      , 4.01387550E-02  , 2.40069814E-02 , -1.32045783E-02 , 0.178915322     , 0.731399119     ,  8.96855593E-02,
   1.15000000E-02 , 0.576556087      , 4.01629582E-02  , 2.40214970E-02 , -1.32239787E-02 , 0.178839639     , 0.731435955     ,  8.97244066E-02,
   1.25000002E-02 , 0.576391935      , 4.01871353E-02  , 2.40359865E-02 , -1.32433213E-02 , 0.178763434     , 0.731472433     ,  8.97641182E-02,
   1.35000004E-02 , 0.576227725      , 4.02112827E-02  , 2.40504444E-02 , -1.32625941E-02 , 0.178686514     , 0.731508434     ,  8.98050219E-02,
   1.44999996E-02 , 0.576063514      , 4.02353965E-02  , 2.40648650E-02 , -1.32817822E-02 , 0.178608656     , 0.731543839     ,  8.98475125E-02,
   1.54999997E-02 , 0.575899243      , 4.02594656E-02  , 2.40792390E-02 , -1.33008687E-02 , 0.178529590     , 0.731578410     ,  8.98919925E-02,
   1.64999999E-02 , 0.575735033      , 4.02834900E-02  , 2.40935609E-02 , -1.33198369E-02 , 0.178449064     , 0.731612027     ,  8.99389088E-02,
   1.75000001E-02 , 0.575570762      , 4.03074548E-02  , 2.41078213E-02 , -1.33386711E-02 , 0.178366825     , 0.731644511     ,  8.99886861E-02,
   1.85000002E-02 , 0.575406551      , 4.03313600E-02  , 2.41220128E-02 , -1.33573553E-02 , 0.178282633     , 0.731675625     ,  9.00417194E-02,
   1.95000004E-02 , 0.575242221      , 4.03551981E-02  , 2.41361316E-02 , -1.33758765E-02 , 0.178196281     , 0.731705368     ,  9.00983587E-02,
   2.05000006E-02 , 0.575077951      , 4.03789654E-02  , 2.41501704E-02 , -1.33942226E-02 , 0.178107575     , 0.731733561     ,  9.01588872E-02,
   2.15000007E-02 , 0.574913621      , 4.04026546E-02  , 2.41641272E-02 , -1.34123880E-02 , 0.178016424     , 0.731760025     ,  9.02235359E-02,
   2.25000009E-02 , 0.574749291      , 4.04262692E-02  , 2.41780002E-02 , -1.34303654E-02 , 0.177922696     , 0.731784880     ,  9.02924463E-02,
   2.34999992E-02 , 0.574584961      , 4.04497981E-02  , 2.41917893E-02 , -1.34481536E-02 , 0.177826360     , 0.731807947     ,  9.03657228E-02,
   2.44999994E-02 , 0.574420631      , 4.04732488E-02  , 2.42054947E-02 , -1.34657528E-02 , 0.177727371     , 0.731829226     ,  9.04433951E-02,
   2.54999995E-02 , 0.574256241      , 4.04966101E-02  , 2.42191181E-02 , -1.34831630E-02 , 0.177625760     , 0.731848776     ,  9.05254781E-02,
   2.64999997E-02 , 0.574091792      , 4.05198894E-02  , 2.42326632E-02 , -1.35003878E-02 , 0.177521497     , 0.731866539     ,  9.06119570E-02,
   2.74999999E-02 , 0.573927343      , 4.05430831E-02  , 2.42461301E-02 , -1.35174291E-02 , 0.177414611     , 0.731882572     ,  9.07028094E-02,
   2.85000000E-02 , 0.573762894      , 4.05661911E-02  , 2.42595226E-02 , -1.35342898E-02 , 0.177305117     , 0.731896877     ,  9.07979980E-02,
   2.95000002E-02 , 0.573598444      , 4.05892096E-02  , 2.42728423E-02 , -1.35509735E-02 , 0.177193031     , 0.731909454     ,  9.08975154E-02,
   3.05000003E-02 , 0.573433876      , 4.06121388E-02  , 2.42860932E-02 , -1.35674803E-02 , 0.177078366     , 0.731920302     ,  9.10013393E-02,
   3.15000005E-02 , 0.573269367      , 4.06349748E-02  , 2.42992751E-02 , -1.35838138E-02 , 0.176961109     , 0.731929421     ,  9.11094695E-02,
   3.24999988E-02 , 0.573104799      , 4.06577215E-02  , 2.43123900E-02 , -1.35999750E-02 , 0.176841274     , 0.731936812     ,  9.12219137E-02,
   3.35000008E-02 , 0.572940171      , 4.06803750E-02  , 2.43254397E-02 , -1.36159649E-02 , 0.176718846     , 0.731942475     ,  9.13386792E-02,
   3.44999991E-02 , 0.572775543      , 4.07029316E-02  , 2.43384279E-02 , -1.36317844E-02 , 0.176593810     , 0.731946409     ,  9.14597660E-02,
   3.55000012E-02 , 0.572610915      , 4.07253951E-02  , 2.43513510E-02 , -1.36474352E-02 , 0.176466182     , 0.731948614     ,  9.15851891E-02,
   3.64999995E-02 , 0.572446167      , 4.07477617E-02  , 2.43642144E-02 , -1.36629166E-02 , 0.176335946     , 0.731949091     ,  9.17149633E-02,
   3.75000015E-02 , 0.572281480      , 4.07700278E-02  , 2.43770182E-02 , -1.36782313E-02 , 0.176203087     , 0.731947839     ,  9.18490961E-02,
   3.84999998E-02 , 0.572116673      , 4.07921970E-02  , 2.43897643E-02 , -1.36933802E-02 , 0.176067606     , 0.731944799     ,  9.19876024E-02,
   3.95000018E-02 , 0.571951866      , 4.08142619E-02  , 2.44024526E-02 , -1.37083633E-02 , 0.175929502     , 0.731940031     ,  9.21304747E-02,
   4.05000001E-02 , 0.571787059      , 4.08362262E-02  , 2.44150888E-02 , -1.37231825E-02 , 0.175788775     , 0.731933475     ,  9.22777429E-02,
   4.14999984E-02 , 0.571622133      , 4.08580862E-02  , 2.44276691E-02 , -1.37378387E-02 , 0.175645396     , 0.731925189     ,  9.24293920E-02,
   4.25000004E-02 , 0.571457267      , 4.08798419E-02  , 2.44401973E-02 , -1.37523329E-02 , 0.175499380     , 0.731915176     ,  9.25854519E-02,
   4.34999987E-02 , 0.571292281      , 4.09014896E-02  , 2.44526770E-02 , -1.37666669E-02 , 0.175350726     , 0.731903374     ,  9.27459151E-02,
   4.45000008E-02 , 0.571127295      , 4.09230292E-02  , 2.44651064E-02 , -1.37808416E-02 , 0.175199404     , 0.731889784     ,  9.29107890E-02,
   4.54999991E-02 , 0.570962250      , 4.09444608E-02  , 2.44774893E-02 , -1.37948571E-02 , 0.175045431     , 0.731874466     ,  9.30800810E-02,
   4.65000011E-02 , 0.570797145      , 4.09657806E-02  , 2.44898256E-02 , -1.38087161E-02 , 0.174888805     , 0.731857359     ,  9.32538062E-02,
   4.74999994E-02 , 0.570631981      , 4.09869850E-02  , 2.45021190E-02 , -1.38224186E-02 , 0.174729496     , 0.731838524     ,  9.34319720E-02,
   4.85000014E-02 , 0.570466816      , 4.10080776E-02  , 2.45143697E-02 , -1.38359666E-02 , 0.174567536     , 0.731817901     ,  9.36145708E-02,
   4.94999997E-02 , 0.570301592      , 4.10290547E-02  , 2.45265793E-02 , -1.38493609E-02 , 0.174402878     , 0.731795490     ,  9.38016176E-02,
   5.05000018E-02 , 0.570136309      , 4.10499126E-02  , 2.45387498E-02 , -1.38626024E-02 , 0.174235553     , 0.731771350     ,  9.39931199E-02,
   5.15000001E-02 , 0.569971025      , 4.10706550E-02  , 2.45508850E-02 , -1.38756940E-02 , 0.174065530     , 0.731745422     ,  9.41890776E-02,
   5.24999984E-02 , 0.569805622      , 4.10912707E-02  , 2.45629847E-02 , -1.38886357E-02 , 0.173892811     , 0.731717706     ,  9.43894982E-02,
   5.35000004E-02 , 0.569640219      , 4.11117673E-02  , 2.45750509E-02 , -1.39014283E-02 , 0.173717394     , 0.731688201     ,  9.45943892E-02,
   5.44999987E-02 , 0.569474757      , 4.11321409E-02  , 2.45870855E-02 , -1.39140757E-02 , 0.173539281     , 0.731656969     ,  9.48037580E-02,
   5.55000007E-02 , 0.569309235      , 4.11523841E-02  , 2.45990921E-02 , -1.39265768E-02 , 0.173358455     , 0.731623948     ,  9.50176045E-02,
   5.64999990E-02 , 0.569143653      , 4.11725007E-02  , 2.46110708E-02 , -1.39389345E-02 , 0.173174903     , 0.731589139     ,  9.52359363E-02,
   5.75000010E-02 , 0.568978012      , 4.11924832E-02  , 2.46230271E-02 , -1.39511507E-02 , 0.172988623     , 0.731552601     ,  9.54587534E-02,
   5.84999993E-02 , 0.568812311      , 4.12123352E-02  , 2.46349592E-02 , -1.39632262E-02 , 0.172799632     , 0.731514335     ,  9.56860632E-02,
   5.95000014E-02 , 0.568646550      , 4.12320495E-02  , 2.46468727E-02 , -1.39751639E-02 , 0.172607884     , 0.731474280     ,  9.59178656E-02,
   6.04999997E-02 , 0.568480730      , 4.12516259E-02  , 2.46587694E-02 , -1.39869656E-02 , 0.172413394     , 0.731432438     ,  9.61541682E-02,
   6.15000017E-02 , 0.568314850      , 4.12710607E-02  , 2.46706530E-02 , -1.39986323E-02 , 0.172216147     , 0.731388867     ,  9.63949710E-02,
   6.25000000E-02 , 0.568148911      , 4.12903503E-02  , 2.46825255E-02 , -1.40101677E-02 , 0.172016144     , 0.731343567     ,  9.66402814E-02,
   6.35000020E-02 , 0.567982912      , 4.13094945E-02  , 2.46943906E-02 , -1.40215736E-02 , 0.171813369     , 0.731296539     ,  9.68900993E-02,
   6.44999966E-02 , 0.567816854      , 4.13284861E-02  , 2.47062519E-02 , -1.40328519E-02 , 0.171607807     , 0.731247783     ,  9.71444249E-02,
   6.54999986E-02 , 0.567650735      , 4.13473211E-02  , 2.47181114E-02 , -1.40440054E-02 , 0.171399474     , 0.731197238     ,  9.74032655E-02,
   6.65000007E-02 , 0.567484558      , 4.13659997E-02  , 2.47299764E-02 , -1.40550369E-02 , 0.171188325     , 0.731145084     ,  9.76666138E-02,
   6.75000027E-02 , 0.567318320      , 4.13845181E-02  , 2.47418471E-02 , -1.40659502E-02 , 0.170974374     , 0.731091142     ,  9.79344845E-02,
   6.84999973E-02 , 0.567152023      , 4.14028689E-02  , 2.47537289E-02 , -1.40767479E-02 , 0.170757592     , 0.731035531     ,  9.82068628E-02,
   6.94999993E-02 , 0.566985607      , 4.14210483E-02  , 2.47656275E-02 , -1.40874321E-02 , 0.170537993     , 0.730978251     ,  9.84837636E-02,
   7.05000013E-02 , 0.566819191      , 4.14390527E-02  , 2.47775484E-02 , -1.40980082E-02 , 0.170315534     , 0.730919302     ,  9.87651795E-02,
   7.15000033E-02 , 0.566652656      , 4.14568745E-02  , 2.47894935E-02 , -1.41084781E-02 , 0.170090228     , 0.730858624     ,  9.90511179E-02,
   7.24999979E-02 , 0.566486061      , 4.14745137E-02  , 2.48014685E-02 , -1.41188465E-02 , 0.169862062     , 0.730796397     ,  9.93415713E-02,
   7.34999999E-02 , 0.566319406      , 4.14919592E-02  , 2.48134807E-02 , -1.41291162E-02 , 0.169631004     , 0.730732441     ,  9.96365473E-02,
   7.45000020E-02 , 0.566152692      , 4.15092111E-02  , 2.48255339E-02 , -1.41392928E-02 , 0.169397056     , 0.730666876     ,  9.99360383E-02,
   7.54999965E-02 , 0.565985858      , 4.15262580E-02  , 2.48376355E-02 , -1.41493799E-02 , 0.169160202     , 0.730599761     , 0.100240052    ,
   7.64999986E-02 , 0.565818965      , 4.15431000E-02  , 2.48497911E-02 , -1.41593814E-02 , 0.168920428     , 0.730530977     , 0.100548580    ,
   7.75000006E-02 , 0.565652013      , 4.15597260E-02  , 2.48620044E-02 , -1.41693018E-02 , 0.168677703     , 0.730460644     , 0.100861631    ,
   7.85000026E-02 , 0.565485001      , 4.15761322E-02  , 2.48742830E-02 , -1.41791450E-02 , 0.168432042     , 0.730388761     , 0.101179205    ,
   7.94999972E-02 , 0.565317869      , 4.15923111E-02  , 2.48866342E-02 , -1.41889164E-02 , 0.168183401     , 0.730315328     , 0.101501293    ,
   8.04999992E-02 , 0.565150678      , 4.16082591E-02  , 2.48990618E-02 , -1.41986208E-02 , 0.167931795     , 0.730240285     , 0.101827897    ,
   8.15000013E-02 , 0.564983428      , 4.16239686E-02  , 2.49115750E-02 , -1.42082619E-02 , 0.167677179     , 0.730163813     , 0.102159023    ,
   8.25000033E-02 , 0.564816058      , 4.16394323E-02  , 2.49241758E-02 , -1.42178452E-02 , 0.167419568     , 0.730085790     , 0.102494672    ,
   8.34999979E-02 , 0.564648628      , 4.16546427E-02  , 2.49368753E-02 , -1.42273735E-02 , 0.167158917     , 0.730006218     , 0.102834836    ,
   8.44999999E-02 , 0.564481139      , 4.16695997E-02  , 2.49496773E-02 , -1.42368525E-02 , 0.166895241     , 0.729925215     , 0.103179514    ,
   8.55000019E-02 , 0.564313531      , 4.16842923E-02  , 2.49625854E-02 , -1.42462859E-02 , 0.166628510     , 0.729842782     , 0.103528716    ,
   8.64999965E-02 , 0.564145863      , 4.16987166E-02  , 2.49756072E-02 , -1.42556773E-02 , 0.166358709     , 0.729758859     , 0.103882439    ,
   8.74999985E-02 , 0.563978076      , 4.17128652E-02  , 2.49887481E-02 , -1.42650316E-02 , 0.166085824     , 0.729673505     , 0.104240686    ,
   8.85000005E-02 , 0.563810229      , 4.17267382E-02  , 2.50020120E-02 , -1.42743504E-02 , 0.165809840     , 0.729586720     , 0.104603447    ,
   8.95000026E-02 , 0.563642263      , 4.17403281E-02  , 2.50154026E-02 , -1.42836375E-02 , 0.165530771     , 0.729498506     , 0.104970731    ,
   9.04999971E-02 , 0.563474238      , 4.17536348E-02  , 2.50289254E-02 , -1.42928958E-02 , 0.165248573     , 0.729408920     , 0.105342537    ,
   9.14999992E-02 , 0.563306153      , 4.17666472E-02  , 2.50425823E-02 , -1.43021280E-02 , 0.164963245     , 0.729317904     , 0.105718873    ,
   9.25000012E-02 , 0.563137949      , 4.17793691E-02  , 2.50563771E-02 , -1.43113350E-02 , 0.164674789     , 0.729225457     , 0.106099732    ,
   9.35000032E-02 , 0.562969625      , 4.17917967E-02  , 2.50703096E-02 , -1.43205188E-02 , 0.164383188     , 0.729131699     , 0.106485114    ,
   9.44999978E-02 , 0.562801242      , 4.18039300E-02  , 2.50843819E-02 , -1.43296793E-02 , 0.164088428     , 0.729036570     , 0.106875025    ,
   9.54999998E-02 , 0.562632799      , 4.18157689E-02  , 2.50985958E-02 , -1.43388184E-02 , 0.163790509     , 0.728940010     , 0.107269473    ,
   9.65000018E-02 , 0.562464178      , 4.18273099E-02  , 2.51129512E-02 , -1.43479342E-02 , 0.163489416     , 0.728842139     , 0.107668452    ,
   9.74999964E-02 , 0.562295556      , 4.18385565E-02  , 2.51274444E-02 , -1.43570267E-02 , 0.163185149     , 0.728742898     , 0.108071961    ,
   9.84999985E-02 , 0.562126756      , 4.18495089E-02  , 2.51420774E-02 , -1.43660940E-02 , 0.162877724     , 0.728642285     , 0.108480006    ,
   9.95000005E-02 , 0.561957896      , 4.18601707E-02  , 2.51568444E-02 , -1.43751344E-02 , 0.162567109     , 0.728540301     , 0.108892590    ,
  0.100500003     , 0.561788917      , 4.18705493E-02  , 2.51717456E-02 , -1.43841449E-02 , 0.162253320     , 0.728436947     , 0.109309711    ,
  0.101499997     , 0.561619878      , 4.18806411E-02  , 2.51867734E-02 , -1.43931238E-02 , 0.161936343     , 0.728332281     , 0.109731369    ,
  0.102499999     , 0.561450660      , 4.18904535E-02  , 2.52019260E-02 , -1.44020654E-02 , 0.161616191     , 0.728226244     , 0.110157572    ,
  0.103500001     , 0.561281383      , 4.18999940E-02  , 2.52171978E-02 , -1.44109679E-02 , 0.161292851     , 0.728118837     , 0.110588312    ,
  0.104500003     , 0.561111987      , 4.19092700E-02  , 2.52325814E-02 , -1.44198257E-02 , 0.160966352     , 0.728010058     , 0.111023597    ,
  0.105499998     , 0.560942531      , 4.19182815E-02  , 2.52480730E-02 , -1.44286342E-02 , 0.160636663     , 0.727899909     , 0.111463428    ,
  0.106500000     , 0.560772896      , 4.19270396E-02  , 2.52636634E-02 , -1.44373877E-02 , 0.160303816     , 0.727788389     , 0.111907795    ,
  0.107500002     , 0.560603201      , 4.19355519E-02  , 2.52793469E-02 , -1.44460816E-02 , 0.159967795     , 0.727675498     , 0.112356707    ,
  0.108499996     , 0.560433328      , 4.19438221E-02  , 2.52951160E-02 , -1.44547094E-02 , 0.159628630     , 0.727561235     , 0.112810157    ,
  0.109499998     , 0.560263395      , 4.19518650E-02  , 2.53109634E-02 , -1.44632664E-02 , 0.159286290     , 0.727445543     , 0.113268152    ,
  0.110500000     , 0.560093284      , 4.19596806E-02  , 2.53268816E-02 , -1.44717460E-02 , 0.158940807     , 0.727328479     , 0.113730676    ,
  0.111500002     , 0.559923112      , 4.19672839E-02  , 2.53428612E-02 , -1.44801419E-02 , 0.158592194     , 0.727210045     , 0.114197746    ,
  0.112499997     , 0.559752762      , 4.19746749E-02  , 2.53588986E-02 , -1.44884493E-02 , 0.158240438     , 0.727090240     , 0.114669345    ,
  0.113499999     , 0.559582293      , 4.19818684E-02  , 2.53749806E-02 , -1.44966627E-02 , 0.157885551     , 0.726969004     , 0.115145475    ,
  0.114500001     , 0.559411705      , 4.19888683E-02  , 2.53911037E-02 , -1.45047745E-02 , 0.157527551     , 0.726846337     , 0.115626127    ,
  0.115500003     , 0.559240997      , 4.19956855E-02  , 2.54072603E-02 , -1.45127801E-02 , 0.157166421     , 0.726722240     , 0.116111316    ,
  0.116499998     , 0.559070170      , 4.20023203E-02  , 2.54234429E-02 , -1.45206749E-02 , 0.156802192     , 0.726596773     , 0.116601013    ,
  0.117500000     , 0.558899164      , 4.20087874E-02  , 2.54396442E-02 , -1.45284534E-02 , 0.156434864     , 0.726469874     , 0.117095232    ,
  0.118500002     , 0.558728039      , 4.20150906E-02  , 2.54558586E-02 , -1.45361116E-02 , 0.156064436     , 0.726341605     , 0.117593966    ,
  0.119499996     , 0.558556795      , 4.20212336E-02  , 2.54720822E-02 , -1.45436432E-02 , 0.155690923     , 0.726211846     , 0.118097201    ,
  0.120499998     , 0.558385372      , 4.20272239E-02  , 2.54883058E-02 , -1.45510444E-02 , 0.155314341     , 0.726080716     , 0.118604943    ,
  0.121500000     , 0.558213770      , 4.20330651E-02  , 2.55045276E-02 , -1.45583125E-02 , 0.154934675     , 0.725948155     , 0.119117178    ,
  0.122500002     , 0.558042049      , 4.20387648E-02  , 2.55207419E-02 , -1.45654436E-02 , 0.154551938     , 0.725814164     , 0.119633906    ,
  0.123499997     , 0.557870209      , 4.20443267E-02  , 2.55369432E-02 , -1.45724332E-02 , 0.154166147     , 0.725678742     , 0.120155126    ,
  0.124499999     , 0.557698190      , 4.20497544E-02  , 2.55531278E-02 , -1.45792784E-02 , 0.153777301     , 0.725541890     , 0.120680816    ,
  0.125499994     , 0.557525992      , 4.20550518E-02  , 2.55692918E-02 , -1.45859765E-02 , 0.153385401     , 0.725403607     , 0.121210985    ,
  0.126499996     , 0.557353675      , 4.20602225E-02  , 2.55854335E-02 , -1.45925246E-02 , 0.152990445     , 0.725263953     , 0.121745616    ,
  0.127499998     , 0.557181180      , 4.20652702E-02  , 2.56015491E-02 , -1.45989209E-02 , 0.152592465     , 0.725122809     , 0.122284710    ,
  0.128500000     , 0.557008505      , 4.20701988E-02  , 2.56176349E-02 , -1.46051617E-02 , 0.152191460     , 0.724980295     , 0.122828253    ,
  0.129500002     , 0.556835651      , 4.20750119E-02  , 2.56336872E-02 , -1.46112461E-02 , 0.151787415     , 0.724836349     , 0.123376250    ,
  0.130500004     , 0.556662619      , 4.20797132E-02  , 2.56497059E-02 , -1.46171711E-02 , 0.151380345     , 0.724690974     , 0.123928681    ,
  0.131500006     , 0.556489468      , 4.20842990E-02  , 2.56656855E-02 , -1.46229351E-02 , 0.150970280     , 0.724544168     , 0.124485545    ,
  0.132499993     , 0.556316078      , 4.20887768E-02  , 2.56816279E-02 , -1.46285370E-02 , 0.150557190     , 0.724395990     , 0.125046834    ,
  0.133499995     , 0.556142569      , 4.20931503E-02  , 2.56975275E-02 , -1.46339731E-02 , 0.150141105     , 0.724246383     , 0.125612542    ,
  0.134499997     , 0.555968821      , 4.20974195E-02  , 2.57133823E-02 , -1.46392426E-02 , 0.149722025     , 0.724095345     , 0.126182646    ,
  0.135499999     , 0.555794954      , 4.21015881E-02  , 2.57291906E-02 , -1.46443443E-02 , 0.149299949     , 0.723942876     , 0.126757160    ,
  0.136500001     , 0.555620849      , 4.21056561E-02  , 2.57449523E-02 , -1.46492757E-02 , 0.148874894     , 0.723789036     , 0.127336055    ,
  0.137500003     , 0.555446565      , 4.21096273E-02  , 2.57606637E-02 , -1.46540357E-02 , 0.148446858     , 0.723633826     , 0.127919346    ,
  0.138500005     , 0.555272102      , 4.21135016E-02  , 2.57763229E-02 , -1.46586224E-02 , 0.148015857     , 0.723477125     , 0.128507003    ,
  0.139500007     , 0.555097401      , 4.21172827E-02  , 2.57919300E-02 , -1.46630351E-02 , 0.147581875     , 0.723319113     , 0.129099011    ,
  0.140499994     , 0.554922581      , 4.21209745E-02  , 2.58074813E-02 , -1.46672716E-02 , 0.147144958     , 0.723159671     , 0.129695386    ,
  0.141499996     , 0.554747462      , 4.21245769E-02  , 2.58229747E-02 , -1.46713303E-02 , 0.146705076     , 0.722998798     , 0.130296111    ,
  0.142499998     , 0.554572225      , 4.21280898E-02  , 2.58384105E-02 , -1.46752102E-02 , 0.146262258     , 0.722836554     , 0.130901158    ,
  0.143500000     , 0.554396749      , 4.21315171E-02  , 2.58537866E-02 , -1.46789113E-02 , 0.145816505     , 0.722672939     , 0.131510541    ,
  0.144500002     , 0.554221034      , 4.21348624E-02  , 2.58691013E-02 , -1.46824298E-02 , 0.145367816     , 0.722507954     , 0.132124230    ,
  0.145500004     , 0.554045141      , 4.21381257E-02  , 2.58843526E-02 , -1.46857658E-02 , 0.144916207     , 0.722341537     , 0.132742241    ,
  0.146500006     , 0.553869009      , 4.21413071E-02  , 2.58995406E-02 , -1.46889184E-02 , 0.144461691     , 0.722173810     , 0.133364528    ,
  0.147499993     , 0.553692698      , 4.21444103E-02  , 2.59146634E-02 , -1.46918865E-02 , 0.144004270     , 0.722004652     , 0.133991092    ,
  0.148499995     , 0.553516090      , 4.21474315E-02  , 2.59297192E-02 , -1.46946684E-02 , 0.143543944     , 0.721834123     , 0.134621933    ,
  0.149499997     , 0.553339303      , 4.21503820E-02  , 2.59447079E-02 , -1.46972630E-02 , 0.143080726     , 0.721662223     , 0.135257050    ,
  0.150500000     , 0.553162277      , 4.21532542E-02  , 2.59596296E-02 , -1.46996705E-02 , 0.142614633     , 0.721488953     , 0.135896400    ,
  0.151500002     , 0.552985013      , 4.21560518E-02  , 2.59744786E-02 , -1.47018880E-02 , 0.142145663     , 0.721314371     , 0.136539981    ,
  0.152500004     , 0.552807570      , 4.21587788E-02  , 2.59892587E-02 , -1.47039173E-02 , 0.141673833     , 0.721138358     , 0.137187794    ,
  0.153500006     , 0.552629828      , 4.21614349E-02  , 2.60039680E-02 , -1.47057548E-02 , 0.141199127     , 0.720961034     , 0.137839824    ,
  0.154499993     , 0.552451849      , 4.21640202E-02  , 2.60186046E-02 , -1.47074014E-02 , 0.140721589     , 0.720782340     , 0.138496056    ,
  0.155499995     , 0.552273631      , 4.21665348E-02  , 2.60331687E-02 , -1.47088561E-02 , 0.140241206     , 0.720602334     , 0.139156476    ,
  0.156499997     , 0.552095175      , 4.21689823E-02  , 2.60476582E-02 , -1.47101181E-02 , 0.139757991     , 0.720420957     , 0.139821067    ,
  0.157499999     , 0.551916420      , 4.21713628E-02  , 2.60620750E-02 , -1.47111872E-02 , 0.139271945     , 0.720238209     , 0.140489817    ,
  0.158500001     , 0.551737428      , 4.21736762E-02  , 2.60764156E-02 , -1.47120617E-02 , 0.138783082     , 0.720054209     , 0.141162723    ,
  0.159500003     , 0.551558197      , 4.21759263E-02  , 2.60906816E-02 , -1.47127407E-02 , 0.138291419     , 0.719868779     , 0.141839772    ,
  0.160500005     , 0.551378667      , 4.21781093E-02  , 2.61048712E-02 , -1.47132259E-02 , 0.137796968     , 0.719682097     , 0.142520949    ,
  0.161500007     , 0.551198900      , 4.21802290E-02  , 2.61189863E-02 , -1.47135137E-02 , 0.137299716     , 0.719494045     , 0.143206224    ,
  0.162499994     , 0.551018834      , 4.21822853E-02  , 2.61330232E-02 , -1.47136068E-02 , 0.136799678     , 0.719304740     , 0.143895596    ,
  0.163499996     , 0.550838530      , 4.21842821E-02  , 2.61469819E-02 , -1.47135016E-02 , 0.136296883     , 0.719114065     , 0.144589067    ,
  0.164499998     , 0.550657928      , 4.21862155E-02  , 2.61608642E-02 , -1.47131998E-02 , 0.135791332     , 0.718922079     , 0.145286590    ,
  0.165500000     , 0.550477028      , 4.21880856E-02  , 2.61746701E-02 , -1.47127006E-02 , 0.135283023     , 0.718728781     , 0.145988181    ,
  0.166500002     , 0.550295889      , 4.21898961E-02  , 2.61883959E-02 , -1.47120031E-02 , 0.134771973     , 0.718534231     , 0.146693811    ,
  0.167500004     , 0.550114393      , 4.21916507E-02  , 2.62020454E-02 , -1.47111062E-02 , 0.134258181     , 0.718338370     , 0.147403464    ,
  0.168500006     , 0.549932659      , 4.21933420E-02  , 2.62156148E-02 , -1.47100110E-02 , 0.133741677     , 0.718141198     , 0.148117140    ,
  0.169499993     , 0.549750566      , 4.21949774E-02  , 2.62291078E-02 , -1.47087174E-02 , 0.133222461     , 0.717942715     , 0.148834810    ,
  0.170499995     , 0.549568236      , 4.21965532E-02  , 2.62425207E-02 , -1.47072235E-02 , 0.132700548     , 0.717742980     , 0.149556458    ,
  0.171499997     , 0.549385548      , 4.21980694E-02  , 2.62558535E-02 , -1.47055294E-02 , 0.132175937     , 0.717541993     , 0.150282085    ,
  0.172499999     , 0.549202561      , 4.21995334E-02  , 2.62691099E-02 , -1.47036361E-02 , 0.131648645     , 0.717339694     , 0.151011661    ,
  0.173500001     , 0.549019277      , 4.22009379E-02  , 2.62822863E-02 , -1.47015424E-02 , 0.131118685     , 0.717136145     , 0.151745170    ,
  0.174500003     , 0.548835695      , 4.22022827E-02  , 2.62953825E-02 , -1.46992477E-02 , 0.130586058     , 0.716931343     , 0.152482614    ,
  0.175500005     , 0.548651755      , 4.22035754E-02  , 2.63084024E-02 , -1.46967527E-02 , 0.130050778     , 0.716725290     , 0.153223962    ,
  0.176499993     , 0.548467457      , 4.22048122E-02  , 2.63213422E-02 , -1.46940565E-02 , 0.129512861     , 0.716517925     , 0.153969198    ,
  0.177499995     , 0.548282862      , 4.22059931E-02  , 2.63342019E-02 , -1.46911591E-02 , 0.128972322     , 0.716309369     , 0.154718310    ,
  0.178499997     , 0.548097968      , 4.22071218E-02  , 2.63469853E-02 , -1.46880616E-02 , 0.128429160     , 0.716099560     , 0.155471295    ,
  0.179499999     , 0.547912657      , 4.22081910E-02  , 2.63596885E-02 , -1.46847609E-02 , 0.127883375     , 0.715888500     , 0.156228110    ,
  0.180500001     , 0.547727048      , 4.22092117E-02  , 2.63723135E-02 , -1.46812601E-02 , 0.127335012     , 0.715676248     , 0.156988755    ,
  0.181500003     , 0.547541082      , 4.22101729E-02  , 2.63848603E-02 , -1.46775572E-02 , 0.126784056     , 0.715462744     , 0.157753214    ,
  0.182500005     , 0.547354758      , 4.22110856E-02  , 2.63973288E-02 , -1.46736521E-02 , 0.126230523     , 0.715247989     , 0.158521473    ,
  0.183500007     , 0.547168076      , 4.22119386E-02  , 2.64097210E-02 , -1.46695459E-02 , 0.125674441     , 0.715032041     , 0.159293503    ,
  0.184499994     , 0.546981037      , 4.22127433E-02  , 2.64220331E-02 , -1.46652376E-02 , 0.125115797     , 0.714814901     , 0.160069302    ,
  0.185499996     , 0.546793640      , 4.22134921E-02  , 2.64342688E-02 , -1.46607272E-02 , 0.124554612     , 0.714596570     , 0.160848841    ,
  0.186499998     , 0.546605825      , 4.22141925E-02  , 2.64464281E-02 , -1.46560147E-02 , 0.123990893     , 0.714376986     , 0.161632121    ,
  0.187500000     , 0.546417654      , 4.22148369E-02  , 2.64585093E-02 , -1.46511002E-02 , 0.123424664     , 0.714156270     , 0.162419096    ,
  0.188500002     , 0.546229124      , 4.22154292E-02  , 2.64705140E-02 , -1.46459844E-02 , 0.122855924     , 0.713934302     , 0.163209766    ,
  0.189500004     , 0.546040177      , 4.22159694E-02  , 2.64824443E-02 , -1.46406656E-02 , 0.122284696     , 0.713711202     , 0.164004117    ,
  0.190500006     , 0.545850873      , 4.22164537E-02  , 2.64942963E-02 , -1.46351457E-02 , 0.121710978     , 0.713486910     , 0.164802134    ,
  0.191499993     , 0.545661151      , 4.22168896E-02  , 2.65060738E-02 , -1.46294227E-02 , 0.121134795     , 0.713261425     , 0.165603787    ,
  0.192499995     , 0.545471013      , 4.22172733E-02  , 2.65177749E-02 , -1.46234985E-02 , 0.120556153     , 0.713034809     , 0.166409060    ,
  0.193499997     , 0.545280516      , 4.22176085E-02  , 2.65294015E-02 , -1.46173723E-02 , 0.119975068     , 0.712807000     , 0.167217940    ,
  0.194499999     , 0.545089543      , 4.22178879E-02  , 2.65409537E-02 , -1.46110430E-02 , 0.119391546     , 0.712578058     , 0.168030411    ,
  0.195500001     , 0.544898212      , 4.22181152E-02  , 2.65524331E-02 , -1.46045135E-02 , 0.118805602     , 0.712347925     , 0.168846458    ,
  0.196500003     , 0.544706464      , 4.22182940E-02  , 2.65638363E-02 , -1.45977810E-02 , 0.118217252     , 0.712116718     , 0.169666052    ,
  0.197500005     , 0.544514239      , 4.22184207E-02  , 2.65751686E-02 , -1.45908464E-02 , 0.117626503     , 0.711884320     , 0.170489177    ,
  0.198500007     , 0.544321597      , 4.22184952E-02  , 2.65864264E-02 , -1.45837115E-02 , 0.117033370     , 0.711650848     , 0.171315819    ,
  0.199499995     , 0.544128537      , 4.22185212E-02  , 2.65976116E-02 , -1.45763736E-02 , 0.116437860     , 0.711416185     , 0.172145948    ,
  0.200499997     , 0.543935001      , 4.22184914E-02  , 2.66087260E-02 , -1.45688346E-02 , 0.115840003     , 0.711180449     , 0.172979563    ,
  0.201499999     , 0.543741047      , 4.22184132E-02  , 2.66197678E-02 , -1.45610943E-02 , 0.115239792     , 0.710943580     , 0.173816636    ,
  0.202500001     , 0.543546617      , 4.22182865E-02  , 2.66307388E-02 , -1.45531520E-02 , 0.114637248     , 0.710705578     , 0.174657151    ,
  0.203500003     , 0.543351769      , 4.22181077E-02  , 2.66416389E-02 , -1.45450085E-02 , 0.114032388     , 0.710466564     , 0.175501078    ,
  0.204500005     , 0.543156445      , 4.22178768E-02  , 2.66524702E-02 , -1.45366648E-02 , 0.113425218     , 0.710226357     , 0.176348418    ,
  0.205500007     , 0.542960644      , 4.22175936E-02  , 2.66632307E-02 , -1.45281190E-02 , 0.112815753     , 0.709985137     , 0.177199125    ,
  0.206499994     , 0.542764366      , 4.22172621E-02  , 2.66739223E-02 , -1.45193730E-02 , 0.112204015     , 0.709742785     , 0.178053215    ,
  0.207499996     , 0.542567611      , 4.22168784E-02  , 2.66845450E-02 , -1.45104248E-02 , 0.111589998     , 0.709499359     , 0.178910628    ,
  0.208499998     , 0.542370319      , 4.22164463E-02  , 2.66951006E-02 , -1.45012774E-02 , 0.110973738     , 0.709254861     , 0.179771379    ,
  0.209500000     , 0.542172611      , 4.22159620E-02  , 2.67055873E-02 , -1.44919287E-02 , 0.110355228     , 0.709009349     , 0.180635437    ,
  0.210500002     , 0.541974366      , 4.22154255E-02  , 2.67160088E-02 , -1.44823790E-02 , 0.109734498     , 0.708762705     , 0.181502774    ,
  0.211500004     , 0.541775644      , 4.22148407E-02  , 2.67263632E-02 , -1.44726299E-02 , 0.109111555     , 0.708515048     , 0.182373375    ,
  0.212500006     , 0.541576385      , 4.22142036E-02  , 2.67366506E-02 , -1.44626806E-02 , 0.108486407     , 0.708266377     , 0.183247223    ,
  0.213499993     , 0.541376650      , 4.22135182E-02  , 2.67468747E-02 , -1.44525301E-02 , 0.107859075     , 0.708016634     , 0.184124291    ,
  0.214499995     , 0.541176379      , 4.22127806E-02  , 2.67570335E-02 , -1.44421812E-02 , 0.107229568     , 0.707765877     , 0.185004577    ,
  0.215499997     , 0.540975571      , 4.22119945E-02  , 2.67671291E-02 , -1.44316312E-02 , 0.106597908     , 0.707514048     , 0.185888037    ,
  0.216499999     , 0.540774226      , 4.22111526E-02  , 2.67771594E-02 , -1.44208828E-02 , 0.105964102     , 0.707261264     , 0.186774656    ,
  0.217500001     , 0.540572345      , 4.22102660E-02  , 2.67871283E-02 , -1.44099342E-02 , 0.105328165     , 0.707007408     , 0.187664434    ,
  0.218500003     , 0.540369928      , 4.22093272E-02  , 2.67970338E-02 , -1.43987862E-02 , 0.104690112     , 0.706752539     , 0.188557327    ,
  0.219500005     , 0.540166974      , 4.22083363E-02  , 2.68068779E-02 , -1.43874399E-02 , 0.104049951     , 0.706496716     , 0.189453319    ,
  0.220500007     , 0.539963424      , 4.22072932E-02  , 2.68166624E-02 , -1.43758943E-02 , 0.103407711     , 0.706239879     , 0.190352395    ,
  0.221499994     , 0.539759338      , 4.22062017E-02  , 2.68263854E-02 , -1.43641494E-02 , 0.102763392     , 0.705982089     , 0.191254541    ,
  0.222499996     , 0.539554715      , 4.22050618E-02  , 2.68360488E-02 , -1.43522071E-02 , 0.102117017     , 0.705723286     , 0.192159727    ,
  0.223499998     , 0.539349496      , 4.22038659E-02  , 2.68456545E-02 , -1.43400654E-02 , 0.101468593     , 0.705463469     , 0.193067923    ,
  0.224500000     , 0.539143682      , 4.22026254E-02  , 2.68552005E-02 , -1.43277254E-02 , 0.100818135     , 0.705202758     , 0.193979114    ,
  0.225500003     , 0.538937271      , 4.22013290E-02  , 2.68646888E-02 , -1.43151879E-02 , 0.100165673     , 0.704941034     , 0.194893301    ,
  0.226500005     , 0.538730264      , 4.21999842E-02  , 2.68741194E-02 , -1.43024521E-02 ,  9.95111987E-02 , 0.704678357     , 0.195810437    ,
  0.227500007     , 0.538522661      , 4.21985872E-02  , 2.68834941E-02 , -1.42895188E-02 ,  9.88547429E-02 , 0.704414785     , 0.196730494    ,
  0.228499994     , 0.538314521      , 4.21971418E-02  , 2.68928129E-02 , -1.42763881E-02 ,  9.81963128E-02 , 0.704150200     , 0.197653487    ,
  0.229499996     , 0.538105667      , 4.21956442E-02  , 2.69020777E-02 , -1.42630599E-02 ,  9.75359231E-02 , 0.703884721     , 0.198579356    ,
  0.230499998     , 0.537896276      , 4.21940945E-02  , 2.69112866E-02 , -1.42495343E-02 ,  9.68735963E-02 , 0.703618288     , 0.199508101    ,
  0.231500000     , 0.537686229      , 4.21924964E-02  , 2.69204434E-02 , -1.42358113E-02 ,  9.62093398E-02 , 0.703350961     , 0.200439692    ,
  0.232500002     , 0.537475526      , 4.21908461E-02  , 2.69295461E-02 , -1.42218927E-02 ,  9.55431685E-02 , 0.703082740     , 0.201374114    ,
  0.233500004     , 0.537264168      , 4.21891436E-02  , 2.69385949E-02 , -1.42077766E-02 ,  9.48751047E-02 , 0.702813566     , 0.202311352    ,
  0.234500006     , 0.537052214      , 4.21873927E-02  , 2.69475952E-02 , -1.41934641E-02 ,  9.42051560E-02 , 0.702543497     , 0.203251362    ,
  0.235499993     , 0.536839604      , 4.21855897E-02  , 2.69565415E-02 , -1.41789550E-02 ,  9.35333371E-02 , 0.702272534     , 0.204194129    ,
  0.236499995     , 0.536626339      , 4.21837345E-02  , 2.69654393E-02 , -1.41642503E-02 ,  9.28596705E-02 , 0.702000678     , 0.205139652    ,
  0.237499997     , 0.536412358      , 4.21818309E-02  , 2.69742869E-02 , -1.41493501E-02 ,  9.21841636E-02 , 0.701727986     , 0.206087872    ,
  0.238499999     , 0.536197782      , 4.21798714E-02  , 2.69830860E-02 , -1.41342534E-02 ,  9.15068388E-02 , 0.701454341     , 0.207038805    ,
  0.239500001     , 0.535982430      , 4.21778634E-02  , 2.69918367E-02 , -1.41189611E-02 ,  9.08277035E-02 , 0.701179922     , 0.207992405    ,
  0.240500003     , 0.535766482      , 4.21758071E-02  , 2.70005409E-02 , -1.41034732E-02 ,  9.01467726E-02 , 0.700904548     , 0.208948657    ,
  0.241500005     , 0.535549819      , 4.21736948E-02  , 2.70091966E-02 , -1.40877906E-02 ,  8.94640759E-02 , 0.700628400     , 0.209907547    ,
  0.242500007     , 0.535332441      , 4.21715342E-02  , 2.70178076E-02 , -1.40719134E-02 ,  8.87796134E-02 , 0.700351357     , 0.210869029    ,
  0.243499994     , 0.535114348      , 4.21693213E-02  , 2.70263720E-02 , -1.40558407E-02 ,  8.80934075E-02 , 0.700073481     , 0.211833104    ,
  0.244499996     , 0.534895539      , 4.21670564E-02  , 2.70348936E-02 , -1.40395733E-02 ,  8.74054730E-02 , 0.699794769     , 0.212799743    ,
  0.245499998     , 0.534676015      , 4.21647392E-02  , 2.70433705E-02 , -1.40231112E-02 ,  8.67158249E-02 , 0.699515283     , 0.213768914    ,
  0.246500000     , 0.534455717      , 4.21623737E-02  , 2.70518046E-02 , -1.40064554E-02 ,  8.60244855E-02 , 0.699234903     , 0.214740604    ,
  0.247500002     , 0.534234762      , 4.21599559E-02  , 2.70601958E-02 , -1.39896050E-02 ,  8.53314549E-02 , 0.698953748     , 0.215714797    ,
  0.248500004     , 0.534013033      , 4.21574824E-02  , 2.70685460E-02 , -1.39725609E-02 ,  8.46367627E-02 , 0.698671758     , 0.216691449    ,
  0.249500006     , 0.533790529      , 4.21549603E-02  , 2.70768553E-02 , -1.39553221E-02 ,  8.39404240E-02 , 0.698389053     , 0.217670560    ,
  0.250499994     , 0.533567309      , 4.21523899E-02  , 2.70851254E-02 , -1.39378905E-02 ,  8.32424462E-02 , 0.698105454     , 0.218652084    ,
  0.251500010     , 0.533343315      , 4.21497636E-02  , 2.70933546E-02 , -1.39202652E-02 ,  8.25428441E-02 , 0.697821140     , 0.219636023    ,
  0.252499998     , 0.533118486      , 4.21470851E-02  , 2.71015447E-02 , -1.39024463E-02 ,  8.18416476E-02 , 0.697536051     , 0.220622331    ,
  0.253500015     , 0.532892942      , 4.21443544E-02  , 2.71096993E-02 , -1.38844345E-02 ,  8.11388642E-02 , 0.697250128     , 0.221610993    ,
  0.254500002     , 0.532666624      , 4.21415754E-02  , 2.71178149E-02 , -1.38662299E-02 ,  8.04345086E-02 , 0.696963489     , 0.222601995    ,
  0.255499989     , 0.532439470      , 4.21387404E-02  , 2.71258950E-02 , -1.38478316E-02 ,  7.97285959E-02 , 0.696676075     , 0.223595306    ,
  0.256500006     , 0.532211542      , 4.21358570E-02  , 2.71339398E-02 , -1.38292415E-02 ,  7.90211484E-02 , 0.696387947     , 0.224590912    ,
  0.257499993     , 0.531982780      , 4.21329178E-02  , 2.71419492E-02 , -1.38104586E-02 ,  7.83121809E-02 , 0.696099043     , 0.225588784    ,
  0.258500010     , 0.531753182      , 4.21299301E-02  , 2.71499250E-02 , -1.37914829E-02 ,  7.76017085E-02 , 0.695809424     , 0.226588875    ,
  0.259499997     , 0.531522810      , 4.21268865E-02  , 2.71578673E-02 , -1.37723153E-02 ,  7.68897384E-02 , 0.695519030     , 0.227591202    ,
  0.260500014     , 0.531291544      , 4.21237908E-02  , 2.71657761E-02 , -1.37529559E-02 ,  7.61763006E-02 , 0.695227981     , 0.228595719    ,
  0.261500001     , 0.531059504      , 4.21206467E-02  , 2.71736551E-02 , -1.37334038E-02 ,  7.54614100E-02 , 0.694936216     , 0.229602396    ,
  0.262499988     , 0.530826569      , 4.21174467E-02  , 2.71815024E-02 , -1.37136597E-02 ,  7.47450739E-02 , 0.694643676     , 0.230611220    ,
  0.263500005     , 0.530592799      , 4.21141945E-02  , 2.71893200E-02 , -1.36937248E-02 ,  7.40273148E-02 , 0.694350481     , 0.231622174    ,
  0.264499992     , 0.530358136      , 4.21108902E-02  , 2.71971077E-02 , -1.36735979E-02 ,  7.33081475E-02 , 0.694056630     , 0.232635230    ,
  0.265500009     , 0.530122638      , 4.21075337E-02  , 2.72048656E-02 , -1.36532793E-02 ,  7.25875869E-02 , 0.693762064     , 0.233650357    ,
  0.266499996     , 0.529886246      , 4.21041250E-02  , 2.72125974E-02 , -1.36327697E-02 ,  7.18656555E-02 , 0.693466783     , 0.234667540    ,
  0.267500013     , 0.529648960      , 4.21006605E-02  , 2.72203013E-02 , -1.36120692E-02 ,  7.11423680E-02 , 0.693170905     , 0.235686749    ,
  0.268500000     , 0.529410779      , 4.20971438E-02  , 2.72279792E-02 , -1.35911768E-02 ,  7.04177320E-02 , 0.692874312     , 0.236707956    ,
  0.269499987     , 0.529171705      , 4.20935750E-02  , 2.72356328E-02 , -1.35700945E-02 ,  6.96917772E-02 , 0.692577064     , 0.237731144    ,
  0.270500004     , 0.528931737      , 4.20899540E-02  , 2.72432603E-02 , -1.35488203E-02 ,  6.89645112E-02 , 0.692279220     , 0.238756284    ,
  0.271499991     , 0.528690815      , 4.20862809E-02  , 2.72508636E-02 , -1.35273561E-02 ,  6.82359561E-02 , 0.691980660     , 0.239783362    ,
  0.272500008     , 0.528448939      , 4.20825519E-02  , 2.72584446E-02 , -1.35057010E-02 ,  6.75061271E-02 , 0.691681504     , 0.240812346    ,
  0.273499995     , 0.528206170      , 4.20787707E-02  , 2.72660032E-02 , -1.34838549E-02 ,  6.67750388E-02 , 0.691381752     , 0.241843224    ,
  0.274500012     , 0.527962446      , 4.20749336E-02  , 2.72735413E-02 , -1.34618189E-02 ,  6.60427138E-02 , 0.691081345     , 0.242875949    ,
  0.275500000     , 0.527717769      , 4.20710482E-02  , 2.72810571E-02 , -1.34395920E-02 ,  6.53091595E-02 , 0.690780342     , 0.243910506    ,
  0.276499987     , 0.527472138      , 4.20671031E-02  , 2.72885542E-02 , -1.34171750E-02 ,  6.45743981E-02 , 0.690478742     , 0.244946882    ,
  0.277500004     , 0.527225554      , 4.20631096E-02  , 2.72960309E-02 , -1.33945681E-02 ,  6.38384521E-02 , 0.690176487     , 0.245985046    ,
  0.278499991     , 0.526977956      , 4.20590565E-02  , 2.73034889E-02 , -1.33717712E-02 ,  6.31013289E-02 , 0.689873695     , 0.247024968    ,
  0.279500008     , 0.526729345      , 4.20549549E-02  , 2.73109321E-02 , -1.33487834E-02 ,  6.23630472E-02 , 0.689570308     , 0.248066634    ,
  0.280499995     , 0.526479781      , 4.20507975E-02  , 2.73183566E-02 , -1.33256065E-02 ,  6.16236292E-02 , 0.689266384     , 0.249110013    ,
  0.281500012     , 0.526229262      , 4.20465842E-02  , 2.73257643E-02 , -1.33022396E-02 ,  6.08830862E-02 , 0.688961864     , 0.250155061    ,
  0.282499999     , 0.525977671      , 4.20423187E-02  , 2.73331590E-02 , -1.32786818E-02 ,  6.01414405E-02 , 0.688656747     , 0.251201808    ,
  0.283499986     , 0.525725067      , 4.20379974E-02  , 2.73405369E-02 , -1.32549349E-02 ,  5.93987070E-02 , 0.688351154     , 0.252250165    ,
  0.284500003     , 0.525471449      , 4.20336202E-02  , 2.73479037E-02 , -1.32309990E-02 ,  5.86549044E-02 , 0.688044965     , 0.253300160    ,
  0.285499990     , 0.525216758      , 4.20291908E-02  , 2.73552556E-02 , -1.32068722E-02 ,  5.79100475E-02 , 0.687738240     , 0.254351735    ,
  0.286500007     , 0.524961054      , 4.20247056E-02  , 2.73625981E-02 , -1.31825563E-02 ,  5.71641549E-02 , 0.687430978     , 0.255404860    ,
  0.287499994     , 0.524704278      , 4.20201644E-02  , 2.73699276E-02 , -1.31580504E-02 ,  5.64172417E-02 , 0.687123239     , 0.256459534    ,
  0.288500011     , 0.524446487      , 4.20155674E-02  , 2.73772478E-02 , -1.31333554E-02 ,  5.56693263E-02 , 0.686814964     , 0.257515728    ,
  0.289499998     , 0.524187565      , 4.20109183E-02  , 2.73845587E-02 , -1.31084705E-02 ,  5.49204275E-02 , 0.686506152     , 0.258573413    ,
  0.290499985     , 0.523927569      , 4.20062132E-02  , 2.73918603E-02 , -1.30833965E-02 ,  5.41705601E-02 , 0.686196864     , 0.259632587    ,
  0.291500002     , 0.523666501      , 4.20014523E-02  , 2.73991544E-02 , -1.30581316E-02 ,  5.34197465E-02 , 0.685887098     , 0.260693163    ,
  0.292499989     , 0.523404360      , 4.19966318E-02  , 2.74064410E-02 , -1.30326785E-02 ,  5.26679978E-02 , 0.685576797     , 0.261755168    ,
  0.293500006     , 0.523141086      , 4.19917591E-02  , 2.74137203E-02 , -1.30070355E-02 ,  5.19153364E-02 , 0.685266078     , 0.262818575    ,
  0.294499993     , 0.522876680      , 4.19868305E-02  , 2.74209958E-02 , -1.29812025E-02 ,  5.11617772E-02 , 0.684954882     , 0.263883352    ,
  0.295500010     , 0.522611141      , 4.19818461E-02  , 2.74282675E-02 , -1.29551804E-02 ,  5.04073389E-02 , 0.684643209     , 0.264949441    ,
  0.296499997     , 0.522344530      , 4.19768058E-02  , 2.74355337E-02 , -1.29289683E-02 ,  4.96520363E-02 , 0.684331059     , 0.266016871    ,
  0.297500014     , 0.522076726      , 4.19717059E-02  , 2.74427980E-02 , -1.29025662E-02 ,  4.88958918E-02 , 0.684018493     , 0.267085582    ,
  0.298500001     , 0.521807790      , 4.19665501E-02  , 2.74500586E-02 , -1.28759751E-02 ,  4.81389202E-02 , 0.683705509     , 0.268155575    ,
  0.299499989     , 0.521537662      , 4.19613384E-02  , 2.74573192E-02 , -1.28491949E-02 ,  4.73811366E-02 , 0.683392048     , 0.269226789    ,
  0.300500005     , 0.521266401      , 4.19560708E-02  , 2.74645798E-02 , -1.28222238E-02 ,  4.66225632E-02 , 0.683078229     , 0.270299226    ,
  0.301499993     , 0.520993948      , 4.19507436E-02  , 2.74718404E-02 , -1.27950637E-02 ,  4.58632149E-02 , 0.682763934     , 0.271372855    ,
  0.302500010     , 0.520720303      , 4.19453606E-02  , 2.74791010E-02 , -1.27677135E-02 ,  4.51031104E-02 , 0.682449222     , 0.272447646    ,
  0.303499997     , 0.520445526      , 4.19399180E-02  , 2.74863653E-02 , -1.27401734E-02 ,  4.43422683E-02 , 0.682134151     , 0.273523569    ,
  0.304500014     , 0.520169437      , 4.19344194E-02  , 2.74936315E-02 , -1.27124442E-02 ,  4.35807072E-02 , 0.681818664     , 0.274600625    ,
  0.305500001     , 0.519892216      , 4.19288613E-02  , 2.75009014E-02 , -1.26845241E-02 ,  4.28184420E-02 , 0.681502819     , 0.275678754    ,
  0.306499988     , 0.519613743      , 4.19232473E-02  , 2.75081750E-02 , -1.26564140E-02 ,  4.20554914E-02 , 0.681186557     , 0.276757926    ,
  0.307500005     , 0.519334018      , 4.19175737E-02  , 2.75154542E-02 , -1.26281139E-02 ,  4.12918739E-02 , 0.680869937     , 0.277838171    ,
  0.308499992     , 0.519053042      , 4.19118404E-02  , 2.75227409E-02 , -1.25996238E-02 ,  4.05276045E-02 , 0.680553019     , 0.278919399    ,
  0.309500009     , 0.518770874      , 4.19060476E-02  , 2.75300331E-02 , -1.25709428E-02 ,  3.97627093E-02 , 0.680235684     , 0.280001611    ,
  0.310499996     , 0.518487394      , 4.19001952E-02  , 2.75373347E-02 , -1.25420718E-02 ,  3.89971957E-02 , 0.679917991     , 0.281084806    ,
  0.311500013     , 0.518202662      , 4.18942869E-02  , 2.75446437E-02 , -1.25130098E-02 ,  3.82310897E-02 , 0.679600000     , 0.282168925    ,
  0.312500000     , 0.517916620      , 4.18883152E-02  , 2.75519621E-02 , -1.24837579E-02 ,  3.74644063E-02 , 0.679281652     , 0.283253938    ,
  0.313499987     , 0.517629325      , 4.18822877E-02  , 2.75592916E-02 , -1.24543151E-02 ,  3.66971642E-02 , 0.678963006     , 0.284339845    ,
  0.314500004     , 0.517340720      , 4.18761969E-02  , 2.75666323E-02 , -1.24246813E-02 ,  3.59293781E-02 , 0.678644001     , 0.285426617    ,
  0.315499991     , 0.517050743      , 4.18700427E-02  , 2.75739841E-02 , -1.23948557E-02 ,  3.51610705E-02 , 0.678324699     , 0.286514223    ,
  0.316500008     , 0.516759515      , 4.18638326E-02  , 2.75813490E-02 , -1.23648401E-02 ,  3.43922600E-02 , 0.678005099     , 0.287602603    ,
  0.317499995     , 0.516466975      , 4.18575592E-02  , 2.75887288E-02 , -1.23346327E-02 ,  3.36229615E-02 , 0.677685261     , 0.288691789    ,
  0.318500012     , 0.516173065      , 4.18512262E-02  , 2.75961217E-02 , -1.23042343E-02 ,  3.28531936E-02 , 0.677365065     , 0.289781719    ,
  0.319499999     , 0.515877783      , 4.18448299E-02  , 2.76035313E-02 , -1.22736441E-02 ,  3.20829749E-02 , 0.677044630     , 0.290872365    ,
  0.320499986     , 0.515581191      , 4.18383740E-02  , 2.76109558E-02 , -1.22428620E-02 ,  3.13123241E-02 , 0.676723957     , 0.291963726    ,
  0.321500003     , 0.515283227      , 4.18318547E-02  , 2.76183989E-02 , -1.22118872E-02 ,  3.05412598E-02 , 0.676402986     , 0.293055773    ,
  0.322499990     , 0.514983833      , 4.18252721E-02  , 2.76258588E-02 , -1.21807214E-02 ,  2.97698006E-02 , 0.676081777     , 0.294148445    ,
  0.323500007     , 0.514683127      , 4.18186262E-02  , 2.76333373E-02 , -1.21493628E-02 ,  2.89979633E-02 , 0.675760269     , 0.295241743    ,
  0.324499995     , 0.514380932      , 4.18119170E-02  , 2.76408363E-02 , -1.21178124E-02 ,  2.82257665E-02 , 0.675438583     , 0.296335667    ,
  0.325500011     , 0.514077425      , 4.18051481E-02  , 2.76483558E-02 , -1.20860683E-02 ,  2.74532288E-02 , 0.675116658     , 0.297430128    ,
  0.326499999     , 0.513772428      , 4.17983122E-02  , 2.76558958E-02 , -1.20541323E-02 ,  2.66803708E-02 , 0.674794495     , 0.298525155    ,
  0.327499986     , 0.513466060      , 4.17914130E-02  , 2.76634600E-02 , -1.20220026E-02 ,  2.59072073E-02 , 0.674472094     , 0.299620688    ,
  0.328500003     , 0.513158202      , 4.17844467E-02  , 2.76710447E-02 , -1.19896792E-02 ,  2.51337588E-02 , 0.674149573     , 0.300716698    ,
  0.329499990     , 0.512848914      , 4.17774208E-02  , 2.76786555E-02 , -1.19571630E-02 ,  2.43600421E-02 , 0.673826754     , 0.301813185    ,
  0.330500007     , 0.512538195      , 4.17703241E-02  , 2.76862904E-02 , -1.19244531E-02 ,  2.35860776E-02 , 0.673503816     , 0.302910119    ,
  0.331499994     , 0.512225986      , 4.17631678E-02  , 2.76939515E-02 , -1.18915485E-02 ,  2.28118841E-02 , 0.673180640     , 0.304007441    ,
  0.332500011     , 0.511912286      , 4.17559408E-02  , 2.77016386E-02 , -1.18584502E-02 ,  2.20374782E-02 , 0.672857344     , 0.305105180    ,
  0.333499998     , 0.511597157      , 4.17486504E-02  , 2.77093519E-02 , -1.18251573E-02 ,  2.12628786E-02 , 0.672533870     , 0.306203276    ,
  0.334500015     , 0.511280477      , 4.17412929E-02  , 2.77170949E-02 , -1.17916698E-02 ,  2.04881039E-02 , 0.672210217     , 0.307301700    ,
  0.335500002     , 0.510962248      , 4.17338684E-02  , 2.77248677E-02 , -1.17579866E-02 ,  1.97131746E-02 , 0.671886384     , 0.308400422    ,
  0.336499989     , 0.510642588      , 4.17263731E-02  , 2.77326703E-02 , -1.17241079E-02 ,  1.89381093E-02 , 0.671562493     , 0.309499413    ,
  0.337500006     , 0.510321379      , 4.17188145E-02  , 2.77405027E-02 , -1.16900345E-02 ,  1.81629229E-02 , 0.671238422     , 0.310598671    ,
  0.338499993     , 0.509998560      , 4.17111851E-02  , 2.77483687E-02 , -1.16557647E-02 ,  1.73876379E-02 , 0.670914173     , 0.311698169    ,
  0.339500010     , 0.509674251      , 4.17034887E-02  , 2.77562663E-02 , -1.16212983E-02 ,  1.66122708E-02 , 0.670589864     , 0.312797844    ,
  0.340499997     , 0.509348392      , 4.16957214E-02  , 2.77641974E-02 , -1.15866354E-02 ,  1.58368424E-02 , 0.670265436     , 0.313897699    ,
  0.341500014     , 0.509020925      , 4.16878872E-02  , 2.77721621E-02 , -1.15517760E-02 ,  1.50613701E-02 , 0.669940948     , 0.314997703    ,
  0.342500001     , 0.508691907      , 4.16799821E-02  , 2.77801640E-02 , -1.15167182E-02 ,  1.42858727E-02 , 0.669616282     , 0.316097826    ,
  0.343499988     , 0.508361280      , 4.16720062E-02  , 2.77882013E-02 , -1.14814639E-02 ,  1.35103688E-02 , 0.669291556     , 0.317198038    ,
  0.344500005     , 0.508029044      , 4.16639596E-02  , 2.77962759E-02 , -1.14460113E-02 ,  1.27348779E-02 , 0.668966770     , 0.318298340    ,
  0.345499992     , 0.507695198      , 4.16558385E-02  , 2.78043877E-02 , -1.14103612E-02 ,  1.19594187E-02 , 0.668641925     , 0.319398671    ,
  0.346500009     , 0.507359743      , 4.16476503E-02  , 2.78125387E-02 , -1.13745118E-02 ,  1.11840088E-02 , 0.668317020     , 0.320499003    ,
  0.347499996     , 0.507022619      , 4.16393876E-02  , 2.78207306E-02 , -1.13384631E-02 ,  1.04086697E-02 , 0.667991996     , 0.321599305    ,
  0.348500013     , 0.506683886      , 4.16310504E-02  , 2.78289616E-02 , -1.13022150E-02 ,  9.63341817E-03 , 0.667666972     , 0.322699606    ,
  0.349500000     , 0.506343424      , 4.16226424E-02  , 2.78372355E-02 , -1.12657677E-02 ,  8.85827467E-03 , 0.667341948     , 0.323799819    ,
  0.350499988     , 0.506001353      , 4.16141599E-02  , 2.78455522E-02 , -1.12291202E-02 ,  8.08325689E-03 , 0.667016804     , 0.324899912    ,
  0.351500005     , 0.505657613      , 4.16056067E-02  , 2.78539099E-02 , -1.11922715E-02 ,  7.30838394E-03 , 0.666691720     , 0.325999916    ,
  0.352499992     , 0.505312145      , 4.15969752E-02  , 2.78623141E-02 , -1.11552216E-02 ,  6.53367583E-03 , 0.666366577     , 0.327099770    ,
  0.353500009     , 0.504965007      , 4.15882654E-02  , 2.78707631E-02 , -1.11179706E-02 ,  5.75915119E-03 , 0.666041434     , 0.328199416    ,
  0.354499996     , 0.504616141      , 4.15794849E-02  , 2.78792568E-02 , -1.10805174E-02 ,  4.98482911E-03 , 0.665716290     , 0.329298884    ,
  0.355500013     , 0.504265547      , 4.15706262E-02  , 2.78877988E-02 , -1.10428622E-02 ,  4.21072822E-03 , 0.665391147     , 0.330398113    ,
  0.356500000     , 0.503913224      , 4.15616892E-02  , 2.78963875E-02 , -1.10050039E-02 ,  3.43686831E-03 , 0.665066063     , 0.331497073    ,
  0.357499987     , 0.503559172      , 4.15526740E-02  , 2.79050265E-02 , -1.09669426E-02 ,  2.66326847E-03 , 0.664740980     , 0.332595766    ,
  0.358500004     , 0.503203332      , 4.15435843E-02  , 2.79137138E-02 , -1.09286774E-02 ,  1.88994757E-03 , 0.664415896     , 0.333694130    ,
  0.359499991     , 0.502845764      , 4.15344127E-02  , 2.79224515E-02 , -1.08902073E-02 ,  1.11692504E-03 , 0.664090931     , 0.334792167    ,
  0.360500008     , 0.502486408      , 4.15251628E-02  , 2.79312432E-02 , -1.08515332E-02 ,  3.44220141E-04 , 0.663765967     , 0.335889846    ,
  0.361499995     , 0.502125204      , 4.15158309E-02  , 2.79400852E-02 , -1.08126532E-02 , -4.28147963E-04 , 0.663441062     , 0.336987108    ,
  0.362500012     , 0.501762271      , 4.15064208E-02  , 2.79489812E-02 , -1.07735675E-02 , -1.20016001E-03 , 0.663116217     , 0.338083953    ,
  0.363499999     , 0.501397491      , 4.14969288E-02  , 2.79579312E-02 , -1.07342759E-02 , -1.97179662E-03 , 0.662791431     , 0.339180350    ,
  0.364499986     , 0.501030862      , 4.14873548E-02  , 2.79669352E-02 , -1.06947776E-02 , -2.74303835E-03 , 0.662466764     , 0.340276241    ,
  0.365500003     , 0.500662386      , 4.14776988E-02  , 2.79759970E-02 , -1.06550716E-02 , -3.51386587E-03 , 0.662142217     , 0.341371655    ,
  0.366499990     , 0.500292122      , 4.14679609E-02  , 2.79851165E-02 , -1.06151570E-02 , -4.28425986E-03 , 0.661817729     , 0.342466533    ,
  0.367500007     , 0.499919951      , 4.14581373E-02  , 2.79942919E-02 , -1.05750347E-02 , -5.05420053E-03 , 0.661493361     , 0.343560845    ,
  0.368499994     , 0.499545932      , 4.14482281E-02  , 2.80035269E-02 , -1.05347028E-02 , -5.82366902E-03 , 0.661169112     , 0.344654590    ,
  0.369500011     , 0.499170005      , 4.14382331E-02  , 2.80128233E-02 , -1.04941614E-02 , -6.59264531E-03 , 0.660844982     , 0.345747679    ,
  0.370499998     , 0.498792201      , 4.14281562E-02  , 2.80221794E-02 , -1.04534104E-02 , -7.36111077E-03 , 0.660520971     , 0.346840173    ,
  0.371499985     , 0.498412490      , 4.14179899E-02  , 2.80315969E-02 , -1.04124472E-02 , -8.12904444E-03 , 0.660197079     , 0.347931951    ,
  0.372500002     , 0.498030841      , 4.14077379E-02  , 2.80410778E-02 , -1.03712734E-02 , -8.89642816E-03 , 0.659873366     , 0.349023044    ,
  0.373499990     , 0.497647285      , 4.13973965E-02  , 2.80506201E-02 , -1.03298873E-02 , -9.66324192E-03 , 0.659549832     , 0.350113422    ,
  0.374500006     , 0.497261763      , 4.13869657E-02  , 2.80602295E-02 , -1.02882879E-02 , -1.04294661E-02 , 0.659226418     , 0.351203024    ,
  0.375499994     , 0.496874303      , 4.13764454E-02  , 2.80699041E-02 , -1.02464762E-02 , -1.11950804E-02 , 0.658903241     , 0.352291852    ,
  0.376500010     , 0.496484846      , 4.13658358E-02  , 2.80796438E-02 , -1.02044493E-02 , -1.19600659E-02 , 0.658580184     , 0.353379875    ,
  0.377499998     , 0.496093452      , 4.13551331E-02  , 2.80894525E-02 , -1.01622082E-02 , -1.27244033E-02 , 0.658257365     , 0.354467064    ,
  0.378500015     , 0.495700032      , 4.13443409E-02  , 2.80993283E-02 , -1.01197511E-02 , -1.34880729E-02 , 0.657934725     , 0.355553359    ,
  0.379500002     , 0.495304614      , 4.13334519E-02  , 2.81092748E-02 , -1.00770779E-02 , -1.42510533E-02 , 0.657612264     , 0.356638789    ,
  0.380499989     , 0.494907200      , 4.13224734E-02  , 2.81192902E-02 , -1.00341886E-02 , -1.50133269E-02 , 0.657290041     , 0.357723266    ,
  0.381500006     , 0.494507730      , 4.13113981E-02  , 2.81293783E-02 , -9.99108143E-03 , -1.57748722E-02 , 0.656968057     , 0.358806819    ,
  0.382499993     , 0.494106233      , 4.13002297E-02  , 2.81395372E-02 , -9.94775537E-03 , -1.65356714E-02 , 0.656646311     , 0.359889358    ,
  0.383500010     , 0.493702680      , 4.12889645E-02  , 2.81497706E-02 , -9.90421139E-03 , -1.72957033E-02 , 0.656324804     , 0.360970914    ,
  0.384499997     , 0.493297040      , 4.12776023E-02  , 2.81600766E-02 , -9.86044668E-03 , -1.80549473E-02 , 0.656003535     , 0.362051427    ,
  0.385500014     , 0.492889345      , 4.12661396E-02  , 2.81704590E-02 , -9.81646124E-03 , -1.88133847E-02 , 0.655682504     , 0.363130897    ,
  0.386500001     , 0.492479533      , 4.12545800E-02  , 2.81809177E-02 , -9.77225509E-03 , -1.95709951E-02 , 0.655361772     , 0.364209235    ,
  0.387499988     , 0.492067635      , 4.12429236E-02  , 2.81914528E-02 , -9.72782727E-03 , -2.03277599E-02 , 0.655041277     , 0.365286469    ,
  0.388500005     , 0.491653621      , 4.12311628E-02  , 2.82020662E-02 , -9.68317594E-03 , -2.10836567E-02 , 0.654721081     , 0.366362572    ,
  0.389499992     , 0.491237491      , 4.12193015E-02  , 2.82127578E-02 , -9.63830110E-03 , -2.18386669E-02 , 0.654401183     , 0.367437482    ,
  0.390500009     , 0.490819186      , 4.12073396E-02  , 2.82235313E-02 , -9.59320087E-03 , -2.25927718E-02 , 0.654081583     , 0.368511170    ,
  0.391499996     , 0.490398765      , 4.11952734E-02  , 2.82343850E-02 , -9.54787619E-03 , -2.33459491E-02 , 0.653762281     , 0.369583637    ,
  0.392500013     , 0.489976138      , 4.11831029E-02  , 2.82453205E-02 , -9.50232521E-03 , -2.40981784E-02 , 0.653443336     , 0.370654851    ,
  0.393500000     , 0.489551336      , 4.11708243E-02  , 2.82563400E-02 , -9.45654698E-03 , -2.48494428E-02 , 0.653124690     , 0.371724755    ,
  0.394499987     , 0.489124358      , 4.11584415E-02  , 2.82674432E-02 , -9.41054057E-03 , -2.55997181E-02 , 0.652806401     , 0.372793347    ,
  0.395500004     , 0.488695145      , 4.11459506E-02  , 2.82786321E-02 , -9.36430506E-03 , -2.63489876E-02 , 0.652488410     , 0.373860598    ,
  0.396499991     , 0.488263756      , 4.11333516E-02  , 2.82899048E-02 , -9.31784045E-03 , -2.70972289E-02 , 0.652170777     , 0.374926448    ,
  0.397500008     , 0.487830102      , 4.11206447E-02  , 2.83012670E-02 , -9.27114487E-03 , -2.78444234E-02 , 0.651853502     , 0.375990897    ,
  0.398499995     , 0.487394184      , 4.11078297E-02  , 2.83127148E-02 , -9.22421645E-03 , -2.85905469E-02 , 0.651536644     , 0.377053916    ,
  0.399500012     , 0.486956030      , 4.10948917E-02  , 2.83242576E-02 , -9.17705987E-03 , -2.93355919E-02 , 0.651220083     , 0.378115475    ,
  0.400000006     , 0.486532003      , 4.11139540E-02  , 2.83555184E-02 , -9.18524247E-03 , -3.00840233E-02 , 0.650901794     , 0.379182220
};

class HelmholtzFD_Op : public E_F0mps {
 public:
  Expression expTh;
  Expression expomega, expmu;
  static const int n_name_param = 1;
  static basicAC_F0::name_and_type name_param[];
  Expression nargs[n_name_param];
  HelmholtzFD_Op(const basicAC_F0 &args, Expression Th) : expTh(Th) {
    args.SetNameParam(n_name_param, name_param, nargs);
    expTh = to< const Mesh3 * >(args[0]);
    expomega = to< Complex >(args[1]);
    expmu = to< Complex >(args[2]);
  }

  long arg(int i, Stack stack, long a) const { return nargs[i] ? GetAny< long >((*nargs[i])(stack)) : a;}
  string* arg(int i, Stack stack, string* a) const { return nargs[i] ? GetAny< string* >((*nargs[i])(stack)) : a;}
  KN_<long>  arg(int i,Stack stack, KN_<long> a ) const { return nargs[i] ? GetAny<KN_<long> >((*nargs[i])(stack)): a;}

  AnyType operator( )(Stack stack) const;
};

basicAC_F0::name_and_type HelmholtzFD_Op::name_param[] = {
  {"npml", &typeid(KN_<long>)}
};

class  HelmholtzFD : public OneOperator {
  public:
    HelmholtzFD() : OneOperator(atype< newpMatrice_Creuse< Complex > >( ), atype< const Mesh3 * >( ), atype< Complex >( ), atype< Complex >( )) {};
    E_F0 *code(const basicAC_F0 &args) const { return new HelmholtzFD_Op(args, t[0]->CastTo(args[0])); }
};

long kkindex(long i1, long i2, long i3, long n1, long n2, long n3) {
  return i2*n3*n1+i1*n3+i3;
}

void subdamp(long n,int npmll, int npmlu, int apml, double h, double omega, std::vector<std::complex<double>>& damp, std::vector<std::complex<double>>& dampb, int sides) {
  double half_pi = 1.570796327;
  std::complex<double> ci(0,1);
  
  for (int i=0; i<=n+1; i++) {
    damp[i] = 1.;
    dampb[i] = 1.;
  }

  double xpmll = npmll*h;
  double xpmlu = npmlu*h;
  double xmax = (n-1)*h;
  double x, xb, eps, epsb;

  if (sides & 1)
  for (int i=1; i<=npmll; i++) {
    x = (i-1)*h;
    xb = (i-1)*h+0.5*h;
    eps  = apml*(1.-cos((xpmll-x)*half_pi/xpmll));
    epsb = apml*(1.-cos((xpmll-xb)*half_pi/xpmll));
    damp[i] = 1./(1.+ci*eps/omega);
    dampb[i] = 1./(1.+ci*epsb/omega);
  }

  if (sides & 2)
  for (int i=1; i<=npmlu; i++) {
    x = (i-1)*h;
    xb = (i-1)*h+0.5*h;
    eps  = apml*(1.-cos((xpmlu-x)*half_pi/xpmlu));
    epsb = apml*(1.-cos((xpmlu-xb)*half_pi/xpmlu));
    damp[n-i+1] = 1./(1.+ci*eps/omega);
  }

  damp[0] = damp[1];
  damp[n+1] = damp[n];

  if (sides & 2)
  for (int i=1; i<=npmlu+1; i++) {
    xb = xmax+0.5*h-(i-1)*h;
    epsb = apml*(1.-cos((xb-(xmax-xpmlu))*half_pi/xpmlu));
    dampb[n-i+1] = 1./(1.+ci*epsb/omega);
  }

  dampb[0] = dampb[1];
  dampb[n+1] = dampb[n];
}

template<class FESpaceT>
MatriceMorse<double> *  buildInterpolationMatrixT1(const FESpaceT & Uh,const KN_<double> & xx,const KN_<double> & yy ,const KN_<double> & zz)
{
  typedef typename FESpaceT::Mesh MeshT;
  typedef typename FESpaceT::FElement FElementT;
  typedef typename MeshT::Element ElementT;
  typedef typename FESpaceT::Rd RdT;
  typedef typename ElementT::RdHat RdHatT;

  int op=op_id; //  value of the function
  int icomp=0;
  bool inside=false;

  int n=Uh.NbOfDF;
  int mm=xx.N();
  int nbxx= mm;
  const MeshT & ThU = Uh.Th; // line
  FElementT Uh0 = Uh[0];
  int nbdfUK= Uh0.NbDoF();
  int NUh= Uh0.N;

  const int sfb1=Uh0.N*last_operatortype*Uh0.NbDoF();
  KN<double> kv(sfb1);
  R * v = kv;
  const R eps = 1e-10;

  What_d whatd= 1 << op;
  MatriceMorse<double> * m = new MatriceMorse<double>(n,mm,0,0);
  RdHatT Phat;
  bool outside;

  for(int ii=0;ii<nbxx;ii++){
    if(verbosity>9) cout << " Find ThU " <<ii << ":" <<  RdT(xx[ii],yy[ii],zz[ii]) << endl;
    const ElementT *ts=ThU.Find(RdT(xx[ii],yy[ii],zz[ii]),Phat,outside);
    if(outside && !inside) continue;
    int it = ThU(ts);
    FElementT KU(Uh[it]);
    KNMK_<double> fb(v,nbdfUK,NUh,last_operatortype);
    Uh0.tfe->FB(whatd,ThU,ThU[it],Phat,fb);
    KN_<double> Fwi(fb('.',icomp,op));
    for (int idfu=0;idfu<nbdfUK;idfu++){
      int  j = ii;
      int  i = KU(idfu);
      R c = Fwi(idfu);
      if(Abs(c)>eps)
        (*m)(i,j) += c;
    }
  }
  return m;
}

template<class T> bool cmp(const std::pair<unsigned int, T>& lhs, const std::pair<unsigned int, T>& rhs) { return lhs.first < rhs.first; }

AnyType HelmholtzFD_Op::operator( )(Stack stack) const {

  typedef typename Mesh3::Element Element;
  typedef typename Mesh3::RdHat RdHat;
  static const int nvedgeTet[6][2] = {{0, 1}, {0, 2}, {0, 3}, {1, 2}, {1, 3}, {2, 3}};
  static const int nvedgeTria[3][2] = {{1, 2}, {2, 0}, {0, 1}};
  static const int nvedgeSeg[1][2] = {{0, 1}};

  const int d = RdHat::d;

  MatriceMorse< Complex > *amorse = 0;
  typedef const Mesh3 *pmesh3;
  const Mesh3 *pTh = GetAny< pmesh3 >((*expTh)(stack));
  ffassert(pTh);
  const Mesh3 &Th(*pTh);

  double lx = 1e+30, ly=1e+30, lz=1e+30, ux=-1e+30, uy=-1e+30, uz=-1e+30, h = 1e+30;

  for (int i=0; i<Th.nbe; i++) {
    for (int j=0; j<3; j++) {
      const R3& p = Th.be(i)[j];
      lx = min(p.x,lx); ly = min(p.y,ly); lz = min(p.z,lz);
      ux = max(p.x,ux); uy = max(p.y,uy); uz = max(p.z,uz);
    }
    R3 p1 = Th.be(i)[1] - Th.be(i)[0];
    R3 p2 = Th.be(i)[2] - Th.be(i)[0];
    h = min(h,min(p1.norme(),p2.norme()));
  }

  double dx = ux-lx, dy = uy-ly, dz = uz-lz;

  //if (mpirank == 0) std::cout << "h = " << h << std::endl;

  long n1 = dx/h + 1, n2 = dy/h + 1, n3 = dz/h + 1;

  std::complex<double> omega = GetAny<std::complex<double>>((*expomega)(stack));

  //if (mpirank == 0) cout << n1 << " " << n2 << " " << n3 << " " << Th.nv << endl;

  KN<long> defnpml(6,8);
  KN<long> npml(arg(0,stack,defnpml));

  KN<long> pmlsides(6,1);
  for (int i=0; i<6; i++) pmlsides[i] = (npml[i] > 0L);

  KN<std::complex<double>> mu(n1*n2*n3);
  KN<double> xx(n1*n2*n3), yy(n1*n2*n3), zz(n1*n2*n3);
  KN<long> boundarynodesFD(n1*n2*n3,0L);

  int cpt = 0;
  for (long i2 = 0; i2 < n2; i2++)
  for (long i1 = 0; i1 < n1; i1++)
  for (long i3 = 0; i3 < n3; i3++) {
    xx[cpt] = lx + i1*h; yy[cpt] = ly + i2*h; zz[cpt] = lz + i3*h;
    MeshPoint* mp(Fem2D::MeshPointStack(stack));
    mp->set(xx[cpt], yy[cpt], zz[cpt]);
    mu[cpt] = GetAny<std::complex<double>>( (*expmu)(stack) );
    if ((i1 == 0 && !npml[0]) || (i1 == n1-1 && !npml[1])
     || (i2 == 0 && !npml[2]) || (i2 == n2-1 && !npml[3])
     || (i3 == 0 && !npml[4]) || (i3 == n3-1 && !npml[5]))
      boundarynodesFD[kkindex(i1,i2,i3,n1,n2,n3)] = 1;
    cpt++;
  }

  {
    std::vector<std::vector<std::complex<double>>> dd(3), db(3);
    
    dd[0].resize(n1+2); dd[1].resize(n2+2); dd[2].resize(n3+2);
    db[0].resize(n1+2); db[1].resize(n2+2); db[2].resize(n3+2);

    subdamp(n1,npml[0],npml[1],90,h,omega.real(),dd[0],db[0],pmlsides[0]+2*pmlsides[1]);
    subdamp(n2,npml[2],npml[3],90,h,omega.real(),dd[1],db[1],pmlsides[2]+2*pmlsides[3]);
    subdamp(n3,npml[4],npml[5],90,h,omega.real(),dd[2],db[2],pmlsides[4]+2*pmlsides[5]);

    MatriceMorse< Complex > *pAij = new MatriceMorse< Complex >(n1*n2*n3, n1*n2*n3, 0, 0), &Aij = *pAij;
    
    std::complex<double> omega2 = omega*omega;

    double c, d, e, f, w1 ,w2, w3; // weights of the mixed grid stencil
    double w2u, w3u;

    double h2 = 1./(h*h);

    long k, l, l1, l2, l3, ll[3], li, lj, lk, ii, ij, ik;
    long ind6[6][3] = {{1,0,0},{0,1,0},{0,0,1},
                      {-1,0,0},{0,-1,0},{0,0,-1}};
    long ind12[12][3] = {{1,1,0},{0,1,1},{1,0,1},
                        {-1,-1,0},{0,-1,-1},{-1,0,-1},
                        {-1,1,0},{1,-1,0},
                        {0,-1,1},{0,1,-1},
                        {1,0,-1},{-1,0,1}};
    long ik12[12] = {2,0,1,2,0,1,2,2,0,0,1,1};
    long ind8[8][3] = {{1,1,1},{-1,-1,-1},
                      {-1,1,1},{1,-1,-1},
                      {1,-1,1},{-1,1,-1},
                      {1,1,-1},{-1,-1,1}};

    double lambda, ppwl1, pi = 3.14159265358979323846;
    for (long i3 = 0; i3 < n3; i3++)
    for (long i2 = 0; i2 < n2; i2++)
    for (long i1 = 0; i1 < n1; i1++) {
      l1 = i1;
      l2 = i2;
      l3 = i3;
      k = kkindex(i1,i2,i3,n1,n2,n3);

      lambda = 2 * pi / omega.real() * sqrt(mu[k].real());
      //ppwl = lambda/h;
      //int ntab = max(0.,min(343.,(ppwl-3)/(20.15-3)*343 + 0.5));

      ppwl1 = h/lambda;
      int ntab = 0;
      while ((ppwl1 > wtab2[8*ntab]) && (ntab<398))
        ntab++;
      if (ntab > 0)
      if (abs(ppwl1-wtab2[8*ntab]) > abs(ppwl1-wtab2[8*(ntab-1)]))
        ntab--;

      c=wtab2[8*ntab+1];
      d=wtab2[8*ntab+2];
      e=wtab2[8*ntab+3];
      f=wtab2[8*ntab+4];
      w1=wtab2[8*ntab+5];
      w2=wtab2[8*ntab+6];
      w3=wtab2[8*ntab+7];

/*
      c=0; d=0; e=0; f=0; w1=0; w2=0; w3=0;
      for (int j3=-1;j3<=1;j3++)
      for (int j2=-1;j2<=1;j2++)
      for (int j1=-1;j1<=1;j1++) {
        long k3 = max(0L,min(n3-1,i3+j3));
        long k2 = max(0L,min(n2-1,i2+j2));
        long k1 = max(0L,min(n1-1,i1+j1));
        long kk = kkindex(k1,k2,k3,n1,n2,n3);
        lambda = 2 * pi / omega.real() * sqrt(mu[kk]);
        ppwl = lambda/h;
        ntab = max(0.,min(343.,(ppwl-3)/(20.15-3)*343 + 0.5));
        c +=wtab[8*ntab+1];
        d +=wtab[8*ntab+2];
        e +=wtab[8*ntab+3];
        f +=wtab[8*ntab+4];
        w1+=wtab[8*ntab+5];
        w2+=wtab[8*ntab+6];
        w3+=wtab[8*ntab+7];
      }
      c/=27; d/=27; e/=27; f/=27; w1/=27; w2/=27; w3/=27;
*/

/*
      // G=4
      c=0.5915900;
      d=4.9653493E-02;
      e=5.1085097E-03;
      f=6.1483691E-03;
      w1=8.8075437E-02;
      w2=0.8266806;
      w3=8.5243940E-02;
*/
/*
      // G=4810
      c=0.4966390;
      d=7.5123318E-02;
      e=4.3846383E-03;
      f=6.7614019E-07;
      w1=5.0247996E-05;
      w2=0.8900359;
      w3=0.1099138;
*/

      w2u=w2/3.;
      w3u=w3/4.;

      /* Node 000 */
      l = k;

      Aij(k, l) = c*omega2/mu[k]
      -w1*h2*(                                         				
               dd[1][l2+1]*(db[1][l2+1]+db[1][l2])               				
              +dd[2][l3+1]*(db[2][l3+1]+db[2][l3])               			
              +dd[0][l1+1]*(db[0][l1+1]+db[0][l1]) // (6)
             )  //R1
      -w2u*h2*2*(
               dd[0][l1+1]*(db[0][l1+1]+db[0][l1])
              +dd[1][l2+1]*(db[1][l2+1]+db[1][l2])
              +dd[2][l3+1]*(db[2][l3+1]+db[2][l3]) // (0.75*8+6) 
                )//R2-R4
      -w3u*h2*0.5*4*(                                            				
               dd[1][l2+1]*(db[1][l2+1]+db[1][l2])               				
              +dd[2][l3+1]*(db[2][l3+1]+db[2][l3])               			
              +dd[0][l1+1]*(db[0][l1+1]+db[0][l1]) // (0.5*24) 
                    ); //B1-B4

      /* 6 nodes */
      for (int q=0; q < 6; q++) {
        l1 = i1+ind6[q][0];
        l2 = i2+ind6[q][1];
        l3 = i3+ind6[q][2];

        ii = q%3;
        ij = (ii+1)%3;
        ik = (ij+1)%3;

        ll[0] = i1; ll[1] = i2; ll[2] = i3;
        li = ll[ii]; lj = ll[ij]; lk = ll[ik];

        if (l1 >= 0 && l1 < n1 && l2 >= 0 && l2 < n2 && l3 >= 0 && l3 < n3) {
          l = kkindex(l1,l2,l3,n1,n2,n3);
          Aij(k, l) = d*omega2/mu[l]

          +w1*h2*dd[ii][li+1]*db[ii][li+1*(q<3)] //R1

          +w2u*0.25*h2*(
             dd[ii][li+1]*db[ii][li+1*(q<3)]*4.
            -dd[ij][lj+1]*(db[ij][lj+1]+db[ij][lj])
            -dd[ik][lk+1]*(db[ik][lk+1]+db[ik][lk])
          )
          +w2u*h2*dd[ii][li+1]*db[ii][li+1*(q<3)] //R2-R4

          +w3u*h2*0.5*4*dd[ii][li+1]*db[ii][li+1*(q<3)]; //B2-B4
        }
      }

      /* 12 nodes */
      for (int q=0; q < 12; q++) {
        l1 = i1+ind12[q][0];
        l2 = i2+ind12[q][1];
        l3 = i3+ind12[q][2];
        
        ik = ik12[q];
        ii = (ik+1)%3;
        ij = (ii+1)%3;
        
        ll[0] = i1; ll[1] = i2; ll[2] = i3;
        li = ll[ii]; lj = ll[ij]; lk = ll[ik];
        
        long si = ind12[q][ii] == 1;
        long sj = ind12[q][ij] == 1;
        
        if (l1 >= 0 && l1 < n1 && l2 >= 0 && l2 < n2 && l3 >= 0 && l3 < n3) {
          l = kkindex(l1,l2,l3,n1,n2,n3);
          Aij(k, l) = e*omega2/mu[l]
            +w2u*h2*0.25*(dd[ii][li+1]*db[ii][li+si]+dd[ij][lj+1]*db[ij][lj+sj]) //R2-R4 0.25*2
            -w3u*h2*0.5*dd[ik][lk+1]*(db[ik][lk]+db[ik][lk+1]); //B1-B4 0.5*2
        }
      }

      /* 8 nodes */
      for (int q=0; q < 8; q++) {
        l1 = i1+ind8[q][0];
        l2 = i2+ind8[q][1];
        l3 = i3+ind8[q][2];
        if (l1 >= 0 && l1 < n1 && l2 >= 0 && l2 < n2 && l3 >= 0 && l3 < n3) {
          l = kkindex(l1,l2,l3,n1,n2,n3);
          Aij(k, l) = f*omega2/mu[l]
          +w3u*h2*0.5*(dd[0][i1+1]*db[0][i1+(ind8[q][0] > 0)]
                      +dd[1][i2+1]*db[1][i2+(ind8[q][1] > 0)]
                      +dd[2][i3+1]*db[2][i3+(ind8[q][2] > 0)]); //B1-B4
        }
      }    
    }
    amorse = pAij;
  }

  FESpace3 Uh(Th);

  MatriceMorse<double>* R = buildInterpolationMatrixT1<FESpace3>(Uh, xx, yy, zz);

  //if (mpirank == 0) std::cout << n1*n2*n3 << " " << Th.nv << " " << R->n << " " << R->m << " " << R->nnz << " " << amorse->n << " " << amorse->m <<  endl;

  std::vector<char> boundarynodesTh(Th.nv,0);

  R->COO();
  amorse->CSR();
  unsigned int m = R->nnz;
  KN<int> lg(m+1,0);
  std::vector<signed int> tmpVec;
  tmpVec.resize(amorse->m);
  for(long i = 0; i < m; ++i)
    tmpVec[R->j[i]] = i + 1;

  std::vector<std::pair<int, std::complex<double>> > tmp;
  tmp.reserve(amorse->nnz);

  lg[0] = 0;
  for(long i = 0; i < m; ++i) {
    for(long j = amorse->p[R->j[i]]; j < amorse->p[R->j[i] + 1]; ++j) {
      long col = tmpVec[amorse->j[j]];
      if(col != 0)
        tmp.push_back(std::make_pair(col - 1, amorse->aij[j]));
    }
    std::sort(tmp.begin() + lg[i], tmp.end(),cmp<std::complex<double>>);
    lg[i + 1] = tmp.size();

    boundarynodesTh[i] = boundarynodesFD[R->j[i]];
  }

  delete R;

  amorse->clear();
  amorse->resize(m,m);
  MatriceMorse<std::complex<double>> &MA = *amorse;
  MA.half = 0;
  for(int i=0; i<m; ++i)
  for(int k= lg[i]; k < lg[i+1]; ++k) {
    int j= tmp[k].first;
    std::complex<double> aij = tmp[k].second;
    MA(i,j) = aij;
  }

  MA.SetBC(&boundarynodesTh[0], -1);

  return SetAny<newpMatrice_Creuse<std::complex<double>>>(newpMatrice_Creuse<std::complex<double>>(stack, &MA));
}

static void Load_Init( ) {
  Global.Add("HelmholtzFD", "(", new HelmholtzFD);
}

LOADFUNC(Load_Init)
