/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.soap;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.emboss.jemboss.JembossParams;
import org.emboss.jemboss.gui.ShowSavedResults;
import org.emboss.jemboss.gui.form.BuildJembossForm;
import org.emboss.jemboss.programs.JembossProcess;
import org.emboss.jemboss.server.JembossServer;
import org.emboss.jemboss.soap.AuthPopup;
import org.emboss.jemboss.soap.JembossSoapException;
import org.emboss.jemboss.soap.PrivateRequest;

public class PendingResults {
    private int completed_jobs = 0;
    private int running_jobs = 0;
    private JembossParams mysettings;
    private Vector pendingResults;
    private JButton jobButton = null;
    private JComboBox jobComboBox = null;
    private boolean autoUpdates = false;
    private boolean withSoap = true;

    public PendingResults(JembossParams mysettings, boolean withSoap) {
        this(mysettings);
        this.withSoap = withSoap;
    }

    public PendingResults(JembossParams mysettings) {
        this.mysettings = mysettings;
        this.pendingResults = new Vector();
    }

    public void addRunningJob() {
        ++this.running_jobs;
        if (this.jobButton != null) {
            this.jobButton.setText(this.jobStatus());
        }
    }

    public void deleteRunningJob() {
        --this.running_jobs;
        ++this.completed_jobs;
        if (this.jobButton != null) {
            this.jobButton.setText(this.jobStatus());
        }
    }

    public void resetCount() {
        this.completed_jobs = 0;
        this.running_jobs = 0;
        this.pendingResults.removeAllElements();
    }

    public void addResult(JembossProcess res) {
        this.pendingResults.add(res);
    }

    public void removeResult(JembossProcess res) {
        this.pendingResults.remove(res);
    }

    public JembossProcess getResult(String s) {
        for (int i = 0; i < this.pendingResults.size(); ++i) {
            JembossProcess er = (JembossProcess)this.pendingResults.get(i);
            if (!er.getJob().equals(s)) continue;
            return er;
        }
        return null;
    }

    public Hashtable descriptionHash() {
        Hashtable<String, String> h = new Hashtable<String, String>();
        for (int i = 0; i < this.pendingResults.size(); ++i) {
            JembossProcess er = (JembossProcess)this.pendingResults.get(i);
            String desc = er.getDescription();
            if (desc == null || desc.equals("")) {
                desc = " Pending";
            }
            h.put(er.getJob(), desc);
        }
        return h;
    }

    public void updateJobStats() {
        int ic = 0;
        int ir = 0;
        for (int i = 0; i < this.pendingResults.size(); ++i) {
            JembossProcess er = (JembossProcess)this.pendingResults.get(i);
            if (er.isCompleted()) {
                ++ic;
            }
            if (!er.isRunning()) continue;
            ++ir;
        }
        this.completed_jobs = ic;
        this.running_jobs = ir;
    }

    public String jobStatus() {
        String sc = new Integer(this.completed_jobs).toString();
        String sr = new Integer(this.running_jobs).toString();
        String s = this.completed_jobs == 0 ? (this.running_jobs == 0 ? "Jobs: no pending jobs" : "Jobs: " + sr + " running") : (this.running_jobs == 0 ? "Jobs: " + sc + " completed" : "Jobs: " + sc + " completed / " + sr + " running");
        return s;
    }

    public void updateStatus() {
        Hashtable<String, String> resToQuery = new Hashtable<String, String>();
        for (int i = 0; i < this.pendingResults.size(); ++i) {
            JembossProcess er = (JembossProcess)this.pendingResults.get(i);
            resToQuery.put(er.getJob(), er.getProject());
        }
        Vector<Object> params = new Vector<Object>();
        params.addElement("");
        params.addElement("");
        params.addElement(this.getVector(resToQuery));
        try {
            Hashtable hashStatus;
            if (this.withSoap) {
                PrivateRequest eq = new PrivateRequest(this.mysettings, "update_result_status", params);
                hashStatus = eq.getHash();
            } else {
                JembossServer js = new JembossServer(this.mysettings.getResultsHome());
                Vector vecStatus = js.update_result_status("", "", resToQuery);
                hashStatus = BuildJembossForm.convert(vecStatus, false);
            }
            for (int i = 0; i < this.pendingResults.size(); ++i) {
                JembossProcess er = (JembossProcess)this.pendingResults.get(i);
                String jobid = er.getJob();
                String s = (String)hashStatus.get(jobid);
                if (this.mysettings.getDebug()) {
                    System.out.println("PendingResults: " + jobid + " : " + s);
                }
                if (!s.equals("complete")) continue;
                er.complete();
                String sd = (String)hashStatus.get(jobid + "-description");
                if (sd.equals("")) continue;
                er.setDescription(sd);
            }
            this.updateJobStats();
            if (this.jobButton != null) {
                this.jobButton.setText(this.jobStatus());
            }
        }
        catch (JembossSoapException jembossSoapException) {
            // empty catch block
        }
    }

    private Vector getVector(Hashtable h) {
        Vector<String> v = new Vector<String>();
        Enumeration e = h.keys();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            v.add(s);
            v.add((String)h.get(s));
        }
        return v;
    }

    public boolean isAutoUpdate() {
        return this.autoUpdates;
    }

    public void setAutoUpdate(boolean b) {
        this.autoUpdates = b;
    }

    public void updateMode() {
        if (this.jobComboBox != null) {
            this.jobComboBox.setSelectedItem(this.mysettings.getCurrentMode());
        }
    }

    public void updateMode(String s) {
        this.mysettings.setCurrentMode(s);
        if (this.jobComboBox != null) {
            this.jobComboBox.setSelectedItem(this.mysettings.getCurrentMode());
        }
    }

    public JPanel statusPanel(final JFrame f) {
        final JPanel jobPanel = new JPanel(new BorderLayout());
        ClassLoader cl = this.getClass().getClassLoader();
        ImageIcon jobIcon = new ImageIcon(cl.getResource("images/Job_manager_button.gif"));
        this.jobButton = new JButton("(No background jobs)", jobIcon);
        this.jobButton.setIconTextGap(50);
        this.jobButton.setHorizontalTextPosition(4);
        this.jobButton.setToolTipText("Batch Job Manager");
        this.jobButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                jobPanel.setCursor(new Cursor(3));
                PendingResults.this.showPendingResults(f);
                jobPanel.setCursor(new Cursor(0));
            }
        });
        jobPanel.add((Component)this.jobButton, "Center");
        Dimension d = jobPanel.getPreferredSize();
        d = new Dimension((int)d.getWidth(), jobIcon.getIconHeight() + 4);
        jobPanel.setPreferredSize(d);
        return jobPanel;
    }

    public JComboBox getExcModeComboBox(int width) {
        if (this.jobComboBox == null) {
            this.jobComboBox = new JComboBox(this.mysettings.modeVector());
            this.jobComboBox.setMaximumSize(new Dimension(width, this.jobComboBox.getPreferredSize().height));
            this.jobComboBox.setToolTipText("Job execution mode");
            this.jobComboBox.setAlignmentX(0.0f);
            this.jobComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JComboBox cb = (JComboBox)e.getSource();
                    String modeName = (String)cb.getSelectedItem();
                    PendingResults.this.mysettings.setCurrentMode(modeName);
                }
            });
        }
        this.updateMode();
        return this.jobComboBox;
    }

    public void showPendingResults(JFrame f) {
        if (this.completed_jobs == 0 && this.running_jobs == 0) {
            JOptionPane.showMessageDialog(f, "No batch/background jobs have been\nsubmitted in current session.");
        } else {
            try {
                new ShowSavedResults(this.mysettings, this);
            }
            catch (JembossSoapException eae) {
                new AuthPopup(this.mysettings, f);
            }
        }
    }

    public String getStatus() {
        return this.jobButton.getText();
    }
}

