/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.draw;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.RepaintManager;
import org.emboss.jemboss.draw.Block;
import org.emboss.jemboss.draw.EmbossCirdnaReader;
import org.emboss.jemboss.draw.GeneticMarker;
import org.emboss.jemboss.draw.LineAttribute;
import org.emboss.jemboss.draw.PrintDNAImage;
import org.emboss.jemboss.draw.RestrictionEnzyme;
import org.emboss.jemboss.draw.Ticks;
import org.emboss.jemboss.draw.Wizard;
import org.emboss.jemboss.gui.Browser;
import org.emboss.jemboss.gui.ScrollPanel;

public class DNADraw
extends ScrollPanel
implements Printable,
DragGestureListener,
DragSourceListener,
DropTargetListener {
    public static JScrollPane jsp;
    private DNADraw current_dna;
    private JFrame mainFrame;
    private Point location = new Point(75, 75);
    private Dimension border = new Dimension(150, 150);
    private Dimension panelSize = new Dimension(600, 600);
    private Dimension linearPanelSize = new Dimension(800, 350);
    private Hashtable lineAttr;
    private Vector minorTicks;
    private Vector majorTicks;
    private Vector block;
    private Vector restrictionEnzyme;
    private int startTick = 0;
    private int minorTick = 100;
    private int majorTick = 500;
    private int[] tickMajorXPositions;
    private int[] tickMajorYPositions;
    private int[] tickMinorXPositions;
    private int[] tickMinorYPositions;
    private int[] reXPositions;
    private int[] reYPositions;
    private boolean close = false;

    public DNADraw() {
        super(new BorderLayout());
        this.current_dna = this;
        this.setBackground(Color.white);
        this.setPreferredSize(this.panelSize);
        this.setOpaque(false);
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this, 3, this);
        this.setDropTarget(new DropTarget(this, this));
        this.lineAttr = new Hashtable();
        this.lineAttr.put("start", new Integer(0));
        this.lineAttr.put("end", new Integer(4000));
        this.lineAttr.put("lsize", new Integer(5));
        this.lineAttr.put("circular", new Boolean(true));
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2 && !me.isPopupTrigger()) {
                    for (int i = 0; i < DNADraw.this.getComponentCount(); ++i) {
                        Block drawBlock;
                        if (!(DNADraw.this.getComponent(i) instanceof Block) || !(drawBlock = (Block)DNADraw.this.getComponent(i)).isOverMe(me.getX(), me.getY())) continue;
                        final JFrame f = new JFrame("Properties");
                        JButton butt = new JButton("Delete");
                        butt.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                DNADraw.this.remove(drawBlock);
                                DNADraw.this.current_dna.repaint();
                                f.setVisible(false);
                                f.dispose();
                                Enumeration enumBk = DNADraw.this.block.elements();
                                int nelement = 0;
                                while (enumBk.hasMoreElements()) {
                                    Vector v = (Vector)enumBk.nextElement();
                                    if (v.contains(drawBlock)) {
                                        DNADraw.this.block.removeElementAt(nelement);
                                    }
                                    ++nelement;
                                }
                            }
                        });
                        drawBlock.showProperties(f, DNADraw.this, butt);
                    }
                }
            }
        };
        this.addMouseListener(mouseListener);
    }

    public DNADraw(Vector minorTicks, Vector majorTicks, Vector block, Vector restrictionEnzyme) {
        this();
        this.minorTicks = minorTicks;
        this.block = block;
        this.restrictionEnzyme = restrictionEnzyme;
    }

    public DNADraw(Vector block, Vector restrictionEnzyme, Hashtable lineAttr, int startTick, int minorTick, int majorTick) {
        this();
        this.block = block;
        this.restrictionEnzyme = restrictionEnzyme;
        this.lineAttr = lineAttr;
        this.startTick = startTick;
        this.minorTick = minorTick;
        this.majorTick = majorTick;
        if (!this.isCircular()) {
            this.setPreferredSize(this.linearPanelSize);
        }
        this.calculateTickPosistions();
    }

    protected double getDiameter() {
        return (double)this.getWidth() - this.border.getWidth();
    }

    protected Point getLocationPoint() {
        return this.location;
    }

    protected void zoomIn() {
        int wid = this.getWidth();
        wid += (int)((double)wid * 0.1);
        int hgt = this.getHeight();
        if (this.isCircular()) {
            hgt += (int)((double)hgt * 0.1);
        }
        this.zoom(wid, hgt);
    }

    protected void zoomOut() {
        int wid = this.getWidth();
        wid -= (int)((double)wid * 0.1);
        int hgt = this.getHeight();
        if (this.isCircular()) {
            hgt -= (int)((double)hgt * 0.1);
        }
        this.zoom(wid, hgt);
    }

    private void zoom(int wid, int hgt) {
        if (this.isCircular()) {
            this.panelSize = new Dimension(wid, hgt);
            this.setPreferredSize(this.panelSize);
            this.setSize(this.panelSize);
        } else {
            this.linearPanelSize = new Dimension(wid, hgt);
            this.setPreferredSize(this.linearPanelSize);
            this.setSize(this.linearPanelSize);
        }
        this.repaint();
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        if (this.isCircular()) {
            this.drawCircularPanel(g2, true);
        } else {
            this.drawLinearPanel(g2);
        }
    }

    protected boolean isCircular() {
        return (Boolean)this.lineAttr.get("circular");
    }

    protected void addBlock(Block b) {
        this.add(b);
        this.validate();
    }

    protected void drawLinearPanel(Graphics2D g2) {
        int y;
        int x;
        int tick;
        FontMetrics fm = g2.getFontMetrics();
        double hgt = fm.getAscent();
        g2.setColor(Color.black);
        double widDash = 4.0;
        int lineSize = 5;
        try {
            lineSize = this.getLineSize();
        }
        catch (NullPointerException npe) {
            System.out.println("No line size specified using default!");
        }
        g2.setStroke(new BasicStroke(lineSize));
        double widthPanel = this.getWidth();
        double ddiameter = widthPanel - this.border.getWidth();
        int diameter = (int)ddiameter;
        int ymid = this.getHeight() / 2;
        g2.setStroke(new BasicStroke(lineSize));
        g2.drawLine(this.location.x, ymid, diameter, ymid);
        int start = this.getStart();
        int end = this.getEnd();
        g2.setColor(Color.black);
        g2.setStroke(new BasicStroke(1.0f));
        if (this.majorTicks == null || this.minorTicks == null) {
            this.calculateTickPosistions();
        }
        Enumeration enumTk = this.minorTicks.elements();
        while (enumTk.hasMoreElements()) {
            tick = (Integer)enumTk.nextElement();
            x = (diameter - this.location.x) * (tick - start) / (end - start) + this.location.x;
            y = ymid + (int)(((double)lineSize + widDash) / 2.0);
            g2.drawLine(x, ymid, x, y);
        }
        enumTk = this.majorTicks.elements();
        while (enumTk.hasMoreElements()) {
            tick = (Integer)enumTk.nextElement();
            x = (diameter - this.location.x) * (tick - start) / (end - start) + this.location.x;
            y = ymid + lineSize / 2 + (int)widDash;
            g2.drawLine(x, ymid, x, y);
            String label = Integer.toString(tick);
            y = (int)((double)y + hgt);
            g2.drawString(label, x -= fm.stringWidth(label) / 2, y);
        }
        if (this.restrictionEnzyme != null) {
            enumTk = this.restrictionEnzyme.elements();
            while (enumTk.hasMoreElements()) {
                Vector re = (Vector)enumTk.nextElement();
                String reLabel = (String)re.elementAt(0);
                int pos = (Integer)re.elementAt(1);
                g2.setColor((Color)re.elementAt(2));
                int x2 = (diameter - this.location.x) * (pos - start) / (end - start) + this.location.x;
                int y2 = ymid - lineSize / 2 - (int)widDash;
                g2.drawLine(x2, ymid, x2, y2);
                y2 = (int)((double)y2 - hgt);
                g2.drawString(reLabel, x2 -= fm.stringWidth(reLabel) / 2, y2);
            }
        }
    }

    protected void drawCircularPanel(Graphics2D g2, boolean record) {
        g2.setColor(Color.black);
        FontMetrics fm = g2.getFontMetrics();
        double hgt = fm.getAscent();
        double widthPanel = this.getWidth();
        double heightPanel = this.getHeight();
        double rad = 360.0;
        double pi = Math.PI;
        double widDash = 4.0;
        double ddiameter = widthPanel - this.border.getWidth();
        double ddiameter2 = ddiameter / 2.0;
        int diameter = (int)ddiameter;
        int lineSize = 5;
        try {
            lineSize = this.getLineSize();
        }
        catch (NullPointerException npe) {
            System.out.println("No line size specified using default!");
        }
        g2.setStroke(new BasicStroke(lineSize));
        g2.drawArc(this.location.x, this.location.y, diameter, diameter, 0, 360);
        AffineTransform origin = g2.getTransform();
        if (this.restrictionEnzyme != null) {
            if (record) {
                int nsize = this.restrictionEnzyme.size();
                this.reXPositions = new int[nsize];
                this.reYPositions = new int[nsize];
            }
            Enumeration enumRes = this.restrictionEnzyme.elements();
            while (enumRes.hasMoreElements()) {
                int index;
                Vector re = (Vector)enumRes.nextElement();
                String reLabel = (String)re.elementAt(0);
                int pos = (Integer)re.elementAt(1);
                g2.setColor((Color)re.elementAt(2));
                double ang = this.getAngleFromPosition(pos, rad);
                AffineTransform newOrig = (AffineTransform)origin.clone();
                newOrig.rotate(Math.toRadians(-ang), widthPanel / 2.0, heightPanel / 2.0);
                int widLabel = (lineSize + fm.stringWidth(reLabel)) / 2;
                int widREDash = (int)(widDash + widDash + (double)lineSize) + widLabel;
                int x = 0;
                int y = 0;
                if (record) {
                    x = (int)(ddiameter2 + newOrig.getScaleX() * (ddiameter2 + 10.0 + (double)widLabel + (double)widREDash) - (double)widLabel);
                    y = (int)(ddiameter2 + newOrig.getShearY() * (ddiameter2 + 10.0 + (double)widREDash + hgt / 2.0) + hgt / 2.0);
                    index = this.restrictionEnzyme.indexOf(re);
                    this.reXPositions[index] = x;
                    this.reYPositions[index] = y;
                } else {
                    index = this.restrictionEnzyme.indexOf(re);
                    x = this.reXPositions[index];
                    y = this.reYPositions[index];
                }
                g2.drawString(reLabel, this.location.x + x, this.location.y + y);
                g2.setTransform(newOrig);
                g2.setStroke(new BasicStroke(1.0f));
                int xLine = this.location.x + (int)ddiameter;
                int yLine = this.location.y + (int)(ddiameter / 2.0);
                g2.drawLine(xLine, yLine, xLine + widREDash, yLine);
                g2.setTransform(origin);
            }
        }
        if (this.majorTicks == null || this.minorTicks == null) {
            this.calculateTickPosistions();
        }
        this.drawCircularTicks(g2, ddiameter, ddiameter2, diameter, origin, widthPanel, heightPanel, rad, pi, widDash, fm, lineSize, record, this.majorTicks, false);
        this.drawCircularTicks(g2, ddiameter, ddiameter2, diameter, origin, widthPanel, heightPanel, rad, pi, widDash / 2.0, fm, lineSize, record, this.minorTicks, true);
    }

    private void drawCircularTicks(Graphics2D g2, double ddiameter, double ddiameter2, int diameter, AffineTransform origin, double widthPanel, double heightPanel, double rad, double pi, double widDash, FontMetrics fm, int lineSize, boolean record, Vector ticks, boolean smallTicks) {
        double hgt = fm.getAscent();
        g2.setColor(Color.black);
        if (record) {
            int nsize = ticks.size();
            if (smallTicks) {
                this.tickMinorXPositions = new int[nsize];
                this.tickMinorYPositions = new int[nsize];
            } else {
                this.tickMajorXPositions = new int[nsize];
                this.tickMajorYPositions = new int[nsize];
            }
        }
        Enumeration enumTk = ticks.elements();
        while (enumTk.hasMoreElements()) {
            int index;
            int tick = (Integer)enumTk.nextElement();
            double theta = Math.toRadians(-this.getAngleFromPosition(tick, rad));
            if (theta > pi) {
                theta -= pi * 2.0;
            }
            AffineTransform newOrig = (AffineTransform)origin.clone();
            newOrig.rotate(theta, widthPanel / 2.0, heightPanel / 2.0);
            String label = Integer.toString(tick);
            double wid = fm.stringWidth(label);
            int x = 0;
            int y = 0;
            if (record) {
                x = (int)(ddiameter2 + newOrig.getScaleX() * (widDash + (double)lineSize + 3.0 + ((double)diameter + wid) / 2.0) - wid / 2.0);
                y = (int)(ddiameter2 + newOrig.getShearY() * (widDash + (double)lineSize + 3.0 + ((double)diameter + hgt) / 2.0) + hgt / 2.0);
                index = ticks.indexOf(new Integer(tick));
                if (smallTicks) {
                    this.tickMinorXPositions[index] = x;
                    this.tickMinorYPositions[index] = y;
                } else {
                    this.tickMajorXPositions[index] = x;
                    this.tickMajorYPositions[index] = y;
                }
            } else {
                index = ticks.indexOf(new Integer(tick));
                if (smallTicks) {
                    x = this.tickMinorXPositions[index];
                    y = this.tickMinorYPositions[index];
                }
                x = this.tickMajorXPositions[index];
                y = this.tickMajorYPositions[index];
            }
            if (!smallTicks) {
                g2.drawString(label, this.location.x + x, this.location.y + y);
            }
            g2.setTransform(newOrig);
            g2.setStroke(new BasicStroke(1.0f));
            int xLine = this.location.x + (int)ddiameter;
            int yLine = this.location.y + (int)(ddiameter / 2.0);
            g2.drawLine(xLine, yLine, (int)((double)(xLine + lineSize) + widDash), yLine);
            g2.setTransform(origin);
        }
    }

    protected void calculateTickPosistions() {
        int i;
        this.minorTicks = new Vector();
        this.majorTicks = new Vector();
        int start = this.getStart();
        int end = this.getEnd();
        if (this.majorTick == 0) {
            return;
        }
        for (i = this.startTick; i < end; i += this.majorTick) {
            if (i < start) continue;
            this.majorTicks.add(new Integer(i));
        }
        if (this.minorTick == 0) {
            return;
        }
        for (i = this.startTick; i < end; i += this.minorTick) {
            Integer tk = new Integer(i);
            if (i < start || this.majorTicks.contains(tk)) continue;
            this.minorTicks.add(tk);
        }
    }

    protected int getStartTick() {
        return this.startTick;
    }

    protected boolean setStartTick(int startTick) {
        this.startTick = startTick;
        return startTick >= this.getStart() && startTick < this.getEnd();
    }

    protected int getTickInterval() {
        return this.majorTick;
    }

    protected boolean setTickInterval(int majorTick) {
        if (majorTick < this.getEnd() - this.getStart()) {
            this.majorTick = majorTick;
            return true;
        }
        return false;
    }

    protected int getMinorTickInterval() {
        return this.minorTick;
    }

    protected boolean setMinorTickInterval(int minorTick) {
        if (minorTick < this.getEnd() - this.getStart()) {
            this.minorTick = minorTick;
            return true;
        }
        return false;
    }

    protected double getAngleFromPosition(int pos, double rad) {
        int start = this.getStart();
        int end = this.getEnd();
        return -((double)(pos - start) * rad) / (double)(end - start);
    }

    public int print(Graphics g, PageFormat pf, int pageIndex) throws PrinterException {
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.black);
        RepaintManager.currentManager(this).setDoubleBufferingEnabled(false);
        Dimension d = this.getSize();
        double panelWidth = d.width;
        double panelHeight = d.height;
        double pageHeight = pf.getImageableHeight();
        double pageWidth = pf.getImageableWidth();
        double scale = pageWidth / panelWidth;
        int totalNumPages = (int)Math.ceil(scale * panelHeight / pageHeight);
        if (pageIndex >= totalNumPages) {
            return 1;
        }
        g2.translate(pf.getImageableX(), pf.getImageableY());
        g2.translate(0.0, (double)(-pageIndex) * pageHeight);
        g2.scale(scale, scale);
        this.drawAll(g2, false);
        return 0;
    }

    public void drawAll(Graphics2D g2, boolean l) {
        if (((Boolean)this.lineAttr.get("circular")).booleanValue()) {
            this.drawCircularPanel(g2, l);
        } else {
            this.drawLinearPanel(g2);
        }
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (!(this.getComponent(i) instanceof Block)) continue;
            System.out.println("Printing block " + i);
            ((Block)this.getComponent(i)).draw(g2);
        }
    }

    public void doPrintActions() {
        PrinterJob pj = PrinterJob.getPrinterJob();
        pj.setPrintable(this);
        pj.printDialog();
        try {
            pj.print();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void setRestrictionEnzyme(Vector restrictionEnzyme) {
        this.restrictionEnzyme = restrictionEnzyme;
    }

    protected void setGeneticMarker(Vector block) {
        this.block = block;
    }

    protected Hashtable getLineAttributes() {
        return this.lineAttr;
    }

    protected void setLineAttributes(Hashtable lineAttr) {
        this.lineAttr = lineAttr;
    }

    protected void setLineSize(int lineSize) {
        this.lineAttr.put("lsize", new Integer(lineSize));
    }

    protected int getLineSize() {
        return (Integer)this.lineAttr.get("lsize");
    }

    public void setPlasmidLocation(int x, int y) {
        this.location.setLocation(x, y);
    }

    public JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        menuBar.add(fileMenu);
        JMenuItem openMenu = new JMenuItem("Open");
        openMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EmbossCirdnaReader dnaRead = new EmbossCirdnaReader();
                DNADraw.this.block = dnaRead.getBlock();
                DNADraw.this.restrictionEnzyme = dnaRead.getRestrictionEnzyme();
                DNADraw.this.lineAttr.put("start", new Integer(dnaRead.getStart()));
                DNADraw.this.lineAttr.put("end", new Integer(dnaRead.getEnd()));
                DNADraw.this.current_dna = new DNADraw(DNADraw.this.block, DNADraw.this.restrictionEnzyme, DNADraw.this.lineAttr, 0, 100, 100);
                jsp.setViewportView(DNADraw.this.current_dna);
            }
        });
        fileMenu.add(openMenu);
        fileMenu.add(new JSeparator());
        JMenu printMenu = new JMenu("Print");
        fileMenu.add(printMenu);
        JMenuItem print = new JMenuItem("Print Postscript");
        print.setToolTipText("Print using available printers in your computer\nor export image to a postscript file (if you have  installed postscript printers)");
        print.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DNADraw.this.doPrintActions();
            }
        });
        printMenu.add(print);
        JMenuItem printImage = new JMenuItem("Print png/jpeg Image...");
        printImage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PrintDNAImage pdnai = new PrintDNAImage(DNADraw.this.current_dna);
                pdnai.print();
            }
        });
        printMenu.add(printImage);
        JMenuItem printPreview = new JMenuItem("Print Preview...");
        printPreview.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PrintDNAImage pdnai = new PrintDNAImage(DNADraw.this.current_dna);
                pdnai.printPreview();
            }
        });
        fileMenu.add(printPreview);
        fileMenu.add(new JSeparator());
        JMenuItem fileMenuExit = new JMenuItem("Exit");
        fileMenuExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!DNADraw.this.close) {
                    System.exit(0);
                } else {
                    DNADraw.this.mainFrame.setVisible(false);
                    DNADraw.this.mainFrame.dispose();
                }
            }
        });
        fileMenu.add(fileMenuExit);
        JMenu viewMenu = new JMenu("View");
        menuBar.add(viewMenu);
        JMenuItem zoomIn = new JMenuItem("Zoom In");
        zoomIn.setAccelerator(KeyStroke.getKeyStroke(73, 2));
        zoomIn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DNADraw.this.zoomIn();
            }
        });
        viewMenu.add(zoomIn);
        JMenuItem zoomOut = new JMenuItem("Zoom Out");
        zoomOut.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        zoomOut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DNADraw.this.zoomOut();
            }
        });
        viewMenu.add(zoomOut);
        JMenu optionMenu = new JMenu("Options");
        menuBar.add(optionMenu);
        JMenuItem wizard = new JMenuItem("DNA Wizard");
        wizard.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Wizard wiz = new Wizard(DNADraw.this.current_dna);
                DNADraw.this.current_dna = wiz.getDNADraw();
                jsp.setViewportView(DNADraw.this.current_dna);
            }
        });
        optionMenu.add(wizard);
        optionMenu.add(new JSeparator());
        JMenuItem line = new JMenuItem("DNA attributes");
        line.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFrame f = new JFrame("DNA Attributes");
                LineAttribute la = new LineAttribute(DNADraw.this.current_dna);
                JScrollPane laScroll = new JScrollPane(la);
                JPanel laPane = (JPanel)f.getContentPane();
                laPane.add((Component)laScroll, "Center");
                f.setJMenuBar(la.createMenuBar(f));
                f.pack();
                f.setVisible(true);
            }
        });
        optionMenu.add(line);
        JMenuItem tickMarks = new JMenuItem("Tick marks");
        tickMarks.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFrame f = new JFrame("Tick Marks");
                Ticks tk = new Ticks(DNADraw.this.current_dna, true);
                JScrollPane tkScroll = new JScrollPane(tk);
                JPanel tkPane = (JPanel)f.getContentPane();
                tkPane.add((Component)tkScroll, "Center");
                f.setJMenuBar(tk.createMenuBar(f));
                f.pack();
                f.setVisible(true);
            }
        });
        optionMenu.add(tickMarks);
        JMenuItem gmarker = new JMenuItem("Genetic Features");
        gmarker.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFrame f = new JFrame("Genetic Features");
                GeneticMarker gm = new GeneticMarker(DNADraw.this.current_dna, DNADraw.this.block);
                JScrollPane gmScroll = new JScrollPane(gm);
                JPanel gmPane = (JPanel)f.getContentPane();
                gmPane.add((Component)gmScroll, "Center");
                f.setJMenuBar(gm.createMenuBar(f));
                f.pack();
                f.setVisible(true);
            }
        });
        optionMenu.add(gmarker);
        JMenuItem reSites = new JMenuItem("Restriction Enzyme");
        reSites.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFrame f = new JFrame("Restriction Enzyme");
                RestrictionEnzyme re = new RestrictionEnzyme(DNADraw.this.current_dna, DNADraw.this.restrictionEnzyme);
                JScrollPane reScroll = new JScrollPane(re);
                JPanel rePane = (JPanel)f.getContentPane();
                rePane.add((Component)reScroll, "Center");
                f.setJMenuBar(re.createMenuBar(f));
                f.pack();
                f.setVisible(true);
            }
        });
        optionMenu.add(reSites);
        JMenu helpMenu = new JMenu("Help");
        menuBar.add(helpMenu);
        JMenuItem aboutMenu = new JMenuItem("About");
        helpMenu.add(aboutMenu);
        aboutMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassLoader cl = this.getClass().getClassLoader();
                try {
                    URL inURL = cl.getResource("resources/readmeDNADraw.html");
                    new Browser(inURL, "resources/readmeAlign.html");
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, "Jemboss Alignment Viewer Guide not found!", "Error", 0);
                }
            }
        });
        return menuBar;
    }

    public void setCloseAndDispose(boolean close, JFrame mainFrame) {
        this.mainFrame = mainFrame;
        this.close = close;
    }

    protected Vector getGeneticMarker() {
        return this.block;
    }

    protected Vector getRestrictionEnzyme() {
        return this.restrictionEnzyme;
    }

    protected int getStart() {
        return (Integer)this.lineAttr.get("start");
    }

    protected int getEnd() {
        return (Integer)this.lineAttr.get("end");
    }

    protected void setStart(int start) {
        this.lineAttr.put("start", new Integer(start));
        this.calculateTickPosistions();
    }

    protected void setEnd(int end) {
        this.lineAttr.put("end", new Integer(end));
        this.calculateTickPosistions();
    }

    public void dragGestureRecognized(DragGestureEvent e) {
        InputEvent ie = e.getTriggerEvent();
        if (ie instanceof MouseEvent && ((MouseEvent)ie).isPopupTrigger()) {
            return;
        }
        Point loc = e.getDragOrigin();
        Component c = this.getComponentAt(loc);
        if (c instanceof Block) {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Block drawBlock;
                if (!(this.getComponent(i) instanceof Block) || !(drawBlock = (Block)this.getComponent(i)).isOverMe(loc.x, loc.y)) continue;
                e.startDrag(DragSource.DefaultCopyDrop, drawBlock, this);
            }
        }
    }

    public void dragDropEnd(DragSourceDropEvent e) {
    }

    public void dragEnter(DragSourceDragEvent e) {
    }

    public void dragExit(DragSourceEvent e) {
    }

    public void dragOver(DragSourceDragEvent e) {
    }

    public void dropActionChanged(DragSourceDragEvent e) {
    }

    public void dragEnter(DropTargetDragEvent e) {
        if (e.isDataFlavorSupported(Block.BLOCK)) {
            e.acceptDrag(3);
        }
    }

    public void drop(DropTargetDropEvent e) {
        Transferable t = e.getTransferable();
        if (t.isDataFlavorSupported(Block.BLOCK)) {
            try {
                Point loc = e.getLocation();
                Block drawBlock = (Block)t.getTransferData(Block.BLOCK);
                for (int i = 0; i < this.getComponentCount(); ++i) {
                    Block c;
                    if (!(this.getComponent(i) instanceof Block) || !(c = (Block)this.getComponent(i)).getLabel().equals(drawBlock.getLabel()) || c.getStart() != drawBlock.getStart() || c.getEnd() != drawBlock.getEnd()) continue;
                    c.setBlockLocation(loc.x, loc.y);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void dragOver(DropTargetDragEvent e) {
    }

    public void dropActionChanged(DropTargetDragEvent e) {
    }

    public void dragExit(DropTargetEvent e) {
    }

    public static void main(String[] arg) {
        Wizard wiz = new Wizard(null);
        DNADraw dna = wiz.getDNADraw();
        JFrame f = new JFrame("DNA Viewer");
        Dimension d = f.getToolkit().getScreenSize();
        Vector<Integer> minTicks = new Vector<Integer>();
        minTicks.add(new Integer(1200));
        minTicks.add(new Integer(1600));
        minTicks.add(new Integer(2000));
        minTicks.add(new Integer(2500));
        minTicks.add(new Integer(3000));
        minTicks.add(new Integer(3500));
        minTicks.add(new Integer(4070));
        minTicks.add(new Integer(4500));
        minTicks.add(new Integer(5070));
        Vector majTicks = new Vector();
        Vector<Object> marker = new Vector<Object>();
        Vector<Vector<Object>> block = new Vector<Vector<Object>>();
        marker.add(new String("CDS"));
        marker.add(new Integer(1200));
        marker.add(new Integer(1600));
        marker.add(Color.red);
        marker.add(new Float(10.0f));
        marker.add(new Boolean(false));
        marker.add(new Boolean(true));
        block.add(marker);
        Vector restrictionEnzyme = new Vector();
        Vector<Object> re = new Vector<Object>();
        re.add(new String("EcoR1"));
        re.add(new Integer(2555));
        re.add(Color.blue);
        restrictionEnzyme.add(re);
        re = new Vector();
        re.add(new String("EcoR1"));
        re.add(new Integer(3444));
        re.add(Color.blue);
        restrictionEnzyme.add(re);
        if (dna == null) {
            dna = new DNADraw(minTicks, majTicks, block, restrictionEnzyme);
        }
        jsp = new JScrollPane(dna);
        jsp.getViewport().setBackground(Color.white);
        f.getContentPane().add(jsp);
        f.setJMenuBar(dna.createMenuBar());
        f.pack();
        f.setLocation(((int)d.getWidth() - f.getWidth()) / 4, ((int)d.getHeight() - f.getHeight()) / 2);
        f.setVisible(true);
    }
}

