/*
 * Copyright (C) 1997 Red Hat Software, Inc.
 *
 * Modify:  2006/24/10  Tommy Scheunemann <net@arrishq.net>
 *
 * Modify:  2004/08/09  Tommy Scheunemann <net@arrishq.net>
 *
 * Modify:  2004/07/10  Tommy Scheunemann <net@arrishq.net>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * Functions needed for producing a WindowMaker configuration
 */

#include <stdio.h>
#include <strings.h>

#include "wmconfig.h"
#include "prototypes.h"
#include "package.h"

static void wmaker(struct group *root, int level,const char *use_term)
{
    int i;
    struct item *item;

    if (root == (struct group *)NULL) {
	return;
    }

    if (level>=0) {
        for (i=0; i<level; i++) {
	    printf("\t");
	}
	printf("\"%s\" MENU\n", root->name);
    }
    item = root->items;
    while (item->type != 0) {
	if (item->type == ITEM_MENU) {
	    wmaker(item->data, level+1, use_term);
	} else if (item->type == ITEM_APP) {
	    struct package *app;

	    app = (struct package *)item->data;
		if (app != NULL) {
		for (i=0; i<level; i++) {
		    printf("\t");
		}
		if (app->restart) {
		    if (strncasecmp(app->restart, "restart", 7) == 0) {
			printf(" \"%s\" RESTART\n", app->name);
		    } else if (strncasecmp(app->restart, "quit", 4) == 0) {
			printf(" \"%s\" EXIT\n", app->name);
		    } else {
			printf(" \"%s\" RESTART %s\n", app->name, app->exec);
		    }
		} else {
		    if (app->terminal) {
			printf("\t\"%s\" EXEC %s -e %s\n", app->name, use_term, app->exec);
		    } else {
			printf("\t\"%s\" EXEC %s\n", app->name, app->exec);
		    }
		}
	    }
	}
	item++;
    }
    if (level>=0) {
        for (i=0; i<level; i++) {
	    printf("\t");
	}
	printf("\"%s\" END\n", root->name);
    }
}

void output_wmaker(struct group *root,const char *use_term)
{
    wmaker(root, 0, use_term);
}
