/*
 * Copyright (C) 1997 Red Hat Software, Inc.
 *	Cristian Gafton <gafton@redhat.com>
 *
 * Modify:  2014/06/05  Tommy Scheunemann <net@arrishq.net>
 *
 * Modify:  2014/05/03  Tommy Scheunemann <net@arrishq.net>
 *
 * Modify:  2014/01/07  Tommy Scheunemann <net@arrishq.net>
 *
 * Modify:  2013-03-19  Tommy Scheunemann <net@arrishq.net>
 *
 * Modify:  2006-24-10  Tommy Scheunemann <net@arrishq.net>
 *
 * Modify:  2004-08-09  Tommy Scheunemann <net@arrishq.net>
 *
 * Modify:  2003-12-23  Tommy Scheunemann <net@arrishq.org>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * WM config helper functions
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#if (defined(__unix__) || defined(unix)) && !defined(USG)
#include <sys/param.h>
#endif

#include "wmconfig.h"

static char ret_str[BUFSIZ];

/*
 * Replaces the white space with underscores...
 */

char *single_string(const char *group_string)
{
    char *p;

    if (group_string == NULL) {
	return NULL;
    }

    memset(ret_str, 0, BUFSIZ);
    strncpy(ret_str, group_string, BUFSIZ-1);
    p = ret_str;
    while (*p) {
	if (isspace(*p))
	    *p = '_';
	p++;
    }
    return strdup(ret_str);
}

/*
 *  get:	"... is cool, (small) and [fast]"
 *  return:	"... is cool, /(small/) and /[fast/]"
 *
 *  Warning: This function modifies its argument, and can't be used
 *           with constant strings.
 */

char *valid_string (char *str)
{
    const char *brackets = "[]()";
    char *p, *q;
    int i, c, k;
    int list[200];
    int sz;

    c = -1;
    i = 0;
    sz = strlen (str);

    while (i < sz) {
	if (strchr (brackets, str[i])) {
	    list[++c] = i;
	}
	i++;
    }

    if (c < 0) {
	return str;
    }

    p = (char*) malloc (sz + c);
    if (p == NULL) {
	fprintf (stderr, gettext ("%d@%s: out of memory !\n"), __LINE__-1, __FUNCTION__);
	return NULL;
    }

    memset (p, 0, sz + c);

    q = str;
    k = 0;
    for (i = 0; i <= c + 1; i++) {
	strncat (p, q, list[i] - k);
	
	if (i != c + 1) {
	    strncat (p, "\\", sizeof(p) - strlen(p) - 1);
	}

	q = &str[list[i]];
	k = list[i];
    }

    free (str);
    return str = p;
}
