/*
 * Copyright (C) 1997 Red Hat Software, Inc.
 *
 * Modify:  2004/08/09  Tommy Scheunemann <net@arrishq.net>
 *
 * Modify:  2003/11/19  Tommy Scheunemann <net@arrishq.org>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * PACKAGE.H
 *
 * structures used by the WM config
 */

#ifndef _PACKAGE_H
#define _PACKAGE_H

#include "wmconfig.h"

struct package {
    char *__package;		/* package name */
    char *name;			/* the name of the application */
    char *icon;			/* icon to be used */
    char *mini_icon;		/* mini icon to be used */
    char *description;		/* decsription of this application */
    char *Xresource;		/* Xresources... */
    char *exec;			/* what to exec... */
    char *group;		/* group we want this application in */
    char *copy;			/* copy the rest of parameters from */
    char *mimetype;		/* mimetype for KDE1, KDE2, KDE3 */
    char *terminal;		/* use terminal for launching the application */
    char *restart;		/* used for the restart and quit entries */
};

#define ITEM_APP	1
#define ITEM_MENU	2
#define ITEM_TITLE	3

/* Maximum items per group */
#ifndef MAX_GROUPITEMS
#define MAX_GROUPITEMS          200
#endif /* MAX_GROUPITEMS */

/* This is the maximum recursion level, for things like a package
 * copying other package configuration, in case the user messes up
 * the configuration. */
#ifndef MAX_RECLEVEL
#define MAX_RECLEVEL		100
#endif /* MAX_RECLEVEL */

struct item {
    int 	type;
    void 	*data;
};

struct group {
    char	*name;		/* This is the name of the group/or app name */
    int		nr_items;	/* Total number of items ... (bounds checking) */
    struct item	items[MAX_GROUPITEMS];
};
    
#endif /* _PACKAGE_H */
