/*
 * Copyright (C) 2002-2015 Tommy Scheunemann
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "wmconfig.h"
#include "prototypes.h"
#include "package.h"

#include <stdio.h>
#include <strings.h>
#include <string.h>

extern unsigned int flags;

/*
 Openbox requires submenus defined before they are
 used - Wmconfig uses a "reverse" output
*/

static void openbox(struct group *root,const char *use_term)
{
    struct item *item;
    if (root == (struct group *)NULL) {
	return;
    }
    item = root->items;
    while (item->type != 0) {
	if (item->type == ITEM_MENU) {
	    openbox(item->data, use_term);
	}
	item++;
    }

    item = root->items;
    printf("<menu id=\"%s\" label=\"%s\">\n", single_string(root->name), root->name);
    while (item->type != 0) {
	if (item->type == ITEM_APP) {
	    struct package *app;
	    app = (struct package *)item->data;
	    if (!app->restart) {
		if (app->name && app->exec) {
		    char *b;
		    int l;
		    b = app->exec;
		    l = strlen(b);

		    printf(" <item label=\"%s\">\n", app->name);
		    printf("  <action name=\"Execute\"><execute>");
		    if (app->terminal) {
		        printf("%s -e ", use_term);
		    }
		    while (l > 0 && b[l - 1] == ' ') {
		        l--;
		    }
		    if (l > 0 && b[l - 1] == '&') {
		        l--;
		    }
		    for (; l > 0; l--,b++) {
		        putchar(*b);
		    }
		    printf("</execute></action>\n");
		}
		printf(" </item>\n");
	    }
	}
	item++;
    }
    printf("</menu>\n\n");
    return;
}

void output_openbox(struct group *root,const char *use_term)
{
    printf("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
    printf("<openbox_pipe_menu xmlns=\"http://openbox.org/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://openbox.org/ file:///usr/local/share/openbox/openbox/menu.xsd\">\n");
    openbox(root, use_term);
    printf("</openbox_pipe_menu>\n");
}
