/* Copyright (c) 2006 Dirk Jagdmann <doj@cubic.org>

This software is provided 'as-is', without any express or implied
warranty. In no event will the authors be held liable for any damages
arising from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you
       must not claim that you wrote the original software. If you use
       this software in a product, an acknowledgment in the product
       documentation would be appreciated but is not required.

    2. Altered source versions must be plainly marked as such, and
       must not be misrepresented as being the original software.

    3. This notice may not be removed or altered from any source
       distribution. */

/* $Header: /code/cbmfs/fuse_ops.c,v 1.3 2006/07/21 14:46:04 doj Exp $ */

#define FUSE_USE_VERSION 25
#include <fuse.h>
int cbmfs_chmod(const char *path, mode_t mode);
int cbmfs_utime(const char *path, struct utimbuf *buf);
int cbmfs_truncate(const char *path, off_t offset);
int cbmfs_mknod(const char *path, mode_t mode, dev_t dev);
int cbmfs_rename(const char *from, const char *to);
int cbmfs_unlink(const char *path);
int cbmfs_statfs(const char *path, struct statvfs *buf);
int cbmfs_read(const char *path, char *buf, size_t size, off_t offset, struct fuse_file_info *fi);
int cbmfs_open(const char *path, struct fuse_file_info *fi);
int cbmfs_readdir(const char *path, void *buf, fuse_fill_dir_t filler, off_t offset, struct fuse_file_info *fi);
int cbmfs_getattr(const char *path, struct stat *stbuf);
void cbmfs_cleanup();
int cbmfs_write(const char *path, const char *buf, size_t size, off_t offset, struct fuse_file_info *fi);
struct fuse_operations cbmfs_ops = {
  .getattr	= cbmfs_getattr,
  .open		= cbmfs_open,
  .read		= cbmfs_read,
  .statfs	= cbmfs_statfs,
  .rename	= cbmfs_rename,
  .mknod	= cbmfs_mknod,
  .unlink	= cbmfs_unlink,
  .truncate	= cbmfs_truncate,
  .utime	= cbmfs_utime,
  .chmod	= cbmfs_chmod,
  .destroy	= cbmfs_cleanup,
  .readdir	= cbmfs_readdir,
  .write	= cbmfs_write,
};
