/* Copyright (c) 2006 Dirk Jagdmann <doj@cubic.org>

This software is provided 'as-is', without any express or implied
warranty. In no event will the authors be held liable for any damages
arising from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you
       must not claim that you wrote the original software. If you use
       this software in a product, an acknowledgment in the product
       documentation would be appreciated but is not required.

    2. Altered source versions must be plainly marked as such, and
       must not be misrepresented as being the original software.

    3. This notice may not be removed or altered from any source
       distribution. */

/* $Header: /code/cbmfs/d80.hpp,v 1.2 2006/07/21 14:46:04 doj Exp $ */

#ifndef D80__HPP
#define D80__HPP

#include "cbmdisk.hpp"

class D80 : public CBMdisk
{
public:

#pragma pack(push, 1)

  struct header {
    /*0x00*/ TS bam;
    /*0x02*/ BYTE DOSformat; // should be 0x43 'C'
    /*0x03*/ BYTE reserved;
    /*0x04*/ BYTE unused1[2];
    /*0x06*/ BYTE diskname[16];
    /*0x16*/ BYTE unused2[2]; // should be 0xA0
    /*0x18*/ BYTE id[2]; // should be "er"
    /*0x1A*/ BYTE unused3; // should be 0xA0
    /*0x1B*/ BYTE DOSversion[2]; // should be "2C"
    /*0x1D*/ BYTE unused4[4]; // should be 0xA0
    /*0x21*/ BYTE unused5[0x100-0x21]; // should be 0
  };
  BOOST_STATIC_ASSERT(sizeof(header) == SECTOR_SIZE);

  struct bamentry_80 {
    BYTE freeblocks;
    BYTE bm0, bm1, bm2, bm3;
  };
  BOOST_STATIC_ASSERT(sizeof(bamentry_80) == 5);

  struct bam_80 {
    /*0x00*/ TS next;
    /*0x02*/ BYTE version;		/* should be 0x41 */
    /*0x03*/ BYTE reserved;
    /*0x04*/ BYTE track_low;
    /*0x05*/ BYTE track_high;
    /*0x06*/ bamentry_80 entry[50];
  };
  BOOST_STATIC_ASSERT(sizeof(bam_80) == SECTOR_SIZE);
#pragma pack(pop)

  D80(BYTE *disk_);
  virtual TS dir();
  virtual int maxblocks();
  virtual void bam_set(const BYTE t, const BYTE s, const bool b);
  virtual void printbam();
  virtual int track_max();

protected:
  virtual const int* sectorsPerTrack();
  virtual bool bam_get(const BYTE t, const BYTE s);
  virtual void fix(bamentry*, const BYTE t);
  virtual bamentry* getbamentry(const BYTE t);
  virtual void fix(bamentry_80*, const BYTE t);
  virtual bamentry_80* getbamentry_80(const BYTE t);
  virtual void printbaminfo();
  virtual bool reserved_track(const BYTE t);

private:
  D80();
  D80(const D80&);
  D80& operator= (const D80&);
};

#endif
