/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.launching;

import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.windows.WinFileSystem;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.ContextInt;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.FetchObjectAction;
import com.install4j.runtime.installer.helper.launching.InputRedirection;
import com.install4j.runtime.installer.helper.launching.InputRedirectionMode;
import com.install4j.runtime.installer.helper.launching.LaunchDescriptor;
import com.install4j.runtime.installer.helper.launching.OutputRedirection;
import com.install4j.runtime.installer.helper.launching.OutputRedirectionMode;
import com.install4j.runtime.installer.helper.launching.UncloseableInputStream;
import com.install4j.runtime.installer.helper.launching.UncloseableOutputStream;
import com.install4j.runtime.installer.helper.versionspecific.VersionSpecificHelper;
import com.install4j.runtime.installer.platform.macos.VolumeInfo;
import com.install4j.runtime.installer.platform.unix.LegacyUnixFileSystem;
import com.install4j.runtime.installer.platform.unix.UnixUserInfo;
import com.install4j.runtime.installer.platform.win32.FolderInfo;
import com.install4j.runtime.util.StringUtil;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class LaunchHelper {
    public static final long LAUNCH_EXIT_DELTA_TIME = 10000L;
    public static final int RETURN_VALUE_TIMEOUT = -10000;
    private static long lastLaunchTime;
    private static char[] SPECIAL_BATCH_FILE_CHARACTERS;
    private static char[] SPECIAL_ARGUMENTS_CHARACTERS;

    public static long getLastLaunchTime() {
        return lastLaunchTime;
    }

    private LaunchHelper() {
    }

    public static boolean launchFinishExecutable(File file, String[] stringArray, File file2) {
        Integer n = Util.isWindows() || Util.isMacOS() ? LaunchHelper.launchApplication(new LaunchDescriptor(file).workingDirectory(file2).arguments(stringArray).executionContext(ExecutionContext.UNELEVATED)) : LaunchHelper.launchApplication(new LaunchDescriptor(new File("/bin/sh")).workingDirectory(file2).arguments(new String[]{"-c", "nohup \"" + (file.exists() ? file.getAbsolutePath() : file.getPath()) + "\" " + StringUtil.makeCommandLine(stringArray) + " > /dev/null 2>&1"}));
        if (n != null) {
            lastLaunchTime = System.currentTimeMillis();
        }
        return n != null;
    }

    public static Integer launchApplication(final LaunchDescriptor launchDescriptor) {
        HelperCommunication helperCommunication = HelperCommunication.getInstance();
        return (Integer)helperCommunication.fetchObject(launchDescriptor.getExecutionContext(), new FetchObjectAction(){

            protected Object fetchValue(Context context) throws Exception {
                return LaunchHelper.launchApplicationDirectly(launchDescriptor);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Integer launchApplicationDirectly(LaunchDescriptor launchDescriptor) {
        File file = launchDescriptor.getExecutable();
        String[] stringArray = LaunchHelper.getEnvironmentVariables(launchDescriptor.getSpecificEnvironmentVariables(), launchDescriptor.isIncludeParentEnvironmentVariables());
        try {
            if (file == null) {
                Logger.getInstance().error(null, "executable is null");
                return null;
            }
            Process process = null;
            OutputStream outputStream2 = null;
            OutputStream outputStream = null;
            InputStream inputStream = null;
            try {
                outputStream2 = LaunchHelper.createOutputStream(launchDescriptor.getStdoutRedirection(), "stdout");
                outputStream = LaunchHelper.createOutputStream(launchDescriptor.getStderrRedirection(), "stderr");
                inputStream = LaunchHelper.createInputStream(launchDescriptor.getStdinRedirection());
            }
            catch (IOException iOException) {
                LaunchHelper.closeStreams(inputStream, outputStream2, outputStream);
                return null;
            }
            if (InstallerUtil.isMacOS()) {
                process = LaunchHelper.launchOnMacOS(launchDescriptor);
            } else if (!file.exists() || file.isFile()) {
                launchDescriptor.useNohup(launchDescriptor.isUseNohup() && outputStream2 == null && outputStream == null && inputStream == null);
                String string = file.exists() ? file.getAbsolutePath() : file.getPath();
                process = Util.isWindows() && (string.toLowerCase().endsWith(".bat") || string.toLowerCase().endsWith(".cmd") || Util.isAtLeastWindowsVista() || launchDescriptor.isShowWindowsConsole()) ? LaunchHelper.launchOnWindows(launchDescriptor, string, stringArray) : LaunchHelper.launchOtherwise(launchDescriptor, string, stringArray);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            } else {
                Logger.getInstance().error(null, "executable is not a file: " + file);
            }
            if (process == null) {
                Logger.getInstance().error(LaunchHelper.class, "process could not be created");
                LaunchHelper.closeStreams(inputStream, outputStream2, outputStream);
                return null;
            }
            new ConsumerThread(process.getInputStream(), outputStream2).start();
            new ConsumerThread(process.getErrorStream(), outputStream).start();
            if (inputStream != null) {
                new WriterThread(process.getOutputStream(), inputStream, inputStream instanceof UncloseableInputStream).start();
            }
            if (launchDescriptor.isReceiveProcess()) {
                launchDescriptor.setProcess(process);
            }
            if (!launchDescriptor.isWait()) {
                return new Integer(1);
            }
            try {
                int n = LaunchHelper.waitFor(process, launchDescriptor.getTimeout());
                if (n != 0) {
                    Logger.getInstance().error(LaunchHelper.class, "return value is " + n);
                }
                Integer n2 = new Integer(n);
                return n2;
            }
            catch (InterruptedException interruptedException) {
                Logger.getInstance().info(LaunchHelper.class, interruptedException.toString());
                interruptedException.printStackTrace();
                Integer n = null;
                return n;
            }
            finally {
                if (launchDescriptor.isWait() && launchDescriptor.isWaitForStreams() && !Util.isMacOS()) {
                    LaunchHelper.waitForStream(process.getInputStream());
                    LaunchHelper.waitForStream(process.getErrorStream());
                }
                LaunchHelper.closeStreams(inputStream, outputStream2, outputStream);
            }
        }
        catch (IOException iOException) {
            try {
                Logger.getInstance().error(LaunchHelper.class, iOException.getMessage());
            }
            catch (Exception exception) {
                // empty catch block
            }
            iOException.printStackTrace();
        }
        return null;
    }

    public static int waitFor(Process process, int n) throws InterruptedException {
        if (n < 0) {
            n = 0;
        }
        if (n == 0) {
            return process.waitFor();
        }
        long l = System.currentTimeMillis() + (long)(n * 1000);
        while (true) {
            try {
                return process.exitValue();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                Thread.sleep(100L);
                if (l > System.currentTimeMillis()) continue;
                process.destroy();
                return -10000;
            }
            break;
        }
    }

    private static void waitForStream(InputStream inputStream) {
        try {
            for (int i = 0; i < 10; ++i) {
                if (inputStream.available() <= 0) {
                    return;
                }
                Thread.sleep(100L);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static Process launchOnMacOS(LaunchDescriptor launchDescriptor) throws IOException {
        Serializable serializable;
        File file = launchDescriptor.getExecutable();
        if ((file = LaunchHelper.checkDmg(file)) == null) {
            return null;
        }
        if (file.isDirectory()) {
            serializable = new ArrayList();
            if (launchDescriptor.isReceiveProcess() || launchDescriptor.isWait()) {
                serializable.add("-W");
            }
            serializable.add(file.getAbsolutePath());
            if (launchDescriptor.getArguments() != null) {
                serializable.add("--args");
                for (int i = 0; i < launchDescriptor.getArguments().length; ++i) {
                    serializable.add(launchDescriptor.getArguments()[i]);
                }
            }
            launchDescriptor.arguments(serializable.toArray(new String[serializable.size()]));
            file = new File("/usr/bin/open");
        }
        serializable = LaunchHelper.createMacStartScript(launchDescriptor, file);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("/bin/sh");
        arrayList.add(((File)serializable).getAbsolutePath());
        Process process = Runtime.getRuntime().exec(arrayList.toArray(new String[arrayList.size()]), null, launchDescriptor.getWorkingDirectory());
        if (process == null) {
            Logger.getInstance().error(null, "process is null");
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return process;
    }

    private static File createMacStartScript(LaunchDescriptor launchDescriptor, File file) throws IOException {
        String[] stringArray = launchDescriptor.getArguments();
        File file2 = File.createTempFile("i4j", ".sh", null);
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(file2)), "UTF-8"));
        printWriter.println("#!/bin/sh");
        if (launchDescriptor.getWorkingDirectory() != null) {
            printWriter.println("old_pwd=`pwd`");
            printWriter.println("cd \"" + launchDescriptor.getWorkingDirectory() + "\"");
        }
        if (launchDescriptor.getSpecificEnvironmentVariables() != null) {
            Iterator iterator = launchDescriptor.getSpecificEnvironmentVariables().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                printWriter.println(entry.getKey() + "=\"" + entry.getValue() + "\"");
                printWriter.println("export " + entry.getKey());
            }
        }
        if (launchDescriptor.isSuidRoot() && (UnixUserInfo.ROOT_USER || HelperCommunication.getInstance().isElevatedHelper()) && Util.isMacOS()) {
            File file3;
            boolean bl = Boolean.getBoolean("install4j.fromService");
            boolean bl2 = Boolean.getBoolean("install4j.noSuid");
            Logger.getInstance().info(null, "SUID elevation: " + !bl + ", " + !bl2);
            if (!bl && !bl2 && (file3 = InstallerUtil.getInstallerFile("install4j")).exists()) {
                printWriter.print("\"" + file3.getAbsolutePath() + "\" __i4j_setuid ");
            }
        }
        printWriter.print("\"" + file.getAbsolutePath() + "\"");
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                printWriter.print(" \"" + stringArray[i] + "\"");
            }
        }
        printWriter.println();
        printWriter.println("exitCode=$?");
        if (launchDescriptor.getWorkingDirectory() != null) {
            printWriter.println("  cd \"$old_pwd\"");
        }
        printWriter.println("rm $0");
        printWriter.println("exit $exitCode");
        printWriter.close();
        return file2;
    }

    private static Process launchOnWindows(LaunchDescriptor launchDescriptor, String string, String[] stringArray) throws IOException {
        boolean bl;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (Util.isWindows9X()) {
            arrayList.add(new File(WinFileSystem.getWindowsDirectory(), "command.com").getAbsolutePath());
        } else {
            try {
                arrayList.add(new File(WinFileSystem.getSystemDirectory(), "cmd.exe").getAbsolutePath());
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                arrayList.add("cmd.exe");
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                arrayList.add("cmd.exe");
            }
        }
        arrayList.add("/D");
        boolean bl2 = bl = launchDescriptor.isShowWindowsConsole() && !Util.isWindows9X();
        if (bl && launchDescriptor.isKeepConsoleWindow()) {
            arrayList.add("/K");
        } else {
            arrayList.add("/C");
        }
        String string2 = string;
        try {
            string2 = FolderInfo.getShortPathName(string);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        File file = LaunchHelper.createWindowsStartScript(launchDescriptor, string2);
        arrayList.add("\"" + file.getAbsolutePath() + "\"");
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < arrayList.size(); ++i) {
            stringBuffer.append(arrayList.get(i));
            if (i >= arrayList.size() - 1) continue;
            stringBuffer.append(" ");
        }
        String string3 = stringBuffer.toString();
        if (bl) {
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append("start \"");
            stringBuffer2.append(string);
            stringBuffer2.append("\" /WAIT ");
            stringBuffer2.append(string3);
            return Runtime.getRuntime().exec(new String[]{"cmd.exe", "/D", "/C", stringBuffer2.toString()}, stringArray, launchDescriptor.getWorkingDirectory());
        }
        return Runtime.getRuntime().exec(string3, stringArray, launchDescriptor.getWorkingDirectory());
    }

    private static File createWindowsStartScript(LaunchDescriptor launchDescriptor, String string) throws IOException {
        File file = File.createTempFile("i4j", ".bat");
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
        printWriter.println("@ECHO OFF");
        printWriter.print("\"" + string + "\"");
        boolean bl = launchDescriptor.getExecutable().getName().toLowerCase().endsWith(".exe");
        String[] stringArray = launchDescriptor.getArguments();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = StringUtil.replace(stringArray[i], "%", "%%");
                if (LaunchHelper.needsQuotes(string2, bl)) {
                    printWriter.print(" \"" + string2 + "\"");
                    continue;
                }
                printWriter.print(" " + string2);
            }
        }
        printWriter.println();
        printWriter.close();
        file.deleteOnExit();
        return file;
    }

    private static boolean needsQuotes(String string, boolean bl) {
        if (string.startsWith("\"")) {
            return false;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= ' ' && c <= 'z' && Arrays.binarySearch(bl ? SPECIAL_ARGUMENTS_CHARACTERS : SPECIAL_BATCH_FILE_CHARACTERS, c) < 0) continue;
            return true;
        }
        return false;
    }

    private static Process launchOtherwise(LaunchDescriptor launchDescriptor, String string, String[] stringArray) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (launchDescriptor.isUseNohup()) {
            arrayList.add("/bin/sh");
            arrayList.add("-c");
            arrayList.add("nohup \"" + string + "\" " + StringUtil.makeCommandLine(launchDescriptor.getArguments()) + " > /dev/null 2>&1");
        } else {
            arrayList.add(string);
            String[] stringArray2 = launchDescriptor.getArguments();
            if (stringArray2 != null) {
                arrayList.addAll(Arrays.asList(stringArray2));
            }
        }
        return Runtime.getRuntime().exec(arrayList.toArray(new String[arrayList.size()]), stringArray, launchDescriptor.getWorkingDirectory());
    }

    private static String[] getEnvironmentVariables(Map map, boolean bl) {
        String string;
        String string2;
        Map.Entry entry;
        if (map == null || map.isEmpty()) {
            if (bl) {
                return null;
            }
            return new String[0];
        }
        Map map2 = VersionSpecificHelper.getenv();
        Map map3 = LaunchHelper.getUpperCaseVariables(map2);
        ArrayList<String> arrayList = new ArrayList<String>();
        HashSet<String> hashSet = new HashSet<String>();
        boolean bl2 = InstallerUtil.isWindows();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            string2 = InstallerVariables.replaceVariables((String)entry.getKey());
            string = InstallerVariables.replaceVariables((String)entry.getValue());
            hashSet.add(bl2 ? string2.toUpperCase() : string2);
            arrayList.add(string2 + "=" + LaunchHelper.replaceEnvironmentVariables(string, bl2 ? map3 : map2));
        }
        if (bl) {
            iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                string2 = (String)entry.getKey();
                string = (String)entry.getValue();
                if (hashSet.contains(bl2 ? string2.toUpperCase() : string2)) continue;
                arrayList.add(string2 + "=" + string);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static Map getUpperCaseVariables(Map map) {
        HashMap hashMap = new HashMap(map.size());
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            hashMap.put(((String)entry.getKey()).toUpperCase(), entry.getValue());
        }
        return hashMap;
    }

    private static String replaceEnvironmentVariables(String string, final Map map) {
        return StringUtil.replaceVariable(string, "${", "}", new StringUtil.ReplacementCallback(){

            public String getReplacement(String string, Object object) {
                return (String)map.get(InstallerUtil.isWindows() ? string.toUpperCase() : string);
            }
        });
    }

    private static File checkDmg(File file) throws IOException {
        if ((file = file.getCanonicalFile()).getName().endsWith(".dmg")) {
            Logger.getInstance().info(null, "mounting dmg");
            File file2 = File.createTempFile("Media", "Mount");
            File file3 = new File(file2.getAbsolutePath() + ".dir");
            file3.mkdir();
            file2.delete();
            file3.deleteOnExit();
            Integer n = LaunchHelper.launchApplication(new LaunchDescriptor(new File("/usr/bin/hdiutil")).arguments(new String[]{"attach", file.getAbsolutePath(), "-mountroot", file3.getAbsolutePath()}).wait(true));
            if (n == null) {
                Logger.getInstance().error(null, "could not execute hdiutil");
                return null;
            }
            if (n == 0) {
                File[] fileArray = file3.listFiles();
                if (fileArray != null) {
                    File file4 = fileArray[0];
                    return LaunchHelper.findExecutableFile(file4.listFiles());
                }
                Logger.getInstance().error(null, "could not list files in " + file3);
                return null;
            }
            Map map = VolumeInfo.getMountPointToDiskFile();
            if (map != null) {
                for (int i = 0; i < 5; ++i) {
                    Iterator iterator = map.entrySet().iterator();
                    while (iterator.hasNext()) {
                        File file5;
                        File[] fileArray;
                        Map.Entry entry = iterator.next();
                        if (!new File((String)entry.getValue()).getCanonicalFile().equals(file) || (fileArray = (file5 = new File((String)entry.getKey())).listFiles()) == null) continue;
                        return LaunchHelper.findExecutableFile(fileArray);
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    map = VolumeInfo.getNewMountPointToDiskFile();
                }
                Logger.getInstance().error(null, "could not find mount point");
            } else {
                Logger.getInstance().error(null, "could not mount dmg file or retrieve mount points");
            }
            return null;
        }
        return file;
    }

    private static File findExecutableFile(File[] fileArray) {
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File[] fileArray2;
                File file;
                File file2 = fileArray[i];
                if (!file2.isDirectory() || !file2.getName().endsWith(".app")) continue;
                Logger.getInstance().info(null, "mounted bundle is " + file2);
                if ("_unknown:_unknown".equals(LegacyUnixFileSystem.getOwnerInfo(file2)) && (file = new File(file2, "Contents/MacOS")).isDirectory() && (fileArray2 = file.listFiles()) != null) {
                    for (int j = 0; j < fileArray2.length; ++j) {
                        File file3 = fileArray2[j];
                        if (!file3.isFile() || file3.getName().startsWith(".")) continue;
                        Logger.getInstance().info(null, "mounted as root, using executable " + file3 + ".");
                        return file3;
                    }
                }
                return file2;
            }
        }
        Logger.getInstance().error(null, "could not find app bundle");
        return null;
    }

    private static void closeStreams(InputStream inputStream, OutputStream outputStream, OutputStream outputStream2) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (outputStream2 != null) {
                outputStream2.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static OutputStream createOutputStream(OutputRedirection outputRedirection, String string) throws IOException {
        if (outputRedirection != null) {
            OutputRedirectionMode outputRedirectionMode = outputRedirection.getRedirectionMode();
            if (outputRedirectionMode == OutputRedirectionMode.FILE) {
                return LaunchHelper.createFileOutputStream(outputRedirection);
            }
            if (outputRedirectionMode == OutputRedirectionMode.VARIABLE || outputRedirectionMode == OutputRedirectionMode.LOG_FILE) {
                return LaunchHelper.createStringOutputStream(outputRedirection, string);
            }
        }
        return null;
    }

    private static OutputStream createFileOutputStream(OutputRedirection outputRedirection) throws IOException {
        block5: {
            File file;
            if (outputRedirection != null && (file = outputRedirection.getFile()) != null) {
                if (file.getPath().replace('\\', '/').equals("/dev/stdout")) {
                    return new UncloseableOutputStream(System.out);
                }
                if (file.getPath().replace('\\', '/').equals("/dev/stderr")) {
                    return new UncloseableOutputStream(System.err);
                }
                try {
                    return new BufferedOutputStream(new FileOutputStream(file));
                }
                catch (IOException iOException) {
                    Logger.getInstance().error(LaunchHelper.class, "output file " + file.getPath() + " could not be created");
                    if (!outputRedirection.isFailOnFileError()) break block5;
                    throw iOException;
                }
            }
        }
        return null;
    }

    private static OutputStream createStringOutputStream(final OutputRedirection outputRedirection, final String string) {
        return new ByteArrayOutputStream(){
            boolean closed = false;

            public synchronized void close() throws IOException {
                if (!this.closed) {
                    OutputRedirectionMode outputRedirectionMode = outputRedirection.getRedirectionMode();
                    if (outputRedirectionMode == OutputRedirectionMode.VARIABLE) {
                        ContextInt contextInt = ContextImpl.getSingleContextInt();
                        String string2 = outputRedirection.getVariableName();
                        contextInt.registerHiddenVariable(string2);
                        contextInt.setVariable(string2, this.toString());
                    } else if (outputRedirectionMode == OutputRedirectionMode.LOG_FILE) {
                        String string3 = StringUtil.trimLineSeparators(this.toString());
                        if (string3.trim().length() == 0) {
                            Logger.getInstance().info(class$com$install4j$runtime$installer$helper$launching$LaunchHelper == null ? (class$com$install4j$runtime$installer$helper$launching$LaunchHelper = LaunchHelper.class$("com.install4j.runtime.installer.helper.launching.LaunchHelper")) : class$com$install4j$runtime$installer$helper$launching$LaunchHelper, string + " output was empty");
                        } else {
                            Logger.getInstance().info(class$com$install4j$runtime$installer$helper$launching$LaunchHelper == null ? (class$com$install4j$runtime$installer$helper$launching$LaunchHelper = LaunchHelper.class$("com.install4j.runtime.installer.helper.launching.LaunchHelper")) : class$com$install4j$runtime$installer$helper$launching$LaunchHelper, "\n" + string + " output:\n---BEGIN---\n" + string3 + "\n---END---");
                        }
                    }
                    this.closed = true;
                }
            }
        };
    }

    private static InputStream createInputStream(InputRedirection inputRedirection) throws IOException {
        if (inputRedirection != null) {
            InputRedirectionMode inputRedirectionMode = inputRedirection.getRedirectionMode();
            if (inputRedirectionMode == InputRedirectionMode.FILE) {
                return LaunchHelper.createFileInputStream(inputRedirection);
            }
            if (inputRedirectionMode == InputRedirectionMode.STRING) {
                return LaunchHelper.createStringInputStream(inputRedirection);
            }
        }
        return null;
    }

    private static InputStream createFileInputStream(InputRedirection inputRedirection) throws IOException {
        block4: {
            File file;
            if (inputRedirection != null && (file = inputRedirection.getFile()) != null) {
                if (file.getPath().replace('\\', '/').equals("/dev/stdin")) {
                    return new UncloseableInputStream(System.in);
                }
                try {
                    return new FileInputStream(file);
                }
                catch (IOException iOException) {
                    Logger.getInstance().error(LaunchHelper.class, "input file " + file.getPath() + " could not be opened");
                    if (!inputRedirection.isFailOnFileError()) break block4;
                    throw iOException;
                }
            }
        }
        return null;
    }

    private static InputStream createStringInputStream(InputRedirection inputRedirection) {
        return new ByteArrayInputStream(inputRedirection.getString().getBytes());
    }

    static {
        SPECIAL_BATCH_FILE_CHARACTERS = new char[]{' ', '&', '(', ')', '[', ']', '{', '}', '^', '=', ';', '!', '+', '`', '\u00b4', '~', '<', '>', '@', '|'};
        SPECIAL_ARGUMENTS_CHARACTERS = new char[]{' ', '&', '^', '`', '\u00b4', '<', '>', '@', '|'};
        Arrays.sort(SPECIAL_BATCH_FILE_CHARACTERS);
        Arrays.sort(SPECIAL_ARGUMENTS_CHARACTERS);
    }

    public static class ConsumerThread
    extends Thread {
        private boolean canceled;
        private InputStream stream;
        private OutputStream outputStream;

        public ConsumerThread(InputStream inputStream, OutputStream outputStream) {
            this.stream = inputStream;
            this.outputStream = outputStream;
        }

        public void run() {
            byte[] byArray = new byte[512];
            while (!this.canceled) {
                try {
                    int n = this.stream.read(byArray);
                    if (n == -1) {
                        this.cancel();
                        continue;
                    }
                    if (this.outputStream == null) continue;
                    this.outputStream.write(byArray, 0, n);
                }
                catch (IOException iOException) {
                    this.cancel();
                }
            }
        }

        public synchronized void cancel() {
            this.canceled = true;
            try {
                if (this.outputStream != null) {
                    this.outputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class WriterThread
    extends Thread {
        private boolean canceled;
        private OutputStream processOutput;
        private InputStream inputStream;
        private boolean unbuffered;

        public WriterThread(OutputStream outputStream, InputStream inputStream, boolean bl) {
            this.processOutput = outputStream;
            this.inputStream = inputStream;
            this.unbuffered = bl;
        }

        public void run() {
            if (this.unbuffered) {
                while (!this.canceled) {
                    try {
                        int n = this.inputStream.read();
                        if (n == -1) {
                            this.cancel();
                            continue;
                        }
                        this.processOutput.write(n);
                        this.processOutput.flush();
                    }
                    catch (IOException iOException) {
                        this.cancel();
                    }
                }
            } else {
                byte[] byArray = new byte[512];
                while (!this.canceled) {
                    try {
                        int n = this.inputStream.read(byArray);
                        if (n == -1) {
                            this.cancel();
                            continue;
                        }
                        this.processOutput.write(byArray, 0, n);
                    }
                    catch (IOException iOException) {
                        this.cancel();
                    }
                }
            }
        }

        public synchronized void cancel() {
            this.canceled = true;
            try {
                this.inputStream.close();
                this.processOutput.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

