/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.config;

import com.install4j.api.Util;
import com.install4j.api.beans.Bean;
import com.install4j.api.beans.ReplacementMode;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.AbstractConfig;
import com.install4j.runtime.installer.config.LinkBeanConfig;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Invokable;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.XmlHelper;
import java.beans.ExceptionListener;
import java.beans.XMLDecoder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractBeanConfig
extends AbstractConfig {
    private static final String ELEMENT_STRING = "string";
    private static List batch = new LinkedList();
    private static WeakHashMap allBeans = new WeakHashMap();
    protected String id;
    protected String customizedId = "";
    protected String idNamespace = "";
    private Element javaElement;
    private String conditionClassName = "";
    private boolean rollbackBarrier = false;

    public static void finishBatch() {
        final XMLDecoder xMLDecoder = AbstractBeanConfig.createBatchXmlDecoder();
        if (Util.isAix()) {
            xMLDecoder.setExceptionListener(new ExceptionListener(){

                public void exceptionThrown(Exception exception) {
                }
            });
        }
        Iterator iterator = batch.iterator();
        while (iterator.hasNext()) {
            AbstractBeanConfig abstractBeanConfig = (AbstractBeanConfig)iterator.next();
            try {
                Bean bean = (Bean)GUIHelper.invokeOnEDT(new Invokable(){

                    public Object invoke() throws Throwable {
                        return xMLDecoder.readObject();
                    }
                });
                allBeans.put(bean, abstractBeanConfig.getDisplayedId());
                abstractBeanConfig.setBean(bean);
            }
            catch (Throwable throwable) {
                Logger.getInstance().error(null, "Exception during instantiation of bean ID " + abstractBeanConfig.id);
                InstallerUtil.reportException(throwable);
                InstallerUtil.exit(1);
            }
        }
        batch.clear();
    }

    private static XMLDecoder createBatchXmlDecoder() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<java class=\"java.beans.XMLDecoder\">");
        Iterator iterator = batch.iterator();
        while (iterator.hasNext()) {
            AbstractBeanConfig abstractBeanConfig = (AbstractBeanConfig)iterator.next();
            if (!abstractBeanConfig.isInstantiated()) {
                String string;
                try {
                    abstractBeanConfig.replaceRuntimeVariables();
                    string = XmlHelper.getString(XmlHelper.findChild(abstractBeanConfig.javaElement, null));
                }
                catch (IOException iOException) {
                    Logger.getInstance().error(null, "Exception during instantiation of bean ID " + abstractBeanConfig.id);
                    InstallerUtil.reportException(iOException);
                    InstallerUtil.exit(1);
                    return null;
                }
                string = InstallerVariables.replaceVariables(string, ReplacementMode.I18N_ONLY);
                stringBuffer.append(string);
                continue;
            }
            iterator.remove();
        }
        stringBuffer.append("</java>");
        try {
            return AbstractBeanConfig.createXMLDecoder(new ByteArrayInputStream(stringBuffer.toString().getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logger.getInstance().error(null, "Exception during bean instantiation ");
            InstallerUtil.reportException(unsupportedEncodingException);
            InstallerUtil.exit(1);
            return null;
        }
    }

    private static XMLDecoder createXMLDecoder(InputStream inputStream) {
        try {
            Constructor constructor = XMLDecoder.class.getConstructor(InputStream.class, Object.class, ExceptionListener.class, ClassLoader.class);
            return (XMLDecoder)constructor.newInstance(inputStream, null, null, AbstractBeanConfig.class.getClassLoader());
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return new XMLDecoder(inputStream);
    }

    public static void clearBeans() {
        batch.clear();
        allBeans.clear();
    }

    public static String getId(Bean bean) {
        return (String)allBeans.get(bean);
    }

    public String getId() {
        return this.id;
    }

    public String getCustomizedId() {
        return this.customizedId;
    }

    public String getDisplayedId() {
        return this.customizedId.length() == 0 ? this.id : this.customizedId;
    }

    public String getIdNamespace() {
        return this.idNamespace;
    }

    public String getConditionClassName() {
        return this.conditionClassName;
    }

    public boolean isRollbackBarrier() {
        return this.rollbackBarrier;
    }

    public abstract boolean isInstantiated();

    protected void setBean(Bean bean) {
    }

    public void batchInstantiate() {
        AbstractBeanConfig abstractBeanConfig = null;
        if (this instanceof LinkBeanConfig) {
            abstractBeanConfig = ((LinkBeanConfig)((Object)this)).getDelegate();
        } else if (!this.isInstantiated()) {
            abstractBeanConfig = this;
        }
        if (abstractBeanConfig != null) {
            batch.add(abstractBeanConfig);
        }
    }

    public String getClassName() {
        return XmlHelper.readAttribute(XmlHelper.findChild(this.javaElement, "object"), "class", "");
    }

    protected Bean instantiateBean(boolean bl) {
        try {
            this.replaceRuntimeVariables();
            String string = XmlHelper.getString(this.javaElement);
            XMLDecoder xMLDecoder = AbstractBeanConfig.createXMLDecoder(new ByteArrayInputStream(string.getBytes("UTF-8")));
            Bean bean = (Bean)xMLDecoder.readObject();
            allBeans.put(bean, this.getDisplayedId());
            return bean;
        }
        catch (Throwable throwable) {
            if (!bl) {
                Logger.getInstance().error(null, "Exception during instantiation of bean ID " + this.getDisplayedId());
                InstallerUtil.reportException(throwable);
                InstallerUtil.exit(1);
            }
            return null;
        }
    }

    private void replaceRuntimeVariables() {
        this.replaceRuntimeVariables(this.javaElement);
    }

    private void replaceRuntimeVariables(Element element) {
        if (element.getTagName().equals(ELEMENT_STRING)) {
            Node node = element.getFirstChild();
            if (node != null) {
                String string = InstallerVariables.replaceVariables(node.getNodeValue(), ReplacementMode.I18N_ONLY);
                node.setNodeValue(string);
            }
        } else {
            Iterator iterator = XmlHelper.childElements(element);
            while (iterator.hasNext()) {
                Element element2 = (Element)iterator.next();
                this.replaceRuntimeVariables(element2);
            }
        }
    }

    protected void read(Element element) {
        this.id = AbstractBeanConfig.readAttribute(element, "id", this.id);
        this.customizedId = AbstractBeanConfig.readAttribute(element, "customizedId", this.customizedId);
        this.idNamespace = AbstractBeanConfig.readAttribute(element, "idNamespace", this.idNamespace);
        this.rollbackBarrier = AbstractBeanConfig.readAttribute(element, "rollbackBarrier", this.rollbackBarrier);
        this.conditionClassName = AbstractBeanConfig.readAttribute(element, "conditionClass", this.conditionClassName);
        this.javaElement = AbstractBeanConfig.findChild(element, "java");
    }

    public void addAllTo(Map map) {
        String string = this.id;
        String string2 = this.getDisplayedId();
        if (this.idNamespace.length() > 0) {
            string = this.idNamespace + ":" + string;
            string2 = this.idNamespace + ":" + string2;
        }
        map.put(string, this);
        if (!string2.equals(string)) {
            map.put(string2, this);
        }
    }

    protected String getIdInNamespace(String string) {
        if (this.idNamespace.length() > 0) {
            return this.idNamespace + ":" + string;
        }
        return string;
    }
}

