/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.registry;

import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.windows.RegistryRoot;
import com.install4j.api.windows.WinRegistry;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class SetRegistryValueAction
extends SystemInstallOrUninstallAction {
    private RegistryRoot registryRoot;
    private String keyName = "";
    private String valueName = "";
    private String value = "";
    private boolean createKey = true;
    private transient Object externalValue = null;

    public SetRegistryValueAction() {
    }

    public SetRegistryValueAction(RegistryRoot registryRoot, String string, String string2, Object object, boolean bl) {
        this.registryRoot = registryRoot;
        this.keyName = string;
        this.valueName = string2;
        this.externalValue = object;
        if (this.externalValue == null) {
            this.value = null;
        }
        this.createKey = bl;
    }

    public boolean execute(Context context) {
        Object object;
        if (!InstallerUtil.isWindows()) {
            return true;
        }
        PerformedAction performedAction = new PerformedAction();
        this.addRollbackAction(performedAction);
        if (this.isCreateKey() && !this.doCreateKey(performedAction)) {
            Logger.getInstance().error(this, "could not create key " + this.registryRoot + " " + this.keyName);
            return false;
        }
        performedAction.oldValue = WinRegistry.getValue(this.getRegistryRoot(), this.getKeyName(), this.getValueName());
        Object object2 = object = this.externalValue != null ? this.externalValue : this.getValue();
        if (object instanceof String && performedAction.oldValue instanceof WinRegistry.ExpandString) {
            object = new WinRegistry.ExpandString((String)object);
        }
        if (object == null) {
            performedAction.newValueSet = true;
            WinRegistry.deleteValue(this.getRegistryRoot(), this.getKeyName(), this.getValueName());
        } else {
            performedAction.newValueSet = WinRegistry.setValue(this.getRegistryRoot(), this.getKeyName(), this.getValueName(), object);
            if (!performedAction.newValueSet) {
                Logger.getInstance().error(this, "could not set value " + this.registryRoot + " " + this.keyName + " " + this.getValueName() + ": " + object);
            }
        }
        return performedAction.newValueSet;
    }

    private boolean doCreateKey(PerformedAction performedAction) {
        String string = this.getKeyName();
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\\");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            string2 = string2 == null ? "" : string2 + "\\";
            string2 = string2 + string3;
            if (WinRegistry.keyExists(this.getRegistryRoot(), string2)) continue;
            if (!WinRegistry.createKey(this.getRegistryRoot(), string2)) {
                return false;
            }
            performedAction.createdKeys.add(string2);
        }
        return true;
    }

    public RegistryRoot getRegistryRoot() {
        return this.registryRoot;
    }

    public void setRegistryRoot(RegistryRoot registryRoot) {
        this.registryRoot = registryRoot;
    }

    public String getKeyName() {
        return SetRegistryValueAction.replaceVariables(this.keyName);
    }

    public void setKeyName(String string) {
        this.keyName = string;
    }

    public String getValueName() {
        return SetRegistryValueAction.replaceVariables(this.valueName);
    }

    public void setValueName(String string) {
        this.valueName = string;
    }

    public String getValue() {
        return SetRegistryValueAction.replaceVariables(this.value);
    }

    public void setValue(String string) {
        this.value = string;
    }

    public boolean isCreateKey() {
        return this.createKey;
    }

    public void setCreateKey(boolean bl) {
        this.createKey = bl;
    }

    private class PerformedAction
    extends SetRegistryValueAction {
        List createdKeys = new ArrayList();
        boolean newValueSet = false;
        Object oldValue;

        PerformedAction() {
            SetRegistryValueAction.this.registryRoot = SetRegistryValueAction.this.getRegistryRoot();
            SetRegistryValueAction.this.keyName = SetRegistryValueAction.this.getKeyName();
            SetRegistryValueAction.this.valueName = SetRegistryValueAction.this.getValueName();
        }

        public boolean install(InstallerContext installerContext) throws UserCanceledException {
            return false;
        }

        public void rollback(InstallerContext installerContext) {
            if (this.newValueSet) {
                if (this.oldValue == null) {
                    WinRegistry.deleteValue(SetRegistryValueAction.this.registryRoot, SetRegistryValueAction.this.keyName, SetRegistryValueAction.this.valueName);
                } else {
                    WinRegistry.setValue(SetRegistryValueAction.this.registryRoot, SetRegistryValueAction.this.keyName, SetRegistryValueAction.this.valueName, this.oldValue);
                }
            }
            for (int i = this.createdKeys.size() - 1; i >= 0; --i) {
                String string = (String)this.createdKeys.get(i);
                WinRegistry.getSubKeyNames(SetRegistryValueAction.this.registryRoot, string);
                WinRegistry.deleteKey(SetRegistryValueAction.this.registryRoot, string, true);
            }
        }
    }
}

